/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import java.awt.EventQueue;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;

public class DockHierarchyLock {
    private volatile Token token = null;
    private boolean hardExceptions = false;
    private volatile int concurrent = 0;
    private Queue<Runnable> onRelease = new LinkedList<Runnable>();
    private boolean onReleaseRunning = false;

    public void setHardExceptions(boolean bl) {
        this.hardExceptions = bl;
    }

    public boolean isHardExceptions() {
        return this.hardExceptions;
    }

    public synchronized void setConcurrent(boolean bl) {
        this.concurrent = bl ? ++this.concurrent : --this.concurrent;
    }

    public boolean isConcurrent() {
        return this.concurrent > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRelease(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("run must not be null");
        }
        Queue<Runnable> queue = this.onRelease;
        synchronized (queue) {
            this.onRelease.add(runnable);
        }
        this.runOnRelease();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runOnRelease() {
        if (EventQueue.isDispatchThread()) {
            if (this.onReleaseRunning) return;
            Object object = this;
            synchronized (object) {
                if (this.token != null) {
                    return;
                }
            }
            try {
                this.onReleaseRunning = true;
                while (true) {
                    object = null;
                    Queue<Runnable> queue = this.onRelease;
                    synchronized (queue) {
                        object = this.onRelease.poll();
                    }
                    if (object == null) {
                        return;
                    }
                    object.run();
                }
            }
            finally {
                this.onReleaseRunning = false;
            }
        }
        final AtomicBoolean atomicBoolean = new AtomicBoolean(true);
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DockHierarchyLock.this.runOnRelease();
                AtomicBoolean atomicBoolean2 = atomicBoolean;
                synchronized (atomicBoolean2) {
                    atomicBoolean.set(false);
                    atomicBoolean.notifyAll();
                }
            }
        });
        long l = System.currentTimeMillis() + 1000L;
        AtomicBoolean atomicBoolean2 = atomicBoolean;
        synchronized (atomicBoolean2) {
            long l2;
            while (atomicBoolean.get() && l > (l2 = System.currentTimeMillis())) {
                try {
                    atomicBoolean.wait(l - l2);
                }
                catch (InterruptedException interruptedException) {}
            }
            return;
        }
    }

    public static Token acquireLinking(DockStation dockStation, Dockable dockable) {
        DockController dockController = dockStation.getController();
        if (dockController == null) {
            return new Token(null, dockStation, dockable, true);
        }
        return dockController.getHierarchyLock().acquireLink(dockStation, dockable);
    }

    public static Token acquireUnlinking(DockStation dockStation, Dockable dockable) {
        DockController dockController = dockStation.getController();
        if (dockController == null) {
            return new Token(null, dockStation, dockable, true);
        }
        return dockController.getHierarchyLock().acquireUnlink(dockStation, dockable);
    }

    public static Token acquiring(DockStation dockStation) {
        DockController dockController = dockStation.getController();
        if (dockController == null) {
            return new Token(null, dockStation);
        }
        return dockController.getHierarchyLock().acquire(dockStation);
    }

    public static Token acquireFake() {
        return new Token(null, null, null, false);
    }

    private String defaultMessage() {
        return "During an operation the framework attempted to acquire the same lock twice. There are two possible explanations:\n1. In a multi-threaded application one or both operations are not executed in the EventDispatchThread, or\n2. The operations are calling each other, which should not happen.\nPlease verify that this application is not accessing the framework from different threads, and fill a bugreport if you feel that this exception is not caused by your application.";
    }

    public synchronized Token acquireLink(DockStation dockStation, Dockable dockable) {
        if (dockStation == null) {
            throw new IllegalArgumentException("station is null");
        }
        if (dockable == null) {
            throw new IllegalArgumentException("dockable is null");
        }
        this.ensureUnlinked(dockStation, dockable);
        if (this.isConcurrent()) {
            return new Token(this, dockStation, dockable, true);
        }
        if (this.token != null) {
            this.throwException(new IllegalStateException(this.defaultMessage()));
        }
        this.token = new Token(this, dockStation, dockable, true);
        return this.token;
    }

    public synchronized Token acquireUnlink(DockStation dockStation, Dockable dockable) {
        if (dockStation == null) {
            throw new IllegalArgumentException("station is null");
        }
        if (dockable == null) {
            throw new IllegalArgumentException("dockable is null");
        }
        this.ensureLinked(dockStation, dockable);
        if (this.isConcurrent()) {
            return new Token(this, dockStation, dockable, false);
        }
        if (this.token != null) {
            this.throwException(new IllegalStateException(this.defaultMessage()));
        }
        this.token = new Token(this, dockStation, dockable, false);
        return this.token;
    }

    public synchronized Token acquire(DockStation dockStation) {
        if (this.isConcurrent()) {
            return new Token(this, dockStation);
        }
        if (this.token != null) {
            this.throwException(new IllegalStateException(this.defaultMessage()));
        }
        this.token = new Token(this, dockStation);
        return this.token;
    }

    private void ensureLinked(DockStation dockStation, Dockable dockable) {
        if (dockable.getDockParent() != dockStation) {
            this.throwException(new IllegalStateException("the parent of '" + dockable + "' is not '" + dockStation + "' but '" + dockable.getDockParent() + "'"));
            return;
        }
        boolean bl = false;
        int n = 0;
        int n2 = dockStation.getDockableCount();
        while (n < n2 && !bl) {
            if (dockStation.getDockable(n) == dockable) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            this.throwException(new IllegalStateException("the station '" + dockStation + "' does not know '" + dockable + "'"));
            return;
        }
    }

    private void ensureUnlinked(DockStation dockStation, Dockable dockable) {
        if (dockable.getDockParent() != null) {
            this.throwException(new IllegalStateException("The parent of '" + dockable + "' is not null but '" + dockable.getDockParent() + "'"));
            return;
        }
        int n = 0;
        int n2 = dockStation.getDockableCount();
        while (n < n2) {
            if (dockStation.getDockable(n) == dockable) {
                this.throwException(new IllegalStateException("The station '" + dockStation + "' knows of '" + dockable + "'"));
                return;
            }
            ++n;
        }
    }

    private void throwException(RuntimeException runtimeException) {
        if (this.hardExceptions) {
            throw runtimeException;
        }
        runtimeException.printStackTrace();
    }

    public static class Token {
        private DockHierarchyLock lock;
        private DockStation station;
        private Dockable dockable;
        private boolean link;

        private Token(DockHierarchyLock dockHierarchyLock, DockStation dockStation) {
            this.lock = dockHierarchyLock;
            this.station = dockStation;
        }

        private Token(DockHierarchyLock dockHierarchyLock, DockStation dockStation, Dockable dockable, boolean bl) {
            this.lock = dockHierarchyLock;
            this.station = dockStation;
            this.dockable = dockable;
            this.link = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            Token token = this;
            synchronized (token) {
                if (this.lock != null) {
                    boolean bl;
                    boolean bl2 = bl = this.lock.token == this;
                    if (bl) {
                        this.lock.token = null;
                    }
                    if (this.dockable != null) {
                        if (this.link) {
                            this.lock.ensureLinked(this.station, this.dockable);
                        } else {
                            this.lock.ensureUnlinked(this.station, this.dockable);
                        }
                    }
                    if (bl) {
                        this.lock.runOnRelease();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseNoCheck() {
            Token token = this;
            synchronized (token) {
                if (this.lock != null) {
                    this.lock.token = null;
                }
            }
        }
    }
}

