/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.component.DockComponentRootHandler;
import bibliothek.gui.dock.dockable.AbstractDockable;
import bibliothek.gui.dock.dockable.DockableBackgroundComponent;
import bibliothek.gui.dock.dockable.DockableIcon;
import bibliothek.gui.dock.dockable.IconHandling;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPanel;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.gui.dock.util.icon.DockIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import javax.swing.LayoutFocusTraversalPolicy;

public class DefaultDockable
extends AbstractDockable {
    private BackgroundPanel pane = new ConfiguredBackgroundPanel((LayoutManager)new BorderLayout(), Transparency.SOLID);
    private String factoryId = "DefaultDockableFactory";
    private Background background = new Background();
    private WeakReference<Component> clientComponent;

    public DefaultDockable() {
        this(null, null, null, IconHandling.REPLACE_NULL_ICON);
    }

    public DefaultDockable(Icon icon) {
        this(null, null, icon, IconHandling.KEEP_NULL_ICON);
    }

    public DefaultDockable(String string) {
        this(null, string, null, IconHandling.REPLACE_NULL_ICON);
    }

    public DefaultDockable(Component component) {
        this(component, null, null, IconHandling.REPLACE_NULL_ICON);
    }

    public DefaultDockable(Component component, Icon icon) {
        this(component, null, icon, IconHandling.KEEP_NULL_ICON);
    }

    public DefaultDockable(Component component, String string) {
        this(component, string, null, IconHandling.REPLACE_NULL_ICON);
    }

    public DefaultDockable(Component component, String string, Icon icon) {
        this(component, string, icon, IconHandling.KEEP_NULL_ICON);
    }

    public DefaultDockable(Component component, String string, Icon icon, IconHandling iconHandling) {
        super(PropertyKey.DOCKABLE_TITLE, PropertyKey.DOCKABLE_TOOLTIP);
        this.pane.setFocusable(false);
        this.pane.setFocusTraversalPolicyProvider(true);
        this.pane.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.pane.setBackground(this.background);
        if (component != null) {
            this.clientComponent = new WeakReference<Component>(component);
            this.getContentPane().setLayout(new GridLayout(1, 1));
            this.getContentPane().add(component);
        }
        this.setTitleIconHandling(iconHandling);
        this.setTitleIcon(icon);
        this.setTitleText(string);
    }

    @Override
    protected DockIcon createTitleIcon() {
        return new DockableIcon("dockable.default", this){

            @Override
            protected void changed(Icon icon, Icon icon2) {
                DefaultDockable.this.fireTitleIconChanged(icon, icon2);
            }
        };
    }

    @Override
    protected DockComponentRootHandler createRootHandler() {
        return new DockComponentRootHandler(this){

            @Override
            protected DockComponentRootHandler.TraverseResult shouldTraverse(Component component) {
                if (component == DefaultDockable.this.getContentPane()) {
                    return DockComponentRootHandler.TraverseResult.EXCLUDE_CHILDREN;
                }
                return DockComponentRootHandler.TraverseResult.INCLUDE_CHILDREN;
            }
        };
    }

    @Override
    public String getFactoryID() {
        return this.factoryId;
    }

    public void setFactoryID(String string) {
        if (string == null) {
            throw new IllegalArgumentException("FactoryID must not be null");
        }
        this.factoryId = string;
    }

    @Override
    public Component getComponent() {
        return this.pane;
    }

    @Override
    public DockStation asDockStation() {
        return null;
    }

    public int getComponentCount() {
        return this.getContentPane().getComponentCount();
    }

    public Component getComponent(int n) {
        return this.getContentPane().getComponent(n);
    }

    public Component getClientComponent() {
        if (this.clientComponent == null) {
            return null;
        }
        Component component = (Component)this.clientComponent.get();
        if (component == null) {
            this.clientComponent = null;
            return null;
        }
        if (component.getParent() != this.getContentPane()) {
            this.clientComponent = null;
            return null;
        }
        return component;
    }

    public Container getContentPane() {
        return this.pane;
    }

    public void add(Component component) {
        this.getContentPane().add(component);
    }

    public void add(Component component, Object object) {
        this.getContentPane().add(component, object);
    }

    public void remove(Component component) {
        this.getContentPane().remove(component);
    }

    public void setLayout(LayoutManager layoutManager) {
        this.getContentPane().setLayout(layoutManager);
    }

    @Override
    public void setController(DockController dockController) {
        super.setController(dockController);
        this.background.setController(dockController);
    }

    private class Background
    extends BackgroundAlgorithm
    implements DockableBackgroundComponent {
        public Background() {
            super(DockableBackgroundComponent.KIND, "dock.background.dockable");
        }

        @Override
        public Component getComponent() {
            return this.getDockable().getComponent();
        }

        @Override
        public Dockable getDockable() {
            return DefaultDockable.this;
        }
    }
}

