/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.themes.BasicTheme;
import bibliothek.gui.dock.themes.NoStackTheme;
import bibliothek.gui.dock.themes.ThemeFactory;
import bibliothek.gui.dock.themes.ThemePropertyFactory;
import bibliothek.gui.dock.util.laf.DefaultLookAndFeelColors;
import bibliothek.gui.dock.util.laf.LookAndFeelColors;
import bibliothek.gui.dock.util.laf.LookAndFeelColorsListener;
import bibliothek.gui.dock.util.laf.Nimbus6u10;
import bibliothek.gui.dock.util.laf.Windows;
import bibliothek.util.container.Tuple;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JDesktopPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DockUI {
    private static DockUI ui;
    public static final String OVERFLOW_MENU_ICON = "overflow.menu";
    private List<ThemeFactory> themes = new ArrayList<ThemeFactory>();
    private List<Tuple<String, LookAndFeelColors>> lookAndFeelColors = new ArrayList<Tuple<String, LookAndFeelColors>>();
    private LookAndFeelColors lookAndFeelColor;
    private List<LookAndFeelColorsListener> colorsListeners = new ArrayList<LookAndFeelColorsListener>();
    private Boolean secureEnvironment = null;
    private LookAndFeelColorsListener colorsListener = new LookAndFeelColorsListener(){

        @Override
        public void colorChanged(String string) {
            LookAndFeelColorsListener[] lookAndFeelColorsListenerArray = DockUI.this.colorsListeners.toArray(new LookAndFeelColorsListener[DockUI.this.colorsListeners.size()]);
            int n = lookAndFeelColorsListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                LookAndFeelColorsListener lookAndFeelColorsListener = lookAndFeelColorsListenerArray[n2];
                lookAndFeelColorsListener.colorChanged(string);
                ++n2;
            }
        }

        @Override
        public void colorsChanged() {
            LookAndFeelColorsListener[] lookAndFeelColorsListenerArray = DockUI.this.colorsListeners.toArray(new LookAndFeelColorsListener[DockUI.this.colorsListeners.size()]);
            int n = lookAndFeelColorsListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                LookAndFeelColorsListener lookAndFeelColorsListener = lookAndFeelColorsListenerArray[n2];
                lookAndFeelColorsListener.colorsChanged();
                ++n2;
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DockUI getDefaultDockUI() {
        if (ui != null) return ui;
        Class<DockUI> clazz = DockUI.class;
        synchronized (DockUI.class) {
            if (ui != null) return ui;
            ui = new DockUI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ui;
        }
    }

    protected DockUI() {
        this.registerThemes();
        this.registerColors();
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("lookAndFeel".equals(propertyChangeEvent.getPropertyName())) {
                    DockUI.this.updateUI();
                }
            }
        });
    }

    protected void updateUI() {
        this.updateLookAndFeelColors();
    }

    private void registerThemes() {
        this.registerTheme(BasicTheme.class);
        this.registerTheme(EclipseTheme.class);
        this.registerTheme(NoStackTheme.getFactory(BasicTheme.class));
    }

    private void registerColors() {
        this.registerColors(".+", new DefaultLookAndFeelColors());
        String string = System.getProperty("java.version");
        int n = string.indexOf(46) + 1;
        int n2 = string.indexOf(46, n);
        int n3 = Integer.parseInt(string.substring(n, n2));
        if (n3 >= 7) {
            this.registerColors("javax\\.swing\\.plaf\\.nimbus\\.NimbusLookAndFeel", new Nimbus6u10());
        } else {
            this.registerColors("com\\.sun\\.java\\.swing\\.plaf\\.nimbus\\.NimbusLookAndFeel", new Nimbus6u10());
        }
        this.registerColors("com\\.sun\\.java\\.swing\\.plaf\\.windows\\.WindowsLookAndFeel", new Windows());
    }

    public ThemeFactory getDefaultTheme() {
        return this.themes.get(0);
    }

    public ThemeFactory[] getThemes() {
        return this.themes.toArray(new ThemeFactory[this.themes.size()]);
    }

    public <T extends DockTheme> void registerTheme(Class<T> clazz) {
        this.registerTheme(new ThemePropertyFactory<T>(clazz));
    }

    public void registerTheme(ThemeFactory themeFactory) {
        if (themeFactory == null) {
            throw new IllegalArgumentException("Theme must not be null");
        }
        this.themes.add(themeFactory);
    }

    public void unregisterTheme(ThemeFactory themeFactory) {
        this.themes.remove(themeFactory);
    }

    public void registerColors(String string, LookAndFeelColors lookAndFeelColors) {
        if (string == null) {
            throw new IllegalArgumentException("lookAndFeelClassNameRegex must not be null");
        }
        if (lookAndFeelColors == null) {
            throw new IllegalArgumentException("colors must not be null");
        }
        this.lookAndFeelColors.add(new Tuple<String, LookAndFeelColors>(string, lookAndFeelColors));
        this.updateLookAndFeelColors();
    }

    public void addLookAndFeelColorsListener(LookAndFeelColorsListener lookAndFeelColorsListener) {
        if (lookAndFeelColorsListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.colorsListeners.add(lookAndFeelColorsListener);
    }

    public void removeLookAndFeelColorsListener(LookAndFeelColorsListener lookAndFeelColorsListener) {
        this.colorsListeners.remove(lookAndFeelColorsListener);
    }

    protected void updateLookAndFeelColors() {
        LookAndFeelColors lookAndFeelColors = this.selectBestMatchingColors();
        if (lookAndFeelColors != this.lookAndFeelColor) {
            if (this.lookAndFeelColor != null) {
                this.lookAndFeelColor.unbind();
                this.lookAndFeelColor.removeListener(this.colorsListener);
            }
            this.lookAndFeelColor = lookAndFeelColors;
            if (lookAndFeelColors != null) {
                lookAndFeelColors.bind();
                this.lookAndFeelColor.addListener(this.colorsListener);
            }
            this.colorsListener.colorsChanged();
        }
    }

    protected LookAndFeelColors selectBestMatchingColors() {
        String string = UIManager.getLookAndFeel().getClass().getName();
        int n = this.lookAndFeelColors.size() - 1;
        while (n >= 0) {
            if (string.matches((String)this.lookAndFeelColors.get(n).getA())) {
                return this.lookAndFeelColors.get(n).getB();
            }
            --n;
        }
        return null;
    }

    public LookAndFeelColors getColors() {
        return this.lookAndFeelColor;
    }

    public static Color getColor(String string) {
        return DockUI.getDefaultDockUI().getColors().getColor(string);
    }

    public static <D extends DockStation, L> void updateTheme(D d, DockFactory<D, ?, L> dockFactory) throws IOException {
        HashMap<Integer, Dockable> hashMap = new HashMap<Integer, Dockable>();
        HashMap<Dockable, Integer> hashMap2 = new HashMap<Dockable, Integer>();
        int n = 0;
        int n2 = d.getDockableCount();
        while (n < n2) {
            Dockable dockable = d.getDockable(n);
            hashMap.put(n, dockable);
            hashMap2.put(dockable, n);
            ++n;
        }
        Object l = dockFactory.getLayout(d, hashMap2);
        DockController dockController = d.getController();
        if (dockController != null) {
            dockController.getRegister().setStalled(true);
            dockController.getHierarchyLock().setConcurrent(true);
        }
        try {
            int n3 = d.getDockableCount() - 1;
            while (n3 >= 0) {
                d.drag(d.getDockable(n3));
                --n3;
            }
            dockFactory.setLayout(d, l, hashMap, null);
        }
        finally {
            if (dockController != null) {
                dockController.getRegister().setStalled(false);
                dockController.getHierarchyLock().setConcurrent(false);
            }
        }
    }

    public static JDesktopPane getDesktopPane(Component component) {
        while (component != null) {
            if (component instanceof JDesktopPane) {
                return (JDesktopPane)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static boolean isOverlapping(Component component, Component component2) {
        if (SwingUtilities.isDescendingFrom(component2, component)) {
            return false;
        }
        if (SwingUtilities.isDescendingFrom(component, component2)) {
            return true;
        }
        if (component == component2) {
            return true;
        }
        Container container = component.getParent();
        while (container != null) {
            if (SwingUtilities.isDescendingFrom(component2, container)) {
                int n;
                Rectangle rectangle;
                Point point = new Point(0, 0);
                Point point2 = new Point(0, 0);
                point = SwingUtilities.convertPoint(component, point, container);
                point2 = SwingUtilities.convertPoint(component2, point2, container);
                Rectangle rectangle2 = new Rectangle(point, component.getSize());
                if (!rectangle2.intersects(rectangle = new Rectangle(point2, component2.getSize()))) {
                    return false;
                }
                Component component3 = DockUI.firstOnPath(container, component);
                Component component4 = DockUI.firstOnPath(container, component2);
                int n2 = container.getComponentZOrder(component3);
                return n2 < (n = container.getComponentZOrder(component4));
            }
            container = container.getParent();
        }
        return false;
    }

    public boolean isSecureEnvironment() {
        if (this.secureEnvironment != null) {
            return this.secureEnvironment;
        }
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            AWTEventListener aWTEventListener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent aWTEvent) {
                }
            };
            toolkit.addAWTEventListener(aWTEventListener, 131128L);
            toolkit.removeAWTEventListener(aWTEventListener);
        }
        catch (SecurityException securityException) {
            this.secureEnvironment = true;
            return true;
        }
        this.secureEnvironment = false;
        return false;
    }

    public void setSecureEnvironment(boolean bl) {
        this.secureEnvironment = bl;
    }

    private static Component firstOnPath(Container container, Component component) {
        Component component2 = component;
        while (component2.getParent() != container) {
            component2 = component2.getParent();
        }
        return component2;
    }
}

