/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui;

import bibliothek.extension.gui.dock.theme.eclipse.EclipseTabDockAction;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.action.ActionGuard;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionIcon;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.DockActionText;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.action.actions.SimpleButtonAction;
import bibliothek.gui.dock.control.DockRegister;
import bibliothek.gui.dock.dockable.DefaultDockableFactory;
import bibliothek.gui.dock.event.DockFrontendListener;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.VetoableDockFrontendListener;
import bibliothek.gui.dock.frontend.DefaultFrontendPerspectiveCache;
import bibliothek.gui.dock.frontend.DefaultLayoutChangeStrategy;
import bibliothek.gui.dock.frontend.DockFrontendInternals;
import bibliothek.gui.dock.frontend.DockFrontendPerspective;
import bibliothek.gui.dock.frontend.FrontendEntry;
import bibliothek.gui.dock.frontend.FrontendPerspectiveCache;
import bibliothek.gui.dock.frontend.LayoutChangeStrategy;
import bibliothek.gui.dock.frontend.Setting;
import bibliothek.gui.dock.frontend.SettingsBlop;
import bibliothek.gui.dock.frontend.VetoManager;
import bibliothek.gui.dock.layout.AdjacentDockFactory;
import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.DockSituationIgnore;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.DockablePropertyFactory;
import bibliothek.gui.dock.layout.PropertyTransformer;
import bibliothek.gui.dock.layout.location.AsideAnswer;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.layout.location.AsideRequestFactory;
import bibliothek.gui.dock.station.flap.FlapDockPropertyFactory;
import bibliothek.gui.dock.station.flap.FlapDockStationFactory;
import bibliothek.gui.dock.station.split.SplitDockPropertyFactory;
import bibliothek.gui.dock.station.split.SplitDockStationFactory;
import bibliothek.gui.dock.station.stack.StackDockPropertyFactory;
import bibliothek.gui.dock.station.stack.StackDockStationFactory;
import bibliothek.gui.dock.util.DirectWindowProvider;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.NullWindowProvider;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.WindowProvider;
import bibliothek.util.Version;
import bibliothek.util.xml.XAttribute;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.awt.Window;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class DockFrontend {
    public static final PropertyKey<KeyStroke> HIDE_ACCELERATOR = new PropertyKey("frontend hide accelerator");
    public static final String DOCKABLE_KEY_PREFIX = "dockable";
    public static final String ROOT_KEY_PREFIX = "root";
    private DockController controller;
    private Hider hider;
    private Map<String, DockInfo> dockables = new HashMap<String, DockInfo>();
    private Set<String> empty = new HashSet<String>();
    private DockStation defaultStation;
    private Map<String, RootInfo> roots = new HashMap<String, RootInfo>();
    private Set<DockFactory<?, ?, ?>> dockFactories = new HashSet();
    private Set<DockFactory<? extends Dockable, ?, ?>> backupDockFactories = new HashSet();
    private Set<AdjacentDockFactory<?>> adjacentDockFactories = new HashSet();
    private Set<DockablePropertyFactory> propertyFactories = new HashSet<DockablePropertyFactory>();
    private String currentSetting;
    private Map<String, Setting> settings = new HashMap<String, Setting>();
    private List<DockFrontendListener> listeners = new ArrayList<DockFrontendListener>();
    private VetoManager veto;
    private DockSituationIgnore ignoreForEntry;
    private DockSituationIgnore ignoreForFinal;
    private LayoutChangeStrategy layoutChangeStrategy = new DefaultLayoutChangeStrategy();
    private boolean showHideAction = true;
    private boolean defaultEntryLayout = true;
    private boolean defaultHideable = false;
    private int onAutoFire = 0;
    private Setting lastAppliedFullSetting = null;
    private Setting lastAppliedEntrySetting = null;
    private boolean readingOldLayoutInformation = false;

    public DockFrontend() {
        this(new DockController(), new NullWindowProvider());
    }

    public DockFrontend(Window window) {
        this(new DockController(), window == null ? new NullWindowProvider() : new DirectWindowProvider(window));
    }

    public DockFrontend(WindowProvider windowProvider) {
        this(new DockController(), windowProvider);
    }

    public DockFrontend(DockController dockController) {
        this(dockController, new NullWindowProvider());
    }

    public DockFrontend(DockController dockController, Window window) {
        this(dockController, window == null ? new NullWindowProvider() : new DirectWindowProvider(window));
    }

    public DockFrontend(DockController dockController, WindowProvider windowProvider) {
        if (dockController == null) {
            throw new IllegalArgumentException("controller must not be null");
        }
        this.controller = dockController;
        dockController.setRootWindowProvider(windowProvider);
        this.veto = new VetoManager(this);
        this.hider = this.createHider();
        dockController.addActionGuard(this.hider);
        this.registerFactory(new DefaultDockableFactory());
        this.registerFactory(new SplitDockStationFactory());
        this.registerFactory(new StackDockStationFactory());
        this.registerFactory(new FlapDockStationFactory());
        this.registerFactory(new SplitDockPropertyFactory());
        this.registerFactory(new StackDockPropertyFactory());
        this.registerFactory(new FlapDockPropertyFactory());
        dockController.getRegister().addDockRegisterListener(new DockRegisterAdapter(){

            @Override
            public void dockableRegistered(DockController dockController, Dockable dockable) {
                if (DockFrontend.this.onAutoFire == 0) {
                    DockFrontend.this.fireShown(dockable);
                }
            }

            @Override
            public void dockableUnregistered(DockController dockController, Dockable dockable) {
                if (DockFrontend.this.onAutoFire == 0) {
                    DockFrontend.this.fireHidden(dockable);
                }
            }
        });
    }

    public DockController getController() {
        return this.controller;
    }

    public void setOwner(WindowProvider windowProvider) {
        this.controller.setRootWindowProvider(windowProvider);
    }

    public WindowProvider getOwner() {
        return this.controller.getRootWindowProvider();
    }

    public void kill() {
        this.controller.kill();
    }

    @Deprecated
    public Collection<Dockable> getDockables() {
        return this.listDockables();
    }

    public void addFrontendListener(DockFrontendListener dockFrontendListener) {
        this.listeners.add(dockFrontendListener);
    }

    public void removeFrontendListener(DockFrontendListener dockFrontendListener) {
        this.listeners.remove(dockFrontendListener);
    }

    public void addVetoableListener(VetoableDockFrontendListener vetoableDockFrontendListener) {
        this.veto.addVetoableListener(vetoableDockFrontendListener);
    }

    public void removeVetoableListener(VetoableDockFrontendListener vetoableDockFrontendListener) {
        this.veto.removeVetoableListener(vetoableDockFrontendListener);
    }

    public void registerFactory(DockFactory<?, ?, ?> dockFactory) {
        if (dockFactory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.dockFactories.add(dockFactory);
    }

    public DockFactory<?, ?, ?> getDockFactory(String string) {
        for (DockFactory<?, ?, ?> dockFactory : this.dockFactories) {
            if (!dockFactory.getID().equals(string)) continue;
            return dockFactory;
        }
        return null;
    }

    public void registerFactory(DockFactory<? extends Dockable, ?, ?> dockFactory, boolean bl) {
        if (dockFactory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.dockFactories.add(dockFactory);
        if (bl) {
            this.backupDockFactories.add(dockFactory);
        }
    }

    public void registerBackupFactory(DockFactory<? extends Dockable, ?, ?> dockFactory) {
        if (dockFactory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.backupDockFactories.add(dockFactory);
    }

    public void registerAdjacentFactory(AdjacentDockFactory<?> adjacentDockFactory) {
        if (adjacentDockFactory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.adjacentDockFactories.add(adjacentDockFactory);
    }

    public void unregisterFactory(DockFactory<?, ?, ?> dockFactory) {
        this.dockFactories.remove(dockFactory);
    }

    public void unregisterBackupFactory(DockFactory<?, ?, ?> dockFactory) {
        this.backupDockFactories.remove(dockFactory);
    }

    public void unregisterAdjacentFactory(AdjacentDockFactory<?> adjacentDockFactory) {
        this.adjacentDockFactories.remove(adjacentDockFactory);
    }

    public void registerFactory(DockablePropertyFactory dockablePropertyFactory) {
        if (dockablePropertyFactory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.propertyFactories.add(dockablePropertyFactory);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addDockable(String string, Dockable dockable) {
        if (dockable == null) {
            throw new IllegalArgumentException("Dockable must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        DockInfo dockInfo = this.dockables.get(string);
        if (dockInfo != null) {
            if (dockInfo.getDockable() != null) throw new IllegalArgumentException("There is already a dockable registered with name " + string);
            dockInfo.setDockable(dockable);
            dockInfo.updateHideAction();
        } else {
            dockInfo = new DockInfo(dockable, string);
            this.dockables.put(string, dockInfo);
        }
        DockLayoutComposition dockLayoutComposition = dockInfo.getLayout();
        if (dockLayoutComposition != null && !this.readingOldLayoutInformation && this.layoutChangeStrategy.shouldUpdateLayoutOnAdd(dockable)) {
            try {
                try {
                    this.readingOldLayoutInformation = true;
                    DockSituation dockSituation = this.layoutChangeStrategy.createSituation(new Internals(), false);
                    dockLayoutComposition = dockSituation.fillMissing(dockLayoutComposition);
                    dockSituation.convert(dockLayoutComposition);
                    dockInfo.setLayout(null);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Cannot read old layout information", iOException);
                }
            }
            finally {
                this.readingOldLayoutInformation = false;
            }
        }
        this.fireAdded(dockable);
    }

    public void setLayoutChangeStrategy(LayoutChangeStrategy layoutChangeStrategy) {
        if (layoutChangeStrategy == null) {
            throw new IllegalArgumentException("strategy must not be null");
        }
        this.layoutChangeStrategy = layoutChangeStrategy;
    }

    public LayoutChangeStrategy getLayoutChangeStrategy() {
        return this.layoutChangeStrategy;
    }

    public PropertyTransformer createPropertyTransformer() {
        return this.layoutChangeStrategy.createTransformer(new Internals());
    }

    public Map<String, Dockable> getNamedDockables() {
        HashMap<String, Dockable> hashMap = new HashMap<String, Dockable>();
        for (Map.Entry<String, DockInfo> entry : this.dockables.entrySet()) {
            if (entry.getValue().getDockable() == null) continue;
            hashMap.put(entry.getKey(), entry.getValue().getDockable());
        }
        return hashMap;
    }

    public Dockable getDockable(String string) {
        DockInfo dockInfo = this.getInfo(string);
        return dockInfo == null ? null : dockInfo.dockable;
    }

    public String getNameOf(Dockable dockable) {
        if (dockable == null) {
            throw new NullPointerException("dockable is null");
        }
        for (Map.Entry<String, DockInfo> entry : this.dockables.entrySet()) {
            if (entry.getValue().dockable != dockable) continue;
            return entry.getKey();
        }
        return null;
    }

    public void addRoot(String string, DockStation dockStation) {
        this.addRoot(dockStation, string);
    }

    @Deprecated
    public void addRoot(DockStation dockStation, String string) {
        if (dockStation == null) {
            throw new IllegalArgumentException("Stations must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (this.roots.containsKey(string)) {
            throw new IllegalArgumentException("There is already a station registered with name " + string);
        }
        this.controller.add(dockStation);
        this.roots.put(string, new RootInfo(dockStation, string));
    }

    public DockStation getRoot(String string) {
        RootInfo rootInfo = this.roots.get(string);
        if (rootInfo == null) {
            return null;
        }
        return rootInfo.getStation();
    }

    public String[] getRootNames() {
        return this.roots.keySet().toArray(new String[this.roots.size()]);
    }

    public DockStation[] getRoots() {
        DockStation[] dockStationArray = new DockStation[this.roots.size()];
        int n = 0;
        for (RootInfo rootInfo : this.roots.values()) {
            dockStationArray[n++] = rootInfo.station;
        }
        return dockStationArray;
    }

    public void addRepresentative(DockElementRepresentative dockElementRepresentative) {
        this.controller.addRepresentative(dockElementRepresentative);
    }

    public void removeRepresentative(DockElementRepresentative dockElementRepresentative) {
        this.controller.removeRepresentative(dockElementRepresentative);
    }

    public void setDefaultStation(DockStation dockStation) {
        if (dockStation != null && this.getRoot(dockStation) == null) {
            throw new IllegalArgumentException("The default station must be registered as root");
        }
        this.defaultStation = dockStation;
    }

    public DockStation getDefaultStation() {
        if (this.defaultStation != null) {
            return this.defaultStation;
        }
        Iterator<RootInfo> iterator = this.roots.values().iterator();
        if (iterator.hasNext()) {
            return iterator.next().getStation();
        }
        return null;
    }

    public void remove(Dockable dockable) {
        DockInfo dockInfo = this.getInfo(dockable);
        if (dockInfo != null) {
            boolean bl = dockInfo.isHideable();
            dockInfo.setHideable(false);
            if (this.empty.contains(dockInfo.getKey())) {
                dockInfo.updateLocation();
                this.fireRemoved(dockable);
                dockInfo.setDockable(null);
                dockInfo.setHideable(bl);
            } else {
                this.dockables.remove(dockInfo.getKey());
                this.fireRemoved(dockable);
            }
        }
    }

    public void addEmpty(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.empty.add(string);
        if (!this.dockables.containsKey(string)) {
            this.dockables.put(string, new DockInfo(null, string));
        }
    }

    public void removeEmpty(String string) {
        this.empty.remove(string);
        DockInfo dockInfo = this.getInfo(string);
        if (dockInfo != null && dockInfo.getDockable() == null) {
            this.dockables.remove(string);
        }
    }

    public boolean isEmpty(String string) {
        return this.empty.contains(string);
    }

    public String[] listEmpty(boolean bl) {
        if (bl) {
            return this.empty.toArray(new String[this.empty.size()]);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.empty) {
            DockInfo dockInfo = this.getInfo(string);
            if (dockInfo.getDockable() != null) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void removeRoot(DockStation dockStation) {
        RootInfo rootInfo = this.getRoot(dockStation);
        if (rootInfo != null) {
            if (this.defaultStation == rootInfo.getStation()) {
                this.defaultStation = null;
            }
            this.roots.remove(rootInfo.getName());
            this.controller.remove(dockStation);
        }
    }

    public boolean hasLocation(Dockable dockable) {
        DockInfo dockInfo = this.getInfo(dockable);
        if (dockInfo == null) {
            return false;
        }
        if (this.isShown(dockable)) {
            return true;
        }
        return dockInfo.root != null && dockInfo.location != null;
    }

    public boolean hasLocation(String string) {
        DockInfo dockInfo = this.getInfo(string);
        if (dockInfo == null) {
            return false;
        }
        return dockInfo.root != null && dockInfo.location != null;
    }

    public void setIgnoreForEntry(DockSituationIgnore dockSituationIgnore) {
        this.ignoreForEntry = dockSituationIgnore;
    }

    public DockSituationIgnore getIgnoreForEntry() {
        return this.ignoreForEntry;
    }

    public void setIgnoreForFinal(DockSituationIgnore dockSituationIgnore) {
        this.ignoreForFinal = dockSituationIgnore;
    }

    public DockSituationIgnore getIgnoreForFinal() {
        return this.ignoreForFinal;
    }

    public DockProperties getDockProperties() {
        return this.controller.getProperties();
    }

    public Setting getLastAppliedFullSetting() {
        return this.lastAppliedFullSetting;
    }

    public Setting getLastAppliedEntrySetting() {
        return this.lastAppliedEntrySetting;
    }

    public Set<String> getSettings() {
        Set<String> set = this.settings.keySet();
        return Collections.unmodifiableSet(set);
    }

    public Setting getSetting(String string) {
        return this.settings.get(string);
    }

    public String getCurrentSetting() {
        return this.currentSetting;
    }

    public void setCurrentSetting(String string) {
        if (string == null) {
            throw new IllegalArgumentException("the name of a setting must not be null");
        }
        if (this.settings.containsKey(string)) {
            this.load(string);
        } else {
            this.save(string);
        }
    }

    public void setCurrentSettingName(String string) {
        this.currentSetting = string;
    }

    public void setSetting(String string, Setting setting) {
        if (setting == null) {
            throw new IllegalArgumentException("setting is null");
        }
        this.settings.put(string, setting);
    }

    public boolean isHidden(Dockable dockable) {
        return !this.isShown(dockable);
    }

    public boolean isShown(Dockable dockable) {
        return this.controller.getRegister().willBeRegistered(dockable);
    }

    public boolean isHiddenRootStation(DockElement dockElement) {
        Dockable dockable = dockElement.asDockable();
        DockStation dockStation = dockElement.asDockStation();
        if (dockStation == null || dockable == null) {
            return false;
        }
        DockRegister dockRegister = this.controller.getRegister();
        if (dockRegister.isProtected(dockStation)) {
            return dockable.getDockParent() == null;
        }
        return false;
    }

    public void setDefaultHideable(boolean bl) {
        this.defaultHideable = bl;
    }

    public boolean isDefaultHideable() {
        return this.defaultHideable;
    }

    public boolean isHideable(Dockable dockable) {
        DockInfo dockInfo = this.getInfo(dockable);
        if (dockInfo == null) {
            throw new IllegalArgumentException("Dockable not registered");
        }
        return dockInfo.isHideable();
    }

    public void setHideable(Dockable dockable, boolean bl) {
        DockInfo dockInfo = this.getInfo(dockable);
        if (dockInfo == null) {
            throw new IllegalArgumentException("Dockable not registered");
        }
        if (dockInfo.isHideable() != bl) {
            dockInfo.setHideable(bl);
            this.fireHideable(dockable, bl);
        }
    }

    public void setShowHideAction(boolean bl) {
        if (this.showHideAction != bl) {
            this.showHideAction = bl;
            for (DockInfo dockInfo : this.dockables.values()) {
                dockInfo.updateHideAction();
            }
        }
    }

    public boolean isShowHideAction() {
        return this.showHideAction;
    }

    public void setDefaultEntryLayout(boolean bl) {
        this.defaultEntryLayout = bl;
    }

    public boolean isDefaultEntryLayout() {
        return this.defaultEntryLayout;
    }

    public void setEntryLayout(Dockable dockable, boolean bl) {
        DockInfo dockInfo = this.getInfo(dockable);
        if (dockInfo == null) {
            throw new IllegalArgumentException("dockable not registered");
        }
        dockInfo.setEntryLayout(bl);
    }

    public void setEntryLayout(String string, boolean bl) {
        DockInfo dockInfo = this.getInfo(string);
        if (dockInfo == null) {
            throw new IllegalArgumentException("no entry present for: " + string);
        }
        dockInfo.setEntryLayout(bl);
    }

    public boolean isEntryLayout(Dockable dockable) {
        DockInfo dockInfo = this.getInfo(dockable);
        if (dockInfo == null) {
            throw new IllegalArgumentException("dockable not registered");
        }
        return dockInfo.isEntryLayout();
    }

    public boolean isEntryLayout(String string) {
        DockInfo dockInfo = this.getInfo(string);
        if (dockInfo == null) {
            throw new IllegalArgumentException("no entry present for: " + string);
        }
        return dockInfo.isEntryLayout();
    }

    public boolean setLocationAside(Dockable dockable, Dockable dockable2) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        if (dockable2 == null) {
            throw new IllegalArgumentException("aside must not be null");
        }
        if (dockable == dockable2) {
            throw new IllegalArgumentException("dockable and aside must not be the same object");
        }
        DockInfo dockInfo = this.getInfo(dockable2);
        if (dockInfo == null) {
            return false;
        }
        DockInfo dockInfo2 = this.getInfo(dockable);
        if (dockInfo2 == null) {
            return false;
        }
        dockInfo.updateLocation();
        String string = dockInfo.getRoot();
        DockableProperty dockableProperty = dockInfo.getLocation();
        if (string == null || dockableProperty == null) {
            return false;
        }
        DockStation dockStation = this.getRoot(string);
        if (dockStation == null) {
            return false;
        }
        AsideRequestFactory asideRequestFactory = this.controller.getProperties().get(AsideRequest.REQUEST_FACTORY);
        AsideRequest asideRequest = asideRequestFactory.createAsideRequest(dockableProperty, dockable);
        AsideAnswer asideAnswer = asideRequest.execute(dockStation);
        if (asideAnswer.isCanceled() || asideAnswer.getLocation() == null) {
            return false;
        }
        dockInfo2.setLocation(string, asideAnswer.getLocation());
        return true;
    }

    public void show(Dockable dockable) {
        this.show(dockable, true);
    }

    public void show(Dockable dockable, boolean bl) {
        try {
            ++this.onAutoFire;
            if ((this.isHidden(dockable) || this.isHiddenRootStation(dockable)) && this.veto.expectToShow(dockable, bl)) {
                DockInfo dockInfo = this.getInfo(dockable);
                if (dockInfo == null) {
                    DockStation dockStation = this.getDefaultStation();
                    if (dockStation == null) {
                        throw new IllegalStateException("Can't find the default station");
                    }
                    dockStation.drop(dockable);
                } else {
                    String string = dockInfo.getRoot();
                    DockableProperty dockableProperty = dockInfo.getLocation();
                    DockStation dockStation = string == null ? this.getDefaultStation() : this.getRoot(string);
                    if (dockStation == null && (dockStation = this.getDefaultStation()) == null) {
                        throw new IllegalStateException("Can't find the default station");
                    }
                    if (dockableProperty == null) {
                        this.getDefaultStation().drop(dockable);
                    } else if (!dockStation.drop(dockable, dockableProperty)) {
                        this.getDefaultStation().drop(dockable);
                    }
                }
                this.fireAllShown(dockable, null);
            }
        }
        finally {
            --this.onAutoFire;
        }
    }

    public void hide(Dockable dockable) {
        this.hide(dockable, true);
    }

    public void hide(Dockable dockable, boolean bl) {
        try {
            ++this.onAutoFire;
            if (this.isShown(dockable) && (dockable.getDockParent() == null || this.veto.expectToHide(dockable, bl))) {
                DockInfo dockInfo = this.getInfo(dockable);
                if (dockInfo != null) {
                    dockInfo.updateLocation();
                }
                if (dockable.getDockParent() != null) {
                    dockable.getDockParent().drag(dockable);
                    this.fireAllHidden(dockable, null);
                }
            }
        }
        finally {
            --this.onAutoFire;
        }
    }

    public void save() {
        if (this.currentSetting == null) {
            throw new IllegalStateException("No setting loaded yet");
        }
        this.save(this.currentSetting);
    }

    public void save(String string) {
        this.save(string, true);
    }

    public void save(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Setting setting = this.getSetting(bl);
        this.setSetting(string, setting);
        this.currentSetting = string;
        this.fireSaved(string);
    }

    public void load(String string) {
        this.load(string, true);
    }

    public void load(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Setting setting = this.settings.get(string);
        if (setting == null) {
            throw new IllegalArgumentException("Unknown setting \"" + string + "\"");
        }
        this.currentSetting = string;
        this.setSetting(setting, bl);
        this.fireLoaded(string);
    }

    public Setting getSetting(boolean bl) {
        DockLayoutComposition dockLayoutComposition;
        DockElement dockElement;
        Setting setting = this.createSetting();
        DockSituation dockSituation = this.layoutChangeStrategy.createSituation(new Internals(), bl);
        for (RootInfo object : this.roots.values()) {
            dockElement = object.getStation();
            if (dockElement.asDockable() != null && dockElement.asDockable().getDockParent() != null) continue;
            dockLayoutComposition = dockSituation.convert(dockElement);
            setting.putRoot(object.getName(), dockLayoutComposition);
        }
        for (DockInfo dockInfo : this.dockables.values()) {
            dockElement = dockInfo.getDockable();
            if (dockElement != null && dockElement.getController() != null) continue;
            dockLayoutComposition = null;
            if (!bl || dockInfo.isEntryLayout()) {
                dockLayoutComposition = dockElement != null ? dockSituation.convert(dockElement) : dockInfo.getLayout();
            }
            setting.addInvisible(dockInfo.getKey(), dockInfo.getRoot(), dockLayoutComposition, dockInfo.getLocation());
        }
        return setting;
    }

    public void setSetting(Setting setting, boolean bl) {
        try {
            try {
                ++this.onAutoFire;
                this.controller.getRegister().setStalled(true);
                if (this.layoutChangeStrategy.setLayout(new Internals(), setting, bl)) {
                    if (bl) {
                        this.lastAppliedEntrySetting = setting;
                    } else {
                        this.lastAppliedEntrySetting = null;
                        this.lastAppliedFullSetting = setting;
                    }
                }
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Cannot set Setting", iOException);
            }
            catch (XException xException) {
                throw new IllegalArgumentException("Cannot set Setting", xException);
            }
        }
        finally {
            --this.onAutoFire;
            this.controller.getRegister().setStalled(false);
        }
        for (DockInfo dockInfo : this.dockables.values()) {
            if (dockInfo.getDockable() == null || dockInfo.isHideable() || !this.isHidden(dockInfo.getDockable())) continue;
            this.show(dockInfo.getDockable());
        }
    }

    public DockFrontendPerspective getPerspective(boolean bl) {
        return this.getPerspective(bl, new DefaultFrontendPerspectiveCache(this));
    }

    public DockFrontendPerspective getPerspective(boolean bl, FrontendPerspectiveCache frontendPerspectiveCache) {
        return this.layoutChangeStrategy.createPerspective(new Internals(), bl, frontendPerspectiveCache);
    }

    public Set<Dockable> listShownDockables() {
        HashSet<Dockable> hashSet = new HashSet<Dockable>();
        for (DockInfo dockInfo : this.dockables.values()) {
            if (dockInfo.getDockable() == null || !this.isShown(dockInfo.getDockable())) continue;
            hashSet.add(dockInfo.getDockable());
        }
        return hashSet;
    }

    public List<Dockable> listDockables() {
        ArrayList<Dockable> arrayList = new ArrayList<Dockable>(this.dockables.size());
        for (DockInfo dockInfo : this.dockables.values()) {
            if (dockInfo.getDockable() == null) continue;
            arrayList.add(dockInfo.getDockable());
        }
        return arrayList;
    }

    public List<FrontendEntry> listFrontendEntries() {
        return new ArrayList<FrontendEntry>(this.dockables.values());
    }

    public FrontendEntry getFrontendEntry(String string) {
        return this.dockables.get(string);
    }

    public FrontendEntry getFrontendEntry(Dockable dockable) {
        return this.getInfo(dockable);
    }

    protected void clean(DockSituationIgnore dockSituationIgnore) {
        for (RootInfo rootInfo : this.roots.values()) {
            if (dockSituationIgnore.ignoreElement(rootInfo.getStation())) continue;
            this.clean(rootInfo.getStation(), dockSituationIgnore);
        }
    }

    protected void clean(DockStation dockStation, DockSituationIgnore dockSituationIgnore) {
        try {
            this.controller.getRegister().setStalled(true);
            if (!dockSituationIgnore.ignoreChildren(dockStation)) {
                int n = dockStation.getDockableCount() - 1;
                while (n >= 0) {
                    Dockable dockable = dockStation.getDockable(n);
                    if (!dockSituationIgnore.ignoreElement(dockable)) {
                        DockStation dockStation2 = dockable.asDockStation();
                        if (dockStation2 != null) {
                            this.clean(dockStation2, dockSituationIgnore);
                        }
                        dockStation.drag(dockable);
                    }
                    --n;
                }
            }
        }
        finally {
            this.controller.getRegister().setStalled(false);
        }
    }

    public int deleteAll() {
        String[] stringArray;
        int n = 0;
        Set<String> set = this.getSettings();
        String[] stringArray2 = stringArray = set.toArray(new String[set.size()]);
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray2[n3];
            if (this.delete(string)) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    public boolean delete(String string) {
        boolean bl;
        if (string == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        boolean bl2 = bl = this.settings.remove(string) != null;
        if (bl) {
            if (string.equals(this.currentSetting)) {
                this.currentSetting = null;
            }
            this.fireDeleted(string);
        }
        return bl;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        this.writeBlop(this.writeBlop(), dataOutputStream);
    }

    public void writeBlop(SettingsBlop settingsBlop, DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_1_1a);
        String string = settingsBlop.getCurrentName();
        if (string == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeUTF(string);
        }
        String[] stringArray = settingsBlop.getNames();
        dataOutputStream.writeInt(stringArray.length);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            dataOutputStream.writeUTF(string2);
            this.write(settingsBlop.getSetting(string2), true, dataOutputStream);
            ++n2;
        }
        this.write(settingsBlop.getCurrentSetting(), false, dataOutputStream);
    }

    protected void write(Setting setting, boolean bl, DataOutputStream dataOutputStream) throws IOException {
        Internals internals = new Internals();
        DockSituation dockSituation = this.layoutChangeStrategy.createSituation(internals, bl);
        PropertyTransformer propertyTransformer = this.layoutChangeStrategy.createTransformer(internals);
        setting.write(dockSituation, propertyTransformer, bl, dataOutputStream);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.read(dataInputStream, false);
    }

    public void read(DataInputStream dataInputStream, boolean bl) throws IOException {
        this.readBlop(this.readBlop(dataInputStream), bl);
    }

    public SettingsBlop readBlop(DataInputStream dataInputStream) throws IOException {
        SettingsBlop settingsBlop = new SettingsBlop();
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        String string = null;
        if (dataInputStream.readBoolean()) {
            string = dataInputStream.readUTF();
        }
        int n = dataInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            String string2 = dataInputStream.readUTF();
            Setting setting = this.read(true, dataInputStream);
            settingsBlop.put(string2, setting);
            ++n2;
        }
        settingsBlop.setCurrent(string, this.read(false, dataInputStream));
        return settingsBlop;
    }

    protected Setting read(boolean bl, DataInputStream dataInputStream) throws IOException {
        Setting setting = this.createSetting();
        Internals internals = new Internals();
        DockSituation dockSituation = this.layoutChangeStrategy.createSituation(internals, bl);
        PropertyTransformer propertyTransformer = this.layoutChangeStrategy.createTransformer(internals);
        setting.read(dockSituation, propertyTransformer, bl, dataInputStream);
        return setting;
    }

    public void writeXML(XElement xElement) {
        this.writeBlopXML(this.writeBlop(), xElement);
    }

    public void writeBlopXML(SettingsBlop settingsBlop, XElement xElement) {
        String string;
        XElement xElement2;
        String[] stringArray = settingsBlop.getNames();
        if (stringArray.length > 0) {
            xElement2 = xElement.addElement("settings");
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                string = stringArray2[n2];
                XElement xElement3 = xElement2.addElement("setting");
                xElement3.addString("name", string);
                this.writeXML(settingsBlop.getSetting(string), true, xElement3);
                ++n2;
            }
        }
        xElement2 = xElement.addElement("current");
        string = settingsBlop.getCurrentName();
        if (string != null) {
            xElement2.addString("name", string);
        }
        this.writeXML(settingsBlop.getCurrentSetting(), false, xElement2);
    }

    protected void writeXML(Setting setting, boolean bl, XElement xElement) {
        Internals internals = new Internals();
        DockSituation dockSituation = this.layoutChangeStrategy.createSituation(internals, bl);
        PropertyTransformer propertyTransformer = this.layoutChangeStrategy.createTransformer(internals);
        setting.writeXML(dockSituation, propertyTransformer, bl, xElement);
    }

    public void readXML(XElement xElement) {
        this.readXML(xElement, false);
    }

    public void readXML(XElement xElement, boolean bl) {
        this.readBlop(this.readBlopXML(xElement), bl);
    }

    public SettingsBlop readBlopXML(XElement xElement) {
        XElement xElement2;
        SettingsBlop settingsBlop = new SettingsBlop();
        XElement xElement3 = xElement.getElement("settings");
        if (xElement3 != null) {
            XElement[] xElementArray = xElement3.getElements("setting");
            int n = xElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                xElement2 = xElementArray[n2];
                String string = xElement2.getString("name");
                Setting setting = this.readXML(true, xElement2);
                settingsBlop.put(string, setting);
                ++n2;
            }
        }
        if ((xElement2 = xElement.getElement("current")) != null) {
            XAttribute xAttribute = xElement2.getAttribute("name");
            String string = null;
            if (xAttribute != null) {
                string = xAttribute.getString();
            }
            settingsBlop.setCurrent(string, this.readXML(false, xElement2));
        }
        return settingsBlop;
    }

    protected Setting readXML(boolean bl, XElement xElement) {
        Setting setting = this.createSetting();
        Internals internals = new Internals();
        DockSituation dockSituation = this.layoutChangeStrategy.createSituation(internals, bl);
        PropertyTransformer propertyTransformer = this.layoutChangeStrategy.createTransformer(internals);
        setting.readXML(dockSituation, propertyTransformer, bl, xElement);
        return setting;
    }

    public SettingsBlop writeBlop() {
        SettingsBlop settingsBlop = new SettingsBlop();
        for (Map.Entry<String, Setting> entry : this.settings.entrySet()) {
            settingsBlop.put(entry.getKey(), entry.getValue());
        }
        settingsBlop.setCurrent(this.currentSetting, this.getSetting(false));
        return settingsBlop;
    }

    public void readBlop(SettingsBlop settingsBlop, boolean bl) {
        if (!bl) {
            this.deleteAll();
        }
        String[] stringArray = settingsBlop.getNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this.settings.put(string, settingsBlop.getSetting(string));
            this.fireRead(string);
            ++n2;
        }
        this.currentSetting = settingsBlop.getCurrentName();
        this.setSetting(settingsBlop.getCurrentSetting(), false);
    }

    protected Hider createHider() {
        return new Hider();
    }

    protected Setting createSetting() {
        return new Setting();
    }

    public Hider getHider() {
        return this.hider;
    }

    private DockInfo getInfo(Dockable dockable) {
        if (dockable == null) {
            throw new NullPointerException("dockable is null");
        }
        for (DockInfo dockInfo : this.dockables.values()) {
            if (dockInfo.getDockable() != dockable) continue;
            return dockInfo;
        }
        return null;
    }

    private DockInfo getInfo(String string) {
        return this.dockables.get(string);
    }

    private RootInfo getRoot(DockStation dockStation) {
        for (RootInfo rootInfo : this.roots.values()) {
            if (rootInfo.getStation() != dockStation) continue;
            return rootInfo;
        }
        return null;
    }

    private RootInfo getRoot(Dockable dockable) {
        RootInfo rootInfo;
        DockStation dockStation = dockable.asDockStation();
        if (dockStation != null && (rootInfo = this.getRoot(dockStation)) != null) {
            return rootInfo;
        }
        dockStation = dockable.getDockParent();
        while (dockStation != null) {
            rootInfo = this.getRoot(dockStation);
            if (rootInfo != null) {
                return rootInfo;
            }
            dockable = dockStation.asDockable();
            if (dockable == null) {
                return null;
            }
            dockStation = dockable.getDockParent();
        }
        return null;
    }

    protected DockFrontendListener[] listeners() {
        return this.listeners.toArray(new DockFrontendListener[this.listeners.size()]);
    }

    protected void fireAllHidden(Dockable dockable, final Set<Dockable> set) {
        DockUtilities.visit(dockable, new DockUtilities.DockVisitor(){

            @Override
            public void handleDockable(Dockable dockable) {
                if (set == null || set.add(dockable)) {
                    DockFrontend.this.fireHidden(dockable);
                    DockInfo dockInfo = DockFrontend.this.getInfo(dockable);
                    if (dockInfo != null) {
                        dockInfo.setShown(false);
                    }
                }
            }
        });
    }

    protected void fireHidden(Dockable dockable) {
        DockFrontendListener[] dockFrontendListenerArray = this.listeners();
        int n = dockFrontendListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockFrontendListener dockFrontendListener = dockFrontendListenerArray[n2];
            dockFrontendListener.hidden(this, dockable);
            ++n2;
        }
    }

    protected void fireAdded(Dockable dockable) {
        DockFrontendListener[] dockFrontendListenerArray = this.listeners();
        int n = dockFrontendListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockFrontendListener dockFrontendListener = dockFrontendListenerArray[n2];
            dockFrontendListener.added(this, dockable);
            ++n2;
        }
    }

    protected void fireHideable(Dockable dockable, boolean bl) {
        DockFrontendListener[] dockFrontendListenerArray = this.listeners();
        int n = dockFrontendListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockFrontendListener dockFrontendListener = dockFrontendListenerArray[n2];
            dockFrontendListener.hideable(this, dockable, bl);
            ++n2;
        }
    }

    protected void fireRemoved(Dockable dockable) {
        DockFrontendListener[] dockFrontendListenerArray = this.listeners();
        int n = dockFrontendListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockFrontendListener dockFrontendListener = dockFrontendListenerArray[n2];
            dockFrontendListener.removed(this, dockable);
            ++n2;
        }
    }

    protected void fireAllShown(Dockable dockable, final Set<Dockable> set) {
        DockUtilities.visit(dockable, new DockUtilities.DockVisitor(){

            @Override
            public void handleDockable(Dockable dockable) {
                if (set == null || set.add(dockable)) {
                    DockFrontend.this.fireShown(dockable);
                    DockInfo dockInfo = DockFrontend.this.getInfo(dockable);
                    if (dockInfo != null) {
                        dockInfo.setShown(true);
                    }
                }
            }
        });
    }

    protected void fireShown(Dockable dockable) {
        DockFrontendListener[] dockFrontendListenerArray = this.listeners();
        int n = dockFrontendListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockFrontendListener dockFrontendListener = dockFrontendListenerArray[n2];
            dockFrontendListener.shown(this, dockable);
            ++n2;
        }
    }

    protected void fireSaved(String string) {
        DockFrontendListener[] dockFrontendListenerArray = this.listeners();
        int n = dockFrontendListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockFrontendListener dockFrontendListener = dockFrontendListenerArray[n2];
            dockFrontendListener.saved(this, string);
            ++n2;
        }
    }

    protected void fireLoaded(String string) {
        DockFrontendListener[] dockFrontendListenerArray = this.listeners();
        int n = dockFrontendListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockFrontendListener dockFrontendListener = dockFrontendListenerArray[n2];
            dockFrontendListener.loaded(this, string);
            ++n2;
        }
    }

    protected void fireRead(String string) {
        DockFrontendListener[] dockFrontendListenerArray = this.listeners();
        int n = dockFrontendListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockFrontendListener dockFrontendListener = dockFrontendListenerArray[n2];
            dockFrontendListener.read(this, string);
            ++n2;
        }
    }

    protected void fireDeleted(String string) {
        DockFrontendListener[] dockFrontendListenerArray = this.listeners();
        int n = dockFrontendListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockFrontendListener dockFrontendListener = dockFrontendListenerArray[n2];
            dockFrontendListener.deleted(this, string);
            ++n2;
        }
    }

    public class DockInfo
    implements FrontendEntry {
        private Dockable dockable;
        private String key;
        private boolean hideable;
        private DefaultDockActionSource source;
        private String root;
        private DockableProperty location;
        private boolean entryLayout;
        private DockLayoutComposition layout;
        private boolean hideActionVisible;
        private boolean shown = false;

        public DockInfo(Dockable dockable, String string) {
            this.dockable = dockable;
            this.key = string;
            this.entryLayout = DockFrontend.this.defaultEntryLayout;
            this.source = new DefaultDockActionSource(new LocationHint(LocationHint.ACTION_GUARD, LocationHint.RIGHT_OF_ALL), new DockAction[0]);
            this.hideActionVisible = false;
            this.setHideable(DockFrontend.this.defaultHideable);
        }

        @Override
        public void setShown(boolean bl) {
            this.shown = bl;
        }

        @Override
        public boolean isShown() {
            return this.shown;
        }

        @Override
        public boolean isEntryLayout() {
            return this.entryLayout;
        }

        @Override
        public void setEntryLayout(boolean bl) {
            this.entryLayout = bl;
        }

        @Override
        public boolean isHideable() {
            return this.hideable;
        }

        @Override
        public void setHideable(boolean bl) {
            this.hideable = bl;
            this.updateHideAction();
        }

        public void updateHideAction() {
            boolean bl;
            boolean bl2 = bl = this.hideable && DockFrontend.this.showHideAction;
            if (bl != this.hideActionVisible) {
                this.hideActionVisible = bl;
                if (bl) {
                    this.source.add(DockFrontend.this.hider);
                } else {
                    this.source.remove(DockFrontend.this.hider);
                }
            }
        }

        public DefaultDockActionSource getSource() {
            return this.source;
        }

        @Override
        public Dockable getDockable() {
            return this.dockable;
        }

        public void setDockable(Dockable dockable) {
            this.dockable = dockable;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public void updateLocation() {
            RootInfo rootInfo = DockFrontend.this.getRoot(this.dockable);
            if (rootInfo == null) {
                return;
            }
            if (rootInfo.getStation() == this.dockable) {
                if (this.dockable.getDockParent() != null) {
                    rootInfo = DockFrontend.this.getRoot(this.dockable.getDockParent());
                    if (rootInfo == null) {
                        return;
                    }
                } else {
                    return;
                }
            }
            this.root = rootInfo.getName();
            this.location = DockUtilities.getPropertyChain(rootInfo.getStation(), this.dockable);
        }

        @Override
        public void setLocation(String string, DockableProperty dockableProperty) {
            this.root = string;
            this.location = dockableProperty;
        }

        @Override
        public String getRoot() {
            return this.root;
        }

        @Override
        public DockableProperty getLocation() {
            return this.location;
        }

        @Override
        public void setLayout(DockLayoutComposition dockLayoutComposition) {
            this.layout = dockLayoutComposition;
        }

        @Override
        public DockLayoutComposition getLayout() {
            return this.layout;
        }
    }

    @EclipseTabDockAction
    public class Hider
    extends SimpleButtonAction
    implements ActionGuard {
        private DockActionIcon icon;
        private DockActionText text = new DockActionText("close", this){

            @Override
            protected void changed(String string, String string2) {
                Hider.this.setText(string2);
            }
        };
        private DockActionText tooltip = new DockActionText("close.tooltip", this){

            @Override
            protected void changed(String string, String string2) {
                Hider.this.setTooltip(string2);
            }
        };

        public Hider() {
            this.icon = new DockActionIcon("close", this){

                @Override
                protected void changed(Icon icon, Icon icon2) {
                    Hider.this.setIcon(icon2);
                }
            };
            this.text.setController(DockFrontend.this.controller);
            this.tooltip.setController(DockFrontend.this.controller);
            this.icon.setManager(DockFrontend.this.controller.getIcons());
            PropertyValue<KeyStroke> propertyValue = new PropertyValue<KeyStroke>(HIDE_ACCELERATOR){

                @Override
                protected void valueChanged(KeyStroke keyStroke, KeyStroke keyStroke2) {
                    Hider.this.setAccelerator(keyStroke2);
                }
            };
            propertyValue.setProperties(DockFrontend.this.controller);
            this.setAccelerator((KeyStroke)propertyValue.getValue());
        }

        public void iconChanged(String string, Icon icon) {
            this.setIcon(icon);
        }

        @Override
        public DockActionSource getSource(Dockable dockable) {
            DockInfo dockInfo = DockFrontend.this.getInfo(dockable);
            if (dockInfo == null) {
                return new DefaultDockActionSource(new LocationHint(LocationHint.ACTION_GUARD, LocationHint.RIGHT_OF_ALL), this);
            }
            return dockInfo.getSource();
        }

        @Override
        public boolean react(Dockable dockable) {
            DockInfo dockInfo = DockFrontend.this.getInfo(dockable);
            return dockInfo != null;
        }

        @Override
        public void action(Dockable dockable) {
            DockFrontend.this.hide(dockable);
        }
    }

    private class Internals
    implements DockFrontendInternals {
        private Internals() {
        }

        @Override
        public void clean(DockSituationIgnore dockSituationIgnore) {
            DockFrontend.this.clean(dockSituationIgnore);
        }

        @Override
        public AdjacentDockFactory<?>[] getAdjacentDockFactories() {
            return DockFrontend.this.adjacentDockFactories.toArray(new AdjacentDockFactory[DockFrontend.this.adjacentDockFactories.size()]);
        }

        @Override
        public DockFactory<?, ?, ?>[] getBackupDockFactories() {
            return DockFrontend.this.backupDockFactories.toArray(new DockFactory[DockFrontend.this.backupDockFactories.size()]);
        }

        @Override
        public DockFactory<?, ?, ?>[] getDockFactories() {
            return DockFrontend.this.dockFactories.toArray(new DockFactory[DockFrontend.this.dockFactories.size()]);
        }

        @Override
        public DockInfo[] getDockables() {
            return DockFrontend.this.dockables.values().toArray(new DockInfo[DockFrontend.this.dockables.size()]);
        }

        @Override
        public DockFrontend getFrontend() {
            return DockFrontend.this;
        }

        @Override
        public DockInfo getInfo(String string) {
            return DockFrontend.this.getInfo(string);
        }

        @Override
        public DockInfo getInfo(Dockable dockable) {
            return DockFrontend.this.getInfo(dockable);
        }

        @Override
        public DockablePropertyFactory[] getPropertyFactories() {
            return DockFrontend.this.propertyFactories.toArray(new DockablePropertyFactory[DockFrontend.this.propertyFactories.size()]);
        }

        @Override
        public RootInfo[] getRoots() {
            return DockFrontend.this.roots.values().toArray(new RootInfo[DockFrontend.this.roots.size()]);
        }

        @Override
        public VetoManager getVetos() {
            return DockFrontend.this.veto;
        }
    }

    public static class RootInfo {
        private DockStation station;
        private String name;

        public RootInfo(DockStation dockStation, String string) {
            this.name = string;
            this.station = dockStation;
        }

        public String getName() {
            return this.name;
        }

        public DockStation getStation() {
            return this.station;
        }
    }
}

