/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.DockHierarchyLock;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.accept.DockAcceptance;
import bibliothek.gui.dock.accept.MultiDockAcceptance;
import bibliothek.gui.dock.action.ActionGuard;
import bibliothek.gui.dock.action.ActionOffer;
import bibliothek.gui.dock.action.ActionPopupSuppressor;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.popup.ActionPopupMenuFactory;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.component.DockComponentManager;
import bibliothek.gui.dock.control.ComponentHierarchyObserver;
import bibliothek.gui.dock.control.ControllerSetupCollection;
import bibliothek.gui.dock.control.DefaultDockControllerFactory;
import bibliothek.gui.dock.control.DockControllerFactory;
import bibliothek.gui.dock.control.DockRegister;
import bibliothek.gui.dock.control.DockRelocator;
import bibliothek.gui.dock.control.DockRelocatorMode;
import bibliothek.gui.dock.control.DockableSelector;
import bibliothek.gui.dock.control.DoubleClickController;
import bibliothek.gui.dock.control.GlobalMouseDispatcher;
import bibliothek.gui.dock.control.KeyboardController;
import bibliothek.gui.dock.control.PopupController;
import bibliothek.gui.dock.control.SingleParentRemover;
import bibliothek.gui.dock.control.focus.DefaultFocusRequest;
import bibliothek.gui.dock.control.focus.FocusController;
import bibliothek.gui.dock.control.focus.FocusHistory;
import bibliothek.gui.dock.control.focus.FocusRequest;
import bibliothek.gui.dock.control.focus.MouseFocusObserver;
import bibliothek.gui.dock.event.ControllerSetupListener;
import bibliothek.gui.dock.event.DockControllerRepresentativeListener;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockRegisterListener;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.event.DockTitleBindingListener;
import bibliothek.gui.dock.event.DockableAdapter;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.event.DockableSelectionEvent;
import bibliothek.gui.dock.event.DockableSelectionListener;
import bibliothek.gui.dock.themes.ThemeManager;
import bibliothek.gui.dock.title.ActivityDockTitleEvent;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleManager;
import bibliothek.gui.dock.util.CoreWarningDialog;
import bibliothek.gui.dock.util.DirectWindowProvider;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.TextManager;
import bibliothek.gui.dock.util.UIScheme;
import bibliothek.gui.dock.util.WindowProvider;
import bibliothek.gui.dock.util.WindowProviderListener;
import bibliothek.gui.dock.util.WindowProviderWrapper;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.gui.dock.util.icon.DefaultIconScheme;
import bibliothek.gui.dock.util.icon.DockIcon;
import bibliothek.gui.dock.util.icon.DockIconBridge;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.gui.dock.util.text.DefaultTextScheme;
import bibliothek.gui.dock.util.text.TextBridge;
import bibliothek.gui.dock.util.text.TextValue;
import bibliothek.util.Workarounds;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class DockController {
    public static final PropertyKey<Boolean> RESTRICTED_ENVIRONMENT = new PropertyKey<Boolean>("dock.restricted_environment", new ConstantPropertyFactory<Boolean>(DockUI.getDefaultDockUI().isSecureEnvironment()), true);
    private DockRegister register;
    private ComponentHierarchyObserver componentHierarchyObserver;
    private DockRelocator relocator;
    private DoubleClickController doubleClickController;
    private KeyboardController keyboardController;
    private DockableSelector dockableSelector;
    private List<DockableSelectionListener> dockableSelectionListeners = new ArrayList<DockableSelectionListener>();
    private List<DockTitleBindingListener> dockTitleBindingListeners = new ArrayList<DockTitleBindingListener>();
    private MouseFocusObserver focusObserver;
    private GlobalMouseDispatcher mouseDispatcher;
    private FocusController focusController;
    private FocusHistory focusHistory;
    private DockTitleObserver dockTitleObserver = new DockTitleObserver();
    private Map<DockTitle, Dockable> activeTitles = new HashMap<DockTitle, Dockable>();
    private DockTitleManager dockTitles;
    private DockComponentManager dockComponentManager;
    private IconManager icons;
    private TextManager texts;
    private ColorManager colors;
    private List<ActionOffer> actionOffers = new ArrayList<ActionOffer>();
    private List<ActionGuard> guards = new ArrayList<ActionGuard>();
    private ActionOffer defaultActionOffer;
    private ActionViewConverter actionViewConverter;
    private MultiDockAcceptance acceptance = new MultiDockAcceptance();
    private PopupController popupController;
    private SingleParentRemover remover;
    private ThemeManager theme;
    private DockProperties properties;
    private DockControllerFactory factory;
    private Map<Component, DockElementRepresentative> componentToDockElements = new HashMap<Component, DockElementRepresentative>();
    private List<DockControllerRepresentativeListener> componentToDockElementsListeners = new ArrayList<DockControllerRepresentativeListener>();
    private WindowProviderWrapper rootWindowProvider;
    private Window rootWindow;
    private DockHierarchyLock lock = new DockHierarchyLock();
    private static boolean showCoreWarning = true;

    public DockController() {
        this(new DefaultDockControllerFactory());
    }

    public DockController(DockControllerFactory dockControllerFactory) {
        if (dockControllerFactory != null) {
            this.initiate(dockControllerFactory, null);
        }
        this.showCoreWarning();
    }

    @Deprecated
    public static void disableCoreWarning() {
        showCoreWarning = false;
    }

    protected void showCoreWarning() {
        if (showCoreWarning) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CoreWarningDialog.showDialog();
                }
            });
        }
    }

    protected final void initiate(DockControllerFactory dockControllerFactory, ControllerSetupCollection controllerSetupCollection) {
        if (this.factory != null) {
            throw new IllegalStateException("DockController already initialized");
        }
        if (dockControllerFactory == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        this.properties = new DockProperties(this);
        this.theme = new ThemeManager(this);
        this.icons = new IconManager(this);
        this.icons.setScheme(Priority.DEFAULT, this.createDefaultIconScheme());
        this.colors = new ColorManager(this);
        this.dockTitles = new DockTitleManager(this);
        this.texts = new TextManager(this);
        this.texts.setScheme(Priority.DEFAULT, this.createDefaultTextScheme());
        this.theme.init();
        this.rootWindowProvider = new WindowProviderWrapper();
        this.rootWindowProvider.addWindowProviderListener(new WindowProviderListener(){

            @Override
            public void windowChanged(WindowProvider windowProvider, Window window) {
                Window window2 = DockController.this.rootWindow;
                DockController.this.rootWindow = window;
                DockController.this.rootWindowChanged(window2, window);
            }

            @Override
            public void visibilityChanged(WindowProvider windowProvider, boolean bl) {
            }
        });
        final LinkedList linkedList = new LinkedList();
        if (controllerSetupCollection == null) {
            controllerSetupCollection = new ControllerSetupCollection(){

                @Override
                public void add(ControllerSetupListener controllerSetupListener) {
                    if (controllerSetupListener == null) {
                        throw new NullPointerException("listener must not be null");
                    }
                    linkedList.add(controllerSetupListener);
                }
            };
        }
        this.factory = dockControllerFactory;
        this.register = dockControllerFactory.createRegister(this, controllerSetupCollection);
        DockRegisterListener dockRegisterListener = dockControllerFactory.createVisibilityFocusObserver(this, controllerSetupCollection);
        if (dockRegisterListener != null) {
            this.register.addDockRegisterListener(dockRegisterListener);
        }
        this.popupController = dockControllerFactory.createPopupController(this, controllerSetupCollection);
        DockRegisterListener dockRegisterListener2 = dockControllerFactory.createActionBinder(this, controllerSetupCollection);
        if (dockRegisterListener2 != null) {
            this.register.addDockRegisterListener(dockRegisterListener2);
        }
        this.register.addDockRegisterListener(this.dockTitleObserver);
        this.addDockTitleBindingListener(this.dockTitleObserver);
        this.register.addDockRegisterListener(new DockableSelectionObserver());
        this.relocator = dockControllerFactory.createRelocator(this, controllerSetupCollection);
        this.defaultActionOffer = dockControllerFactory.createDefaultActionOffer(this, controllerSetupCollection);
        this.focusObserver = dockControllerFactory.createMouseFocusObserver(this, controllerSetupCollection);
        this.focusController = dockControllerFactory.createFocusController(this, controllerSetupCollection);
        this.focusHistory = dockControllerFactory.createFocusHistory(this, controllerSetupCollection);
        this.actionViewConverter = dockControllerFactory.createActionViewConverter(this, controllerSetupCollection);
        this.doubleClickController = dockControllerFactory.createDoubleClickController(this, controllerSetupCollection);
        this.keyboardController = dockControllerFactory.createKeyboardController(this, controllerSetupCollection);
        this.dockableSelector = dockControllerFactory.createDockableSelector(this, controllerSetupCollection);
        this.mouseDispatcher = dockControllerFactory.createGlobalMouseDispatcher(this, controllerSetupCollection);
        this.dockComponentManager = dockControllerFactory.createDockComponentManager(this, controllerSetupCollection);
        this.setTheme(DockUI.getDefaultDockUI().getDefaultTheme().create(this));
        this.relocator.addMode(DockRelocatorMode.NO_COMBINATION);
        this.properties.set(SplitDockStation.MAXIMIZE_ACCELERATOR, KeyStroke.getKeyStroke(77, 128));
        this.properties.set(DockFrontend.HIDE_ACCELERATOR, KeyStroke.getKeyStroke(115, 128));
        this.properties.set(DockableSelector.INIT_SELECTION, KeyStroke.getKeyStroke(69, 192));
        this.setSingleParentRemover(dockControllerFactory.createSingleParentRemover(this, controllerSetupCollection));
        this.focusController.addDockableFocusListener(new FocusControllerObserver());
        for (ControllerSetupListener controllerSetupListener : linkedList) {
            controllerSetupListener.done(this);
        }
        Workarounds.getDefault().setup(this);
    }

    protected UIScheme<Icon, DockIcon, DockIconBridge> createDefaultIconScheme() {
        DefaultIconScheme defaultIconScheme = new DefaultIconScheme("data/bibliothek/gui/dock/core/icons.ini", this);
        defaultIconScheme.link(PropertyKey.DOCKABLE_ICON, "dockable.default");
        defaultIconScheme.link(PropertyKey.DOCK_STATION_ICON, "dockStation.default");
        return defaultIconScheme;
    }

    protected UIScheme<String, TextValue, TextBridge> createDefaultTextScheme() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("data.bibliothek.gui.dock.core.locale.text", Locale.getDefault(), DockController.class.getClassLoader());
        return new DefaultTextScheme(resourceBundle);
    }

    public void kill() {
        this.setRootWindowProvider(null);
        this.focusObserver.kill();
        this.register.kill();
        this.keyboardController.kill();
        this.theme.kill();
        this.mouseDispatcher.kill();
    }

    public void setRestrictedEnvironment(boolean bl) {
        this.getProperties().set(RESTRICTED_ENVIRONMENT, bl);
    }

    public boolean isRestrictedEnvironment() {
        return this.getProperties().get(RESTRICTED_ENVIRONMENT);
    }

    public MouseFocusObserver getMouseFocusObserver() {
        return this.focusObserver;
    }

    public FocusController getFocusController() {
        return this.focusController;
    }

    public FocusHistory getFocusHistory() {
        return this.focusHistory;
    }

    public GlobalMouseDispatcher getGlobalMouseDispatcher() {
        return this.mouseDispatcher;
    }

    public DockRegister getRegister() {
        return this.register;
    }

    public ComponentHierarchyObserver getComponentHierarchyObserver() {
        if (this.componentHierarchyObserver == null) {
            this.componentHierarchyObserver = new ComponentHierarchyObserver(this);
            if (this.rootWindow != null) {
                this.componentHierarchyObserver.add(this.rootWindow);
            }
        }
        return this.componentHierarchyObserver;
    }

    public DockRelocator getRelocator() {
        return this.relocator;
    }

    public DoubleClickController getDoubleClickController() {
        return this.doubleClickController;
    }

    public KeyboardController getKeyboardController() {
        return this.keyboardController;
    }

    public ActionViewConverter getActionViewConverter() {
        return this.actionViewConverter;
    }

    public SingleParentRemover getSingleParentRemover() {
        return this.remover;
    }

    public void setSingleParentRemover(SingleParentRemover singleParentRemover) {
        if (this.remover != null) {
            this.remover.uninstall(this);
        }
        this.remover = singleParentRemover;
        if (this.remover != null) {
            this.remover.install(this);
            this.remover.testAll(this);
        }
    }

    public DockHierarchyLock getHierarchyLock() {
        return this.lock;
    }

    public boolean freezeLayout() {
        DockRegister dockRegister = this.getRegister();
        boolean bl = dockRegister.isStalled();
        this.getRegister().setStalled(true);
        return bl;
    }

    public boolean isLayoutFrozen() {
        return this.getRegister().isStalled();
    }

    public boolean meltLayout() {
        if (!this.isLayoutFrozen()) {
            throw new IllegalStateException("the layout is not frozen");
        }
        DockRegister dockRegister = this.getRegister();
        dockRegister.setStalled(false);
        return dockRegister.isStalled();
    }

    public MultiDockAcceptance getAcceptance() {
        return this.acceptance;
    }

    public void addAcceptance(DockAcceptance dockAcceptance) {
        this.acceptance.add(dockAcceptance);
    }

    public void removeAcceptance(DockAcceptance dockAcceptance) {
        this.acceptance.remove(dockAcceptance);
    }

    public ActionPopupSuppressor getPopupSuppressor() {
        return this.popupController.getPopupSuppressor();
    }

    public void setPopupSuppressor(ActionPopupSuppressor actionPopupSuppressor) {
        this.popupController.setPopupSuppressor(actionPopupSuppressor);
    }

    public ActionPopupMenuFactory getPopupMenuFactory() {
        return this.popupController.getPopupMenuFactory();
    }

    public void setPopupMenuFactory(ActionPopupMenuFactory actionPopupMenuFactory) {
        this.popupController.setPopupMenuFactory(actionPopupMenuFactory);
    }

    public PopupController getPopupController() {
        return this.popupController;
    }

    public ActionOffer getDefaultActionOffer() {
        return this.defaultActionOffer;
    }

    public void setDefaultActionOffer(ActionOffer actionOffer) {
        if (actionOffer == null) {
            throw new IllegalArgumentException();
        }
        this.defaultActionOffer = actionOffer;
    }

    public void addActionOffer(ActionOffer actionOffer) {
        if (actionOffer == null) {
            throw new IllegalArgumentException();
        }
        this.actionOffers.add(actionOffer);
    }

    public void removeActionOffer(ActionOffer actionOffer) {
        this.actionOffers.remove(actionOffer);
    }

    public ActionOffer getActionOffer(Dockable dockable) {
        for (ActionOffer actionOffer : this.actionOffers) {
            if (!actionOffer.interested(dockable)) continue;
            return actionOffer;
        }
        return this.getDefaultActionOffer();
    }

    public void setTheme(DockTheme dockTheme) {
        this.theme.setTheme(dockTheme);
    }

    public DockTheme getTheme() {
        return this.theme.getTheme();
    }

    public ThemeManager getThemeManager() {
        return this.theme;
    }

    public DockProperties getProperties() {
        return this.properties;
    }

    public DockComponentManager getDockComponentManager() {
        return this.dockComponentManager;
    }

    public void addRepresentativeListener(DockControllerRepresentativeListener dockControllerRepresentativeListener) {
        if (dockControllerRepresentativeListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.componentToDockElementsListeners.add(dockControllerRepresentativeListener);
    }

    public void removeRepresentativeListener(DockControllerRepresentativeListener dockControllerRepresentativeListener) {
        this.componentToDockElementsListeners.remove(dockControllerRepresentativeListener);
    }

    public void addRepresentative(DockElementRepresentative dockElementRepresentative) {
        DockControllerRepresentativeListener dockControllerRepresentativeListener;
        int n;
        int n2;
        DockControllerRepresentativeListener[] dockControllerRepresentativeListenerArray;
        DockControllerRepresentativeListener[] dockControllerRepresentativeListenerArray2 = this.componentToDockElementsListeners.toArray(new DockControllerRepresentativeListener[this.componentToDockElementsListeners.size()]);
        DockElementRepresentative dockElementRepresentative2 = this.componentToDockElements.put(dockElementRepresentative.getComponent(), dockElementRepresentative);
        if (dockElementRepresentative2 != null) {
            dockControllerRepresentativeListenerArray = dockControllerRepresentativeListenerArray2;
            n2 = dockControllerRepresentativeListenerArray2.length;
            n = 0;
            while (n < n2) {
                dockControllerRepresentativeListener = dockControllerRepresentativeListenerArray[n];
                dockControllerRepresentativeListener.representativeRemoved(this, dockElementRepresentative2);
                ++n;
            }
        }
        dockControllerRepresentativeListenerArray = dockControllerRepresentativeListenerArray2;
        n2 = dockControllerRepresentativeListenerArray2.length;
        n = 0;
        while (n < n2) {
            dockControllerRepresentativeListener = dockControllerRepresentativeListenerArray[n];
            dockControllerRepresentativeListener.representativeAdded(this, dockElementRepresentative);
            ++n;
        }
    }

    public void removeRepresentative(DockElementRepresentative dockElementRepresentative) {
        if (this.componentToDockElements.remove(dockElementRepresentative.getComponent()) != null) {
            DockControllerRepresentativeListener[] dockControllerRepresentativeListenerArray;
            DockControllerRepresentativeListener[] dockControllerRepresentativeListenerArray2 = dockControllerRepresentativeListenerArray = this.componentToDockElementsListeners.toArray(new DockControllerRepresentativeListener[this.componentToDockElementsListeners.size()]);
            int n = dockControllerRepresentativeListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                DockControllerRepresentativeListener dockControllerRepresentativeListener = dockControllerRepresentativeListenerArray2[n2];
                dockControllerRepresentativeListener.representativeRemoved(this, dockElementRepresentative);
                ++n2;
            }
        }
    }

    public DockElementRepresentative searchElement(Component component) {
        while (component != null) {
            DockElementRepresentative dockElementRepresentative = this.componentToDockElements.get(component);
            if (dockElementRepresentative != null && dockElementRepresentative.getElement().getController() == this) {
                return dockElementRepresentative;
            }
            component = component.getParent();
        }
        return null;
    }

    public DockElementRepresentative[] getRepresentatives(DockElement dockElement) {
        ArrayList<DockElementRepresentative> arrayList = new ArrayList<DockElementRepresentative>();
        for (DockElementRepresentative dockElementRepresentative : this.componentToDockElements.values()) {
            if (dockElementRepresentative.getElement() != dockElement) continue;
            arrayList.add(dockElementRepresentative);
        }
        return arrayList.toArray(new DockElementRepresentative[arrayList.size()]);
    }

    public void add(DockStation dockStation) {
        this.register.add(dockStation);
        this.register.setProtected(dockStation, true);
    }

    public void remove(DockStation dockStation) {
        this.register.remove(dockStation);
    }

    public int getStationCount() {
        return this.register.getStationCount();
    }

    public DockStation getStation(int n) {
        return this.register.getStation(n);
    }

    public boolean isOnFocusing() {
        return this.focusController.isOnFocusing();
    }

    public void setAtLeastFocusedDockable(Dockable dockable, Component component) {
        Dockable dockable2 = this.getFocusedDockable();
        if (dockable2 == null) {
            this.setFocusedDockable(new DefaultFocusRequest(dockable, component, false));
        } else if (!DockUtilities.isAncestor(dockable, dockable2)) {
            this.setFocusedDockable(new DefaultFocusRequest(dockable, component, false));
        }
    }

    public void setFocusedDockable(Dockable dockable, boolean bl) {
        this.setFocusedDockable(new DefaultFocusRequest(dockable, bl));
    }

    @Deprecated
    public void setFocusedDockable(Dockable dockable, Component component, boolean bl) {
        this.setFocusedDockable(new DefaultFocusRequest(dockable, component, bl));
    }

    @Deprecated
    public void setFocusedDockable(Dockable dockable, Component component, boolean bl, boolean bl2, boolean bl3) {
        this.setFocusedDockable(new DefaultFocusRequest(dockable, component, bl, bl2, bl3));
    }

    public void setFocusedDockable(FocusRequest focusRequest) {
        this.focusController.focus(focusRequest);
    }

    public boolean isFocused(Dockable dockable) {
        Dockable dockable2 = this.getFocusedDockable();
        while (dockable2 != null) {
            if (dockable2 == dockable) {
                return true;
            }
            DockStation dockStation = dockable2.getDockParent();
            Dockable dockable3 = dockable2 = dockStation == null ? null : dockStation.asDockable();
        }
        return false;
    }

    public boolean isBound(DockTitle dockTitle) {
        return this.dockTitleObserver.isBound(dockTitle);
    }

    public void ensureFocusSet() {
        this.focusController.ensureFocusSet(false);
    }

    public Dockable getFocusedDockable() {
        return this.focusController.getFocusedDockable();
    }

    public DockableSelector getDockableSelector() {
        return this.dockableSelector;
    }

    public DockTitleManager getDockTitleManager() {
        return this.dockTitles;
    }

    public IconManager getIcons() {
        return this.icons;
    }

    public TextManager getTexts() {
        return this.texts;
    }

    public ColorManager getColors() {
        return this.colors;
    }

    public void setRootWindow(Window window) {
        if (window == null) {
            this.setRootWindowProvider(null);
        } else {
            this.setRootWindowProvider(new DirectWindowProvider(window));
        }
    }

    public void setRootWindowProvider(WindowProvider windowProvider) {
        this.rootWindowProvider.setDelegate(windowProvider);
    }

    public WindowProviderWrapper getRootWindowProvider() {
        return this.rootWindowProvider;
    }

    protected void rootWindowChanged(Window window, Window window2) {
        if (this.componentHierarchyObserver != null) {
            if (window != null) {
                this.componentHierarchyObserver.remove(window);
            }
            if (window2 != null) {
                this.componentHierarchyObserver.add(window2);
            }
        }
    }

    public Window findRootWindow() {
        Component component;
        Object object;
        DockElement dockElement;
        if (this.rootWindow != null) {
            return this.rootWindow;
        }
        Component component2 = null;
        Dialog dialog = null;
        DockElement[] dockElementArray = this.getRegister().listRoots();
        int n = dockElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Window window;
            dockElement = dockElementArray[n2];
            object = dockElement.asDockable();
            if (object != null && (window = SwingUtilities.getWindowAncestor(component = object.getComponent())) != null) {
                component2 = window;
                if (window instanceof Frame) {
                    return window;
                }
                if (window instanceof Dialog) {
                    dialog = (Dialog)window;
                }
            }
            ++n2;
        }
        dockElementArray = this.getRegister().listDockables();
        n = dockElementArray.length;
        n2 = 0;
        while (n2 < n) {
            dockElement = dockElementArray[n2];
            object = dockElement.getComponent();
            component = SwingUtilities.getWindowAncestor((Component)object);
            if (component != null) {
                component2 = component;
                if (component instanceof Frame) {
                    return component;
                }
                if (component instanceof Dialog) {
                    dialog = (Dialog)component;
                }
            }
            ++n2;
        }
        if (dialog != null) {
            return dialog;
        }
        return component2;
    }

    public void addActionGuard(ActionGuard actionGuard) {
        if (actionGuard == null) {
            throw new IllegalArgumentException("guard must not be null");
        }
        this.guards.add(actionGuard);
    }

    public void removeActionGuard(ActionGuard actionGuard) {
        this.guards.remove(actionGuard);
    }

    public DockActionSource listOffers(Dockable dockable) {
        ArrayList<DockActionSource> arrayList = new ArrayList<DockActionSource>();
        ArrayList<DockActionSource> arrayList2 = new ArrayList<DockActionSource>();
        DockStation dockStation = dockable.getDockParent();
        while (dockStation != null) {
            arrayList2.add(dockStation.getIndirectActionOffers(dockable));
            Dockable object2 = dockStation.asDockable();
            dockStation = object2 != null ? object2.getDockParent() : null;
        }
        for (ActionGuard actionGuard : this.guards) {
            if (!actionGuard.react(dockable)) continue;
            arrayList.add(actionGuard.getSource(dockable));
        }
        ActionOffer actionOffer = this.getActionOffer(dockable);
        Object object = null;
        if (dockable.getDockParent() != null) {
            object = dockable.getDockParent().getDirectActionOffers(dockable);
        }
        return actionOffer.getSource(dockable, dockable.getLocalActionOffers(), arrayList.toArray(new DockActionSource[arrayList.size()]), (DockActionSource)object, arrayList2.toArray(new DockActionSource[arrayList2.size()]));
    }

    public void addDockTitleBindingListener(DockTitleBindingListener dockTitleBindingListener) {
        if (dockTitleBindingListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.dockTitleBindingListeners.add(dockTitleBindingListener);
    }

    public void removeDockTitleBindingListener(DockTitleBindingListener dockTitleBindingListener) {
        if (dockTitleBindingListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.dockTitleBindingListeners.remove(dockTitleBindingListener);
    }

    protected DockTitleBindingListener[] dockTitleBindingListeners() {
        return this.dockTitleBindingListeners.toArray(new DockTitleBindingListener[this.dockTitleBindingListeners.size()]);
    }

    public void addDockableFocusListener(DockableFocusListener dockableFocusListener) {
        this.focusController.addDockableFocusListener(dockableFocusListener);
    }

    public void removeDockableFocusListener(DockableFocusListener dockableFocusListener) {
        this.focusController.removeDockableFocusListener(dockableFocusListener);
    }

    public void addDockableSelectionListener(DockableSelectionListener dockableSelectionListener) {
        if (dockableSelectionListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.dockableSelectionListeners.add(dockableSelectionListener);
    }

    public void removeDockableSelectionListener(DockableSelectionListener dockableSelectionListener) {
        this.dockableSelectionListeners.remove(dockableSelectionListener);
    }

    protected DockableSelectionListener[] dockableSelectionListeners() {
        return this.dockableSelectionListeners.toArray(new DockableSelectionListener[this.dockableSelectionListeners.size()]);
    }

    protected void fireTitleBound(DockTitle dockTitle, Dockable dockable) {
        DockTitleBindingListener[] dockTitleBindingListenerArray = this.dockTitleBindingListeners();
        int n = dockTitleBindingListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockTitleBindingListener dockTitleBindingListener = dockTitleBindingListenerArray[n2];
            dockTitleBindingListener.titleBound(this, dockTitle, dockable);
            ++n2;
        }
    }

    protected void fireTitleUnbound(DockTitle dockTitle, Dockable dockable) {
        DockTitleBindingListener[] dockTitleBindingListenerArray = this.dockTitleBindingListeners();
        int n = dockTitleBindingListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockTitleBindingListener dockTitleBindingListener = dockTitleBindingListenerArray[n2];
            dockTitleBindingListener.titleUnbound(this, dockTitle, dockable);
            ++n2;
        }
    }

    protected void fireDockableSelected(DockStation dockStation, Dockable dockable, Dockable dockable2) {
        DockableSelectionEvent dockableSelectionEvent = new DockableSelectionEvent(this, dockStation, dockable, dockable2);
        DockableSelectionListener[] dockableSelectionListenerArray = this.dockableSelectionListeners();
        int n = dockableSelectionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockableSelectionListener dockableSelectionListener = dockableSelectionListenerArray[n2];
            dockableSelectionListener.dockableSelected(dockableSelectionEvent);
            ++n2;
        }
    }

    private class DockTitleObserver
    extends DockRegisterAdapter
    implements DockTitleBindingListener {
        private Set<DockTitle> titles = new HashSet<DockTitle>();
        private DockableListener dockableListener = new DockableAdapter(){

            @Override
            public void titleBound(Dockable dockable, DockTitle dockTitle) {
                DockTitleObserver.this.titles.add(dockTitle);
                DockTitleObserver.this.handleAddedTitle(dockable, dockTitle);
            }

            @Override
            public void titleUnbound(Dockable dockable, DockTitle dockTitle) {
                DockTitleObserver.this.titles.remove(dockTitle);
                DockTitleObserver.this.handleRemovedTitle(dockable, dockTitle);
            }
        };

        private DockTitleObserver() {
        }

        public boolean isBound(DockTitle dockTitle) {
            return this.titles.contains(dockTitle);
        }

        @Override
        public void titleBound(DockController dockController, DockTitle dockTitle, Dockable dockable) {
            DockController.this.addRepresentative(dockTitle);
        }

        @Override
        public void titleUnbound(DockController dockController, DockTitle dockTitle, Dockable dockable) {
            DockController.this.removeRepresentative(dockTitle);
            DockController.this.activeTitles.remove(dockTitle);
            DockStation dockStation = dockable.getDockParent();
            if (dockStation != null) {
                dockStation.changed(dockable, dockTitle, false);
            } else {
                dockTitle.changed(new ActivityDockTitleEvent(dockable, false));
            }
        }

        private void handleAddedTitle(Dockable dockable, DockTitle dockTitle) {
            dockTitle.bind();
            DockController.this.fireTitleBound(dockTitle, dockable);
            DockStation dockStation = dockable.getDockParent();
            boolean bl = false;
            Dockable dockable2 = DockController.this.getFocusedDockable();
            while (!bl && dockable2 != null) {
                bl = dockable2 == dockable;
                DockStation dockStation2 = dockable2.getDockParent();
                Dockable dockable3 = dockable2 = dockStation2 == null ? null : dockStation2.asDockable();
            }
            if (dockStation == null) {
                dockTitle.changed(new ActivityDockTitleEvent(dockable, bl));
            } else {
                dockStation.changed(dockable, dockTitle, bl);
            }
            if (bl) {
                DockController.this.activeTitles.put(dockTitle, dockable);
            }
        }

        private void handleRemovedTitle(Dockable dockable, DockTitle dockTitle) {
            dockTitle.unbind();
            DockController.this.fireTitleUnbound(dockTitle, dockable);
        }

        @Override
        public void dockableRegistering(DockController dockController, Dockable dockable) {
            dockable.addDockableListener(this.dockableListener);
        }

        @Override
        public void dockableRegistered(DockController dockController, Dockable dockable) {
            DockTitle[] dockTitleArray;
            DockController.this.addRepresentative(dockable);
            DockTitle[] dockTitleArray2 = dockTitleArray = dockable.listBoundTitles();
            int n = dockTitleArray.length;
            int n2 = 0;
            while (n2 < n) {
                DockTitle dockTitle = dockTitleArray2[n2];
                if (this.titles.add(dockTitle)) {
                    this.handleAddedTitle(dockable, dockTitle);
                }
                ++n2;
            }
        }

        @Override
        public void dockableUnregistered(DockController dockController, Dockable dockable) {
            DockTitle[] dockTitleArray;
            dockable.removeDockableListener(this.dockableListener);
            DockController.this.removeRepresentative(dockable);
            DockTitle[] dockTitleArray2 = dockTitleArray = dockable.listBoundTitles();
            int n = dockTitleArray.length;
            int n2 = 0;
            while (n2 < n) {
                DockTitle dockTitle = dockTitleArray2[n2];
                if (this.titles.remove(dockTitle)) {
                    this.handleRemovedTitle(dockable, dockTitle);
                }
                ++n2;
            }
        }
    }

    private class DockableSelectionObserver
    extends DockRegisterAdapter {
        private DockStationListener listener = new DockStationAdapter(){

            @Override
            public void dockableSelected(DockStation dockStation, Dockable dockable, Dockable dockable2) {
                DockController.this.fireDockableSelected(dockStation, dockable, dockable2);
            }
        };

        private DockableSelectionObserver() {
        }

        @Override
        public void dockStationRegistered(DockController dockController, DockStation dockStation) {
            dockStation.addDockStationListener(this.listener);
        }

        @Override
        public void dockStationUnregistered(DockController dockController, DockStation dockStation) {
            dockStation.removeDockStationListener(this.listener);
        }
    }

    private class FocusControllerObserver
    implements DockableFocusListener {
        private FocusControllerObserver() {
        }

        @Override
        public void dockableFocused(DockableFocusEvent dockableFocusEvent) {
            DockTitle[] dockTitleArray;
            Map.Entry entry2;
            for (Map.Entry entry2 : DockController.this.activeTitles.entrySet()) {
                dockTitleArray = ((Dockable)entry2.getValue()).getDockParent();
                if (dockTitleArray != null) {
                    dockTitleArray.changed((Dockable)entry2.getValue(), (DockTitle)entry2.getKey(), false);
                    continue;
                }
                ((DockTitle)entry2.getKey()).changed(new ActivityDockTitleEvent((Dockable)entry2.getValue(), false));
            }
            DockController.this.activeTitles.clear();
            entry2 = dockableFocusEvent.getNewFocusOwner();
            while (entry2 != null) {
                DockStation dockStation = entry2.getDockParent();
                if (dockStation != null) {
                    DockTitle[] dockTitleArray2 = dockTitleArray = entry2.listBoundTitles();
                    int n = dockTitleArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DockTitle dockTitle = dockTitleArray2[n2];
                        dockStation.changed((Dockable)((Object)entry2), dockTitle, true);
                        DockController.this.activeTitles.put(dockTitle, entry2);
                        ++n2;
                    }
                    dockStation.setFrontDockable((Dockable)((Object)entry2));
                    entry2 = dockStation.asDockable();
                    continue;
                }
                entry2 = null;
            }
        }
    }
}

