/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public abstract class MouseOverListener
extends MouseAdapter
implements ContainerListener {
    private boolean mouseover = false;

    public MouseOverListener(Component component) {
        this.added(component);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseover = true;
        this.changed();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseover = false;
        this.changed();
    }

    protected abstract void changed();

    public boolean isMouseOver() {
        return this.mouseover;
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        this.added(containerEvent.getChild());
    }

    protected void added(Component component) {
        component.addMouseListener(this);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.addContainerListener(this);
            int n = 0;
            int n2 = container.getComponentCount();
            while (n < n2) {
                this.added(container.getComponent(n));
                ++n;
            }
        }
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        this.removed(containerEvent.getChild());
    }

    protected void removed(Component component) {
        component.removeMouseListener(this);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.removeContainerListener(this);
            int n = 0;
            int n2 = container.getComponentCount();
            while (n < n2) {
                this.removed(container.getComponent(n));
                ++n;
            }
        }
    }
}

