/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack.tab4;

import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab4.TabComponentCondition;
import bibliothek.gui.DockController;
import bibliothek.gui.dock.control.GlobalMouseDispatcher;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;

public class HoverCondition
extends TabComponentCondition {
    private MouseEvent latestEvent;
    private DockController controller;
    private Listener listener = new Listener();

    public HoverCondition(TabComponent tabComponent) {
        super(tabComponent);
    }

    public void setController(DockController dockController) {
        if (this.controller != dockController) {
            GlobalMouseDispatcher globalMouseDispatcher;
            if (this.controller != null) {
                globalMouseDispatcher = this.controller.getGlobalMouseDispatcher();
                globalMouseDispatcher.removeMouseListener(this.listener);
                globalMouseDispatcher.removeMouseMotionListener(this.listener);
            }
            this.controller = dockController;
            if (this.controller != null) {
                globalMouseDispatcher = this.controller.getGlobalMouseDispatcher();
                globalMouseDispatcher.addMouseListener(this.listener);
                globalMouseDispatcher.addMouseMotionListener(this.listener);
            }
            this.invalidate(null);
        }
    }

    @Override
    protected boolean checkCondition() {
        MouseEvent mouseEvent = this.latestEvent;
        if (mouseEvent == null) {
            return false;
        }
        Point point = mouseEvent.getPoint();
        Component component = this.getComponent().getComponent();
        point = SwingUtilities.convertPoint(mouseEvent.getComponent(), point, component);
        return component.contains(point);
    }

    private void invalidate(MouseEvent mouseEvent) {
        this.latestEvent = mouseEvent;
        this.invalidate();
    }

    private class Listener
    implements MouseListener,
    MouseMotionListener {
        private Listener() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            HoverCondition.this.invalidate(mouseEvent);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            HoverCondition.this.invalidate(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            HoverCondition.this.invalidate(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            HoverCondition.this.invalidate(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            HoverCondition.this.invalidate(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            HoverCondition.this.invalidate(mouseEvent);
        }
    }
}

