/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack.tab;

import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabPanePainter;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.util.color.AbstractDockColor;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.gui.dock.util.color.DockColor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class LinePainter
implements TabPanePainter {
    private AbstractDockColor color = new AbstractDockColor("stack.border", DockColor.KIND_DOCK_COLOR, Color.BLACK){

        @Override
        protected void changed(Color color, Color color2) {
            LinePainter.this.pane.repaint();
        }
    };
    private EclipseTabPane pane;

    public LinePainter(EclipseTabPane eclipseTabPane) {
        this.pane = eclipseTabPane;
    }

    @Override
    public void setController(DockController dockController) {
        ColorManager colorManager = dockController == null ? null : dockController.getColors();
        this.color.setManager(colorManager);
    }

    @Override
    public void paintBackground(Graphics graphics) {
    }

    @Override
    public void paintForeground(Graphics graphics) {
        Dockable dockable = this.pane.getSelectedDockable();
        if (dockable == null) {
            return;
        }
        EclipseTab eclipseTab = (EclipseTab)this.pane.getTab(dockable);
        if (eclipseTab == null || !eclipseTab.isPaneVisible()) {
            return;
        }
        Rectangle rectangle = eclipseTab.getBounds();
        Rectangle rectangle2 = this.pane.getAvailableArea();
        graphics.setColor((Color)this.color.value());
        switch (this.pane.getDockTabPlacement()) {
            case TOP_OF_DOCKABLE: {
                this.paintHorizontal(graphics, rectangle2, rectangle, rectangle.y + rectangle.height - 1);
                break;
            }
            case BOTTOM_OF_DOCKABLE: {
                this.paintHorizontal(graphics, rectangle2, rectangle, rectangle.y);
                break;
            }
            case LEFT_OF_DOCKABLE: {
                this.paintVertical(graphics, rectangle2, rectangle, rectangle.x + rectangle.width - 1);
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                this.paintVertical(graphics, rectangle2, rectangle, rectangle.x);
            }
        }
    }

    private void paintHorizontal(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, int n) {
        if (rectangle.x < rectangle2.x - 1) {
            graphics.drawLine(rectangle.x, n, rectangle2.x - 1, n);
        }
        if (rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
            graphics.drawLine(rectangle.x + rectangle.width, n, rectangle2.x + rectangle2.width, n);
        }
    }

    private void paintVertical(Graphics graphics, Rectangle rectangle, Rectangle rectangle2, int n) {
        if (rectangle.y < rectangle2.y - 1) {
            graphics.drawLine(n, rectangle.y, n, rectangle2.y - 1);
        }
        if (rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
            graphics.drawLine(n, rectangle.y + rectangle.height, n, rectangle2.y + rectangle2.height);
        }
    }
}

