/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack.tab;

import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.InvisibleTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.InvisibleTabPane;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.themes.color.TabColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;

public class DefaultInvisibleTab
implements InvisibleTab {
    protected final TabColor colorStackTabBorder;
    protected final TabColor colorStackTabBorderSelected;
    protected final TabColor colorStackTabBorderSelectedFocused;
    protected final TabColor colorStackTabBorderSelectedFocusLost;
    private WindowActiveObserver observer = new WindowActiveObserver();
    private InvisibleTabPane pane;
    private Dockable dockable;
    private DockController controller;
    private Color oldColor;
    private DockableFocusListener focusListener = new DockableFocusListener(){

        @Override
        public void dockableFocused(DockableFocusEvent dockableFocusEvent) {
            if (dockableFocusEvent.getOldFocusOwner() == DefaultInvisibleTab.this.dockable || dockableFocusEvent.getNewFocusOwner() == DefaultInvisibleTab.this.dockable) {
                DefaultInvisibleTab.this.updateBorder();
            }
        }
    };

    public DefaultInvisibleTab(InvisibleTabPane invisibleTabPane, Dockable dockable) {
        if (invisibleTabPane == null) {
            throw new IllegalArgumentException("pane must not be null");
        }
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        this.pane = invisibleTabPane;
        this.dockable = dockable;
        this.colorStackTabBorder = new InvisibleTabColor("stack.tab.border");
        this.colorStackTabBorderSelected = new InvisibleTabColor("stack.tab.border.selected");
        this.colorStackTabBorderSelectedFocused = new InvisibleTabColor("stack.tab.border.selected.focused");
        this.colorStackTabBorderSelectedFocusLost = new InvisibleTabColor("stack.tab.border.selected.focuslost");
        this.updateBorder();
    }

    @Override
    public void setController(DockController dockController) {
        if (this.controller != null) {
            this.controller.removeDockableFocusListener(this.focusListener);
        }
        this.controller = dockController;
        if (dockController != null) {
            dockController.addDockableFocusListener(this.focusListener);
        }
        this.colorStackTabBorder.connect(dockController);
        this.colorStackTabBorderSelected.connect(dockController);
        this.colorStackTabBorderSelectedFocused.connect(dockController);
        this.colorStackTabBorderSelectedFocusLost.connect(dockController);
        if (dockController == null || this.dockable == null) {
            this.observer.observe(null);
        } else {
            this.observer.observe(this.dockable.getComponent());
        }
        this.updateBorder();
    }

    private void updateBorder() {
        if (this.controller != null) {
            Window window = this.observer.getWindow();
            boolean bl = false;
            if (window != null) {
                boolean bl2 = bl = !window.isActive();
            }
            Color color = this.pane.getSelectedDockable() == this.dockable ? (this.controller.getFocusedDockable() == this.dockable ? (bl ? (Color)this.colorStackTabBorderSelectedFocusLost.value() : (Color)this.colorStackTabBorderSelectedFocused.value()) : (Color)this.colorStackTabBorderSelected.value()) : (Color)this.colorStackTabBorder.value();
            if (!color.equals(this.oldColor)) {
                this.oldColor = color;
                this.pane.setBorder(this.dockable, new MatteBorder(2, 2, 2, 2, color));
            }
        }
    }

    private class InvisibleTabColor
    extends TabColor {
        public InvisibleTabColor(String string) {
            super(string, DefaultInvisibleTab.this.pane.getStation(), DefaultInvisibleTab.this.dockable, Color.BLACK);
        }

        @Override
        protected void changed(Color color, Color color2) {
            DefaultInvisibleTab.this.updateBorder();
        }
    }

    private class WindowActiveObserver
    extends WindowAdapter
    implements HierarchyListener {
        private Window window;
        private Component component;

        private WindowActiveObserver() {
        }

        public void observe(Component component) {
            if (this.component != component) {
                if (this.component != null) {
                    if (this.window != null) {
                        this.window.removeWindowListener(this);
                        this.window = null;
                    }
                    this.component.removeHierarchyListener(this);
                }
                this.component = component;
                if (this.component != null) {
                    this.component.addHierarchyListener(this);
                    this.window = SwingUtilities.getWindowAncestor(component);
                    if (this.window != null) {
                        this.window.addWindowListener(this);
                    }
                }
            }
        }

        public Window getWindow() {
            return this.window;
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            Window window = SwingUtilities.getWindowAncestor(this.component);
            long l = hierarchyEvent.getChangeFlags();
            if (this.window != window && (l & 1L) != 0L) {
                if (this.window != null) {
                    this.window.removeWindowListener(this);
                }
                if (window != null) {
                    window.addWindowListener(this);
                    DefaultInvisibleTab.this.updateBorder();
                }
                this.window = window;
            }
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            DefaultInvisibleTab.this.updateBorder();
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            DefaultInvisibleTab.this.updateBorder();
        }
    }
}

