/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack.tab;

import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.EclipseDockTitleEvent;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.themes.basic.BasicDockTitle;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleEvent;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.color.ColorManager;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Icon;

public class BasicTabDockTitle
extends BasicDockTitle {
    public static final DockTitleFactory FACTORY = new DockTitleFactory(){

        @Override
        public void install(DockTitleRequest dockTitleRequest) {
        }

        @Override
        public void uninstall(DockTitleRequest dockTitleRequest) {
        }

        @Override
        public void request(DockTitleRequest dockTitleRequest) {
            dockTitleRequest.answer(new BasicTabDockTitle(dockTitleRequest.getTarget(), dockTitleRequest.getVersion()));
        }
    };
    private boolean selected = false;
    private boolean paintIconWhenInactive = true;
    private TitleColor borderColor;

    public BasicTabDockTitle(Dockable dockable, DockTitleVersion dockTitleVersion) {
        super(dockable, dockTitleVersion, false);
        this.setBorder("dock.border.title.tab", BorderFactory.createEmptyBorder(0, 0, 1, 0));
        this.setActiveLeftColorId("stack.tab.top.selected.focused");
        this.setActiveRightColorId("stack.tab.bottom.selected.focused");
        this.setActiveTextColorId("stack.tab.text");
        this.setInactiveLeftColorId("stack.tab.top.selected");
        this.setInactiveRightColorId("stack.tab.bottom.selected");
        this.setInactiveTextColorId("stack.tab.text");
        this.setDisabledLeftColorId("stack.tab.top.disabled");
        this.setDisabledRightColorId("stack.tab.bottom.disabled");
        this.borderColor = new TitleColor("stack.border", (DockTitle)this, Color.BLACK){

            @Override
            protected void changed(Color color, Color color2) {
                BasicTabDockTitle.this.repaint();
            }
        };
    }

    @Override
    public void bind() {
        super.bind();
        DockController dockController = this.getDockable().getController();
        ColorManager colorManager = dockController.getColors();
        this.borderColor.setManager(colorManager);
    }

    @Override
    public void unbind() {
        super.unbind();
        this.borderColor.setManager(null);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void changed(DockTitleEvent dockTitleEvent) {
        super.changed(dockTitleEvent);
        if (dockTitleEvent instanceof EclipseDockTitleEvent) {
            EclipseDockTitleEvent eclipseDockTitleEvent = (EclipseDockTitleEvent)dockTitleEvent;
            this.selected = eclipseDockTitleEvent.isSelected();
            this.paintIconWhenInactive = eclipseDockTitleEvent.isPaintIconWhenInactive();
            this.updateTabIcon();
        }
    }

    @Override
    protected void setIcon(Icon icon) {
        if (this.selected || this.paintIconWhenInactive) {
            super.setIcon(icon);
        } else {
            super.setIcon(null);
        }
    }

    private void updateTabIcon() {
        if (this.selected || this.paintIconWhenInactive) {
            this.setIcon(this.getDockable().getTitleIcon());
        } else {
            this.setIcon(null);
        }
    }
}

