/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack.tab;

import bibliothek.extension.gui.dock.theme.eclipse.EclipseDockActionSource;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseTabStateInfo;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabInfo;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.BaseTabFocusTraversalPolicy;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabComponent;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.focus.DockFocusTraversalPolicy;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabComponentLayoutManager;
import bibliothek.gui.dock.station.stack.tab.TabConfiguration;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.TabPaneTabBackgroundComponent;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonPanel;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.gui.dock.util.render.DockRenderingHints;
import bibliothek.gui.dock.util.swing.OrientedLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public abstract class BaseTabComponent
extends ConfiguredBackgroundPanel
implements TabComponent,
EclipseTabStateInfo {
    protected final TabColor colorStackTabBorder;
    protected final TabColor colorStackTabBorderSelected;
    protected final TabColor colorStackTabBorderSelectedFocused;
    protected final TabColor colorStackTabBorderSelectedFocusLost;
    protected final TabColor colorStackTabBorderDisabled;
    protected final TabColor colorStackTabTop;
    protected final TabColor colorStackTabTopSelected;
    protected final TabColor colorStackTabTopSelectedFocused;
    protected final TabColor colorStackTabTopSelectedFocusLost;
    protected final TabColor colorStackTabTopDisabled;
    protected final TabColor colorStackTabBottom;
    protected final TabColor colorStackTabBottomSelected;
    protected final TabColor colorStackTabBottomSelectedFocused;
    protected final TabColor colorStackTabBottomSelectedFocusLost;
    protected final TabColor colorStackTabBottomDisabled;
    protected final TabColor colorStackTabText;
    protected final TabColor colorStackTabTextSelected;
    protected final TabColor colorStackTabTextSelectedFocused;
    protected final TabColor colorStackTabTextSelectedFocusLost;
    protected final TabColor colorStackTabTextDisabled;
    protected final TabColor colorStackBorder;
    private TabColor[] colors;
    private Dockable dockable;
    private boolean paintIconWhenInactive = false;
    private Icon icon;
    private ButtonPanel buttons;
    private EclipseDockActionSource actions;
    private boolean hasFocus;
    private boolean isSelected;
    private EclipseTabPane pane;
    private EclipseTab tab;
    private boolean bound;
    private Background background;
    private OrientedLabel label = new OrientedLabel();
    private TabPlacement orientation = TabPlacement.TOP_OF_DOCKABLE;
    private boolean previousTabSelectedSet = false;
    private boolean previousTabSelected = false;
    private boolean nextTabSelectedSet = false;
    private boolean nextTabSelected = false;
    private TabComponentLayoutManager layoutManager;

    public BaseTabComponent(EclipseTabPane eclipseTabPane, Dockable dockable) {
        this(eclipseTabPane, dockable, null);
    }

    public BaseTabComponent(EclipseTabPane eclipseTabPane, Dockable dockable, String string) {
        super(null, Transparency.DEFAULT);
        if (eclipseTabPane == null) {
            throw new IllegalArgumentException("pane must not be null");
        }
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        this.pane = eclipseTabPane;
        this.dockable = dockable;
        this.add(this.label);
        DockStation dockStation = eclipseTabPane.getStation();
        if (string == null) {
            string = "";
        }
        this.colorStackTabBorder = new BorderTabColor("stack.tab.border" + string, dockStation, Color.WHITE);
        this.colorStackTabBorderSelected = new BorderTabColor("stack.tab.border.selected" + string, dockStation, Color.WHITE);
        this.colorStackTabBorderSelectedFocused = new BorderTabColor("stack.tab.border.selected.focused" + string, dockStation, Color.WHITE);
        this.colorStackTabBorderSelectedFocusLost = new BorderTabColor("stack.tab.border.selected.focuslost" + string, dockStation, Color.WHITE);
        this.colorStackTabBorderDisabled = new BorderTabColor("stack.tab.border.disabled" + string, dockStation, Color.WHITE);
        this.colorStackTabTop = new BaseTabColor("stack.tab.top" + string, dockStation, Color.LIGHT_GRAY);
        this.colorStackTabTopSelected = new BaseTabColor("stack.tab.top.selected" + string, dockStation, Color.LIGHT_GRAY);
        this.colorStackTabTopSelectedFocused = new BaseTabColor("stack.tab.top.selected.focused" + string, dockStation, Color.LIGHT_GRAY);
        this.colorStackTabTopSelectedFocusLost = new BaseTabColor("stack.tab.top.selected.focuslost" + string, dockStation, Color.LIGHT_GRAY);
        this.colorStackTabTopDisabled = new BaseTabColor("stack.tab.top.disabled" + string, dockStation, Color.LIGHT_GRAY);
        this.colorStackTabBottom = new BaseTabColor("stack.tab.bottom" + string, dockStation, Color.WHITE);
        this.colorStackTabBottomSelected = new BaseTabColor("stack.tab.bottom.selected" + string, dockStation, Color.WHITE);
        this.colorStackTabBottomSelectedFocused = new BaseTabColor("stack.tab.bottom.selected.focused" + string, dockStation, Color.WHITE);
        this.colorStackTabBottomSelectedFocusLost = new BaseTabColor("stack.tab.bottom.selected.focuslost" + string, dockStation, Color.WHITE);
        this.colorStackTabBottomDisabled = new BaseTabColor("stack.tab.bottom.disabled" + string, dockStation, Color.WHITE);
        this.colorStackTabText = new BaseTabColor("stack.tab.text" + string, dockStation, Color.BLACK);
        this.colorStackTabTextSelected = new BaseTabColor("stack.tab.text.selected" + string, dockStation, Color.BLACK);
        this.colorStackTabTextSelectedFocused = new BaseTabColor("stack.tab.text.selected.focused" + string, dockStation, Color.BLACK);
        this.colorStackTabTextSelectedFocusLost = new BaseTabColor("stack.tab.text.selected.focuslost" + string, dockStation, Color.BLACK);
        this.colorStackTabTextDisabled = new BaseTabColor("stack.tab.text.disabled" + string, dockStation, Color.BLACK);
        this.colorStackBorder = new BaseTabColor("stack.border" + string, dockStation, Color.BLACK);
        this.colors = new TabColor[]{this.colorStackTabBorder, this.colorStackTabBorderSelected, this.colorStackTabBorderSelectedFocused, this.colorStackTabBorderSelectedFocusLost, this.colorStackTabBorderDisabled, this.colorStackTabTop, this.colorStackTabTopSelected, this.colorStackTabTopSelectedFocused, this.colorStackTabTopSelectedFocusLost, this.colorStackTabTopDisabled, this.colorStackTabBottom, this.colorStackTabBottomSelected, this.colorStackTabBottomSelectedFocused, this.colorStackTabBottomSelectedFocusLost, this.colorStackTabBottomDisabled, this.colorStackTabText, this.colorStackTabTextSelected, this.colorStackTabTextSelectedFocused, this.colorStackTabTextSelectedFocusLost, this.colorStackTabTextDisabled, this.colorStackBorder};
        this.buttons = new ButtonPanel(false);
        this.add(this.buttons);
        this.setFocusable(false);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new DockFocusTraversalPolicy(new BaseTabFocusTraversalPolicy(this.buttons), true));
        this.layoutManager = new TabComponentLayoutManager(this.label, this.buttons, eclipseTabPane.getConfiguration(dockable));
        this.setLayout(this.layoutManager);
    }

    @Override
    public EclipseTabStateInfo getEclipseTabStateInfo() {
        return this;
    }

    protected void addAdditionalColors(TabColor ... tabColorArray) {
        TabColor[] tabColorArray2 = new TabColor[this.colors.length + tabColorArray.length];
        System.arraycopy(this.colors, 0, tabColorArray2, 0, this.colors.length);
        System.arraycopy(tabColorArray, 0, tabColorArray2, this.colors.length, tabColorArray.length);
        this.colors = tabColorArray2;
    }

    @Override
    public void setConfiguration(TabConfiguration tabConfiguration) {
        this.layoutManager.setConfiguration(tabConfiguration);
    }

    public abstract void updateBorder();

    protected void refreshActions() {
        if (this.actions != null) {
            this.actions.refresh();
        }
        ((EclipseTabInfo)this.pane.getInfoComponent()).refreshActions();
    }

    public abstract void updateFocus();

    protected abstract void updateSelected();

    protected abstract void updateColors();

    protected abstract void updateEnabled();

    protected void updatePaintIcon() {
        if (this.isSelected() || this.doPaintIconWhenInactive()) {
            this.label.setIcon(this.icon);
        } else {
            this.label.setIcon(null);
        }
        this.revalidate();
        this.repaint();
    }

    protected abstract void updateOrientation();

    @Override
    public void setTab(EclipseTab eclipseTab) {
        if (this.background != null) {
            this.background.setController(null);
            this.background = null;
        }
        this.tab = eclipseTab;
        if (this.bound) {
            this.background = new Background(eclipseTab);
            this.background.setController(this.getController());
            this.buttons.setController(this.getController());
        }
        this.setBackground(this.background);
    }

    @Override
    public void bind() {
        if (this.buttons != null) {
            this.actions = new EclipseDockActionSource(this.pane.getTheme(), this.dockable.getGlobalActionOffers(), this, true);
            this.buttons.set(this.dockable, this.actions);
        }
        DockController dockController = this.pane.getController();
        if (this.tab != null) {
            this.background = new Background(this.tab);
            this.background.setController(dockController);
        }
        this.setBackground(this.background);
        this.buttons.setController(dockController);
        TabColor[] tabColorArray = this.colors;
        int n = this.colors.length;
        int n2 = 0;
        while (n2 < n) {
            TabColor tabColor = tabColorArray[n2];
            tabColor.connect(dockController);
            ++n2;
        }
        this.revalidate();
        this.bound = true;
    }

    @Override
    public void unbind() {
        this.bound = false;
        if (this.buttons != null) {
            this.buttons.set(null);
        }
        if (this.background != null) {
            this.background.setController(null);
            this.background = null;
        }
        this.setBackground(this.background);
        this.buttons.setController(null);
        TabColor[] tabColorArray = this.colors;
        int n = this.colors.length;
        int n2 = 0;
        while (n2 < n) {
            TabColor tabColor = tabColorArray[n2];
            tabColor.connect(null);
            ++n2;
        }
    }

    public boolean isBound() {
        return this.bound;
    }

    @Override
    public Dockable getDockable() {
        return this.dockable;
    }

    @Override
    public DockElement getElement() {
        return this.dockable;
    }

    @Override
    public boolean isUsedAsTitle() {
        return true;
    }

    @Override
    public boolean shouldTransfersFocus() {
        return true;
    }

    @Override
    public boolean shouldFocus() {
        return true;
    }

    @Override
    public void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.addMouseListener(mouseInputListener);
        this.addMouseMotionListener(mouseInputListener);
    }

    @Override
    public void removeMouseInputListener(MouseInputListener mouseInputListener) {
        this.removeMouseListener(mouseInputListener);
        this.removeMouseMotionListener(mouseInputListener);
    }

    @Override
    public synchronized void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        this.label.addMouseListener(mouseListener);
        this.buttons.addMouseListener(mouseListener);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        this.label.removeMouseListener(mouseListener);
        this.buttons.removeMouseListener(mouseListener);
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        super.addMouseMotionListener(mouseMotionListener);
        this.label.addMouseMotionListener(mouseMotionListener);
        this.buttons.addMouseMotionListener(mouseMotionListener);
    }

    @Override
    public synchronized void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        super.removeMouseMotionListener(mouseMotionListener);
        this.label.removeMouseMotionListener(mouseMotionListener);
        this.buttons.removeMouseMotionListener(mouseMotionListener);
    }

    @Override
    public Point getPopupLocation(Point point, boolean bl) {
        if (bl) {
            return point;
        }
        return null;
    }

    public DockController getController() {
        return this.pane.getController();
    }

    public DockStation getStation() {
        return this.pane.getStation();
    }

    @Override
    protected void setupRenderingHints(Graphics graphics) {
        DockController dockController = this.getController();
        if (dockController != null) {
            DockRenderingHints dockRenderingHints = dockController.getProperties().get(DockRenderingHints.RENDERING_HINTS);
            dockRenderingHints.setupGraphics(graphics);
        }
    }

    public EclipseTabPane getPane() {
        return this.pane;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setFocused(boolean bl) {
        if (this.hasFocus != bl) {
            this.hasFocus = bl;
            this.refreshActions();
            this.updateFocus();
        }
    }

    @Override
    public boolean isFocused() {
        return this.hasFocus;
    }

    public boolean isFocusTemporarilyLost() {
        Window window = SwingUtilities.getWindowAncestor(this.getComponent());
        boolean bl = false;
        if (window != null) {
            bl = !window.isActive();
        }
        return bl;
    }

    @Override
    public void setSelected(boolean bl) {
        if (this.isSelected != bl) {
            this.isSelected = bl;
            if (this.isSelected() || this.doPaintIconWhenInactive()) {
                this.label.setIcon(this.icon);
            } else {
                this.label.setIcon(null);
            }
            this.refreshActions();
            this.revalidate();
            this.updateSelected();
        }
    }

    @Override
    public boolean isSelected() {
        return this.isSelected;
    }

    protected void setPreviousTabSelected(boolean bl) {
        this.previousTabSelected = bl;
        this.previousTabSelectedSet = true;
    }

    protected void cleanPreviousTabSelected() {
        this.previousTabSelectedSet = false;
    }

    protected boolean isPreviousTabSelected() {
        if (this.previousTabSelectedSet) {
            return this.previousTabSelected;
        }
        EclipseTabPane eclipseTabPane = this.getPane();
        eclipseTabPane.getSelectedIndex();
        int n = this.getTabIndex();
        if (n <= 0) {
            return false;
        }
        EclipseTab eclipseTab = (EclipseTab)eclipseTabPane.getVisibleTab(n - 1);
        return eclipseTab.getDockable() == eclipseTabPane.getSelectedDockable();
    }

    protected void setNextTabSelected(boolean bl) {
        this.nextTabSelected = bl;
        this.nextTabSelectedSet = true;
    }

    protected void cleanNextTabSelected() {
        this.nextTabSelectedSet = false;
    }

    protected boolean isNextTabSelected() {
        if (this.nextTabSelectedSet) {
            return this.nextTabSelected;
        }
        EclipseTabPane eclipseTabPane = this.getPane();
        int n = this.getTabIndex();
        if (n >= eclipseTabPane.getVisibleTabCount()) {
            return false;
        }
        EclipseTab eclipseTab = (EclipseTab)eclipseTabPane.getVisibleTab(n + 1);
        if (eclipseTab == null) {
            return false;
        }
        return eclipseTab.getDockable() == eclipseTabPane.getSelectedDockable();
    }

    public int getDockableIndex() {
        EclipseTabPane eclipseTabPane = this.getPane();
        if (eclipseTabPane == null || !this.isBound()) {
            return -1;
        }
        return eclipseTabPane.indexOf(this.getDockable());
    }

    public int getTabIndex() {
        EclipseTabPane eclipseTabPane = this.getPane();
        if (eclipseTabPane == null || !this.isBound()) {
            return -1;
        }
        return eclipseTabPane.indexOfVisible(this);
    }

    public boolean doPaintIconWhenInactive() {
        return this.paintIconWhenInactive;
    }

    @Override
    public void setPaintIconWhenInactive(boolean bl) {
        if (this.paintIconWhenInactive != bl) {
            this.paintIconWhenInactive = bl;
            this.updatePaintIcon();
        }
    }

    @Override
    public void setIcon(Icon icon) {
        this.icon = icon;
        if (this.isSelected() || this.doPaintIconWhenInactive()) {
            this.label.setIcon(icon);
            this.revalidate();
        }
    }

    public Icon getIcon() {
        return this.label.getIcon();
    }

    @Override
    public void setText(String string) {
        this.label.setText(string);
        this.revalidate();
    }

    @Override
    public void setTooltip(String string) {
        this.setToolTipText(string);
        this.label.setToolTipText(string);
    }

    public String getText() {
        return this.label.getText();
    }

    public void setLabelInsets(Insets insets) {
        this.layoutManager.setLabelInsets(insets);
        this.revalidate();
    }

    public Insets getLabelInsets() {
        return this.layoutManager.getLabelInsets();
    }

    public void setButtonInsets(Insets insets) {
        this.layoutManager.setActionInsets(insets);
        this.revalidate();
    }

    public Insets getButtonInsets() {
        return this.layoutManager.getActionInsets();
    }

    protected OrientedLabel getLabel() {
        return this.label;
    }

    public ButtonPanel getButtons() {
        return this.buttons;
    }

    protected boolean containsButton(int n, int n2) {
        return this.buttons.contains(n -= this.buttons.getX(), n2 -= this.buttons.getY());
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.isEnabled() != bl) {
            super.setEnabled(bl);
            this.label.setEnabled(bl);
            this.refreshActions();
            this.updateEnabled();
        }
    }

    @Override
    public void setOrientation(TabPlacement tabPlacement) {
        if (tabPlacement == null) {
            throw new IllegalArgumentException("orientation must not be null");
        }
        if (this.orientation != tabPlacement) {
            this.orientation = tabPlacement;
            this.layoutManager.setOrientation(tabPlacement);
            this.refreshActions();
            this.updateOrientation();
        }
    }

    public TabPlacement getOrientation() {
        return this.orientation;
    }

    @Override
    public Dimension getMinimumSize(TabComponent[] tabComponentArray) {
        this.setSelection(tabComponentArray);
        Dimension dimension = this.getMinimumSize();
        this.unsetSelection();
        return dimension;
    }

    @Override
    public Dimension getPreferredSize(TabComponent[] tabComponentArray) {
        this.setSelection(tabComponentArray);
        Dimension dimension = this.getPreferredSize();
        this.unsetSelection();
        return dimension;
    }

    private void setSelection(TabComponent[] tabComponentArray) {
        int n = 0;
        while (n < tabComponentArray.length) {
            if (tabComponentArray[n] == this) {
                if (n > 0 && tabComponentArray[n - 1] instanceof BaseTabComponent) {
                    this.setPreviousTabSelected(((BaseTabComponent)tabComponentArray[n - 1]).isSelected());
                }
                if (n + 1 >= tabComponentArray.length || !(tabComponentArray[n + 1] instanceof BaseTabComponent)) break;
                this.setNextTabSelected(((BaseTabComponent)tabComponentArray[n + 1]).isSelected());
                break;
            }
            ++n;
        }
    }

    private void unsetSelection() {
        this.cleanNextTabSelected();
        this.cleanPreviousTabSelected();
    }

    private class Background
    extends BackgroundAlgorithm
    implements TabPaneTabBackgroundComponent {
        private EclipseTab tab;

        public Background(EclipseTab eclipseTab) {
            super(TabPaneTabBackgroundComponent.KIND, "dock.background.tabPane.child.tab");
            this.tab = eclipseTab;
        }

        @Override
        public Tab getTab() {
            return this.tab;
        }

        @Override
        public TabPaneComponent getChild() {
            return this.tab;
        }

        @Override
        public TabPane getPane() {
            return this.tab.getTabParent();
        }

        @Override
        public Component getComponent() {
            return BaseTabComponent.this.getComponent();
        }
    }

    private class BaseTabColor
    extends TabColor {
        public BaseTabColor(String string, DockStation dockStation, Color color) {
            super(string, dockStation, BaseTabComponent.this.dockable, color);
        }

        @Override
        protected void changed(Color color, Color color2) {
            BaseTabComponent.this.updateColors();
        }
    }

    private class BorderTabColor
    extends TabColor {
        public BorderTabColor(String string, DockStation dockStation, Color color) {
            super(string, dockStation, BaseTabComponent.this.dockable, color);
        }

        @Override
        protected void changed(Color color, Color color2) {
            BaseTabComponent.this.updateBorder();
        }
    }
}

