/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack.tab;

import java.awt.Dimension;
import java.util.Arrays;

public class Arch {
    private int width;
    private int height;
    private int[] values;

    public Arch(int n, int n2) {
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("width or height smaller than 1: " + n + ", " + n2);
        }
        this.width = n;
        this.height = n2;
        this.values = new int[n];
        this.calculate();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getValue(int n) {
        return this.values[n];
    }

    private void calculate() {
        int n;
        int n2;
        int n3 = this.lineWidth(this.width);
        int n4 = this.lineHeight(this.height);
        Dimension dimension = this.findGoodSlope(n3, n4);
        n3 = dimension.width;
        n4 = dimension.height;
        int n5 = (this.width - n3) / 2;
        int n6 = (this.height - n4) / 2;
        int n7 = this.width - n5 - n3;
        int n8 = this.height - n6 - n4;
        Arrays.fill(this.values, -1);
        double[] dArray = this.arch(0, 0, n5, n6, (double)n4 / (double)n3);
        double[] dArray2 = this.arch(0, 0, n7, n8, (double)n4 / (double)n3);
        int n9 = 0;
        while (n9 < n5) {
            this.values[n9] = n2 = (int)(dArray[n9] + 0.5);
            ++n9;
        }
        n9 = 0;
        while (n9 < n7) {
            n2 = (int)(dArray2[n9] + 0.5);
            this.values[this.width - n9 - 1] = this.height - n2 - 1;
            ++n9;
        }
        double[] dArray3 = this.line(n5, n6, this.width - n7, this.height - n8);
        n2 = 0;
        while (n2 < dArray3.length && n2 + n5 < this.values.length) {
            this.values[n2 + n5] = n = (int)(dArray3[n2] + 0.5);
            ++n2;
        }
        if (this.values[0] == -1) {
            this.values[0] = 0;
            this.values[this.values.length - 1] = this.height - 1;
        }
        n2 = 1;
        n = this.width / 2;
        while (n2 <= n) {
            if (this.values[n2] == -1) {
                this.values[n2] = this.values[n2 - 1];
                this.values[this.width - n2 - 1] = this.values[this.width - n2];
            }
            ++n2;
        }
    }

    private double[] line(int n, int n2, int n3, int n4) {
        double[] dArray = new double[n3 - n + 1];
        int n5 = 0;
        while (n5 < dArray.length) {
            int n6 = 0;
            while (n6 < 10) {
                double d = (double)(10 * n5 + n6) / 10.0 / (double)dArray.length;
                double d2 = (double)(10 * n5 + n6) / 10.0 / (double)(dArray.length + 1);
                double d3 = (double)n + d * (double)(n3 - n + 1);
                double d4 = (double)n2 + d2 * (double)(n4 - n2 + 1);
                int n7 = (int)d3 - n;
                dArray[n7] = dArray[n7] + 0.1 * d4;
                ++n6;
            }
            ++n5;
        }
        return dArray;
    }

    private double[] arch(int n, int n2, int n3, int n4, double d) {
        double d2 = n2;
        double d3 = this.cutWithZero(n + n3, n2 + n4, d, d2);
        double d4 = d2;
        double[] dArray = new double[n3];
        int[] nArray = new int[n3];
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < 10) {
                double d5 = (double)(10 * n5 + n6) / 10.0 / (double)n3;
                double d6 = this.bezier(d5, n, d3, n + n3);
                double d7 = this.bezier(d5, n2, d4, n2 + n4);
                int n7 = (int)d6 - n;
                int n8 = nArray[n7];
                int n9 = n7;
                nArray[n9] = nArray[n9] + 1;
                dArray[n7] = ((double)n8 * dArray[n7] + d7) / (double)(n8 + 1);
                ++n6;
            }
            ++n5;
        }
        return dArray;
    }

    private double bezier(double d, double d2, double d3, double d4) {
        return (1.0 - d) * (1.0 - d) * d2 + 2.0 * d * (1.0 - d) * d3 + d * d * d4;
    }

    private double cutWithZero(double d, double d2, double d3, double d4) {
        double d5 = d2 - d3 * d;
        return (d4 - d5) / d3;
    }

    private int lineWidth(int n) {
        int n2 = n / 3;
        int n3 = n % 3;
        if (n3 == 1) {
            return n2 + 1;
        }
        return n2;
    }

    private int lineHeight(int n) {
        int n2 = n / 2;
        if ((n - n2) % 2 == 1) {
            ++n2;
        }
        return n2;
    }

    private Dimension findGoodSlope(int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        if (n2 > 0) {
            double d = (double)n / (double)n2;
            double d2 = this.neareastRatio(d);
            dimension.width = (int)(d2 * (double)n2);
        }
        return dimension;
    }

    private double neareastRatio(double d) {
        if (d > 1.0) {
            return Math.round(d);
        }
        return 1.0 / (double)Math.round(1.0 / d);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.height) {
            if (n > 0) {
                stringBuilder.append("\n");
            }
            if (n < 10) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(n);
            stringBuilder.append(": ");
            int n2 = 0;
            while (n2 < this.width) {
                if (this.values[n2] == n) {
                    stringBuilder.append("*");
                } else {
                    stringBuilder.append(" ");
                }
                ++n2;
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.height;
        n = 31 * n + this.width;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Arch arch = (Arch)object;
        if (this.height != arch.height) {
            return false;
        }
        return this.width == arch.width;
    }
}

