/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseMenu;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabInfo;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabPaneContent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.BaseTabComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.BorderedComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabPainter;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabPanePainter;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.CombinedStackDockComponent;
import bibliothek.gui.dock.station.stack.CombinedStackDockContentPane;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentBorder;
import bibliothek.gui.dock.station.stack.StackDockComponentContentBorder;
import bibliothek.gui.dock.station.stack.menu.ButtonCombinedMenu;
import bibliothek.gui.dock.station.stack.tab.AbstractTab;
import bibliothek.gui.dock.station.stack.tab.AbstractTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.LonelyTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneListener;
import bibliothek.gui.dock.themes.border.BorderForwarder;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class EclipseTabPane
extends CombinedStackDockComponent<EclipseTab, EclipseMenu, EclipseTabInfo>
implements BorderedComponent {
    private PropertyValue<TabPainter> tabPainter = new PropertyValue<TabPainter>(EclipseTheme.TAB_PAINTER){

        @Override
        protected void valueChanged(TabPainter tabPainter, TabPainter tabPainter2) {
            EclipseTabPane.this.updateTabPainter();
        }
    };
    private PropertyValue<Boolean> paintIcons = new PropertyValue<Boolean>(EclipseTheme.PAINT_ICONS_WHEN_DESELECTED){

        @Override
        protected void valueChanged(Boolean bl, Boolean bl2) {
            EclipseTabPane.this.updatePaintIcons();
        }
    };
    private DockStation station;
    private EclipseTheme theme;
    private TabPanePainter painter;
    private BorderForwarder border;

    public EclipseTabPane(EclipseTheme eclipseTheme, DockStation dockStation) {
        this.theme = eclipseTheme;
        this.station = dockStation;
        this.setInfoComponent(new EclipseTabInfo(this));
        this.addTabPaneListener(new TabPaneListener(){

            @Override
            public void added(TabPane tabPane, Dockable dockable) {
            }

            @Override
            public void removed(TabPane tabPane, Dockable dockable) {
            }

            @Override
            public void selectionChanged(TabPane tabPane) {
                EclipseTabPane.this.updateFullBorder();
            }

            @Override
            public void infoComponentChanged(TabPane tabPane, LonelyTabPaneComponent lonelyTabPaneComponent, LonelyTabPaneComponent lonelyTabPaneComponent2) {
            }

            @Override
            public void controllerChanged(TabPane tabPane, DockController dockController) {
            }
        });
        this.getComponent().addHierarchyListener(new WindowActiveObserver());
    }

    @Override
    protected CombinedStackDockContentPane createContentPane(CombinedStackDockComponent<EclipseTab, EclipseMenu, EclipseTabInfo> combinedStackDockComponent) {
        return new EclipseTabPaneContent((EclipseTabPane)combinedStackDockComponent);
    }

    @Override
    public void setController(DockController dockController) {
        super.setController(dockController);
        this.tabPainter.setProperties(dockController);
        this.paintIcons.setProperties(dockController);
        this.getBorderForwarder().setController(dockController);
        if (this.painter != null) {
            this.painter.setController(dockController);
        }
        for (AbstractTabPaneComponent abstractTabPaneComponent : this.getTabsList()) {
            ((AbstractTab)abstractTabPaneComponent).setController(dockController);
        }
        for (AbstractTabPaneComponent abstractTabPaneComponent : this.getMenuList()) {
            ((ButtonCombinedMenu)abstractTabPaneComponent).setController(dockController);
        }
        this.updateTabPainter();
    }

    @Override
    public void setInfoComponent(EclipseTabInfo eclipseTabInfo) {
        EclipseTabInfo eclipseTabInfo2 = (EclipseTabInfo)this.getInfoComponent();
        if (eclipseTabInfo2 != null) {
            eclipseTabInfo2.setSelection(null);
        }
        if (eclipseTabInfo != null) {
            eclipseTabInfo.setSelection(this.getSelectedDockable());
        }
        super.setInfoComponent(eclipseTabInfo);
    }

    public EclipseTheme getTheme() {
        return this.theme;
    }

    public DockStation getStation() {
        return this.station;
    }

    public TabPainter getTabPainter() {
        return this.tabPainter.getValue();
    }

    protected void updateTabPainter() {
        this.updateFullBorder();
        TabPainter tabPainter = this.getTabPainter();
        this.setPainter(tabPainter == null ? null : tabPainter.createDecorationPainter(this));
        this.discardComponentsAndRebuild();
    }

    public void setPainter(TabPanePainter tabPanePainter) {
        if (this.painter != null) {
            this.painter.setController(null);
        }
        this.painter = tabPanePainter;
        if (this.painter != null) {
            this.painter.setController(this.getController());
        }
        this.repaint();
    }

    public TabPanePainter getPainter() {
        return this.painter;
    }

    @Override
    public void updateFullBorder() {
        TabPainter tabPainter = this.getTabPainter();
        DockController dockController = this.getController();
        Dockable dockable = this.getSelectedDockable();
        Border border = null;
        if (tabPainter != null && dockController != null && dockable != null) {
            border = tabPainter.getFullBorder(this, dockController, dockable);
        }
        this.getBorderForwarder().setBorder(border);
        this.repaint();
    }

    private BorderForwarder getBorderForwarder() {
        if (this.border == null) {
            this.border = this.createBorderModifier(this.getComponent());
            this.border.setController(this.getController());
        }
        return this.border;
    }

    protected BorderForwarder createBorderModifier(JComponent jComponent) {
        return new TabPaneBorder(jComponent);
    }

    @Override
    protected BorderForwarder createContentBorderModifier(Dockable dockable, JComponent jComponent) {
        return new TabContentBorder(dockable, jComponent);
    }

    private void updatePaintIcons() {
        boolean bl = this.paintIcons.getValue();
        for (EclipseTab eclipseTab : this.getTabsList()) {
            eclipseTab.setPaintIconWhenInactive(bl);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    protected EclipseTab newTab(Dockable dockable) {
        TabComponent tabComponent = this.getTabPainter().createTabComponent(this, dockable);
        EclipseTab eclipseTab = new EclipseTab(this, dockable, tabComponent);
        eclipseTab.setPaintIconWhenInactive(this.paintIcons.getValue());
        eclipseTab.setController(this.getController());
        eclipseTab.bind();
        return eclipseTab;
    }

    @Override
    protected void tabRemoved(EclipseTab eclipseTab) {
        eclipseTab.unbind();
    }

    public int indexOfVisible(TabComponent tabComponent) {
        for (EclipseTab eclipseTab : this.getTabsList()) {
            if (eclipseTab.getTabComponent() != tabComponent) continue;
            return this.indexOfVisible(eclipseTab);
        }
        return -1;
    }

    @Override
    public EclipseMenu newMenu() {
        EclipseMenu eclipseMenu = new EclipseMenu(this);
        eclipseMenu.setController(this.getController());
        return eclipseMenu;
    }

    @Override
    protected void menuRemoved(EclipseMenu eclipseMenu) {
        eclipseMenu.setController(null);
    }

    public void setContentBorderAt(int n, Border border) {
        this.getContentAt(n).setBorder(border);
    }

    @Override
    protected Component createLayerAt(Component component, Dockable dockable) {
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        jPanel.add(component);
        jPanel.setOpaque(false);
        return jPanel;
    }

    @Override
    public JComponent getLayerAt(int n) {
        return (JComponent)super.getLayerAt(n);
    }

    public Insets getContentInsets() {
        Rectangle rectangle = this.getSelectedBounds();
        Dimension dimension = this.getComponent().getSize();
        Insets insets = new Insets(rectangle.y, rectangle.x, dimension.height - rectangle.y - rectangle.height, dimension.width - rectangle.x - rectangle.width);
        int n = this.getSelectedIndex();
        if (n < 0) {
            return insets;
        }
        JComponent jComponent = this.getLayerAt(n);
        Border border = jComponent.getBorder();
        if (border != null) {
            Insets insets2 = border.getBorderInsets(jComponent);
            insets.left += insets2.left;
            insets.right += insets2.right;
            insets.top += insets2.top;
            insets.bottom += insets2.bottom;
        }
        return insets;
    }

    @Override
    public boolean hasBorder() {
        return true;
    }

    @Override
    public boolean isSingleTabComponent() {
        return true;
    }

    private class TabContentBorder
    extends BorderForwarder
    implements StackDockComponentContentBorder {
        private Dockable dockable;

        public TabContentBorder(Dockable dockable, JComponent jComponent) {
            super(StackDockComponentContentBorder.KIND, "dock.border.stack.eclipse.content", jComponent);
            this.dockable = dockable;
        }

        @Override
        public StackDockComponent getStackComponent() {
            return EclipseTabPane.this;
        }

        @Override
        public Dockable getDockable() {
            return this.dockable;
        }
    }

    private class TabPaneBorder
    extends BorderForwarder
    implements StackDockComponentBorder {
        public TabPaneBorder(JComponent jComponent) {
            super(StackDockComponentBorder.KIND, "dock.border.stack.eclipse", jComponent);
        }

        @Override
        public StackDockComponent getStackComponent() {
            return EclipseTabPane.this;
        }
    }

    private class WindowActiveObserver
    extends WindowAdapter
    implements HierarchyListener {
        private Window window;

        private WindowActiveObserver() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            Window window = SwingUtilities.getWindowAncestor(EclipseTabPane.this.getComponent());
            long l = hierarchyEvent.getChangeFlags();
            if (this.window != window && (l & 1L) != 0L) {
                if (this.window != null) {
                    this.window.removeWindowListener(this);
                }
                if (window != null) {
                    EclipseTab eclipseTab;
                    window.addWindowListener(this);
                    if (EclipseTabPane.this.getSelectedIndex() != -1 && (eclipseTab = (EclipseTab)EclipseTabPane.this.getTab(EclipseTabPane.this.getSelectedDockable())) != null && eclipseTab.getComponent() instanceof BaseTabComponent) {
                        ((BaseTabComponent)eclipseTab.getComponent()).updateBorder();
                        ((BaseTabComponent)eclipseTab.getComponent()).updateFocus();
                    }
                }
                this.window = window;
            }
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            EclipseTab eclipseTab;
            if (EclipseTabPane.this.getSelectedIndex() != -1 && (eclipseTab = (EclipseTab)EclipseTabPane.this.getTab(EclipseTabPane.this.getSelectedDockable())) != null && eclipseTab.getComponent() instanceof BaseTabComponent) {
                ((BaseTabComponent)eclipseTab.getComponent()).updateBorder();
                ((BaseTabComponent)eclipseTab.getComponent()).updateFocus();
            }
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            EclipseTab eclipseTab;
            if (EclipseTabPane.this.getSelectedIndex() != -1 && (eclipseTab = (EclipseTab)EclipseTabPane.this.getTab(EclipseTabPane.this.getSelectedDockable())) != null && eclipseTab.getComponent() instanceof BaseTabComponent) {
                ((BaseTabComponent)eclipseTab.getComponent()).updateBorder();
                ((BaseTabComponent)eclipseTab.getComponent()).updateFocus();
            }
        }
    }
}

