/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack;

import bibliothek.extension.gui.dock.theme.eclipse.EclipseTabStateInfo;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabComponent;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.station.stack.CombinedTab;
import bibliothek.gui.dock.station.stack.tab.AbstractTab;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabConfiguration;
import bibliothek.gui.dock.station.stack.tab.TabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.MouseInputListener;

public class EclipseTab
extends AbstractTab
implements CombinedTab {
    private TabComponent component;
    private EclipseTabPane parent;
    private List<MouseInputListener> mouseInputListeners = new ArrayList<MouseInputListener>();
    private boolean enabled = true;

    public EclipseTab(EclipseTabPane eclipseTabPane, Dockable dockable, TabComponent tabComponent) {
        super(eclipseTabPane, dockable);
        this.parent = eclipseTabPane;
        this.component = tabComponent;
        this.component.setIcon(dockable.getTitleIcon());
        this.component.setText(dockable.getTitleText());
        this.component.setTab(this);
    }

    public EclipseTabStateInfo getEclipseTabStateInfo() {
        return this.component.getEclipseTabStateInfo();
    }

    @Override
    public void setConfiguration(TabConfiguration tabConfiguration) {
        this.component.setConfiguration(tabConfiguration);
    }

    @Override
    public Component getComponent() {
        return this.component.getComponent();
    }

    public TabComponent getTabComponent() {
        return this.component;
    }

    @Override
    public void setPaneVisible(boolean bl) {
        this.parent.getTabHandler().setVisible(this, bl);
    }

    @Override
    public boolean isPaneVisible() {
        return this.parent.getTabHandler().isVisible(this);
    }

    @Override
    public void setZOrder(int n) {
        this.parent.getTabHandler().setZOrder(this, n);
    }

    @Override
    public int getZOrder() {
        return this.parent.getTabHandler().getZOrder(this);
    }

    @Override
    public void setIcon(Icon icon) {
        this.component.setIcon(icon);
    }

    @Override
    public void setText(String string) {
        this.component.setText(string);
    }

    @Override
    public void setTooltip(String string) {
        this.component.setTooltip(string);
    }

    @Override
    public void setOrientation(TabPlacement tabPlacement) {
        super.setOrientation(tabPlacement);
        this.component.setOrientation(tabPlacement);
    }

    @Override
    public Dimension getMinimumSize(Tab[] tabArray) {
        return this.component.getMinimumSize(this.extract(tabArray));
    }

    @Override
    public Dimension getPreferredSize(Tab[] tabArray) {
        return this.component.getPreferredSize(this.extract(tabArray));
    }

    private TabComponent[] extract(Tab[] tabArray) {
        TabComponent[] tabComponentArray = new TabComponent[tabArray.length];
        int n = 0;
        while (n < tabArray.length) {
            if (tabArray[n] instanceof EclipseTab) {
                tabComponentArray[n] = ((EclipseTab)tabArray[n]).getTabComponent();
            }
            ++n;
        }
        return tabComponentArray;
    }

    @Override
    public DockElement getElement() {
        return this.getDockable();
    }

    @Override
    public Point getPopupLocation(Point point, boolean bl) {
        if (bl) {
            return point;
        }
        return null;
    }

    @Override
    public boolean isUsedAsTitle() {
        return true;
    }

    @Override
    public boolean shouldFocus() {
        return true;
    }

    @Override
    public boolean shouldTransfersFocus() {
        return true;
    }

    @Override
    public void setEnabled(boolean bl) {
        block4: {
            if (bl == this.enabled) break block4;
            this.enabled = bl;
            this.component.setEnabled(bl);
            if (bl) {
                for (MouseInputListener mouseInputListener : this.mouseInputListeners) {
                    this.component.addMouseInputListener(mouseInputListener);
                }
            } else {
                for (MouseInputListener mouseInputListener : this.mouseInputListeners) {
                    this.component.removeMouseInputListener(mouseInputListener);
                }
            }
        }
    }

    @Override
    public void removeMouseInputListener(MouseInputListener mouseInputListener) {
        this.mouseInputListeners.remove(mouseInputListener);
        if (this.enabled) {
            this.component.removeMouseInputListener(mouseInputListener);
        }
    }

    @Override
    public void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.mouseInputListeners.add(mouseInputListener);
        if (this.enabled) {
            this.component.addMouseInputListener(mouseInputListener);
        }
    }

    @Override
    public void bind() {
        this.component.bind();
        super.bind();
    }

    @Override
    public void unbind() {
        this.component.unbind();
        super.unbind();
    }

    @Override
    public Insets getOverlap(TabPaneComponent tabPaneComponent) {
        if (tabPaneComponent instanceof EclipseTab) {
            EclipseTab eclipseTab = (EclipseTab)tabPaneComponent;
            return this.getTabComponent().getOverlap(eclipseTab.getTabComponent());
        }
        return super.getOverlap(tabPaneComponent);
    }

    public void setPaintIconWhenInactive(boolean bl) {
        this.component.setPaintIconWhenInactive(bl);
    }

    @Override
    protected void informFocusChanged(boolean bl) {
        this.component.setFocused(bl);
    }

    @Override
    protected void informSelectionChanged(boolean bl) {
        this.component.setSelected(bl);
    }

    public String toString() {
        Dockable dockable = this.component.getElement().asDockable();
        if (dockable == null) {
            return String.valueOf(this.getClass().getSimpleName()) + "@[component=" + this.component + "]";
        }
        return String.valueOf(this.getClass().getSimpleName()) + "@[dockable title=" + dockable.getTitleText() + "]";
    }
}

