/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.displayer;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnector;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnectorListener;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.util.PropertyValue;

public abstract class TitleBarObserver {
    private DockController controller;
    private DockStation station;
    private EclipseThemeConnector.TitleBar titleBar;
    private Dockable dockable;
    private EclipseThemeConnectorListener connectorListener = new EclipseThemeConnectorListener(){

        @Override
        public void titleBarChanged(EclipseThemeConnector eclipseThemeConnector, Dockable dockable, EclipseThemeConnector.TitleBar titleBar) {
            if (TitleBarObserver.this.connector != null && TitleBarObserver.this.controller != null && dockable == TitleBarObserver.this.dockable && titleBar != TitleBarObserver.this.titleBar) {
                TitleBarObserver.this.destroy();
                TitleBarObserver.this.invalidated();
            }
        }
    };
    private PropertyValue<EclipseThemeConnector> connector = new PropertyValue<EclipseThemeConnector>(EclipseTheme.THEME_CONNECTOR){

        @Override
        protected void valueChanged(EclipseThemeConnector eclipseThemeConnector, EclipseThemeConnector eclipseThemeConnector2) {
            if (eclipseThemeConnector != null) {
                eclipseThemeConnector.removeEclipseThemeConnectorListener(TitleBarObserver.this.connectorListener);
            }
            if (TitleBarObserver.this.connector != null && TitleBarObserver.this.controller != null && TitleBarObserver.this.dockable != null && eclipseThemeConnector2 != null && TitleBarObserver.this.titleBar != eclipseThemeConnector2.getTitleBarKind(TitleBarObserver.this.station, TitleBarObserver.this.dockable)) {
                TitleBarObserver.this.destroy();
                TitleBarObserver.this.invalidated();
            }
            if (TitleBarObserver.this.connector != null && TitleBarObserver.this.controller != null && eclipseThemeConnector2 != null) {
                eclipseThemeConnector2.addEclipseThemeConnectorListener(TitleBarObserver.this.connectorListener);
            }
        }
    };

    public TitleBarObserver(DockStation dockStation, Dockable dockable, EclipseThemeConnector.TitleBar titleBar) {
        this.station = dockStation;
        this.dockable = dockable;
        this.titleBar = titleBar;
    }

    public void setDockable(Dockable dockable) {
        this.dockable = dockable;
    }

    public void setController(DockController dockController) {
        this.controller = dockController;
        if (this.connector != null) {
            this.connector.setProperties(dockController);
        }
    }

    public void destroy() {
        if (this.connector != null) {
            this.setController(null);
            this.connector.getValue().removeEclipseThemeConnectorListener(this.connectorListener);
            this.connector = null;
        }
    }

    protected abstract void invalidated();
}

