/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.displayer;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnector;
import bibliothek.extension.gui.dock.theme.eclipse.displayer.TitleBarObserver;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.BorderedComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.InvisibleTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.InvisibleTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabPainter;
import bibliothek.extension.gui.dock.util.ReverseCompoundBorder;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.displayer.DisplayerDockBorder;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.ThemeManager;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayer;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayerDecorator;
import bibliothek.gui.dock.themes.border.BorderModifier;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.Transparency;
import java.awt.Graphics;
import javax.swing.border.Border;

public class NoTitleBarDisplayer
extends BasicDockableDisplayer
implements DockableDisplayer,
InvisibleTabPane,
BorderedComponent {
    private PropertyValue<TabPainter> painter;
    private TitleBarObserver observer;
    private InvisibleTab invisibleTab;
    private Border innerBorder;
    private Border outerBorder;
    private DisplayerBorder innerBorderModifier = new DisplayerBorder("in");
    private DisplayerBorder outerBorderModifier = new DisplayerBorder("out");

    public NoTitleBarDisplayer(DockStation dockStation, Dockable dockable, DockTitle dockTitle, EclipseThemeConnector.TitleBar titleBar) {
        super(dockStation);
        this.setDockable(dockable);
        this.setTitle(dockTitle);
        this.setTransparency(Transparency.TRANSPARENT);
        boolean bl = titleBar == EclipseThemeConnector.TitleBar.NONE_BORDERED || titleBar == EclipseThemeConnector.TitleBar.NONE_HINTED_BORDERED;
        boolean bl2 = titleBar == EclipseThemeConnector.TitleBar.NONE_HINTED || titleBar == EclipseThemeConnector.TitleBar.NONE_HINTED_BORDERED;
        this.setRespectBorderHint(bl2);
        this.setDefaultBorderHint(bl);
        this.observer = new TitleBarObserver(dockStation, dockable, titleBar){

            @Override
            protected void invalidated() {
                DockableDisplayerListener[] dockableDisplayerListenerArray = NoTitleBarDisplayer.this.listeners();
                int n = dockableDisplayerListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DockableDisplayerListener dockableDisplayerListener = dockableDisplayerListenerArray[n2];
                    dockableDisplayerListener.discard(NoTitleBarDisplayer.this);
                    ++n2;
                }
            }
        };
        this.painter = new PropertyValue<TabPainter>(EclipseTheme.TAB_PAINTER){

            @Override
            protected void valueChanged(TabPainter tabPainter, TabPainter tabPainter2) {
                NoTitleBarDisplayer.this.updateFullBorder();
                NoTitleBarDisplayer.this.updateInvisibleTab();
            }
        };
        this.updateFullBorder();
        this.updateInvisibleTab();
    }

    private boolean getBorderHint() {
        if (this.isRespectBorderHint()) {
            return this.getHints().getShowBorderHint();
        }
        return this.getDefaultBorderHint();
    }

    @Override
    public void updateFullBorder() {
        if ((this.isRespectBorderHint() || this.getDefaultBorderHint()) && this.painter != null) {
            TabPainter tabPainter = this.painter.getValue();
            Dockable dockable = this.getDockable();
            DockController dockController = this.getController();
            this.outerBorder = dockController == null || tabPainter == null || dockable == null ? null : (this.getBorderHint() ? tabPainter.getFullBorder(this, dockController, dockable) : null);
            this.updateBorder();
        }
    }

    @Override
    public void setBorder(Dockable dockable, Border border) {
        if (dockable != this.getDockable()) {
            throw new IllegalArgumentException("unknown dockable: " + dockable);
        }
        if ((this.getDefaultBorderHint() || this.isRespectBorderHint()) && this.getBorderHint()) {
            this.innerBorder = border;
            this.updateBorder();
        }
    }

    @Override
    protected Border getDefaultBorder() {
        Border border = this.innerBorderModifier.modify(this.innerBorder);
        Border border2 = this.outerBorderModifier.modify(this.outerBorder);
        if (border == null && border2 == null) {
            return null;
        }
        if (border == null) {
            return border2;
        }
        if (border2 == null) {
            return border;
        }
        return new ReverseCompoundBorder(border2, border);
    }

    protected void updateInvisibleTab() {
        TabPainter tabPainter;
        Dockable dockable;
        if (this.invisibleTab != null) {
            this.invisibleTab.setController(null);
            this.invisibleTab = null;
        }
        if ((dockable = this.getDockable()) != null && this.painter != null && (tabPainter = this.painter.getValue()) != null) {
            this.invisibleTab = tabPainter.createInvisibleTab(this, dockable);
            this.invisibleTab.setController(this.getController());
        }
    }

    @Override
    public TabPlacement getDockTabPlacement() {
        DockController dockController = this.getController();
        if (dockController == null) {
            return null;
        }
        return dockController.getProperties().get(StackDockStation.TAB_PLACEMENT);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintBorder(graphics);
    }

    @Override
    public Dockable getSelectedDockable() {
        return this.getDockable();
    }

    @Override
    public void setController(DockController dockController) {
        DockController dockController2 = this.getController();
        super.setController(dockController2);
        if (this.painter != null) {
            this.painter.setProperties(dockController == null ? null : dockController.getProperties());
        }
        if (this.observer != null) {
            this.observer.setController(dockController);
        }
        if (this.invisibleTab != null) {
            this.invisibleTab.setController(dockController);
        }
        this.innerBorderModifier.setController(dockController2, dockController);
        this.outerBorderModifier.setController(dockController2, dockController);
        this.updateFullBorder();
    }

    @Override
    public void setDockable(Dockable dockable) {
        if (this.invisibleTab != null) {
            this.invisibleTab.setController(null);
            this.invisibleTab = null;
        }
        if (this.observer != null) {
            this.observer.setDockable(dockable);
        }
        super.setDockable(dockable);
        this.updateInvisibleTab();
    }

    @Override
    protected BasicDockableDisplayerDecorator createTabDecorator() {
        if (this.isStacked()) {
            return this.createStackedDecorator();
        }
        return this.createMinimalDecorator();
    }

    private class DisplayerBorder
    implements DisplayerDockBorder {
        private String suffix;
        private BorderModifier modifier;

        public DisplayerBorder(String string) {
            this.suffix = string;
        }

        @Override
        public DockableDisplayer getDisplayer() {
            return NoTitleBarDisplayer.this;
        }

        public void setController(DockController dockController, DockController dockController2) {
            if (dockController != null) {
                dockController.getThemeManager().remove(this);
            }
            if (dockController2 != null) {
                String string = "dock.border.displayer.eclipse.no_title." + this.suffix;
                dockController2.getThemeManager().add(string, DisplayerDockBorder.KIND, ThemeManager.BORDER_MODIFIER_TYPE, this);
            } else {
                this.set(null);
            }
        }

        @Override
        public void set(BorderModifier borderModifier) {
            if (borderModifier != this.modifier) {
                this.modifier = borderModifier;
                NoTitleBarDisplayer.this.updateBorder();
            }
        }

        public Border modify(Border border) {
            if (this.modifier == null) {
                return border;
            }
            return this.modifier.modify(border);
        }
    }
}

