/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.displayer;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnector;
import bibliothek.extension.gui.dock.theme.eclipse.displayer.TitleBarObserver;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayer;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayerDecorator;
import bibliothek.gui.dock.title.DockTitle;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

public class EclipseDockableDisplayer
extends BasicDockableDisplayer {
    private TitleBarObserver observer;

    public EclipseDockableDisplayer(EclipseTheme eclipseTheme, DockStation dockStation, Dockable dockable, DockTitle dockTitle) {
        super(dockStation, false);
        this.observer = new TitleBarObserver(dockStation, dockable, EclipseThemeConnector.TitleBar.ECLIPSE){

            @Override
            protected void invalidated() {
                DockableDisplayerListener[] dockableDisplayerListenerArray = EclipseDockableDisplayer.this.listeners();
                int n = dockableDisplayerListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DockableDisplayerListener dockableDisplayerListener = dockableDisplayerListenerArray[n2];
                    dockableDisplayerListener.discard(EclipseDockableDisplayer.this);
                    ++n2;
                }
            }
        };
        this.init(dockStation, dockable, dockTitle, DockableDisplayer.Location.TOP);
        this.setDefaultBorderHint(false);
        this.setRespectBorderHint(true);
        this.setSingleTabShowInnerBorder(false);
        this.setSingleTabShowOuterBorder(false);
        this.updateDecorator(true);
    }

    @Override
    protected Border getDefaultBorder() {
        return BorderFactory.createEmptyBorder();
    }

    @Override
    public void setDockable(Dockable dockable) {
        super.setDockable(dockable);
        this.observer.setDockable(dockable);
    }

    @Override
    public void setController(DockController dockController) {
        super.setController(dockController);
        this.observer.setController(dockController);
    }

    @Override
    protected BasicDockableDisplayerDecorator createMinimalDecorator() {
        return this.createTabDecorator();
    }

    @Override
    protected BasicDockableDisplayerDecorator createStackedDecorator() {
        return this.createTabDecorator();
    }
}

