/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.displayer;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnector;
import bibliothek.extension.gui.dock.theme.eclipse.displayer.EclipseBasicDockableDisplayer;
import bibliothek.extension.gui.dock.theme.eclipse.displayer.EclipseDockableDisplayer;
import bibliothek.extension.gui.dock.theme.eclipse.displayer.NoTitleBarDisplayer;
import bibliothek.extension.gui.dock.theme.eclipse.rex.RexSystemColor;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.displayer.DisplayerRequest;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayer;
import bibliothek.gui.dock.title.DockTitle;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class EclipseDisplayerFactory
implements DisplayerFactory {
    private EclipseTheme theme;

    public EclipseDisplayerFactory(EclipseTheme eclipseTheme) {
        this.theme = eclipseTheme;
    }

    @Override
    public void request(DisplayerRequest displayerRequest) {
        DockTitle dockTitle;
        Dockable dockable = displayerRequest.getTarget();
        DockStation dockStation = displayerRequest.getParent();
        DockableDisplayer dockableDisplayer = this.create(dockStation, dockable, dockTitle = displayerRequest.getTitle());
        if (dockableDisplayer != null) {
            displayerRequest.answer(dockableDisplayer);
        }
    }

    protected DockableDisplayer create(DockStation dockStation, Dockable dockable, DockTitle dockTitle) {
        EclipseThemeConnector.TitleBar titleBar = this.theme.getThemeConnector(dockStation.getController()).getTitleBarKind(dockStation, dockable);
        switch (titleBar) {
            case NONE_BORDERED: 
            case NONE: 
            case NONE_HINTED: 
            case NONE_HINTED_BORDERED: {
                return new NoTitleBarDisplayer(dockStation, dockable, dockTitle, titleBar);
            }
            case ECLIPSE: {
                return new EclipseDockableDisplayer(this.theme, dockStation, dockable, dockTitle);
            }
            case BASIC_BORDERED: {
                return this.create(dockStation, dockable, dockTitle, true, titleBar);
            }
        }
        return this.create(dockStation, dockable, dockTitle, false, titleBar);
    }

    protected BasicDockableDisplayer create(DockStation dockStation, Dockable dockable, DockTitle dockTitle, boolean bl, EclipseThemeConnector.TitleBar titleBar) {
        DockableDisplayer.Location location = DockableDisplayer.Location.TOP;
        if (dockable.asDockStation() != null) {
            location = DockableDisplayer.Location.LEFT;
        }
        EclipseBasicDockableDisplayer eclipseBasicDockableDisplayer = bl ? new EclipseBasicDockableDisplayer(dockStation, dockable, dockTitle, location, titleBar){

            @Override
            protected Border getDefaultBorder() {
                return new LineBorder(RexSystemColor.getBorderColor());
            }
        } : new EclipseBasicDockableDisplayer(dockStation, dockable, dockTitle, location, titleBar){

            @Override
            protected Border getDefaultBorder() {
                return null;
            }
        };
        return eclipseBasicDockableDisplayer;
    }
}

