/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse;

import bibliothek.gui.dock.control.focus.FocusAwareComponent;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModelAdapter;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonModel;
import bibliothek.gui.dock.themes.basic.action.buttons.MiniButtonContent;
import bibliothek.gui.dock.util.AbstractPaintableComponent;
import bibliothek.gui.dock.util.BackgroundComponent;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.util.Colors;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Icon;
import javax.swing.JComponent;

public class RoundRectDropDownButton
extends JComponent
implements FocusAwareComponent {
    private static final long serialVersionUID = 1709299903419456519L;
    private BasicDropDownButtonModel model;
    private BasicDropDownButtonHandler handler;
    private Icon dropIcon;
    private Runnable afterFocusRequest;
    private MiniButtonContent content;

    public RoundRectDropDownButton(BasicDropDownButtonHandler basicDropDownButtonHandler) {
        this.handler = basicDropDownButtonHandler;
        this.model = new BasicDropDownButtonModel(this, basicDropDownButtonHandler, basicDropDownButtonHandler, true){

            @Override
            protected boolean inDropDownArea(int n, int n2) {
                return RoundRectDropDownButton.this.inDropDownArea(n, n2);
            }

            @Override
            public void changed() {
                RoundRectDropDownButton.this.revalidate();
                super.changed();
            }
        };
        this.setOpaque(false);
        this.content = this.createButtonContent();
        this.setLayout(null);
        this.add(this.content);
        this.content.setModel(this.model);
        this.content.setForegroundColorId("action.button.text", "action.button.text.disabled");
        this.dropIcon = basicDropDownButtonHandler.getDropDownIcon();
        this.model.addListener(new BasicButtonModelAdapter(){

            @Override
            public void mousePressed(BasicButtonModel basicButtonModel, boolean bl) {
                if (!bl) {
                    RoundRectDropDownButton.this.requestFocusInWindow();
                    RoundRectDropDownButton.this.invokeAfterFocusRequest();
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                RoundRectDropDownButton.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                RoundRectDropDownButton.this.repaint();
            }
        });
    }

    protected MiniButtonContent createButtonContent() {
        return new MiniButtonContent();
    }

    @Override
    public void maybeRequestFocus() {
        this.afterFocusRequest = null;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!RoundRectDropDownButton.this.model.isMousePressed()) {
                    RoundRectDropDownButton.this.requestFocusInWindow();
                    RoundRectDropDownButton.this.invokeAfterFocusRequest();
                }
            }
        });
    }

    @Override
    public void invokeOnFocusRequest(Runnable runnable) {
        this.afterFocusRequest = runnable;
    }

    private void invokeAfterFocusRequest() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (RoundRectDropDownButton.this.afterFocusRequest != null) {
                    RoundRectDropDownButton.this.afterFocusRequest.run();
                    RoundRectDropDownButton.this.afterFocusRequest = null;
                }
            }
        });
    }

    public BasicDropDownButtonModel getModel() {
        return this.model;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension dimension = this.content.getPreferredSize();
        if (this.model.getOrientation().isHorizontal()) {
            return new Dimension(dimension.width + 6 + this.dropIcon.getIconWidth(), dimension.height + 2);
        }
        return new Dimension(dimension.width + 2, dimension.height + 6 + this.dropIcon.getIconHeight());
    }

    @Override
    public void doLayout() {
        if (this.model.getOrientation().isHorizontal()) {
            this.content.setBounds(1, 1, this.getWidth() - 5 - this.dropIcon.getIconWidth(), this.getHeight() - 2);
        } else {
            this.content.setBounds(1, 1, this.getWidth() - 2, this.getHeight() - 5 - this.dropIcon.getIconHeight());
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        BasicDropDownButtonModel basicDropDownButtonModel = this.getModel();
        BackgroundPaint backgroundPaint = basicDropDownButtonModel.getBackground();
        BackgroundComponent backgroundComponent = basicDropDownButtonModel.getBackgroundComponent();
        AbstractPaintableComponent abstractPaintableComponent = new AbstractPaintableComponent(backgroundComponent, this, backgroundPaint){

            @Override
            protected void foreground(Graphics graphics) {
            }

            @Override
            protected void background(Graphics graphics) {
                RoundRectDropDownButton.this.doPaintBackground(graphics);
            }

            @Override
            protected void border(Graphics graphics) {
            }

            @Override
            protected void children(Graphics graphics) {
            }

            @Override
            protected void overlay(Graphics graphics) {
            }

            @Override
            public Transparency getTransparency() {
                return Transparency.DEFAULT;
            }
        };
        abstractPaintableComponent.paint(graphics);
    }

    private void doPaintBackground(Graphics graphics) {
        Color color = this.getBackground();
        Color color2 = null;
        if (this.model.isMousePressed()) {
            color2 = Colors.diffMirror(color, 0.3);
            color = Colors.undiffMirror(color, 0.8);
        } else if (this.model.isSelected() || this.model.isMouseInside()) {
            color2 = Colors.diffMirror(color, 0.3);
            color = Colors.undiffMirror(color, 0.4);
        }
        int n = this.getWidth() - 1;
        int n2 = this.getHeight() - 1;
        if (color2 != null) {
            graphics.setColor(color);
            graphics.fillRoundRect(0, 0, n, n2, 4, 4);
        }
    }

    public boolean inDropDownArea(int n, int n2) {
        if (!this.contains(n, n2)) {
            return false;
        }
        if (this.model.getOrientation().isHorizontal()) {
            return n >= this.getWidth() - this.dropIcon.getIconWidth() - 5;
        }
        return n2 >= this.getHeight() - this.dropIcon.getIconHeight() - 5;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.handler != null) {
            this.handler.updateUI();
        }
    }
}

