/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse;

import bibliothek.gui.dock.control.focus.FocusAwareComponent;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModelAdapter;
import bibliothek.gui.dock.themes.basic.action.BasicResourceInitializer;
import bibliothek.gui.dock.themes.basic.action.BasicTrigger;
import bibliothek.gui.dock.themes.basic.action.buttons.MiniButtonContent;
import bibliothek.gui.dock.util.AbstractPaintableComponent;
import bibliothek.gui.dock.util.BackgroundComponent;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.util.Colors;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;

public class RoundRectButton
extends JComponent
implements FocusAwareComponent {
    private static final long serialVersionUID = -5249516359774863262L;
    private BasicButtonModel model;
    private Runnable afterFocusRequest;
    private MiniButtonContent content;

    public RoundRectButton(BasicTrigger basicTrigger, BasicResourceInitializer basicResourceInitializer) {
        this.model = new BasicButtonModel(this, basicTrigger, basicResourceInitializer, true);
        this.setOpaque(false);
        this.setFocusable(true);
        this.content = this.createButtonContent();
        this.setLayout(null);
        this.add(this.content);
        this.content.setModel(this.model);
        this.content.setForegroundColorId("action.button.text", "action.button.text.disabled");
        this.model.addListener(new BasicButtonModelAdapter(){

            @Override
            public void mousePressed(BasicButtonModel basicButtonModel, boolean bl) {
                if (!bl) {
                    RoundRectButton.this.requestFocusInWindow();
                    RoundRectButton.this.invokeAfterFocusRequest();
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                RoundRectButton.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                RoundRectButton.this.repaint();
            }
        });
    }

    protected MiniButtonContent createButtonContent() {
        return new MiniButtonContent();
    }

    @Override
    public void maybeRequestFocus() {
        this.afterFocusRequest = null;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!RoundRectButton.this.model.isMousePressed()) {
                    RoundRectButton.this.requestFocusInWindow();
                    RoundRectButton.this.invokeAfterFocusRequest();
                }
            }
        });
    }

    @Override
    public void invokeOnFocusRequest(Runnable runnable) {
        this.afterFocusRequest = runnable;
    }

    private void invokeAfterFocusRequest() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (RoundRectButton.this.afterFocusRequest != null) {
                    RoundRectButton.this.afterFocusRequest.run();
                    RoundRectButton.this.afterFocusRequest = null;
                }
            }
        });
    }

    public BasicButtonModel getModel() {
        return this.model;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension dimension = this.content.getPreferredSize();
        return new Dimension(dimension.width + 4, dimension.height + 4);
    }

    @Override
    public void doLayout() {
        this.content.setBounds(2, 2, this.getWidth() - 4, this.getHeight() - 4);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        BackgroundPaint backgroundPaint = this.model.getBackground();
        BackgroundComponent backgroundComponent = this.model.getBackgroundComponent();
        if (backgroundPaint == null) {
            this.doPaintBackground(graphics);
        } else {
            AbstractPaintableComponent abstractPaintableComponent = new AbstractPaintableComponent(backgroundComponent, this, backgroundPaint){

                @Override
                protected void foreground(Graphics graphics) {
                }

                @Override
                protected void background(Graphics graphics) {
                    RoundRectButton.this.doPaintBackground(graphics);
                }

                @Override
                protected void border(Graphics graphics) {
                }

                @Override
                protected void children(Graphics graphics) {
                }

                @Override
                protected void overlay(Graphics graphics) {
                }

                @Override
                public Transparency getTransparency() {
                    return Transparency.DEFAULT;
                }
            };
            abstractPaintableComponent.paint(graphics);
        }
    }

    private void doPaintBackground(Graphics graphics) {
        Color color = this.getBackground();
        Color color2 = null;
        if (this.model.isMousePressed()) {
            color2 = Colors.diffMirror(color, 0.3);
            color = Colors.undiffMirror(color, 0.6);
        } else if (this.model.isSelected() || this.model.isMouseInside()) {
            color2 = Colors.diffMirror(color, 0.6);
            color = Colors.undiffMirror(color, 0.6);
        }
        int n = this.getWidth() - 1;
        int n2 = this.getHeight() - 1;
        if (color2 != null) {
            graphics.setColor(color);
            graphics.fillRoundRect(0, 0, n, n2, 4, 4);
            graphics.setColor(color2);
            graphics.drawRoundRect(0, 0, n, n2, 4, 4);
        }
    }
}

