/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse;

import bibliothek.extension.gui.dock.theme.eclipse.EclipseTabDockAction;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseTabDockActionLocation;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseTabStateInfo;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnector;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnectorListener;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.action.DockAction;
import java.util.ArrayList;
import java.util.List;

public class DefaultEclipseThemeConnector
implements EclipseThemeConnector {
    private List<EclipseThemeConnectorListener> listeners = new ArrayList<EclipseThemeConnectorListener>();

    @Override
    public void addEclipseThemeConnectorListener(EclipseThemeConnectorListener eclipseThemeConnectorListener) {
        this.listeners.add(eclipseThemeConnectorListener);
    }

    @Override
    public void removeEclipseThemeConnectorListener(EclipseThemeConnectorListener eclipseThemeConnectorListener) {
        this.listeners.remove(eclipseThemeConnectorListener);
    }

    protected EclipseThemeConnectorListener[] listeners() {
        return this.listeners.toArray(new EclipseThemeConnectorListener[this.listeners.size()]);
    }

    protected boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    @Override
    public EclipseThemeConnector.TitleBar getTitleBarKind(DockStation dockStation, Dockable dockable) {
        if (dockStation instanceof StackDockStation) {
            return EclipseThemeConnector.TitleBar.NONE;
        }
        if (dockable.asDockStation() == null) {
            return EclipseThemeConnector.TitleBar.ECLIPSE;
        }
        return EclipseThemeConnector.TitleBar.NONE_HINTED;
    }

    @Override
    public boolean shouldShowOnSide(DockAction dockAction, EclipseTabStateInfo eclipseTabStateInfo) {
        return this.getLocation(dockAction, eclipseTabStateInfo).isSide();
    }

    @Override
    public boolean shouldShowOnTab(DockAction dockAction, EclipseTabStateInfo eclipseTabStateInfo) {
        return this.getLocation(dockAction, eclipseTabStateInfo).isTab();
    }

    protected EclipseTabDockActionLocation getLocation(DockAction dockAction, EclipseTabStateInfo eclipseTabStateInfo) {
        EclipseTabDockAction eclipseTabDockAction = dockAction.getClass().getAnnotation(EclipseTabDockAction.class);
        return this.getLocation(eclipseTabDockAction, eclipseTabStateInfo);
    }

    protected EclipseTabDockActionLocation getLocation(EclipseTabDockAction eclipseTabDockAction, EclipseTabStateInfo eclipseTabStateInfo) {
        if (eclipseTabDockAction == null) {
            return EclipseTabDockActionLocation.SIDE;
        }
        if (eclipseTabStateInfo.isFocused()) {
            return eclipseTabDockAction.focused();
        }
        if (eclipseTabStateInfo.isSelected()) {
            return eclipseTabDockAction.selected();
        }
        return eclipseTabDockAction.normal();
    }
}

