/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme;

import bibliothek.gui.dock.themes.ColorScheme;
import bibliothek.gui.dock.themes.color.AbstractColorScheme;
import bibliothek.gui.dock.util.UIProperties;
import bibliothek.gui.dock.util.UIScheme;
import bibliothek.gui.dock.util.UISchemeEvent;
import bibliothek.gui.dock.util.UISchemeListener;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.DockColor;
import bibliothek.util.Path;
import java.awt.Color;
import java.util.Collection;
import java.util.Set;

public class IdentifiedColorScheme
extends AbstractColorScheme {
    private String id;
    private ColorScheme delegate;
    private UISchemeListener<Color, DockColor, ColorBridge> delegateListener = new UISchemeListener<Color, DockColor, ColorBridge>(){

        @Override
        public void changed(final UISchemeEvent<Color, DockColor, ColorBridge> uISchemeEvent) {
            IdentifiedColorScheme.this.fire(new UISchemeEvent<Color, DockColor, ColorBridge>(){

                @Override
                public Collection<Path> changedBridges(Set<Path> set) {
                    return uISchemeEvent.changedBridges(set);
                }

                @Override
                public Collection<String> changedResources(Set<String> set) {
                    return uISchemeEvent.changedResources(set);
                }

                @Override
                public UIScheme<Color, DockColor, ColorBridge> getScheme() {
                    return IdentifiedColorScheme.this;
                }
            });
        }
    };

    public IdentifiedColorScheme(String string, ColorScheme colorScheme) {
        if (string == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (colorScheme == null) {
            throw new IllegalArgumentException("delegate must not be null");
        }
        this.id = string;
        this.delegate = colorScheme;
    }

    @Override
    public void addListener(UISchemeListener<Color, DockColor, ColorBridge> uISchemeListener) {
        boolean bl = this.hasListeners();
        super.addListener(uISchemeListener);
        if (!bl) {
            this.delegate.addListener(this.delegateListener);
        }
    }

    @Override
    public void removeListener(UISchemeListener<Color, DockColor, ColorBridge> uISchemeListener) {
        super.removeListener(uISchemeListener);
        if (!this.hasListeners()) {
            this.delegate.removeListener(this.delegateListener);
        }
    }

    @Override
    public void install(UIProperties<Color, DockColor, ColorBridge> uIProperties) {
        super.install(uIProperties);
        this.delegate.uninstall(uIProperties);
    }

    @Override
    public void uninstall(UIProperties<Color, DockColor, ColorBridge> uIProperties) {
        super.uninstall(uIProperties);
        this.delegate.uninstall(uIProperties);
    }

    @Override
    protected void updateUI() {
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IdentifiedColorScheme identifiedColorScheme = (IdentifiedColorScheme)object;
        return this.id.equals(identifiedColorScheme.id);
    }

    @Override
    public ColorBridge getBridge(Path path, UIProperties<Color, DockColor, ColorBridge> uIProperties) {
        return this.delegate.getBridge(path, uIProperties);
    }

    @Override
    public Color getResource(String string, UIProperties<Color, DockColor, ColorBridge> uIProperties) {
        return this.delegate.getResource(string, uIProperties);
    }
}

