/*------------------------------------------------------------------------------
						HDR
------------------------------------------------------------------------------*/

float4 HDRPass( float4 colorInput, float2 Tex )
{
	float4 HDR = colorInput;
	float4 c_center = tex2D(s0, Tex.xy).rgba;
	float4 bloom_sum1 = float4(0.0, 0.0, 0.0, 0.0);
	float4 bloom_sum2 = float4(0.0, 0.0, 0.0, 0.0);
	Tex += float2(0, 0);
	float radius1 = 0.793;
	bloom_sum1 += tex2D(s0, Tex + float2(-1.5, -1.5) * radius1);
	bloom_sum1 += tex2D(s0, Tex + float2(-2.5, 0) * radius1);
	bloom_sum1 += tex2D(s0, Tex + float2(-1.5, 1.5) * radius1);
	bloom_sum1 += tex2D(s0, Tex + float2(0, 2.5) * radius1);
	bloom_sum1 += tex2D(s0, Tex + float2(1.5, 1.5) * radius1);
	bloom_sum1 += tex2D(s0, Tex + float2(2.5, 0) * radius1);
	bloom_sum1 += tex2D(s0, Tex + float2(1.5, -1.5) * radius1);
	bloom_sum1 += tex2D(s0, Tex + float2(0, -2.5) * radius1);
	bloom_sum1 *= 0.005;
	bloom_sum2 += tex2D(s0, Tex + float2(-1.5, -1.5) * radius2);
	bloom_sum2 += tex2D(s0, Tex + float2(-2.5, 0) * radius2);
	bloom_sum2 += tex2D(s0, Tex + float2(-1.5, 1.5) * radius2);
	bloom_sum2 += tex2D(s0, Tex + float2(0, 2.5) * radius2);
	bloom_sum2 += tex2D(s0, Tex + float2(1.5, 1.5) * radius2);
	bloom_sum2 += tex2D(s0, Tex + float2(2.5, 0) * radius2);
	bloom_sum2 += tex2D(s0, Tex + float2(1.5, -1.5) * radius2);
	bloom_sum2 += tex2D(s0, Tex + float2(0, -2.5) * radius2);
	bloom_sum2 *= 0.010;
	float dist = radius2 - radius1;
	HDR = (c_center + (bloom_sum2 - bloom_sum1)) * dist;
	float4 blend = HDR + colorInput;
	HDR += pow(blend, HDRPower) ;
	return HDR;
}