/*-----------------------------------------------【扩展】-----------------------------------------------*/
/*屏蔽脚本错误*/
window.onerror = function () {return true;};
/*去除左右空格*/
String.prototype.trim = function(){return this.replace(/(^\s*)|(\s*$)/g, "");}
/*中文转码*/
String.prototype.encodeChinese = function(){if(this) return encodeURIComponent(encodeURIComponent(this));else return "";}
/*中文解码*/
String.prototype.decodeChinese = function(){if(this) return decodeURIComponent(decodeURIComponent(this));else return "";}
/*截取指定字节长度的字符串*/
String.prototype.cutLength = function(length){
    var result = '',strlen = this.length, // 字符串长度
        chrlen = this.replace(/[^\x00-\xff]/g,'**').length; // 字节长度
    if(chrlen<=length){return this;}
    for(var i=0,j=0;i<strlen;i++){
        var chr = this.charAt(i);
        if(/[\x00-\xff]/.test(chr)){
            j++; // ascii码为0-255，一个字符就是一个字节的长度
        }else{
            j+=2; // ascii码为0-255以外，一个字符就是两个字节的长度
        }
        if(j<=length){ // 当加上当前字符以后，如果总字节长度小于等于length，则将当前字符真实的+在result后
            result += chr;
        }else{ // 反之则说明result已经是不拆分字符的情况下最接近length的值了，直接返回
            return result;
        }
    }
}
/*日期转为字符串*/
Date.prototype.format = function(fmt) {
    var o = {
        "M+" : this.getMonth()+1, //月份
        "d+" : this.getDate(), //日
        "h+" : this.getHours()%12 == 0 ? 12 : this.getHours()%12, //小时
        "H+" : this.getHours(), //小时
        "m+" : this.getMinutes(), //分
        "s+" : this.getSeconds(), //秒
        "q+" : Math.floor((this.getMonth()+3)/3), //季度
        "S" : this.getMilliseconds() //毫秒
    };
    var week = {
        "0" : "\u65e5",
        "1" : "\u4e00",
        "2" : "\u4e8c",
        "3" : "\u4e09",
        "4" : "\u56db",
        "5" : "\u4e94",
        "6" : "\u516d"
    };
    if(/(y+)/.test(fmt)){
        fmt=fmt.replace(RegExp.$1, (this.getFullYear()+"").substr(4 - RegExp.$1.length));
    }
    if(/(E+)/.test(fmt)){
        fmt=fmt.replace(RegExp.$1, ((RegExp.$1.length>1) ? (RegExp.$1.length>2 ? "\u661f\u671f" : "\u5468") : "")+week[this.getDay()+""]);
    }
    for(var k in o){
        if(new RegExp("("+ k +")").test(fmt)){
            fmt = fmt.replace(RegExp.$1, (RegExp.$1.length==1) ? (o[k]) : (("00"+ o[k]).substr((""+ o[k]).length)));
        }
    }
    return fmt;
}


/*-----------------------------------------------【函数】-----------------------------------------------*/
/*清除HTML5中的本地缓存和session缓存*/
function clearStorage(){
    sessionStorage.clear();//清除所有
    localStorage.clear();//清除所有
}

/*时间对象转换成字符串【11月14日 11:22】或者【今天 11:22】或者【明天 11:22】或者【昨天 11:22】或者【前天 11:22】*/
function dateToString(timeLong){
    if(!timeLong)return;
    var onDayLong = 24*60*60*1000;
    var date = new Date(timeLong);
    var currentDay = new Date();
    if(currentDay.getFullYear()==date.getFullYear() && currentDay.getMonth() == date.getMonth() && currentDay.getDate() == date.getDate()){
        //今天
        return date.format("HH:mm");
    }else if(currentDay.getFullYear()==date.getFullYear() && currentDay.getMonth() == date.getMonth() && (currentDay.getDate() + 1) == date.getDate()){
        //明天
        return "明天 " + date.format("HH:mm");
    }else if(currentDay.getFullYear()==date.getFullYear() && currentDay.getMonth() == date.getMonth() && (currentDay.getDate() - 1) == date.getDate()){
        //昨天
        return "昨天 " + date.format("HH:mm");
    }else if(currentDay.getFullYear()==date.getFullYear() && currentDay.getMonth() == date.getMonth() && (currentDay.getDate() - 2) == date.getDate()){
        //前天
        return "前天 " + date.format("HH:mm");
    }else if(currentDay.getFullYear()==date.getFullYear()){
        //今年
        return date.format("MM/dd HH:mm");
    }
    return date.format("yyyy/MM/dd HH:mm");
}

/*毫秒转换成时分秒
* type:1（平常的时间 冒号） ，2（语音单位符号）*/
function countTime(ms,type) {
    if(!ms || isNaN(ms)){
        return '';
    }
    var unit_h = ':',unit_m = ':',unit_s = '';
    if(type==2){
        unit_h = '\'',unit_m = '\'',unit_s = '\'\'';
    }
    var ss = 1000;
    var mi = ss * 60;
    var hh = mi * 60;
    var dd = hh * 24;

    var day = (ms / dd).toFixed(0);
    var hour = parseInt((ms - day * dd) / hh);
    var minute = parseInt((ms - day * dd - hour * hh) / mi);
    var second = parseInt((ms - day * dd - hour * hh - minute * mi) / ss);
    var milliSecond = parseInt(ms - day * dd - hour * hh - minute * mi - second * ss);

    var strDay = day < 10 ? "0" + day : "" + day; //天
    var strHour = hour < 10 ? "0" + hour : "" + hour;//小时
    var strMinute = minute < 10 ? "0" + minute : "" + minute;//分钟
    var strSecond = second < 10 ? "0" + second : "" + second;//秒
    var strMilliSecond = milliSecond < 10 ? "0" + milliSecond : "" + milliSecond;//毫秒
    strMilliSecond = milliSecond < 100 ? "0" + strMilliSecond : "" + strMilliSecond;
    if(type==2){
        //return (strHour==00)?(strMinute + unit_m + strSecond + unit_s):(strHour + unit_h + strMinute + unit_m + strSecond + unit_s);
        if(strHour==00 && strMinute==00){
            return (strSecond + unit_s);
        }else{
            return (strMinute + unit_m + strSecond + unit_s);
        }
    }
    return (strHour==00)?(strMinute + unit_m + strSecond):(strHour + unit_h + strMinute + unit_m + strSecond);
}

/*根据文件名称，返回后缀，不识别的后缀返回other*/
function getFileSuffix(fileName){
    if(!fileName)return;
    var suffixes = ["folder","txt","exe","dll","jpg","gif","bmp","png","rar","zip","iso",
        "doc","xls","ppt","docx","xlsx","pptx","mp3","wav","mid","wmv",
        "wma","avi","mpg","mkv","rmv","mp4","htm","html","pdf"];
    var suffix = (fileName.split(".").length==1)?"folder":(fileName.split(".")[fileName.split(".").length-1]);
    suffix = suffix.toLowerCase();
    var a = suffixes.indexOf(suffix);
    if(a>=0) return suffix;
    else return "other";
}

/*获取地址栏参数*/
function getUrlParamt(name){
    var reg = new RegExp("(^|&)"+ name +"=([^&]*)(&|$)");
    var r = window.location.search.substr(1).match(reg);
    if(r!=null)return  unescape(r[2]); return null;
}

/*去除html标签*/
function removeHTMLTag(str) {
    str = str.replace(/<\/?[^>]*>/g, ''); //去除HTML tag
    str = str.replace(/[ | ]*\n/g, ''); //去除行尾空白
    str = str.replace(/&nbsp;/ig, ''); //去掉尾部空格
    return str;
}

/*获取图片相对于外层元素的宽高*/
function countWidthHeightForDialog(sourceWidth,sourceHeight,dialogWidth,dialogHeight){
    if(sourceWidth <= dialogWidth && sourceHeight <= dialogHeight)
        return {"width":sourceWidth,"height":sourceHeight};
    var newWidth=3000,newHeight= 0;
    while(newWidth > dialogWidth || newHeight > dialogHeight){
        if(sourceWidth > dialogWidth){
            newWidth = dialogWidth;
            newHeight = sourceHeight/sourceWidth * newWidth;
        }else if(sourceHeight > dialogHeight){
            newHeight = dialogHeight;
            newWidth = sourceWidth/sourceHeight * newHeight;
        }
        sourceWidth = newWidth,sourceHeight = newHeight;
    }
    return {"width":parseInt(newWidth),"height":parseInt(newHeight)};
}

/*设置img的原始图片宽高
 * targ:img 元素节点*/
function setImgAttr(targ){
    var img = new Image();
    img.src = targ.attr("src");
    img.onload = function(){
        // 打印
        targ.attr("data-swidth",img.width);
        targ.attr("data-sheight",img.height);
    };
}

/* 容量单位转换
 * size:容量大小
 * initUnit:初始单位
 * decimals:保留小数点位数
 * targetUnit:转换后的单位*/
function parseFileSize(size, initUnit, decimals, targetUnit) {
    size = parseInt(size);
    var units = ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB'];
    var initUnitIndex = units.indexOf(initUnit);
    while(size>=1024){
        size = size / 1024;
        ++initUnitIndex;
        if(units[initUnitIndex]==targetUnit)break;
    }
    return (size.toFixed(decimals)+" "+units[initUnitIndex]);
}

/*获取浏览器版本*/
function browerVersion(){
    var u = navigator.userAgent,app = navigator.appVersion;
    return {
        trident : u.indexOf('Trident') > -1, //IE内核
        presto : u.indexOf('Presto') > -1,//opera内核
        webKit : u.indexOf('AppleWebKit') > -1, //苹果、谷歌内核
        gecko : u.indexOf('Gecko') > -1 && u.indexOf('KHTML') == -1, //火狐内核
        mobile : !!u.match(/AppleWebKit.*Mobile.*/) || !!u.match(/AppleWebKit/),//是否为移动终端
        ios : !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/), //ios终端
        android : u.indexOf('Android') > -1 || u.indexOf('Linux') > -1, //android终端或者uc浏览器
        iPhone : u.indexOf('iPhone') > -1 || u.indexOf('Mac') > -1, //是否为iPhone或者QQHD浏览器
        iPad : u.indexOf('iPad') > -1, //是否iPad
        webApp : u.indexOf('Safari') == -1, //是否web应该程序，没有头部与底部
        linux : u.indexOf('linux') > -1, //加mobile和这个属性一起，可以判断uc浏览器
        wp7 : (u.indexOf('WP7') > -1) || (u.indexOf('Windows Phone OS') > -1)//trident IE内核 并且包含WP7标示 windows phone7手机
    };
}

/*随机获取颜色*/
function getRandomColor(){
    return  '#' +
        (function(color){
            return (color +=  '0123456789abcdef'[Math.floor(Math.random()*15)])
                && (color.length == 6) ?  color : arguments.callee(color);
        })('');
}

/*字符串 过滤小括号，中文括号、数字、下划线、减号、小数点号，并截取倒数2位*/
function cutName(name){
    name = name.replace(/[\d()（）._-]*/ig,'');
    return (name.substr(name.length - 2 , 2));
}

/*选中全部文本
* target:jquery选择器*/
function selectAllText(target) {
    if(!target)return;
    selectElement(target);
    function selectElement(target){
        if (document.selection) {
            var range = document.body.createTextRange();
            range.moveToElementText(target[0]);
            range.select();
        } else if (window.getSelection) {
            var range = document.createRange();
            range.selectNode(target[0]);
            var selection = window.getSelection();
            selection.setAnchorNode = null;
            selection.removeAllRanges();
            selection.addRange(range);
        }
    }
}

/**
 * 清除所有选中状态
 */
function clearAllSeletion () {
    if ("getSelection" in window) {
        window.getSelection().removeAllRanges();
    } else {
        document.selection.empty();
    }
    $('img').removeClass('img-select');
}

/*验证网址*/
function matchUrl(str_url){
    var strRegex = "^((https|http|ftp|rtsp|mms|file)://)"
        + "(([0-9a-z_!~*'().&=+$%-]+: )?[0-9a-z_!~*'().&=+$%-]+@)?" //ftp的user@
        + "(([0-9]{1,3}\.){3}[0-9]{1,3}" // ip形式的url- 199.194.52.184
        + "|" // 允许ip和domain（域名）
        + "([0-9a-z_!~*'()-]+\.)*" // 域名- www.
        + "([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\." // 二级域名
        + "[a-z]{2,6})" // first level domain- .com or .museum
        + "(:[0-9]{1,4})?" // 端口- :80
        + "((/?)|" // a slash isn't required if there is no file name
        + "(/[0-9a-zA-Z_!~*'().;?:@&=+$,%#-]+)+/?)$";
    var re=new RegExp(strRegex);
    if (re.test(str_url)){
        return true;
    }else{
        return false;
    }
}

//匹配并替换字符串中的超链接标签
function matchReplaceAtable(str){
    if(!str)return '';

    str = str.replace(/&/g,'&amp;');
    str = str.replace(/</g,'&lt;');
    str = str.replace(/>/g,'&gt;');
    str = str.replace(/ /g,"\f");//替换所有空格符为翻页符(\f)

    var strRegex = "";

    // var urlReg = "((https|http|ftp|rtsp|mms|file)://)?" +
    //     "(" +
    //     "(([0-9a-z_!~*'().&=+$%-]+:)([0-9a-z_!~*'().&=+$%-]+@))|" + //ftp的user@
    //     "((([0-9]{1,3}\\.){3}[0-9]{1,3})|(localhost))(:[0-9]{1,4})?|" + //ip形式
    //     //"([wW]{3}\\.)?([0-9a-zA-Z]+\\.)+[a-z]{2,6}" + //域名 + 二级域名
    //     "([wW]{3}\\.)?" +//域名
    //     "([0-9a-zA-Z-]+\\.)+" +//网站名称
    //     "(com|cn|edu|gov|mil|net|org|biz|info|name|museum|us|ca|uk|fr|de|me|pro)" + //二级域名
    //     ")" +
    //     // "[_a-zA-Z0-9:/?.%@&-=#~]*";
    //     "[_a-zA-Z0-9/?.%@;&=#~-]*";

    var urlReg = "(https://|http://|ftp://|rtsp://|mms://|file://|www\\.)([!_a-zA-Z0-9/?.%@*:;&+=#~-]+)";
    var emailReg = "[a-zA-Z0-9-_.*]+@[a-zA-Z0-9-_.*]+";//邮箱匹配
    // var phoneReg = "(13|14|15|17|18)\\d{1}(\\s|-)?\\d{4}(\\s|-)?\\d{4}"; // 手机号
    // var phoneReg = "(0\\d{2,3}(\\s|-)?)?\\d{8}"; // 固话匹配
    // var phoneReg = '(((13|14|15|17|18)\\d{1}(\\s|-)?\\d{4}(\\s|-)?\\d{4})|(0\\d{2,3}(\\s|-)?\\d{4}(\\s|-)?\\d{4}))';
    var phoneReg = '((13|14|15|17|18)\\d{1}(\\s|-)?\\d{4}(\\s|-)?\\d{4})|((0\\d{2,3}(\\s|-)?)?\\d{8})';
    var bankReg = "(\\d{19}|\\d{16})";
    //url链接匹配
    strRegex = "("+urlReg+")|" +
        "("+emailReg+")|" +//邮箱
        "("+phoneReg+")|" +//手机、固话
        "("+bankReg+")";//银行卡号
    strRegex = new RegExp(strRegex,'g');
    str = str.replace(strRegex,function(word){
        if(new RegExp(emailReg,'g').test(word)){
            return "<a class='email' href='mailto:"+word+"'>"+word+"</a>";
        }else if(new RegExp(urlReg,'g').test(word)){
            var regstr = "(https|http|ftp|rtsp|mms|file)";
            var index = word.search(regstr);
            var hef = word;
            if(index!==0){hef = "http://" + hef;}//没有前缀的时候默认添加http://前缀
            return "<a target='_blank' href='"+hef+"'>"+word+"</a>";
        }else if(new RegExp(phoneReg,'g').test(word)){
            return "<a class='phone' href='javascript:void(0)'>"+word+"</a>";
        }else if(new RegExp(bankReg,'g').test(word)){
            return "<a class='bank' href='javascript:void(0)'>"+word+"</a>";
        }
    });

    str = str.replace(/\n/g,"<br/>");
    str = str.replace(/\f/g,"&nbsp;");//替换所有翻页符为空格
    str = str.replace(/\t/g,"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");//替换制表符，1个制表符等于8个空格;
    return str;
}


//将一个数字转化成16进制字符串形式
function toHex(num){
    num = parseInt(num);
    return num<16?"0x0"+num.toString(16).toUpperCase():"0x"+num.toString(16).toUpperCase();
}

//高亮显示搜索文字
function lightSearchText(str, search){
    if(!str)return "";
    if(!search)return str;
    str = str.replace(search,function(word){
        var html = '<label style="color: red;">'+word+'</label>';
        return html
    })
    return str;
}