﻿/**
 * 渲染层-动态构造html
 */

// 处理点击查看更多消息事件
function onShowMoreHistoryMsg() {
	// C++代码尚未执行时, 不允许重复调用当前函数
	if(this.time)
		return;
	insertViewMoreLoadHtml();
	// 延迟显示数据
	this.time = setTimeout(function() {
		// 调用C++代码读取更多消息
		window.external.showMoreHisotry();
		this.time = null;
	}, 500);

}

/*插入查看更多加载动画
* type:delete(删除查看更多消息按钮)，其他 则插入查看更多消息按钮*/
function insertViewMoreLoadHtml(type){
    if(type=='delete'){
        $('.more.voice-load').remove();
        return;
    }
    insertViewMoreMessageHtml('delete');
    var html = '<i class="bgicon more voice-load"></i>';
    $('.more.voice-load').remove();
    $('.message-wrapper .message-container').prepend(html);
}

/*插入查看更多消息的HTML
* type:delete(删除查看更多消息按钮)，其他 则插入查看更多消息按钮*/
function insertViewMoreMessageHtml(type,content){
    if(type=='delete'){
        $('button.viewMore').remove();
        return;
    }
    if(!content){
        content = '查看更多消息';
    }
    insertViewMoreLoadHtml('delete');
    var html = '<button class="bgicon viewMore margin cancelSelect">'+content+'</button>';
    $('button.viewMore').remove();
    $('.message-wrapper .message-container').prepend(html);

}

/*插入以上是历史消息的HTML
* type:delete(删除以上是历史消息)，其他 则插入以上是历史消息*/
function insertHistoryHtml(type,content){
    if(type=='delete'){
        $('div.history-line').remove();
        return;
    }
    if($('div.history-line').length>0){
        return;
    }
    if(!content){
        content = '以上是历史消息';
    }
    var html = '<div class="history-line col1 cancelSelect"><i class="line"></i><span>'+content+'</span><i class="line"></i></div>';
    $('.message-wrapper .message-container').prepend(html);

}

/*插入时间消息的HTML
* type:消息类型（1：即时消息-默认，2：历史消息）
* msg_type: 1、表示历史记录，2、表示搜索记录，3、表示没有任何记录
*/
function insertTimeHtml(messageInfo,type){
    if(!messageInfo)return;
    var disTime = 60*1000;//间隔时间1分钟
    var timeStr = '';
    timeStr = dateToString(messageInfo.time);
    var html = '<span class="time margin col1" data-time="'+messageInfo.time+'">'+timeStr+'</span>';
    if(msg_type == 1){
        html = '<span class="time margin col1" data-time="'+messageInfo.time+'">'+timeStr+'</span>';
    }else if(msg_type == 2){
        html = '<span class="time margin col1" data-time="'+messageInfo.time+'">'+timeStr+'<a class="viewContext">查看前后消息</a></span>';
    }
    if(type==2){
        //判断发送时间间隔大于1分钟，则插入时间
        var firstMessage = $('.message-wrapper .message-container').find('*[data-time]').eq(1);
        var dt = firstMessage.attr('data-time');
        // if((msg_type == 1 || msg_type == 2) || (!dt || (dt - messageInfo.time > disTime))){
        if(!msg_type) {
            $('.message-wrapper .message-container').prepend(html);
        }else if((msg_type == 1 || msg_type == 2) || dt){
            $('.message-wrapper .message-container').prepend(html);
        }
    }else{
        //判断发送时间间隔大于1分钟，则插入时间
        var historyMessage = $('.message-wrapper .message-container').find('.history-line');
        var lastMessage = $('.message-wrapper .message-container').find('*[data-time]:last');
        var dt = lastMessage.attr('data-time');
        if(msg_type == 1 || msg_type == 2){
            $('.message-wrapper .message-container').append(html);
        }else if(historyMessage.length>0 && historyMessage.next().length==0){
            $('.message-wrapper .message-container').append(html);
        }else if(!dt || (messageInfo.time - dt > disTime)){
            $('.message-wrapper .message-container').append(html);
        }
    }

}

/*插入发送抖动窗口消息的HTML
 type:消息类型（1：即时消息-默认，2：历史消息）
 * messageInfo:单条消息对象
 * messageInfo 对象含参数
 * id - 消息id,
 * time - 消息发送时间，长整形,
 * content - 消息内容,
 * ismyself - 发送人是否是我自己（1：是、2：否）,
 * name - 发送人名称,
 */
function insertShakeWindownMessageHtml(messageInfo,type){
    if(!messageInfo)return;
    var spos = getScrollPos();
    messageInfo = JSON.parse(messageInfo);
    messageInfo.time = messageInfo.time * 1000;
    var html = '<div id="'+messageInfo.id+'" class="center-message margin '+(messageInfo.ismyself==1?"myself":"")+'" data-time="'+messageInfo.time+'">' +
        '<i class="bgicon success"></i>' +
        '<aside>'+messageInfo.content+'</aside>' +
        '</div>';
    if(type==2){
        $('.message-wrapper .message-container').prepend(html);
        insertTimeHtml(messageInfo,type);
    }else{
        insertTimeHtml(messageInfo);
        $('.message-wrapper .message-container').append(html);
    }

    if(type==1 && (messageInfo.ismyself==1 || (messageInfo.ismyself==2 && spos=='end'))){
    //if((messageInfo.ismyself==1 && type==1) || (messageInfo.ismyself==2 && spos=='end')){
        scrollTo('bottom');
    }else if(type==1 && (messageInfo.ismyself==2 && spos!='null')){
        messageInfo.butmContent = '发送一个窗口抖动';
        insertBottomMessageHtml(messageInfo);
    }
}

/*插入自定义内容的居中消息的HTML
 * type:消息类型（1：即时消息-默认，2：历史消息）
 * subType:（1：安全设置太高无法接收文件）
 * messageInfo:单条消息对象
 * messageInfo 对象含参数
 * id - 消息id,
 * time - 消息发送时间，长整形,
 * state - 左边图标类型 1(success)-默认,2(plaint) ,3(faile)
 * content - 消息内容,
 * ismyself - 发送人是否是我自己（1：是、2：否）,
 * name - 发送人名称,
 */
function insertCenterMessage(messageInfo,type,subType){
    if(!messageInfo)return;
    var spos = getScrollPos();
    messageInfo = JSON.parse(messageInfo);
    messageInfo.time = messageInfo.time * 1000;
    if(messageInfo.state==2){
        messageInfo.state = 'plaint';
    }else if(messageInfo.state==3){
        messageInfo.state = 'faile';
    }else{
        messageInfo.state = 'success';
    }
    if(subType && subType==1){
        messageInfo.content = '对方尝试向您发送' + messageInfo.content + '，当前传文件安全设置的级别无法接收该文件。文件传输请求被拒绝。<a href="javascript:void(0);" onclick="alert(1)">安全设置</a>';
    }
    var html = '<div id="'+messageInfo.id+'" class="center-message margin myself" data-time="'+messageInfo.time+'">' +
        '<i class="bgicon '+messageInfo.state+'"></i>' +
        '<aside>'+messageInfo.content+'</aside>' +
        '</div>';

    if($('#'+messageInfo.id).length>0){
        //修改
        $('#'+messageInfo.id).replaceWith(html);

    }else{
        //新增
        if(type==2){
            $('.message-wrapper .message-container').prepend(html);
            insertTimeHtml(messageInfo,type);
        }else{
            insertTimeHtml(messageInfo);
            $('.message-wrapper .message-container').append(html);
        }

        if(type==1 && (messageInfo.ismyself==1 || (messageInfo.ismyself==2 && spos=='end'))){
        //if((messageInfo.ismyself==1 && type==1) || (messageInfo.ismyself==2 && spos=='end')){
            scrollTo('bottom');
        }else if(type==1 && (messageInfo.ismyself==2 && spos!='null')){
            messageInfo.butmContent = messageInfo.content;
            insertBottomMessageHtml(messageInfo);
        }
    }

}


/*插入聊天消息的HTML
* messageInfo:单条消息对象
* type:消息类型（1：即时消息-默认，2：历史消息）
* messageInfo 对象含参数
* id - 消息id,
* time - 消息发送时间，长整形,
* state - 消息状态（1：成功、2：失败、3：未读、4：视频通话已取消、5：视频通话未接听、6：对方未接听通话、7：正在加载）,
* reason - 消息发送失败原因
* content - 消息内容,
* ismyself - 发送人是否是我自己（1：是、2：否）,
* isgroup - 是否群组消息（1：是、2：否）,
* headUrl - 发送人头像,
* name - 发送人名称,
* accNbr - 发送人账号,
* sex - 发送人性别（1：男、2：女）,
*/
function insertMessageHtml(messageInfo,type){
    if(!messageInfo)return;
	//console.log(messageInfo);
    var spos = getScrollPos();
    messageInfo = JSON.parse(messageInfo);
    messageInfo.time = messageInfo.time * 1000;
    messageInfo.reason = '发送失败，点击重新发送';
	messageInfo.type = type;
    var contentObj = parseMessageContent(messageInfo.content);
    var html = '<div id="'+messageInfo.id+'" data-time="'+messageInfo.time+'" data-accNbr="'+messageInfo.accNbr+'" class="message margin '+(messageInfo.ismyself==1?"myself":"")+'">' +
        '<img class="headPic cancelSelect" width="30px" height="30px" src="'+messageInfo.headUrl+'">' +
        ((messageInfo.isgroup==1&&messageInfo.ismyself!=1)?('<span class="name">'+messageInfo.name+'</span>'):"") +
        '<section class="content-wrap">' +
        '<i class="bgicon sharp"></i>' +
        (messageInfo.state==2?('<i class="bgicon result plaint red" data-reason="'+messageInfo.reason+'"></i>'):
            (messageInfo.state==7?'<i class="bgicon result plaint voice-load"></i>':'')) +
        '<font style="'+contentObj.css+'">'+contentObj.content+'</font>' +
        '</section>' +
        '</div>';

    if($('#'+messageInfo.id).length>0){
        //修改
        var _lastid = $(".message-container>div").last().attr('id');
        $('#'+messageInfo.id).replaceWith(html);
        $('#'+messageInfo.id).data('message',messageInfo);
    }else{
        if(type==2){
            $('.message-wrapper .message-container').prepend(html);
            insertTimeHtml(messageInfo,type);
        }else{
            insertTimeHtml(messageInfo);
            $('.message-wrapper .message-container').append(html);
        }
        $('#'+messageInfo.id).data('message',messageInfo);
        if(type==1 && (messageInfo.ismyself==1 || (messageInfo.ismyself==2 && spos=='end'))){
            setTimeout(function(){scrollTo('bottom');},50);
        }else if(type==1 && (messageInfo.ismyself==2 && spos!='null')){
            messageInfo.butmContent = contentObj.butmContent;
            insertBottomMessageHtml(messageInfo);
        }
    }
//	if(spos=='end')
//		setTimeout(function(){scrollTo('bottom');},1);
    if(messageInfo.id == msg_id){
        $("#" + msg_id).addClass("light");
    }
}

/*插入动态表情聊天消息的HTML
 * messageInfo:单条消息对象
 * type:消息类型（1：即时消息-默认，2：历史消息）
 * messageInfo 对象含参数
 * id - 消息id,
 * time - 消息发送时间，长整形,
 * state - 消息状态（1：成功、2：失败、3：未读、4：视频通话已取消、5：视频通话未接听、6：对方未接听通话）,
 * reason - 消息发送失败原因
 * content - 消息内容,
 * ismyself - 发送人是否是我自己（1：是、2：否）,
 * isgroup - 是否群组消息（1：是、2：否）,
 * headUrl - 发送人头像,
 * name - 发送人名称,
 * accNbr - 发送人账号,
 * sex - 发送人性别（1：男、2：女）,
 */
function insertDynamicFaceMessageHtml(messageInfo,type){
    if(!messageInfo)return;
    var spos = getScrollPos();
    messageInfo = JSON.parse(messageInfo);
    messageInfo.time = messageInfo.time * 1000;
    var contentObj = parseMessageContent(messageInfo.content);
    var html = '<div id="'+messageInfo.id+'" data-time="'+messageInfo.time+'" data-accNbr="'+messageInfo.accNbr+'" class="message margin '+(messageInfo.ismyself==1?"myself":"")+'">' +
        '<img class="headPic cancelSelect" width="30px" height="30px" src="'+messageInfo.headUrl+'">' +
        ((messageInfo.isgroup==1&&messageInfo.ismyself!=1)?('<span class="name">'+messageInfo.name+'</span>'):"") +
        '<section class="content-wrap transparent">' +
        '<i class="bgicon sharp"></i>' + (messageInfo.state==2?('<i class="bgicon result plaint red" data-reason="'+messageInfo.reason+'"></i>'):"") +
        '<font style="'+contentObj.css+'">'+contentObj.content+'</font>' +
        '</section>' +
        '</div>';

    if($('#'+messageInfo.id).length>0){
        //修改
        $('#'+messageInfo.id).replaceWith(html);

    }else{
        if(type==2){
            $('.message-wrapper .message-container').prepend(html);
            insertTimeHtml(messageInfo,type);
        }else{
            insertTimeHtml(messageInfo);
            $('.message-wrapper .message-container').append(html);
        }

        if(type==1 && (messageInfo.ismyself==1 || (messageInfo.ismyself==2 && spos=='end'))){
            //if((messageInfo.ismyself==1 && type==1) || (messageInfo.ismyself==2 && spos=='end')){
            scrollTo('bottom');
        }else if(type==1 && (messageInfo.ismyself==2 && spos!='null')){
            messageInfo.butmContent = contentObj.butmContent;
            insertBottomMessageHtml(messageInfo);
        }
    }

}

/*插入语音消息的HTML
 * messageInfo:单条消息对象
 * type:消息类型（1：即时消息-默认，2：历史消息）
 * messageInfo 对象含参数
 * id - 消息id,
 * time - 消息发送时间，长整形,
 * state - 消息状态（1：成功、2：失败、3：未读、4、正在播放、5：正在加载）,
 * reason - 消息发送失败原因
 * content - 消息内容,
 * ismyself - 发送人是否是我自己（1：是、2：否）,
 * isgroup - 是否群组消息（1：是、2：否）,
 * headUrl - 发送人头像,
 * name - 发送人名称,
 * accNbr - 发送人账号,
 * sex - 发送人性别（1：男、2：女）,
 */
function insertVoiceMessageHtml(messageInfo,type){
    if(!messageInfo)return;
    var spos = getScrollPos();
    messageInfo = JSON.parse(messageInfo);
    var html = '';
    if($('#'+messageInfo.id).length>0){
        //修改
        var target = $('#'+messageInfo.id);
        html = '<i class="bgicon result'+(messageInfo.state==2?" plaint red":(messageInfo.state==3?" unread":(messageInfo.state==5?" voice-load":"")))+'" data-reason="'+messageInfo.reason?messageInfo.reason:''+'"></i>';
        target.find('.content-wrap>.result').replaceWith(html);
        target = target.find('.content-wrap>font>i.voice');
        html = '<i class="bgicon voice'+(messageInfo.state==4?" play":"")+'" data-url="'+messageInfo.content[0]+'" data-state="'+messageInfo.state+'"></i>';
        target.replaceWith(html);
    }else{
        messageInfo.time = messageInfo.time * 1000;
        var fontHtml = '';
        if(messageInfo.ismyself==1){
            //是我自己发送的
            fontHtml = '<font>' +
                '<label class="f"></label>' +
                '<i class="bgicon voice'+(messageInfo.state==4?" play":"")+'" data-url="'+messageInfo.content[0]+'" data-state="'+messageInfo.state+'"></i>' +
                '<label class="t">'+countTime(messageInfo.content[1],2)+'</label>' +
                '</font>';
        }else{
            //不是我自己发送的
            fontHtml = '<font>' +
                '<label class="t">'+countTime(messageInfo.content[1],2)+'</label>' +
                '<i class="bgicon voice'+(messageInfo.state==4?" play":"")+'" data-url="'+messageInfo.content[0]+'" data-state="'+messageInfo.state+'"></i>' +
                '<label class="f"></label>' +
                '</font>';
        }

        html = '<div id="'+messageInfo.id+'" data-time="'+messageInfo.time+'" data-accNbr="'+messageInfo.accNbr+'" class="message margin '+(messageInfo.ismyself==1?"myself":"")+'">' +
            '<img class="headPic cancelSelect" width="30px" height="30px" src="'+messageInfo.headUrl+'">' +
            ((messageInfo.isgroup==1&&messageInfo.ismyself!=1)?('<span class="name">'+messageInfo.name+'</span>'):"") +
            '<section class="content-wrap">' +
            '<i class="bgicon sharp"></i>' +
            '<i class="bgicon result'+(messageInfo.state==2?" plaint red":(messageInfo.state==3?" unread":(messageInfo.state==5?" voice-load":"")))+'" data-reason="'+messageInfo.reason+'"></i>' +//voice-load
            fontHtml +
            '</section>' +
            '</div>';

        // if(type==2){
        //     $('.message-wrapper .message-container').prepend(html);
        //     insertTimeHtml(messageInfo),type;
        // }else{
        //     $('.message-wrapper .message-container').append(html);
        //     insertTimeHtml(messageInfo);
        // }

        if(type==2){
            $('.message-wrapper .message-container').prepend(html);
            insertTimeHtml(messageInfo,type);
        }else{
            insertTimeHtml(messageInfo);
            $('.message-wrapper .message-container').append(html);
        }

        if(type==1 && (messageInfo.ismyself==1 || (messageInfo.ismyself==2 && spos=='end'))){
            scrollTo('bottom');
        }else if(type==1 && (messageInfo.ismyself==2 && spos!='null')){
            messageInfo.butmContent = '给您发送了一个语音消息';
            insertBottomMessageHtml(messageInfo);
        }
    }
}
//修改正在播放的语音消息为正常状态，状态1
function stopVoice(){
    $('.message-wrapper .message-container>.message>.content-wrap i.voice.play').removeClass('play').attr('data-state',1);
}
/*插入视频通话消息的HTML
 * messageInfo:单条消息对象
 * type:消息类型（1：即时消息-默认，2：历史消息）
 * messageInfo 对象含参数
 * id - 消息id,
 * time - 消息发送时间，长整形,
 * state(属性已删除) - 消息状态（1：成功、2：失败、3：未读、4：视频通话已取消、5：视频通话未接听、6：对方未接听通话）,
 * redmark - 红点标记（true: 有红点标记， false: 没有红点标记）
 * reason - 消息发送失败原因
 * content - 消息内容,
 * ismyself - 发送人是否是我自己（1：是、2：否）,
 * isgroup - 是否群组消息（1：是、2：否）,
 * headUrl - 发送人头像,
 * name - 发送人名称,
 * accNbr - 发送人账号,
 * sex - 发送人性别（1：男、2：女）,
 */
function insertVideoCallMessageHtml(messageInfo,type){
    if(!messageInfo)return;
    var spos = getScrollPos();
    messageInfo = JSON.parse(messageInfo);
    messageInfo.time = messageInfo.time * 1000;
    // var h = '';
    // if(messageInfo.state==4){
    //     h = '<font><i class="bgicon video"></i>视频通话已经取消</font>'
    // }else if(messageInfo.state==5){
    //     h = '<font style="color: red;"><i class="bgicon video red"></i>视频通话未接听</font>'
    // }else if(messageInfo.state==6){
    //     h = '<font><i class="bgicon video"></i>对方未接听通话</font>'
    // }else{
    //     h = '<font><i class="bgicon video gray"></i>通话时长 '+countTime(messageInfo.content)+'</font>'
    // }
    var h = '<font><i class="bgicon video"></i>'+(messageInfo.content)+'</font>';

    var html = '<div id="'+messageInfo.id+'" data-time="'+messageInfo.time+'" data-accNbr="'+messageInfo.accNbr+'" class="message margin '+(messageInfo.ismyself==1?"myself":"")+'">' +
        '<img class="headPic cancelSelect" width="30px" height="30px" src="'+messageInfo.headUrl+'">' +
        ((messageInfo.isgroup==1&&messageInfo.ismyself!=1)?('<span class="name">'+messageInfo.name+'</span>'):"") +
        '<section class="content-wrap">' +
        '<i class="bgicon sharp"></i>' +
        (type==1&&messageInfo.redmark?('<i class="bgicon result redmark"></i>'):'')
        + h +
        '</section>' +
        '</div>';

    if(type==2){
        $('.message-wrapper .message-container').prepend(html);
        insertTimeHtml(messageInfo,type);
    }else{
        insertTimeHtml(messageInfo);
        $('.message-wrapper .message-container').append(html);
    }


    if(type==1 && (messageInfo.ismyself==1 || (messageInfo.ismyself==2 && spos=='end'))){
        //if((messageInfo.ismyself==1 && type==1) || (messageInfo.ismyself==2 && spos=='end')){
        scrollTo('bottom');
    }else if(type==1 && (messageInfo.ismyself==2 && spos!='null')){
        messageInfo.butmContent = '给您发送了一个视频通话消息';
        insertBottomMessageHtml(messageInfo);
    }
}

/*修改视频通话消息
* id:消息id
* type:1(点击回拨)，2(还原)*/
function updateVideoCallMessageHtml(id,type){
    var message = $('.message-wrapper .message-container').find('#'+id);
    var html = '<i class="bgicon video"></i>点击回拨';
    if(type==2){
        html = message.find('.content-wrap>font').data('srcHtml');
        message.find('.content-wrap>font').css({'color':'#232323','cursor':'inherit'}).html(html);
    }else{
        var srcHtml = message.find('.content-wrap>font').html();
        message.find('.content-wrap>font').css({'color':'#2e9bff','cursor':'pointer'}).html(html);
        html = message.find('.content-wrap>font').data('srcHtml');
        if(!html) message.find('.content-wrap>font').data('srcHtml',srcHtml);
    }
}

/*插入语音通话消息的HTML
 * messageInfo:单条消息对象
 * type:消息类型（1：即时消息-默认，2：历史消息）
 * messageInfo 对象含参数
 * id - 消息id,
 * time - 消息发送时间，长整形,
 * state - 消息状态（1：成功、2：失败、3：未读、4：语音通话已取消、5：语音通话未接听、6：对方未接听语音通话）,
 * redmark - 红点标记（true: 有红点标记， false: 没有红点标记）
 * reason - 消息发送失败原因
 * content - 消息内容,
 * ismyself - 发送人是否是我自己（1：是、2：否）,
 * isgroup - 是否群组消息（1：是、2：否）,
 * headUrl - 发送人头像,
 * name - 发送人名称,
 * accNbr - 发送人账号,
 * sex - 发送人性别（1：男、2：女）,
 */
function insertVoiceCallMessageHtml(messageInfo,type){
    if(!messageInfo)return;
    var spos = getScrollPos();
    messageInfo = JSON.parse(messageInfo);
    messageInfo.time = messageInfo.time * 1000;
    // var h = '';
    // if(messageInfo.state==4){
    //     h = '<font><i class="bgicon tel"></i>语音通话已经取消</font>'
    // }else if(messageInfo.state==5){
    //     h = '<font style="color: red;"><i class="bgicon tel red"></i>语音通话未接听</font>'
    // }else if(messageInfo.state==6){
    //     h = '<font><i class="bgicon tel"></i>对方未接听通话</font>'
    // }else{
    //     h = '<font><i class="bgicon tel gray"></i>通话时长 '+countTime(messageInfo.content)+'</font>'
    // }
    var h = '<font><i class="bgicon tel"></i>' + (messageInfo.content) + '</font>';
    var html = '<div id="'+messageInfo.id+'" data-time="'+messageInfo.time+'" data-accNbr="'+messageInfo.accNbr+'" class="message margin '+(messageInfo.ismyself==1?"myself":"")+'">' +
        '<img class="headPic cancelSelect" width="30px" height="30px" src="'+messageInfo.headUrl+'">' +
        ((messageInfo.isgroup==1&&messageInfo.ismyself!=1)?('<span class="name">'+messageInfo.name+'</span>'):"") +
        '<section class="content-wrap">' +
        '<i class="bgicon sharp"></i>' +
        (type==1&&messageInfo.redmark?('<i class="bgicon result redmark"></i>'):'')
         + h +
        '</section>' +
        '</div>';

    if(type==2){
        $('.message-wrapper .message-container').prepend(html);
        insertTimeHtml(messageInfo,type);
    }else{
        insertTimeHtml(messageInfo);
        $('.message-wrapper .message-container').append(html);
    }

    if(type==1 && (messageInfo.ismyself==1 || (messageInfo.ismyself==2 && spos=='end'))){
        //if((messageInfo.ismyself==1 && type==1) || (messageInfo.ismyself==2 && spos=='end')){
        scrollTo('bottom');
    }else if(type==1 && (messageInfo.ismyself==2 && spos!='null')){
        messageInfo.butmContent = '给您发送了一个语音通话消息';
        insertBottomMessageHtml(messageInfo);
    }
}

/*修改语音通话消息
 * id:消息id
 * type:1(改成发起视频通话)，2(还原)*/
function updateVoiceCallMessageHtml(id,type){
    var message = $('.message-wrapper .message-container').find('#'+id);
    var html = '<i class="bgicon tel"></i>点击回拨';
    if(type==2){
        html = message.find('.content-wrap>font').data('srcHtml');
        message.find('.content-wrap').css('cursor','default');
        message.find('.content-wrap>font').css('color','#232323').html(html);
    }else{
        var srcHtml = message.find('.content-wrap>font').html();
        message.find('.content-wrap').css('cursor','pointer');
        message.find('.content-wrap>font').css('color','#2e9bff').html(html);
        html = message.find('.content-wrap>font').data('srcHtml');
        if(!html) message.find('.content-wrap>font').data('srcHtml',srcHtml);
    }

}

/*插入位置消息的HTML
 * messageInfo:单条消息对象
 * type:消息类型（1：即时消息-默认，2：历史消息）
 * messageInfo 对象含参数
 * id - 消息id,
 * time - 消息发送时间，长整形,
 * state - 消息状态（1：成功、2：失败、3：未读、4：视频通话已取消、5：视频通话未接听、6：对方未接听通话）,
 * reason - 消息发送失败原因
 * content - 消息内容,
 * ismyself - 发送人是否是我自己（1：是、2：否）,
 * isgroup - 是否群组消息（1：是、2：否）,
 * headUrl - 发送人头像,
 * name - 发送人名称,
 * accNbr - 发送人账号,
 * sex - 发送人性别（1：男、2：女）,
 */
function insertPositionMessageHtml(messageInfo,type){
    if(!messageInfo)return;
    var spos = getScrollPos();
    messageInfo = JSON.parse(messageInfo);
    messageInfo.time = messageInfo.time * 1000;
    var html = '<div id="'+messageInfo.id+'" data-time="'+messageInfo.time+'" data-accNbr="'+messageInfo.accNbr+'" class="message margin '+(messageInfo.ismyself==1?"myself":"")+'">' +
        '<img class="headPic cancelSelect" width="30px" height="30px" src="'+messageInfo.headUrl+'">' +
        ((messageInfo.isgroup==1&&messageInfo.ismyself!=1)?('<span class="name">'+messageInfo.name+'</span>'):"") +
        '<section class="content-wrap border systemMessage posMessage">' +
        '<i class="bgicon sharp"></i>' +
        '<article>' +
        '<img class="pic post" src="./resources/img/position/def.png" width="40" height="40">' +
        '<div>' +
        '<h4 class="ellipsisHide">'+messageInfo.content[0]+'</h4>' +
        '<h4 class="ellipsisHide" title="'+messageInfo.content[1]+'">'+messageInfo.content[1]+'</h4>' +
        '</div>' +
        '</article>' +
        '<article class="footer">' +
        '<a class="openPosition">打开</a>' +
//        '<a class="collect">收藏</a>' +
        '</article>' +
        '</section>' +
        '</div>';

    if($('#'+messageInfo.id).length>0){
        //修改
        $('#'+messageInfo.id).replaceWith(html);
        $('#'+messageInfo.id).data('message',messageInfo);

    }else{
        if(type==2){
            $('.message-wrapper .message-container').prepend(html);
            insertTimeHtml(messageInfo,type);
        }else{
            insertTimeHtml(messageInfo);
            $('.message-wrapper .message-container').append(html);
        }
        $('#'+messageInfo.id).data('message',messageInfo);

        if(type==1 && (messageInfo.ismyself==1 || (messageInfo.ismyself==2 && spos=='end'))){
            //if((messageInfo.ismyself==1 && type==1) || (messageInfo.ismyself==2 && spos=='end')){
            scrollTo('bottom');
        }else if(type==1 && (messageInfo.ismyself==2 && spos!='null')){
            messageInfo.butmContent = '[位置]'+messageInfo.content[1];
            insertBottomMessageHtml(messageInfo);
        }
    }

}

/*插入文件接收消息
 * messageInfo:单条消息对象
 * type:消息类型（1：即时消息-默认，2：历史消息）
 * subType:消息类型（1：标记漫游消息）
 * messageInfo 对象含参数
 * id - 消息id,
 * time - 消息发送时间，长整形,
 * state - 消息状态（1：成功、2：失败、3：未读、4：视频通话已取消、5：视频通话未接听、6：对方未接听通话）,
 * fileState - 文件状态（1：成功、2：失败）
 * reason - 消息发送失败原因
 * content - 消息内容,
 * ismyself - 发送人是否是我自己（1：是、2：否）,
 * isgroup - 是否群组消息（1：是、2：否）,
 * headUrl - 发送人头像,
 * name - 发送人名称,
 * accNbr - 发送人账号,
 * sex - 发送人性别（1：男、2：女）,
 */
function insertFileMessageHtml(messageInfo,type,subType){
    if(!messageInfo)return;
    var spos = getScrollPos();
    messageInfo = JSON.parse(messageInfo);
    messageInfo.time = messageInfo.time * 1000;
    //messageInfo.content[0] = '0411聊天界面-聊天记录_产品发布问题交流312*福州测试.png';
    //messageInfo.content[2] = '177.47KB';
    var fileNameTitle = messageInfo.content[0] + '(' + messageInfo.content[2] + ')';
    var fileName = '';
    var chrlen = fileNameTitle.replace(/[^\x00-\xff]/g,'**').length; // 字节长度
    var maxCharLen = 32;
    var slh = '...';
    if(chrlen>=maxCharLen){
        fileName = messageInfo.content[0];
        var suffix = fileName.split('.')[fileName.split('.').length-1];
        suffix = fileName.substr(fileName.indexOf(suffix)-3);
        suffix += '(' + messageInfo.content[2] + ')';
        var suffix_chrlen = suffix.replace(/[^\x00-\xff]/g,'**').length; // 字节长度
        var slh_chrlen = slh.replace(/[^\x00-\xff]/g,'**').length; // 字节长度
        fileName = fileNameTitle.replace(suffix,'');
        fileName = fileName.cutLength(maxCharLen - suffix_chrlen - slh_chrlen);
        fileName += slh + suffix;

    }else{
        fileName = fileNameTitle;
    }


    var content = messageInfo.content[1];
    var buttunStr = '<a class="copy" href="javascript:void(0)">复制</a><a class="openFolder" href="javascript:void(0)">打开文件夹</a><a class="open" href="javascript:void(0)">打开</a>';
    var errIconHtml = '';
    if(messageInfo.fileState==1){
        messageInfo.fileState = 'success';
        content = '<label class="path">'+messageInfo.content[1]+'</label>';
        if(subType && subType==1){
            buttunStr = '<a class="saveAs" href="javascript:void(0)">另存为</a>';
        }
    }else{
        messageInfo.fileState = 'faile';
        buttunStr = '<a class="saveAs" href="javascript:void(0)">另存为</a><a class="receiveAgain" href="javascript:void(0)">再次接收</a>';
    }
    if(messageInfo.state!=1){
        errIconHtml = '<i class="bgicon result plaint red" data-reason="'+messageInfo.reason+'"></i>'
    }
    var html = '<div id="'+messageInfo.id+'" data-time="'+messageInfo.time+'" data-accNbr="'+messageInfo.accNbr+'" class="message margin '+(messageInfo.ismyself==1?"myself":"")+'">' +
        '<img class="headPic cancelSelect" width="30px" height="30px" src="'+messageInfo.headUrl+'">' +
        ((messageInfo.isgroup==1&&messageInfo.ismyself!=1)?('<span class="name">'+messageInfo.name+'</span>'):"") +
        '<section class="content-wrap border systemMessage filesMessage">' +
        '<i class="bgicon sharp"></i>' +
        errIconHtml +
        '<article>' +
        '<i class="pic bgicon '+getFileSuffix(messageInfo.content[0])+'">' +
        '<i class="bgicon '+messageInfo.fileState+'"></i>' +
        '</i>' +
        '<div>' +
        '<h4 class="ellipsisHide" title="'+fileNameTitle+'">'+fileName+'</h4>' +
        '<h4 class="ellipsisHide" title="'+messageInfo.content[1]+'">'+content +
        '</div>' +
        '</article>' +
        '<article class="footer">' + buttunStr +
        //'<a href="#">复制</a><a href="#">打开文件夹</a><a href="#">打开</a>' +
        '</article>' +
        '</section>' +
        '</div>';

    if($('#'+messageInfo.id).length>0){
        //修改
        $('#'+messageInfo.id).replaceWith(html);
        $('#'+messageInfo.id).data('message',messageInfo);

    }else{
        if(type==2){
            $('.message-wrapper .message-container').prepend(html);
            insertTimeHtml(messageInfo,type);
        }else{
            insertTimeHtml(messageInfo);
            $('.message-wrapper .message-container').append(html);
        }
        $('#'+messageInfo.id).data('message',messageInfo);


        if(type==1 && (messageInfo.ismyself==1 || (messageInfo.ismyself==2 && spos=='end'))){
            //if((messageInfo.ismyself==1 && type==1) || (messageInfo.ismyself==2 && spos=='end')){
            scrollTo('bottom');
        }else if(type==1 && (messageInfo.ismyself==2 && spos!='null')){
            //messageInfo.butmContent = '给您发送了一个位置消息';
            //insertBottomMessageHtml(messageInfo);
        }
    }

    //修复离线文件暂存7天，会有字体丢失
//    var w = $('#'+messageInfo.id).find('.content-wrap.systemMessage>article:first-of-type>div').width();
//    w += 1;
//    $('#'+messageInfo.id).find('.content-wrap.systemMessage>article:first-of-type>div').css('min-width',w+'px');


}

/*插入签收消息的HTML
 * messageInfo:单条消息对象
 * type:消息类型（1：即时消息-默认，2：历史消息）
 * messageInfo 对象含参数
 * id - 消息id,
 * time - 消息发送时间，长整形,
 * state - 消息状态（1：成功、2：失败、3：未读、4：视频通话已取消、5：视频通话未接听、6：对方未接听通话、7：待签收、8：已被签收、9：已签收）,
 * reason - 消息发送失败原因
 * content - 消息内容,
 * ismyself - 发送人是否是我自己（1：是、2：否）,
 * isgroup - 是否群组消息（1：是、2：否）,
 * headUrl - 发送人头像,
 * name - 发送人名称,
 * accNbr - 发送人账号,
 * title - 签收消息显示的标题文字,
 * button - 签收按钮的文字
 */
function insertSignMessageHtml(messageInfo,type){
    if(!messageInfo)return;
    var spos = getScrollPos();
    messageInfo = JSON.parse(messageInfo);
    messageInfo.time = messageInfo.time * 1000;
    var contentObj = parseMessageContent(messageInfo.content);
    var html = '<div id="'+messageInfo.id+'" data-time="'+messageInfo.time+'" data-accNbr="'+messageInfo.accNbr+'" class="message margin '+(messageInfo.ismyself==1?"myself":"")+'">' +
        '<img class="headPic cancelSelect" width="30px" height="30px" src="'+messageInfo.headUrl+'">' +
        ((messageInfo.isgroup==1&&messageInfo.ismyself!=1)?('<span class="name">'+messageInfo.name+'</span>'):"") +
        '<section class="content-wrap border systemMessage sign">' +
        '<i class="bgicon sharp"></i>' +
        '<article>' +
        '<aside class="ellipsisHide">' +
        '<i class="bgicon '+(messageInfo.state==7?"plaint":"success")+'"></i>'+ (messageInfo.title) +
        '</aside>' +
        '<aside class="content" style="'+contentObj.css+'">'+contentObj.content+'</aside>' +
        '</article>' +
        (messageInfo.state==7?('<article id="btn_sign" class="footer"><a class="confirmSign" href="javascript:void(0)">' + messageInfo.button +'</a></article>'):"") +
        '</section>' +
        '</div>';
    if($('#'+messageInfo.id).length>0){
        //修改
        $('#'+messageInfo.id).replaceWith(html);
        $('#'+messageInfo.id).data('message',messageInfo);

    }else{
        if(type==2){
            $('.message-wrapper .message-container').prepend(html);
            insertTimeHtml(messageInfo,type);
        }else{
            insertTimeHtml(messageInfo);
            $('.message-wrapper .message-container').append(html);
        }
        $('#'+messageInfo.id).data('message',messageInfo);
        if(type==1 && (messageInfo.ismyself==1 || (messageInfo.ismyself==2 && spos=='end'))){
            //if((messageInfo.ismyself==1 && type==1) || (messageInfo.ismyself==2 && spos=='end')){
            scrollTo('bottom');
        }else if(type==1 && (messageInfo.ismyself==2 && spos!='null')){
            messageInfo.butmContent = messageInfo.state==7?'发送了一条签收消息':'已确认签收消息';
            insertBottomMessageHtml(messageInfo);
        }
    }

}
// 当点击确认签收的时候调用到此函数, 用于得到C++的返回内容, 并更新显示的按钮文字
function doSignMessage(msgid) {
    // 调用C++代码, 并得到返回值
    external.doSign(msgid);
	var btn = $("#"+msgid).find("#btn_sign");
	if(btn) {
		btn.html('<span>已签收</span>');
	}
}


/*插入视频消息的HTML
 * messageInfo:单条消息对象
 * type:消息类型（1：即时消息-默认，2：历史消息）
 * messageInfo 对象含参数
 * id - 消息id,
 * time - 消息发送时间，长整形,
 * state - 消息状态（1：成功、2：失败、4：正在播放、5：正在加载）,
 * reason - 消息发送失败原因
 * content - 消息内容,
 * ismyself - 发送人是否是我自己（1：是、2：否）,
 * isgroup - 是否群组消息（1：是、2：否）,
 * headUrl - 发送人头像,
 * name - 发送人名称,
 * accNbr - 发送人账号,
 * sex - 发送人性别（1：男、2：女）,
 */
function insertVideoMessageHtml(messageInfo,type){
    if(!messageInfo)return;
    var spos = getScrollPos();
    messageInfo = JSON.parse(messageInfo);
    messageInfo.time = messageInfo.time * 1000;
    messageInfo.reason = '发送失败，点击重新发送';
    var _messageWrapperHeight = $('.message-wrapper').outerHeight();
    var _vedioImgMaxHeight = parseInt(_messageWrapperHeight * 0.7);
    var html = '<div id="'+messageInfo.id+'" data-time="'+messageInfo.time+'" data-accNbr="'+messageInfo.accNbr+'" class="message margin '+(messageInfo.ismyself==1?"myself":"")+'">' +
        '<img class="headPic cancelSelect" width="30px" height="30px" src="'+messageInfo.headUrl+'">' +
        ((messageInfo.isgroup==1&&messageInfo.ismyself!=1)?('<span class="name">'+messageInfo.name+'</span>'):"") +
        '<section class="content-wrap">' +
        '<i class="bgicon sharp"></i>' +
        (messageInfo.state==2?('<i class="bgicon result plaint red" data-reason="'+messageInfo.reason+'"></i>'):(messageInfo.state==5?('<i class="bgicon result voice-load"></i>'):"")) +
        '<font>' +
//        '<video id="video'+messageInfo.id+'" src="'+messageInfo.content[0]+'">' +
//        '<p>您的版本不支持视频播放</p>' +
//        '</video>' +
//        '<i class="bgicon vedio-play"></i>' +
        '<div>' +
        '<img class="video" data-src="'+messageInfo.content[0]+'" src="'+messageInfo.content[1]+'" title="'+(messageInfo.state==1?("双击查看原视频"):"")+'" style="max-height: '+_vedioImgMaxHeight+'px;">' +
        (messageInfo.state==4?('<i class="ico pause videoPause"></i>'):(messageInfo.state==1?('<i class="ico play videoPlay"></i>'):""))+
        '</div>'+
        '</font>' +
        '</section>' +
        '</div>';
    if($('#'+messageInfo.id).length>0){
        //修改
        $('#'+messageInfo.id).replaceWith(html);
        //$('#'+messageInfo.id).data('message',messageInfo);
    }else{
        if(type==2){
            $('.message-wrapper .message-container').prepend(html);
            insertTimeHtml(messageInfo,type);
        }else{
            insertTimeHtml(messageInfo);
            $('.message-wrapper .message-container').append(html);
        }
        $('#'+messageInfo.id).data('message',messageInfo);
        setTimeout(function(){
            if(type==1 && (messageInfo.ismyself==1 || (messageInfo.ismyself==2 && spos=='end'))){
                scrollTo('bottom');
            }else if(type==1 && (messageInfo.ismyself==2 && spos!='null')){
                messageInfo.butmContent = '给您发送了一个视频消息';
                insertBottomMessageHtml(messageInfo);
            }
        },50);
    }

//    if(type==2){
//        $('.message-wrapper .message-container').prepend(html);
//        insertTimeHtml(messageInfo,type);
//    }else{
//        insertTimeHtml(messageInfo);
//        $('.message-wrapper .message-container').append(html);
//    }
    //var video = $('.message-wrapper .message-container').find('#'+messageInfo.id).find('video');
    //添加视频监听
    //addVedioListen('video'+messageInfo.id);

//    if(type==1 && (messageInfo.ismyself==1 || (messageInfo.ismyself==2 && spos=='end'))){
//        scrollTo('bottom');
//    }else if(type==1 && (messageInfo.ismyself==2 && spos!='null')){
//        messageInfo.butmContent = '给您发送了一个视频消息';
//        insertBottomMessageHtml(messageInfo);
//    }
}

function resizeVedioPic(){
    var _messageWrapperHeight = $('.message-wrapper').outerHeight();
    var _vedioImgMaxHeight = parseInt(_messageWrapperHeight * 0.7);
    $('.message-wrapper .message-container>.message>.content-wrap img.video').css('maxHeight', _vedioImgMaxHeight+'px');
}

/*插入窗口底部消息提示HTML
 * messageInfo:单条消息对象
 * messageInfo 对象含参数
 * id - 消息id,
 * time - 消息发送时间，长整形,
 * state - 消息状态（1：成功、2：失败、3：未读、4：视频通话已取消、5：视频通话未接听、6：对方未接听通话、7：待签收、8：已被签收、9：已签收）,
 * reason - 消息发送失败原因
 * butmContent - 消息内容
 * ismyself - 发送人是否是我自己（1：是、2：否）,
 * isgroup - 是否群组消息（1：是、2：否）,
 * headUrl - 发送人头像,
 * name - 发送人名称,
 * accNbr - 发送人账号,
 * sex - 发送人性别（1：男、2：女）,
 */
function insertBottomMessageHtml(messageInfo){
    var  html = '<article data-id="'+messageInfo.id+'" class="message-tip bottom ellipsisHide">' +
        '<img class="headPic cancelSelect" src="'+messageInfo.headUrl+'" width="20" height="20">' +
        messageInfo.name + "：" + messageInfo.butmContent +
        '</article>';
    $('.message-wrapper').find('.message-tip.bottom').remove();
    $('.message-wrapper').append(html);
}

//构造消息发送失败的提示框
function creatTipWrapHtml(target,content){
    if(target=='delete'){
        $('.tip-wrap').remove();
        return;
    }
    if(!target || !content) return;
    var id = 'tw' + new Date().getTime();
    var html = '<aside id="'+id+'" class="tip-wrap">' +
        '<em class="sjx top"></em>' +
        '<em class="sjx top"></em>' +
        '<label>'+content+'</label>' +
        '</aside>';
    $('body').append(html);
    var $tipWrap = $('#'+id);
    var top = target.offset().top;
    var left = target.offset().left;
    var width = target.width();
    var height = target.height();
    var winWidth = $(window).width();
    var winHeight = $(window).height();
    var tipWrapWidth = $tipWrap.outerWidth();
    var tipWrapHeight = $tipWrap.outerHeight();
    var tipWrapSjxWidth = 14;
    var tipWrapSjxHeight = 7;
    //判断垂直方向是否还有足够的高度放置tip-wrap
    var surplusHeight = winHeight - top - height;//剩余高度
    var surplusWidth = winWidth - left - width;//剩余宽度
//    console.info('top:'+top+",left:"+left+",width:"+width+",height:"+height+",winWidth:"+winWidth+",winHeight:"+winHeight
//        +",tipWrapWidth:"+tipWrapWidth+",tipWrapHeight:"+tipWrapHeight+",surplusHeight:"+surplusHeight+",surplusWidth:"+surplusWidth
//        +",tipWrapSjxWidth:"+tipWrapSjxWidth+",tipWrapSjxHeight:"+tipWrapSjxHeight);
    if(surplusHeight > (tipWrapHeight + tipWrapSjxHeight)){
//        console.dir('靠下：'+surplusHeight);
        $tipWrap.find('.sjx').removeClass('bottom').addClass('top');
        $tipWrap.css({
            'top':(top + height + tipWrapSjxHeight) + 'px'
        });
    }else{
//        console.dir('靠上：'+surplusHeight);
        $tipWrap.find('.sjx').removeClass('top').addClass('bottom');
        $tipWrap.css({
            'top':(top - tipWrapHeight - tipWrapSjxHeight) + 'px'
        });
    }

    if(left <= (tipWrapWidth - width)/2){
//        console.dir('靠左');
        $tipWrap.css({
            'left':'2px'
        });
    }else if(surplusWidth <= (tipWrapWidth - width)/2){
//        console.dir('靠右');
        $tipWrap.css({
            'left':(winWidth - tipWrapWidth - 2) + 'px'
        });
    }else{
//        console.dir('默认');
        $tipWrap.css({
            'left':(left + width/2 - tipWrapWidth/2) + 'px'
        });
    }
    var l = parseInt($tipWrap.css('left'));
//    console.error('l='+(left + width/2 - l - tipWrapSjxWidth/2));
    $tipWrap.find('.sjx').css({
        'left':(left + width/2 - l - tipWrapSjxWidth/2) + 'px'
    });
}

//图片上插入放大镜的HMTL
function insertMagnifierHtml(target,url){
    var imgTarget = target.find('img[src="'+url+'"]');
    var ptop = imgTarget.position().top,pleft = imgTarget.position().left,
        sw = imgTarget.width(),sh = imgTarget.height(),
        magnifWidth = 30,magnifHeight = 30,
        fzhi = 5;
    pleft = pleft + sw - magnifWidth - fzhi;
    ptop = ptop + sh - magnifHeight;
    var html = '<i class="bgicon magnifier" data-img="'+url+'" title="双击查看原图" data-sw="'+sw+'" data-sh="'+sh+'" style="top: 0px;left: 0px;"></i>';
    if(target.find('.magnifier[data-img="'+url+'"]').length==0){
        target.append(html);
    }
    target.find('.magnifier[data-img="'+url+'"]').css({
        'top':ptop + 'px',
        'left':pleft + 'px'
    });
}

//创建语音播放的HTML
function creatVoicePlay_br(target){
    var url = target.attr('data-url');
    if(!target || !url){
        return;
    }
    url = '';
    //如果audio已经存在，则停止播放
    if($('#voice[src="'+url+'"]').length>0){
        var audio = document.getElementById("voice");
        audio.pause();
        $('audio#voice').remove();
        return;
    }

    //添加语音播放器
    var html = '<audio id="voice" src="'+url+'" autoplay><p>您的版本不支持语音播放</p></audio>';
    $('audio#voice').remove();
    $("body").append(html);
    //添加播放监听
    addVoiceListen(target);
}

/**
 * 插入没有任何记录的HTML
 */
function insertNothing(){
    var height = $(".message-wrapper").height();
    height -= 10;
    var html = '<div style="width: 100%;height: '+height+'px;line-height: '+height+'px;color: #666666;font-size: 14px;text-align: center;">未检索到相关信息</div>';
    $(".message-wrapper .message-container").html(html);
}

/*解析content参数
* var content = {
 "font": {
 "n": "微软雅黑",        // 字体名称。字符串
 "s": 12,                // 字号。整型
 "c":"0x000000",           // 颜色。无符号整形. 如白色用0xFFFFFF表示
 "b": 1,                 //  整型。1: 粗体, 0: 正常
 "i": 0,                  //  整型。1: 斜体,。0: 正常
 "u": 1                  //  整型。1: 有下划线。 0: 正常
 },
 "content": ["这是一条测试内容",["at", "66001122", "张三"], ["at","66001123", "李四"], ["face", 108, "file://c:/108.gif"], "\n这是文本第二行测试数据", ["img", 0, "file://c:/2.png", 100, 200], ["url","http://www.baidu.com"],""]
 }*/
function parseMessageContent(content){
    var fcss = creatFontCss(content.font);
    var cent = creatContent(content.content);
    var butmContent = creatButmContent(content.content);
    return {'css':fcss,'content':cent,'butmContent':butmContent};
    function creatFontCss(font){
        if(!font)return '';
        var family = font.n,size = font.s,color = font.c,bold = font.b,italic = font.i,underline = font.u;
        if(family && family.length>0){
            family = 'font-family: '+family+';'
        }
        if(size){
            size = 'font-size: '+size+'px;'
        }
        if(color){
            color = 'color: #' + toHex(color).replace('0x','')+';';
            //color = 'color: #'+parseInt(color,16).replace('0x','')+';'
        }
        if(bold == 1){
            bold = 'font-weight: bold;'
        }else{
            bold = '';
        }
        if(italic == 1){
            italic = 'font-style: italic;'
        }else{
            italic = '';
        }
        if(underline == 1){
            underline = 'text-decoration: underline;'
        }else{
            underline = '';
        }
        return family + size + color + bold + italic + underline;
    }
    function creatContent(content){
        if(!content)return '';
        var html = '';
        for(var i=0;i<content.length;i++){
            var c = content[i];
            if(typeof c == 'string'){
            	//alert(c);
                var str = matchReplaceAtable(c);
                //alert(str);
                html += str;
            }else{
                if(c[0]=='at'){
                    //@账号
                    var accNbr = c[1],name = c[2];
                    html += '<a id="atuser" atuserid="'+accNbr+'" atnickname="'+name+'" href="javascript:window.external.clickAtUser(\''+accNbr+'\');">@'+name+'</a>';
                }else if(c[0]=='face'){
                    //表情
                    var faceId = c[1], faceText = c[2], facePath = c[3];
                    html += '<img src="'+facePath+'" data-faceid="'+faceId+'" data-facetext="'+faceText+'">';
                }else if(c[0]=='img'){
                    //图片     ["img", 0, "file://c:/2.png", 100, 200]
                    var imgNumber = c[1],imgPath = c[2],imgWidth = c[3],imgHeight = c[4];
                    if(imgNumber==1){
                        //正在加载中
                        html += '<img src="resources/img/pic-def.gif" data-val="loading">';
                    }else if(imgNumber==2){
                        //图片加载失败
                        html += '<img src="resources/img/pic-def-faile.png" data-val="faile" title="点击重新加载">';
                    }else{
                        //加载成功
                        var _wrapperHeight = $('.message-wrapper').height();
                        var _imgMaxHeight = parseInt(_wrapperHeight * 0.75);
                        html += '<img style="max-height: '+_imgMaxHeight+'px" title="双击查看原图" src="'+imgPath+'"'+(imgWidth?(" data-sw="+imgWidth):"")+(imgHeight?(" data-sh="+imgHeight):"")+'>';
                    }
                }else if(c[0]=='url'){
                    //链接
                    var urlPath = c[1];
                    html += '<a href="'+urlPath+'" target="_blank">'+urlPath+'</a>';
                }
            }
        }
        return html;
    }
    function creatButmContent(content){
        if(!content)return '';
        var html = '';
        for(var i=0;i<content.length;i++){
            var c = content[i];
            if(typeof c == 'string'){
                html += c;
            }else{
                if(c[0]=='at'){
                    //@账号
                    var accNbr = c[1],name = c[2];
                    html += '@'+name;
                }else if(c[0]=='face'){
                    //表情
                    var faceId = c[1], faceText = c[2], facePath = c[3];
                    html += '['+faceText+']';
                }else if(c[0]=='img'){
                    //图片     ["img", 0, "file://c:/2.png", 100, 200]
                    html += '[图片]';
                }else if(c[0]=='url'){
                    //链接
                    var urlPath = c[1];
                    html += '<a href="'+urlPath+'" target="_blank">'+urlPath+'</a>';
                }
            }
        }
        return html;
    }
}

function resizeImg(){
    var _messageWrapperHeight = $('.message-wrapper').outerHeight();
    var _imgMaxHeight = parseInt(_messageWrapperHeight * 0.7);
    $('.message-wrapper .message-container>.message>.content-wrap>font>img').css('maxHeight', _imgMaxHeight+'px');
}

function controlBottomMessage(){
    var _messageWrapperHeight = $('.message-wrapper').outerHeight();
    var _messageContainerHeight = $('.message-wrapper>.message-container').outerHeight();
    if(_messageWrapperHeight > _messageContainerHeight){
        $('.message-tip.bottom').remove();
    }
    if($('.message-wrapper').attr('data-scrollmark') == 'end' || getScrollPos() == 'end'){
        scrollTo('bottom');
    }
}

/*插入链接消息的HTML
 * messageInfo:单条消息对象
 * type:消息类型（1：即时消息-默认，2：历史消息）
 * messageInfo 对象含参数
 * id - 消息id,
 * time - 消息发送时间，长整形,
 * state - 消息状态（1：成功、2：失败、3：未读、4：视频通话已取消、5：视频通话未接听、6：对方未接听通话）,
 * reason - 消息发送失败原因
 * content - 消息内容,
 * ismyself - 发送人是否是我自己（1：是、2：否）,
 * isgroup - 是否群组消息（1：是、2：否）,
 * headUrl - 发送人头像,
 * name - 发送人名称,
 * accNbr - 发送人账号,
 * sex - 发送人性别（1：男、2：女）,
 */
function insertLinkMessageHtml(messageInfo, type){
    if(!messageInfo)return;
    var spos = getScrollPos();
    messageInfo = JSON.parse(messageInfo);
    messageInfo.time = messageInfo.time * 1000;

    //图片     ["img", 0, "file://c:/2.png"]
    var imgData = messageInfo.content[4];
    var imgNumber = imgData[1], imgPath = imgData[2], dataVal = "";
    if(imgNumber==1){
        //正在加载中
        imgPath = "resources/img/pic-def.gif";
        dataVal = "loading";
    }else if(imgNumber==2){
        //图片加载失败
        imgPath = "resources/img/pic-def-faile.png";
        dataVal = "faile";
    }

    var html = '<div id="'+messageInfo.id+'" data-time="'+messageInfo.time+'" data-accNbr="'+messageInfo.accNbr+'" class="message margin '+(messageInfo.ismyself==1?"myself":"")+'">' +
        '<img class="headPic cancelSelect" width="30px" height="30px" src="'+messageInfo.headUrl+'">' +
        ((messageInfo.isgroup==1&&messageInfo.ismyself!=1)?('<span class="name">'+messageInfo.name+'</span>'):"") +
        '<section class="content-wrap border systemMessage posMessage">' +
        '<i class="bgicon sharp"></i>' +
        (messageInfo.state==2?('<i class="bgicon result plaint red" data-reason="'+messageInfo.reason+'"></i>'):
            (messageInfo.state==7?'<i class="bgicon result plaint voice-load"></i>':'')) +
        '<article>' +
        '<img class="pic link" src="'+imgPath+'" data-val="'+dataVal+'" width="40" height="40">' +
        '<div>' +
        '<h4 class="ellipsisHide">'+messageInfo.content[0]+'</h4>' +
        '<h4 style="display: -webkit-box;-webkit-box-orient: vertical;-webkit-line-clamp: 2;overflow: hidden;">'+messageInfo.content[1]+'</h4>' +
        '</div>' +
        '</article>' +
        '<article class="footer">' +
        '<p class="ellipsisHide" style="float: left;color: #999;width: 200px;">'+messageInfo.content[2]+'</p>' +
        '<a class="copyLink">复制链接</a>' +
        '<a target="_blank" href="'+messageInfo.content[3]+'">打开</a>' +
        '</article>' +
        '</section>' +
        '</div>';

    if($('#'+messageInfo.id).length>0){
        //修改
        $('#'+messageInfo.id).replaceWith(html);
        $('#'+messageInfo.id).data('message',messageInfo);

    }else{
        if(type==2){
            $('.message-wrapper .message-container').prepend(html);
            insertTimeHtml(messageInfo,type);
        }else{
            insertTimeHtml(messageInfo);
            $('.message-wrapper .message-container').append(html);
        }
        $('#'+messageInfo.id).data('message',messageInfo);

        if(type==1 && (messageInfo.ismyself==1 || (messageInfo.ismyself==2 && spos=='end'))){
            scrollTo('bottom');
        }else if(type==1 && (messageInfo.ismyself==2 && spos!='null')){
            messageInfo.butmContent = '[链接]'+messageInfo.content[0];
            insertBottomMessageHtml(messageInfo);
        }
    }

}

function outset(content){
    content = JSON.stringify(content);
    var html = '<div id="outset" style="position: absolute;top: 0;left: 0;width:100%;height: 100%;background: yellow; color: #000;z-index:2;opacity:0.7;"></div>';
    if($('#outset').length === 0) $('#message-wrapper').append(html);
    var scontent = $('#outset').html();
    content = scontent + '<br>' + content;
    $('#outset').html(scontent);
}