/**
 * 模型层-处理业务逻辑，请求数据、处理返回数据
 */
var _target = $('#message-wrapper');//需要加载滚动条插件的对象
var msg_type = getUrlParamt('msg_type');//1、表示历史记录，2、表示搜索记录，3、表示没有任何记录
var msg_id = getUrlParamt('msg_id');//搜索文字，需要高亮显示
var WRAPPER = '';//聊天窗口属性对象，用于记录最新的聊天窗口属性

// 高亮某一条消息
function lightMessage(id){
	msg_id = id;
	/*setTimeout(function(){
		$("#" + id).addClass("light");
	},100); */
	
}

/*聊天窗口滚动条滚动到指定位置
* position:top(默认),bottom,20px(像素),#id(id名)*/
function scrollTo(position){
    var tarName = 'message-wrapper';
    if(!position || position == 'top'){
        position = 0;
        $("#"+tarName).scrollTop(position);
    }
    else if(position == 'bottom'){
        position = $("#"+tarName)[0].scrollHeight;
        //移除底部提示信息
        $('.message-tip.bottom').remove();
        $('.message-wrapper').attr('data-scrollmark','end');
        $("#"+tarName).scrollTop(position);
    }else if($(position).length>0){
        position = $(position).position().top;
        $("#"+tarName).scrollTop(position);
    }
//    $("#"+tarName).animate({
//        scrollTop: position
//    }, 50);
}

function getScrollPos(){
    var $wrapper = $('.message-wrapper');
    var $container = $wrapper.find('.message-container');
    var sh = '',top = '',_wrapperHeight = '',_containHeight = '';
    if($wrapper.height() > 1){
        //记录窗口属性
        sh = $wrapper[0].scrollHeight;
        top = $wrapper.scrollTop();
        _wrapperHeight = $wrapper.height();
        _containHeight = $container.height();
        WRAPPER = {'sh': sh, 'top': top, 'wrapperHeight': _wrapperHeight, 'containHeight': _containHeight};
    }else{
        //当窗口高度被设置为1的时候，给予最近一次的窗口属性
        sh = WRAPPER.sh;
        top = WRAPPER.top;
        _wrapperHeight = WRAPPER.wrapperHeight;
        _containHeight = WRAPPER.containHeight;
    }

    if(parseInt(_containHeight) < parseInt(_wrapperHeight)){
        top = 'null';
    }else if(parseInt(top + _wrapperHeight) >= sh){
        top = 'end';
    }
    $('.message-wrapper').attr('data-scrollmark',top);
    return top;
}

/*是否插入底部的消息提示*/
function isInsertBottomMessage(){
    if(_target.hasClass('mCS_no_scrollbar')){
        //滚动条未出现,说明还未超出
        return false;
    }else if(_target.attr('data-scrollPos')!='end'){
        //滚动条出现，但是未滑动到底部，此时如果接收到别人的消息，要插入底部的消息提示
        return true;
    }
}

/*修改单条聊天信息的状态
* target : $('.content-wrap')
* type:1 success，2 load , 3 faile*/
function modifyMessageState(target,type){
    if(target.find('.result').hasClass('unread')){
        return;
    }
    target.find('.result').remove();
    if(type==1){
        return;
    }
    if(type==2){
        type = 'voice-load';
    }else if(type==3){
        type = 'plaint red';
        target.find('font').eq(0).css('color','red')
        target.find('.t').remove();
        target.find('.f').html('语音加载失败');
        target.find('.voice').addClass('red');
    }
    var html = '<i class="bgicon result '+type+'"></i>';
    target.find('.sharp').after(html);
}

/*语音监听*/
function addVoiceListen(id){
    if($('#'+id).length==0){
        return;
    }
    var audio = document.getElementById(id);
    var cw = $('#'+id).parents('.content-wrap');
    var target = $('#'+id).parent().find('i.voice');
    audio.addEventListener('loadstart', function () {
        console.info('客户端开始请求数据');
        modifyMessageState(cw,2);
    });

    audio.addEventListener('error', function () {
        console.info('请求数据时遇到错误 ');
        modifyMessageState(cw,3);
    });

    audio.addEventListener('canplaythrough', function () {
        console.info('可以播放，歌曲全部加载完毕  ');
        modifyMessageState(cw,1);
        refreshScrollBar();
    });

    audio.addEventListener('stalled', function () {
        console.info('网速失速 ');
        modifyMessageState(cw,1);
    });

    audio.addEventListener('play', function () {
        console.info('play()和autoplay开始播放时触发 ');
        modifyMessageState(cw,1);
        target.addClass('play');
    });

    audio.addEventListener('pause', function () {
        console.info('pause');
        target.removeClass('play');
    });

    audio.addEventListener('waiting', function () {
        modifyMessageState(cw,2);
        console.info('等待数据，并非错误 ');
    });

    audio.addEventListener('playing', function () {
        console.info('开始回放');
        modifyMessageState(cw,1);
    });

    audio.addEventListener('timeupdate', function () {
        console.info('播放时间改变');
        modifyMessageState(cw,1);
    });

    audio.addEventListener('ended', function () {
        console.info('end='+target[0].tagName);
        target.removeClass('play');
    });
}

/*视频监听*/
function addVedioListen(id){
    if($('#'+id).length==0){
        return;
    }
    var target = $('#'+id);
    var video = target[0];
    var cw = $('#'+id).parents('.content-wrap');
    video.addEventListener('loadstart', function () {
        console.info('客户端开始请求数据');
        modifyMessageState(cw,2);
    });

    video.addEventListener('error', function () {
        console.info('请求数据时遇到错误 ');
        modifyMessageState(cw,3);
    });

    video.addEventListener('canplaythrough', function () {
        console.info('可以播放，歌曲全部加载完毕  ');
        modifyMessageState(cw,1);
        refreshScrollBar();
    });

    video.addEventListener('stalled', function () {
        console.info('网速失速 ');
        modifyMessageState(cw,1);
    });

    video.addEventListener('play', function () {
        console.info('play()和autoplay开始播放时触发 ');
        modifyMessageState(cw,1);
    });

    video.addEventListener('pause', function () {
        console.info('pause');
        target.next('i.vedio-play').show();
    });

    video.addEventListener('waiting', function () {
        modifyMessageState(cw,2);
        console.info('等待数据，并非错误 ');
    });

    video.addEventListener('playing', function () {
        console.info('开始回放');
        modifyMessageState(cw,1);
    });

    video.addEventListener('timeupdate', function () {
        console.info('播放时间改变');
        modifyMessageState(cw,1);
    });

    video.addEventListener('ended', function () {
        console.info('end');
        target.next('i.vedio-play').show();
    });
}

function clearScreen(){
    $('.message-wrapper .message-container').empty();
}

/**
 * 删除一条消息
 * @param id 消息记录id
 */
function removeMessage(id){
    if(!id)return;
    var target = $('.message[id="'+id+'"]');
    target.prev('.time').remove();
    target.remove();
}

function custScroll(type){
    if(type=='hide'){
        $('.message-wrapper').css({
            'overflow':'hidden'
        });
    }else if(type=='show'){
        $('.message-wrapper').css({
            'overflow':'auto'
        });
    }
}

/**
 * 获取元素位置
 */
function getElePostion(id){
    if(!id || $('#'+id).length==0)return;
    var top = document.getElementById(id).getBoundingClientRect().top;
    var height = $('.message-wrapper').height();
    if(top>=0 && top <= height){
        window.external.msgVisible(true, id);
    }else{
       // alert("元素不在可视范围内");
    }
}

//获取地址栏参数
function getUrlParamt(name){
    var reg = new RegExp("(^|&)"+ name +"=([^&]*)(&|$)");
    var r = window.location.search.substr(1).match(reg);
    if(r!=null)return  unescape(r[2]); return null;
}

/**
 * 隐藏、显示滚动条
 * @param type : hide\show
 */
function constScroll(type){
    var dom = $("#message-wrapper")
    if(type === 'hide'){
        dom.addClass("hideScroll");
    }else{
        dom.removeClass("hideScroll");
    }
}

/**
 * 修改用户信息，头像、昵称
 * obj = {'accNbr': '','headImg': '', 'name': ''}
 */
function updateUserInfo(obj) {
    if(!obj) return;
    obj = JSON.parse(obj);
    if(!obj.accNbr) return;
    var name = obj.name;
    var headImg = obj.headImg;
    var dom = $('.message[data-accNbr="'+obj.accNbr+'"]');
    if(name) {
        dom.find('span.name').text(name);
    }
    if(headImg) {
        dom.find('img.headPic').attr('src', headImg);   
    }
}

/*更新所有的时间*/
function updateTime() {
    $('span.time').each(function(){
        var time = $(this).attr('data-time');
        time = dateToString(parseInt(time));
        $(this).text(time);
    })

}