function init(virtual)
  	if not virtual then
    	entity.setInteractive(true)
  	end

    storage.speciesIndex = storage.speciesIndex or 1
    storage.seedValue = storage.seedValue or 0
    storage.type = storage.type or 1
  	storage.parentSpawner = storage.parentSpawner or nil

    local pos  = entity.position()

    --handler for messages coming from the UI sending us the chosen species index 
  	message.setHandler("setSpecies", function(_, _, params)
      setSpecies(params)
    end)
    --handler for messages coming from the UI sending us the chosen seed value 
    message.setHandler("setSeedValue", function(_, _, params)
      setSeedValue(params)
    end)
    --handler for messages coming from the UI sending us the chosen NPC type 
    message.setHandler("setType", function(_, _, params)
      setType(params)
    end)

    --handler for messages coming from the UI to retrieve the current species index
    message.setHandler("getSpecies", function(_, _)
      return getSpecies()
    end)
    --handler for messages coming from the UI to retrieve the current seed value
    message.setHandler("getSeedValue", function(_, _)
      return getSeedValue()
    end)
    --handler for messages coming from the UI to retrieve the current NPC type
    message.setHandler("getType", function(_, _)
      return getType()
    end)

    --handler for messages coming from the spawner with the spawner's unique id
    --called from spawner object after panel is created. stores the id of the parent spawner
 	  message.setHandler("setParentSpawner", function(_, _, params)
      setParentSpawner(params)
    end)
end

function onInteraction(args)
  local interactionConfig = entity.configParameter("uiConfig")
  return {"ScriptConsole", interactionConfig}
end

function update(dt)
end 

function setParentSpawner(spawnerId)
  storage.parentSpawner = spawnerId
  --world.logInfo("PANEL: recieved the id of the parent spawner")
end

function setSpecies(speciesIndex)
  storage.speciesIndex = speciesIndex
	if storage.parentSpawner then
		--world.logInfo("PANEL: sending raceChange message to the spawner obj. Message is: "..tostring(speciesIndex))
    --after getting the species from the UI panel, pass it on to the spawner
		world.sendEntityMessage(storage.parentSpawner, "setSpecies", storage.speciesIndex)
	else
		world.logInfo("The panel object did not pass on the species index because the parentSpawner was not found or is null.")
	end
end

function setSeedValue(seedValue)
  storage.seedValue = seedValue
  if storage.parentSpawner then
    --world.logInfo("PANEL: sending seed value message to the spawner obj. Message is: "..tostring(seedValue))
    world.sendEntityMessage(storage.parentSpawner, "setSeedValue", storage.seedValue)
  else
    world.logInfo("The panel object did not pass on the seed value because the parentSpawner was not found or is null.")
  end
end

function setType(type)
  storage.type = type
  if storage.parentSpawner then
    --world.logInfo("PANEL: sending type change message to the spawner obj. Message is: "..tostring(type))
    world.sendEntityMessage(storage.parentSpawner, "setType", storage.type)
  else
    world.logInfo("The panel object did not pass on the type because the parentSpawner was not found or is null.")
  end
end

function getSpecies()
  if storage.speciesIndex ~= nil then
    --world.logInfo("PANEL: Species requested. The speciesIndex is: " .. tostring(storage.speciesIndex))
    return storage.speciesIndex
  else
    world.logInfo("PANEL: Species requested. The speciesIndex was nil.")
    return 1
  end
end

function getSeedValue()
  if storage.seedValue ~= nil then
    --world.logInfo("PANEL: Seed value requested. The seed value is: " .. tostring(storage.seedValue))
    return storage.seedValue
  else
    world.logInfo("PANEL: Seed value requested. The seed value was nil.")
    return 0
  end
end

function getType()
  if storage.type ~= nil then
    --world.logInfo("PANEL: Type requested. The type is: " ..storage.type)
    return storage.type
  else
    world.logInfo("PANEL: Type requested. The type was nil.")
    return 0
  end
end

