
function init()
	--these variables store the results of the messages we send to the parent panel obj
	self.gettingSpecies = world.sendEntityMessage(console.sourceEntity(), "getSpecies")
	self.gettingSeedValue = world.sendEntityMessage(console.sourceEntity(), "getSeedValue")
  self.gettingType = world.sendEntityMessage(console.sourceEntity(), "getType")

	self.sendingSpecies = nil
	self.sendingSeedValue = nil
  self.sendingType = nil

	self.sliderVal = 0

	self.speciesInitialized = false;
	self.seedValueInitialized = false;
  self.typeInitialized = false;

	self.raceButtons = {}

  local raceLabels = root.assetJson("/player.config").species

	 -- Create race-picker radio buttons and add a listener to each one to change the species index
	local speciesGroup = Panel(5, 220)
	for i,v in ipairs(raceLabels) do
		--coordinates originate from bottom-left of the canvas panel apparently
		local button = TextRadioButton(0,-i*12, 35, 10, v)
		
		button:addListener("pressed", function(t, k, old, new)
			if new and self.gettingSpecies:finished() then
				if not self.sendingSpecies or self.sendingSpecies:finished() then
					--world.logInfo('UI: race changed from own button press. calling function on Panel obj')
  					self.sendingSpecies = world.sendEntityMessage(console.sourceEntity(), "setSpecies", i)
				end
			end
		end)

		speciesGroup:add(button)
		self.raceButtons[i] = button;
	end

  self.typeButtons = {}

  local typeOptions = console.configParameter("typeOptions")
  local typeGroup = Panel(30, 90)
  for i,v in ipairs(typeOptions) do
    local button = TextRadioButton(i*30, 0, 35, 10, v)

    button:addListener("pressed", function(t, k, old, new)
      if new and self.gettingType:finished() then
        if not self.sendingType or self.sendingType:finished() then
          --world.logInfo('UI: type changed from own button press. calling function on Panel obj')
            self.sendingType = world.sendEntityMessage(console.sourceEntity(), "setType", i)
        end
      end
    end)

    typeGroup:add(button)
    self.typeButtons[i] = button;
  end

	self.seedValueLabel = Label(115, 20, tostring(0))

	-- Create a slider
	--function Slider:_init(x, y, width, height, min, max, step, vertical)
 	self.slider = Slider(10, 20, 100, 12, 0, 100, 1)

 	self.slider:addListener("dragging", function(t, k, old, new)
     	if not new and self.gettingSeedValue:finished() then
     		if not self.sendingSeedValue or self.sendingSeedValue:finished() then
     			--world.logInfo("Slider has been dragged to %s", self.sliderVal)
     			--world.logInfo('UI: seed value changed from own slider. calling function on Panel obj')
     			self.sendingSeedValue = world.sendEntityMessage(console.sourceEntity(), "setSeedValue", self.sliderVal)
 			end
     	end
   	end)

   	self.slider:addListener("moving", function(t, k, old, new)
     	if new == nil and self.gettingSeedValue:finished() then
     		if not self.sendingSeedValue or self.sendingSeedValue:finished() then
     			--world.logInfo("Slider has been moved to %s", self.sliderVal)
     			--world.logInfo('UI: seed value changed from own slider. calling function on Panel obj')
     			self.sendingSeedValue = world.sendEntityMessage(console.sourceEntity(), "setSeedValue", self.sliderVal)
 			end
     	end
   	end)

 	self.slider:addListener("value", function(t, k, old, new)
     	self.seedValueLabel.text = string.format("%d", new)
     	self.sliderVal = new
   	end)

   	self.slider.lineColor = "white"
    local npcImage = Image(50, 120, "/interface/CAFmenu/npcPortrait.png")

    GUI.add(speciesGroup)
    GUI.add(typeGroup)
    GUI.add(self.slider)
    GUI.add(self.seedValueLabel)
    GUI.add(npcImage)

    local seedTitle = Label(10, 65, "Randomize")
    local seedSubtitle = Label(10, 45, "Change the look of your friend! Friends \nwith the same value will look the same!", 6)

    GUI.add(seedTitle)
    GUI.add(seedSubtitle)
end

function update(dt)
  GUI.step(dt)

  --initializing the species from the panel object
  if not self.speciesInitialized and self.gettingSpecies:finished() and self.gettingSpecies:result() then
  	local result = self.gettingSpecies:result()
  	--world.logInfo("UI: the species index has been initialized from panel object. Changed to: " .. tostring(result))
  	self.raceButtons[result]:select();
  	self.speciesInitialized = true
  end

  --initializing the seed value from the panel object
  if not self.seedValueInitialized and self.gettingSeedValue:finished() and self.gettingSeedValue:result() then
  	local result = self.gettingSeedValue:result()
  	--world.logInfo("UI: the seed value has been initialized from panel object. Changed to: " .. tostring(result))
  	self.slider.value = result
  	self.seedValueLabel.text = tostring(result)
  	self.seedValueInitialized = true
  end

  --initializing the type from the panel object
  if not self.typeInitialized and self.gettingType:finished() and self.gettingType:result() then
    local result = self.gettingType:result()
    --world.logInfo("UI: the type has been initialized from panel object. Changed to: " .. tostring(result))
    self.typeButtons[result]:select();
    self.typeInitialized = true
  end

end

function canvasClickEvent(position, button, pressed)
  GUI.clickEvent(position, button, pressed)
end

function canvasKeyEvent(key, isKeyDown)
  GUI.keyEvent(key, isKeyDown)
end
