(
	struct CameraOutputSize (
		cname		= "",
		cdname		= "",
		width		= undefined,
		height		= undefined
	)
	
	struct SMapFile (
			id		= 0,		-- map file id, must unique
			origin	= "",		-- origin path
			real	= "",		-- real path
			islost	= false,	-- if this file is not found
			rename	= ""		-- renamed path, path on server	
	)
	include "GodHorseLang.ms"
	include "UserDirConfig.ms"
	fn get_abs f = (
		return (pathConfig.convertPathToAbsolute f)
	)

global	proj_dirty	

fn xdkFetchMaxFile = (
		if(proj_dirty) then (
					fetchMaxFile quiet:true
					setSaveRequired true
		) else (
				local maxfile = maxFilePath + maxFileName
				loadMaxFile maxfile useFileUnits:true quiet:true
		)
)


fn is_valid_filename str = (
	local invalid_filename_chars = #("/","\\","*","?","+","<",">","|",":"," ","-","#")
	print str
	for chr = 1 to invalid_filename_chars.count do (
		c =findString str invalid_filename_chars[chr]
		if (c != undefinded) then (
			return false
		)
	)
	return true
)	
		
	fn get_version = (
		local max_version ="0000"
		case (maxVersion())[1] of
		(
			9000:
				max_version = "9"
			10000:
				max_version = "2008"
			11000:
				max_version = "2009"
			12000:
				max_version = "2010"
			13000:
				max_version = "2011"
			14000:
				max_version = "2012"
			15000:
				max_version = "2013"
			16000:
				max_version = "2014"
			17000:
				max_version = "2015"
			18000:
				max_version = "2016"
			19000:
				max_version = "2017"
			20000:
				max_version = "2018"
			21000:
				max_version = "2019"
			22000:
				max_version = "2020"
		)
		return max_version
	)
	fn sellectByName ddl txt = 
	(
		local names = ddl.items
		for i = 1 to names.count do
		(
			if names[i] == txt then ddl.selection = i
		)
	)	
	fn get_bit = (if is64bitApplication() then(return "64")else(return "32"))
	fn get_cameras = (
			local max_cameras  = #()
			for c in cameras do
			(
				if iskindof c camera do
				(
					append max_cameras c.name
				)
			)
			if max_cameras.count == 0 then (
				print cn1
				return undefined
			) else (
				return max_cameras
			)
	)
	
	fn filenameFromPath_sw str = (
		local idx = 0
		for i = 1 to str.count do (
			if str[i] == "\\" then (
				idx = i
			)
		)
		local tmp = substring str (idx + 1) -1
		return tmp
	)
	
	fn formatToString str num=(
		str=str as string
		str="0000"+str
		local c=str.count
		local start=(c-num)+1
		str=substring str start -1
		return str
	)
	fn get_sceneroot = (
			local scenearr = (for r in (refs.dependents rootNode) where (classof r == Scene) collect r)
			if scenearr.count < 1 then (
				errstr = lang_sroot_failed
				return undefined
			)
			return scenearr[1]			 
	)
		
	try (
		global srs_floater
		local ro_common
		local ro_vray
		local ro_submit
		local ro_about
		local prg_value = 0
		local NewJobsDir 		= undefined
		local ec_default_out		= "Outputs\\"
		local proj_name		= undefined
		local proj_dir			= undefined
		local proj_desc 			= undefined	
		local proj_origin		= undefined	
		local RET_OK	= "OK"
		local errstr		= ""
		local msg_title	=cn2
		local camera_output_sizes = #()
		local lightfirst = false
		global allfiles_global= #()
		global ScriptVersion="3.4"
		fn get_selected_cameras = (
				local max_cameras  = #()
				for c in camera_output_sizes do
				(
					append max_cameras c.cname
				)
				if max_cameras.count == 0 then (
					print cn3
					return undefined
				) else (
					return max_cameras
				)
		)
		
		fn get_camera_outputsize cam &width &height = (
			for c in camera_output_sizes do
			(
				if (c.cname == cam) then (
					width = c.width
					height = c.height
					if(width == 0) then
						width = renderWidth
					if(height == 0) then
						height = renderHeight
					return true
				)
			)
			return undefined
		)
	
		fn update_prg_progress val = (
			ro_submit.pbar_progress.value = val
			ro_submit.lbl_prg_value.caption = val as string + "%"
		)
		fn set_info str = (
			ro_submit.lbl_process.text = str
		)
		fn GenerateTaskDir = (
			local t=getUniversalTime();
			proj_name =(formatToString t[1] 4)+(formatToString t[2] 2)+(formatToString t[4] 2)+(formatToString t[5] 2)+(formatToString t[6] 2)+(formatToString t[7] 2)+(formatToString t[8] 3) 
			proj_dir  = NewJobsDir + proj_name + "\\"
			return RET_OK
		)
		
		fn findItemIgnoreCase arr a = (
			local idx = 0
			for i = 1 to arr.count do (
				if (stricmp arr[i] a) == 0 then (
					idx = i
					exit()
				)
			)
			return idx
		)
	
		fn deleteItemByName arr i = 
		(
			local idx = findItemIgnoreCase arr i
			if idx != 0 then deleteitem arr idx
		)
		fn createXml pname pcams= (
		local max_render = renderers.current
		local outfile = rendOutputFilename
		local sceneName = maxFilePath + maxFileName
			local file = createFile proj_desc
			if file != undefined then (
				format "%\n" cn5 to:file
				if maxFileName!="" then(
					format "%\n" maxFileName to:file
				)
				else(
					format "scene.max\n" to:file
				)
				format "%\n" proj_name to:file
				version=ro_common.ddl_version.selected as String
				format "%\n" version to:file
				local SceneFile=proj_dir + maxFileName
				format "%\n"  SceneFile to:file
				format "%\n" outfile to:file
				local IsXianShi="0"
			
				if((ro_common.qos_opts.selected as String)==cn53) then
				(
					IsXianShi="1"
				)
				else if((ro_common.qos_opts.selected as String)==cn54) then
				(
					IsXianShi="0"
				)
				local ThreadNum=""
				if((ro_common.qos_opts_new.selected as String)!="") then
				(
					ThreadNum=(ro_common.qos_opts_new.selected as String)
				)
				else
				(
					ThreadNum="32"
				)
				

				local max_cameras  = get_selected_cameras()
				local max_cameras_str=""
				if max_cameras == undefined or max_cameras.count < 1 then (
					max_cameras = #("")
				)
				else(	
					for c in max_cameras do
					(
						get_camera_outputsize c &width &height
						max_cameras_str=max_cameras_str+","+(c as string)+"|"+(width as string)+"|"+(height as string)
					)
					
					if (max_cameras_str!="") then(
						max_cameras_str=subString max_cameras_str 2 10000
					)
				)
				
				format "%\n" IsXianShi  to:file
				format "%\n" max_cameras_str  to:file
				format "%\n" Renderers.current  to:file
				format "%\n" ThreadNum  to:file
				
				local lightfirstratio
				case ro_common.sgi_buttons.state of (
					1: lightfirstratio = 1
					2: lightfirstratio = 2
					3: lightfirstratio = 4
					4: lightfirstratio = 8
				)
				format "%\n" lightfirstratio  to:file
				format "%\n" renderWidth  to:file
				format "%\n" renderHeight  to:file
				if(ro_common.ao_channel.state==true) then
				(
					format "%\n" "1" to:file
				)
				else(
					format "%\n" "0" to:file
				)
				if(ro_common.caizhi_channel.state==true) then
				(
					format "%\n" "1" to:file
				)
				else(
					format "%\n" "0" to:file
				)
				format "%\n" (TIF.getType() as string) to:file	
				format "%\n" (IDisplayGamma.colorCorrectionMode as String) to:file
				format "%\n" fileInGamma to:file
				format "%\n" fileOutGamma to:file
				format "%\n" IDisplayGamma.affectColorPickers to:file
				format "%\n" IDisplayGamma.affectMEdit to:file
				
			    if  (substring  (Renderers.current as string) 1 5) == "V_Ray" then
				(
					format "%\n" Renderers.current.gi_irradmap_subdivs to:file
					format "%\n" Renderers.current.gi_irradmap_interpSamples to:file
					format "%\n" Renderers.current.lightcache_subdivs to:file
					format "%\n" Renderers.current.lightcache_sampleSize to:file
				)
				else(
					format "is_not_vray\n"  to:file
					format "is_not_vray\n"  to:file
					format "is_not_vray\n"  to:file
					format "is_not_vray\n"  to:file
				)
				format "%\n" ScriptVersion to:file
				local arr_lang=sysinfo.GetMaxLanguage()
				format "%\n" arr_lang[3] to:file
				close file
				return RET_OK
			)
			else (
				errstr = (cn6 + proj_desc)
				return undefined
			)
		)

		
		fn exec pname pcams= (
		
			set_info cn7
			makeDir proj_dir
			makeDir (proj_dir + ec_default_out)
			proj_origin		= maxFilePath + maxFileName
			proj_desc			= proj_dir + "data.txt"
			
			local max_files		= #()
			local max_files_real		= #()
			
			ATSOps.refresh()
			ATSOps.GetFiles &max_files
			deleteItemByName max_files rendOutputFilename
			local input_dir="Inputs\\"
			makeDir (proj_dir+input_dir)
			local FindMax=""
			
			local org_cnp = ATSOps.CheckNetworkPaths
			
			
			
			ATSOps.CheckNetworkPaths = true
			ATSOps.GetResolvedPaths max_files &max_files_real
			local sceneroot=get_sceneroot()			
			--reset path to absolute
			
			
			local allfiles	= #()
			local i=0
			for i = 1 to max_files.count do
			(
				if((ATSOps.IsInputFile max_files[i])==true and ((getFilenameFile max_files_real[i])+(getFilenameType max_files_real[i]))!=maxFileName) then
				(
					if (not doesFileExist max_files_real[i]) then (
						append allfiles (SMapFile origin:max_files[i] real:max_files_real[i] islost:true rename:(proj_dir+input_dir+(i as String)+getFilenameType(max_files_real[i])))
					)
					else(
						append allfiles (SMapFile origin:max_files[i] real:max_files_real[i] islost:false rename:(proj_dir+input_dir+(i as String)+getFilenameType(max_files_real[i])))
					)
				)
			)	
			
			local file_map = createFile (proj_dir+"Inputs\\map.txt")
			if(file_map != undefined) then(
				format "%\n" (cn5+"|"+cn5+"|islost:true|"+cn5) to:file_map
				for item in allfiles do(
					format "%\n" (item.origin+"|"+item.rename+"|islost:"+(item.islost as string)+"|"+item.real)  to:file_map	
				)
			)else(
				MessageBox "Cannot Create Map.txt"
				return undefined
			)
			close file_map
			ATSOps.CheckNetworkPaths = org_cnp
			
			proj_dirty = getSaveRequired()
			if(proj_dirty) then (
				max file save
			)
			allfiles_global=allfiles
			sleep 2
			set_info "retarget files.."
			prg_value +=45
			update_prg_progress prg_value
			if maxFileName!="" then(
			    saveMaxFile (proj_dir+input_dir+maxFileName) useNewFile:false
			)
			else(
				saveMaxFile (proj_dir+input_dir+"scene.max") useNewFile:false
			)
			
			createXml pname pcams
			prg_value = 100
			update_prg_progress prg_value
			sub_msg = cn46
			set_info (sub_msg + " [" + proj_name + "]")
			local file = createFile (proj_dir + "WaitToDb.flag")
			close file
			MessageBox subOK_msg title:msg_title
			closeRolloutFloater srs_floater
		)
		
		local rad_button_offset = 0
		local group_cameras_offset = 0
		local group_dr_offset = 0
		local group_gi_offset = 0
		rad_button_offset = 0
		group_cameras_offset = -15
		group_dr_offset = -40
		group_gi_offset = 10
	
		fn sellectByName ddl txt = 
		(
			local names = ddl.items
			for i = 1 to names.count do
			(
				if names[i] == txt then ddl.selection = i
			)
		)
		rollout ro_common cn8 width:500 height:290
		(
			label lbl_jobname "" pos:[5,10] width:76 height:14
			Label edt_jobname "" pos:[51,9] width:429 height:17
			label lbl_version "" pos:[5,40] width:76 height:15
			label lbl_simpleframe "" pos:[5,70] width:220 height:15
			groupBox group_cameras "    " pos:[5,150] width:475 height:145		
			
			label channel_txt pos:[5,100] width:80 height:14 
			checkBox ao_channel pos:[85,100] width:14 height:14 
			label ao_channel_txt "" pos:[105,100] width:60 height:14
			checkBox caizhi_channel pos:[168,100] width:14 height:14 
			label caizhi_channel_txt "" pos:[193,100] width:100 height:14
			
			label lbl_view "" pos:[20,150] width:(68 + group_cameras_offset) height:14 align:#right
			label lbl_view2 "" pos:[15,170] width:400 height:14
			
			label lbl_sgi "" pos:[5,73] width:140 height:18
			radiobuttons sgi_buttons "" columns:7 pos:[220,73] width:200 labels:#(cn59,"1/2", "1/4","1/8") default:3

			listBox lbx_cameras "                            " pos:[15,190] width:200 height:6
			listBox lbx_cameras_rnd "                                                         " pos:[270,190] width:200 height:6
			button btn_add_camera ">>" pos:[225,224] width:35 height:21
			button btn_del_camera "<<" pos:[225,250] width:35 height:21
			fn set_cameras_btn = (
				if lbx_cameras.items.count > 0 then (
					btn_add_camera.enabled = true
				) else (
					btn_add_camera.enabled = false
				)
				if lbx_cameras_rnd.items.count > 0 then (
					btn_del_camera.enabled = true
				) else (
					btn_del_camera.enabled = false
				)
			)
			fn mv_camera lbfrom lbto = (
				local itemsfrom	= lbfrom.items
				local itemsto		= lbto.items
				local idx 			= lbfrom.selection
				local txt			= lbfrom.selected
				if itemsfrom.count < 1 or idx < 1 then (
					return undefined
				)
				deleteItem itemsfrom idx
				append itemsto txt
				sort itemsto 
				lbfrom.items	= itemsfrom
				lbto.items		= itemsto
			)
			label lbl_qos "" pos:[280,40] width:100 height:15
			dropDownList qos_opts "" pos:[340,37] width:100 height:22 items:#(cn67,cn53,cn54) selection:1
			dropDownList ddl_version "" pos:[50,37] width:80 height:22 items:#("2012","2013","2014","2015","2016","2017","2018","2019","2020") selected:3
			label lbl_qos_new "" pos:[150,40] width:100 height:15
			dropDownList qos_opts_new "" pos:[205,37] width:60 height:22 items:#("32","64","96","128","160","192","224","256","288","320") selection:1
			on ro_common open do (
				--init data
				ao_channel_txt.caption=cn60
				caizhi_channel_txt.caption=cn61
				channel_txt.caption=cn62
				lbl_sgi.caption=cn58
				lbl_version.caption =cn9
				lbl_jobname.caption = cn10
				lbl_view.caption = cn11
				lbl_view2.caption = cn12
				lbl_view2.enabled = false
				lbx_cameras.caption =cn13
				lbx_cameras_rnd.caption = cn14
				lbl_qos.caption =cn15
				lbl_qos_new.caption=cn57
				local jobname = (getFilenameFile maxFileName)
				if jobname!="" then(
					edt_jobname.text = jobname
				)else(
					edt_jobname.text ="δ.max"
				)
				local max_cameras = get_cameras()
				if max_cameras != undefined then (
					lbx_cameras.items = max_cameras
				)
				
				local max_version = get_version()
				sellectByName ddl_version max_version
				set_cameras_btn()	
			)
			
			on lbx_cameras_rnd doubleClicked itm do (
				rollout set_camera_resolution cn63 width:230 height:80
				(
					group "" (
						label lbl_camera_width "" pos:[15,16] width:40 height:17
						spinner camera_width "" pos:[55,16] width:50 height:18 range:[1,32768,1] type:#integer scale:1
						label lbl_camera_height "" pos:[125,16] width:40 height:17
						spinner camera_height "" pos:[165,16] width:50 height:18 range:[1,32768,1] type:#integer scale:1
					)
					button btn_set_ok "" pos:[90,50] width:50 height:21					
					
					on set_camera_resolution open do (
						local resetsize = false
						lbl_camera_width.caption =cn64
						lbl_camera_height.caption =cn65
						btn_set_ok.caption = cn66
						
						local currcam = lbx_cameras_rnd.selected
						for i = 1 to camera_output_sizes.count do (
							if camera_output_sizes[i].cdname == lbx_cameras_rnd.selected then (
								camera_width.value = camera_output_sizes[i].width					
								camera_height.value = camera_output_sizes[i].height
								if(camera_width.value == 0) then
									camera_width.value = renderWidth
								if(camera_height.value == 0) then
									camera_height.value = renderHeight
								resetsize = true
								exit
							)
						)
						if (resetsize == false) then (
							camera_width.value = renderWidth						
							camera_height.value = renderHeight
						)
					)
					
					on btn_set_ok pressed do (
						local ncdname = undefined
						local currcam = lbx_cameras_rnd.selected
						for i = 1 to camera_output_sizes.count do (
							if camera_output_sizes[i].cdname == lbx_cameras_rnd.selected then (
								camera_output_sizes[i].width = camera_width.value
								camera_output_sizes[i].height = camera_height.value
								ncdname = camera_output_sizes[i].cname + "(" + (camera_width.value as string) + "*" + (camera_height.value as string) + ")"
								camera_output_sizes[i].cdname = ncdname
								exit
							)
						)
						-- refresh outputs
						local fromitems = lbx_cameras_rnd.items
						local idx = lbx_cameras_rnd.selection
						local scname = lbx_cameras_rnd.selected
						if fromitems.count < 1 or idx < 1 then (
							return undefined
						)
						deleteItem fromitems idx
						append fromitems ncdname
						sort  fromitems
						lbx_cameras_rnd.items = fromitems
						DestroyDialog set_camera_resolution
					)
				)
				createDialog set_camera_resolution				
			)
			
			
			
			
			on btn_add_camera pressed do (
				local fromitems = lbx_cameras.items
				local toitems = lbx_cameras_rnd.items
				local idx = lbx_cameras.selection
				local scname = lbx_cameras.selected
				if fromitems.count < 1 or idx < 1 then (
					return undefined
				)
				local cdname = scname + "(" + cn16+ ")"
				append camera_output_sizes (CameraOutputSize cname:scname cdname:cdname width:0 height:0)
				deleteItem fromitems idx
				append toitems cdname
				sort toitems
				lbx_cameras.items = fromitems
				lbx_cameras_rnd.items = toitems
				set_cameras_btn()
			)
			on btn_del_camera pressed do (
				local fromitems = lbx_cameras_rnd.items
				local toitems = lbx_cameras.items
				local idx = lbx_cameras_rnd.selection
				local scname = lbx_cameras_rnd.selected
				if fromitems.count < 1 or idx < 1 then (
					return undefined
				)
				for i = 1 to camera_output_sizes.count do (
					if camera_output_sizes[i].cdname == scname then (
						deleteItem fromitems idx
						append toitems camera_output_sizes[i].cname
						sort toitems
						lbx_cameras.items = toitems
						lbx_cameras_rnd.items = fromitems
						deleteItem camera_output_sizes i
						exit
					)
				)
				set_cameras_btn()
			)
		)
		rollout ro_submit cn17 width:500 height:39
		(
			label lbl_prg "" pos:[10,5] width:100 height:30
			progressbar pbar_progress color:green pos:[110,5] width:250 height:20
			label lbl_prg_value "0 %" pos:[370,5] width:50 height:20
			label lbl_stat "" pos:[10,30] width:100 height:30
			label lbl_process "" pos:[110,30] width:230 height:40
			button btn_submit "" pos:[405,13] width:75 height:48
			fn set_info_with_dlg str = (
				set_info str
				messageBox str title:msg_title
			)
			on ro_submit open do (						
				lbl_process.caption = cn18
				lbl_prg.caption = cn19
				lbl_stat.caption = cn20
				btn_submit.caption = cn21
				
				if maxFileName == "" then (
					--maxFileName=".max"
					--messagebox cn22 title:msg_title
					--try(closeRolloutFloater srs_floater) catch()
					--return undefined
				)
			)
			on btn_submit pressed do (
				renderSceneDialog.close()
				prg_value = 0
				update_prg_progress prg_value
				local max_version = ro_common.ddl_version.selected
				local max_version_curr = get_version()
				local dir_exists=undefined
				local outfile = rendOutputFilename
				outfile = (get_abs outfile)
			
				if outfile == "" or (filenameFromPath_sw outfile) == "" then (
					MessageBox cn29
					return undefined
				)
				
				if (getFilenameType outfile) == "" then (
					MessageBox cn29
					return undefined
				)
				
				if((ro_common.qos_opts.selected as String)==cn67) then(
					MessageBox cn68
					return undefined
				)
			
				try (
					local ckfile = (getFilenamePath rendOutputFilename)+ "ceshi.tmp"
					local ckfs = createFile ckfile
					if(ckfs != undefined) then (
						close ckfs
						deleteFile ckfile
					)
				) catch (
					MessageBox cn29
					return undefined			
				)
				
				if (max_version as Integer) < (max_version_curr as Integer) then (
					set_info_with_dlg cn23
					return undefined
				)
				local max_cameras  = get_selected_cameras()
				local max_cameras_str=""
				if max_cameras == undefined or max_cameras.count < 1 then (
					max_cameras = #("")
				)
				else(
					for c in max_cameras do
					(
						max_cameras_str=max_cameras_str+","+(c as string)
					)
					if (max_cameras_str!="") then(
						max_cameras_str=subString max_cameras_str 2 10000
					)
				)
				

			for c in max_cameras do
			(
				if (is_valid_filename c)==false then(
					MessageBox cn55
					update_prg_progress  0
					return false
				)
			)
					
				
				local curr = renderers.current
				if (substring  (curr as string) 1 5) != "V_Ray" and (substring  (curr as string) 1 6) != "Corona" then (
					set_info_with_dlg cn24
					return undefined
				)
				local arr= #()
				local arr2= #()
				local arr3= #()
				ATSOps.GetFiles &arr
				for f in arr do(
					if ATSOps.TestFileSystemStatus f #Found then
					(
						append arr2 f
					)
					if ATSOps.TestFileSystemStatus f #Missing then
					(
						append arr3 f
					)
				)
				local str_str=""
				i=0
				for f in arr3 do(
					i=i+1
					if(i<20)then(
					
					str_str=str_str+"\n"+f
					)
				)	
				if arr3.count>0 then
				(
					if not (queryBox (cn25+(arr3.count as string)+cn26+"\n"+str_str+"...\n"+cn27) title:msg_title) then (
						set_info_with_dlg cn28
						update_prg_progress  0
						return RET_OK
					)
				)
				
				set_info cn52
				renderSceneDialog.close()
				GenerateTaskDir()
				local isrename = true
				local jobname = (getFilenameFile maxFileName)
				local renderType = (getRenderType() as string)
				if ((renderType == "selected") or (renderType == "boxselected") or (renderType == "regionselected") or (renderType == "cropselected")) and (selection.count == 0) then (
					errstr = cn30
					set_info_with_dlg errstr
					return undefined
				)
				local vrayver = ""
				local curr = renderers.current
				if (substring  (curr as string) 1 5) == "V_Ray" then (
					local verstrs = (filterString  (curr as string) ":_")							
					local ver = verstrs[verstrs.count - 2]
					local minv = substring verstrs[verstrs.count - 1] 1 1
					vrayver = ver + "." + minv
				)
				local outfile = rendOutputFilename			
				if outfile == "" or (filenameFromPath_sw outfile) == "" then (
					errstr =cn31
					set_info_with_dlg errstr
					return undefined
				)
				local outfile_tmp_path = (getFilenamePath outfile)
				local max_cameras = get_selected_cameras()
				if max_cameras == undefined or max_cameras.count < 1 then (
					max_cameras = #("")
				)
				set_info cn32
				
				if  (substring  (curr as string) 1 5) == "V_Ray" then
				(
				if (curr.output_on == true) then (
					if (curr.output_getsetsfrommax == false) then (
						renderWidth = curr.output_width
						renderHeight = curr.output_height
						curr.output_getsetsfrommax = true
					)
					if (curr.output_splitgbuffer == true) and (curr.output_splitfilename != "") and (curr.output_splitfilename != undefined) then (
						
					) else 
					(
							local b = bitmap renderWidth renderHeight
							local tp = (getFilenamePath rendoutputfilename) + (getFilenameFile rendoutputfilename) + "_bmp" + (getFilenameType rendoutputfilename)
							b.filename = tp
							save b
							close b
							deleteFile tp
							curr.output_splitgbuffer = true
							curr.output_splitbitmap = b
							curr.output_splitfilename = (getFilenamePath rendoutputfilename) + (getFilenameFile rendoutputfilename) + "_auto" + (getFilenameType rendoutputfilename)
							curr.output_splitRGB = true
							curr.output_splitAlpha = false
					)
				)
				)
				----if_vray  end
	
				prg_value +=25
				update_prg_progress prg_value
				rendUseActiveView = true
				prg_value +=10
				update_prg_progress prg_value
				local jobinfo = ""
				jobinfo += cn33	
				jobinfo += "\n" + cn34 + jobname
				local max_cameras_print = 0
				for c in max_cameras do (
					local width = renderWidth
					local height = renderHeight
					if (c == "") then (
						jobinfo += "\n"+cn35+ "[Default]" + cn36+ (width as string) + cn37 + (height as string)
					) else (
						local revcamsize = get_camera_outputsize c &width &height
						jobinfo += "\n"+cn38+ "[" + c + "]" + cn39  + (width as string) + cn40 + (height as string)
					)
					max_cameras_print += 1
				)
				max_cameras_print = 0
				for c in max_cameras do (
					if (c == "") then (
						jobinfo += "\n" +cn41+ (filenameFromPath_sw outfile)
					) else (
						jobinfo += "\n"+cn42 + (filenameFromPath_sw (getFilenamePath outfile) + (getFilenameFile outfile) + "_" + c + (getFilenameType outfile))
					)
					max_cameras_print += 1
				)
				jobinfo +="\n"+cn43
				if not (queryBox jobinfo title:msg_title) then (
					set_info_with_dlg cn44
					update_prg_progress  0
					return RET_OK
				)
				exec jobname max_cameras
				return RET_OK
			)
		)
		rollout ro_about cn49 width:500 height:25 rolledUp:true
		(
			label lbl_company "" pos:[130,15] width:400 height:25
			on ro_about open do (
				lbl_company.caption =cn47
			)
		)
		renderSceneDialog.close()
		local ec_dir =UserDir+"\\GodHorse\\"
		NewJobsDir = ec_dir +"NewJobs\\"
		if srs_floater == undefined or (not srs_floater.open) then (
			srs_floater = newRolloutFloater (cn48+ScriptVersion) 500 452
			addRollout ro_about srs_floater
			addRollout ro_common srs_floater
			addRollout ro_submit srs_floater
		)
	) catch (
		MessageBox (cn51+ getCurrentException()) title:cn50
	)
)