/*
 * Decompiled with CFR 0.152.
 */
package karob.bigtrees;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.File;
import karob.bigtrees.BlockBTSapling;
import karob.bigtrees.ItemBlockSapling;
import karob.bigtrees.KTreeCfg;
import karob.bigtrees.KTreeCfgBiomes;
import karob.bigtrees.KTreeCfgBiomes2;
import karob.bigtrees.KTreeCfgTrees;
import karob.bigtrees.KTreeDecorate;
import karob.bigtrees.KWorldGenBigTree;
import karob.bigtrees.KWorldGenCyprusTree;
import karob.bigtrees.KWorldGenHatTree;
import karob.bigtrees.KWorldGenTallTree;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;

@Mod(modid="bigtrees", name="BigTrees", version="1.6.4")
public class mod_BigTrees {
    protected KWorldGenBigTree kWorldGenBigTree;
    protected KWorldGenCyprusTree kWorldGenCyprusTree;
    protected KWorldGenHatTree kWorldGenHatTree;
    protected KWorldGenTallTree kWorldGenTallTree;
    public File config;
    public String configDir;
    @Mod.Instance(value="bigtrees")
    public static mod_BigTrees instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
        this.configDir = event.getModConfigurationDirectory() + File.separator + "bigtrees";
        KTreeCfg.init(this.configDir);
        mod_BigTrees.registerBlock(new BlockBTSapling().func_149663_c("bt_bigSapling"), ItemBlockSapling.class);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        GameRegistry.addRecipe((ItemStack)new ItemStack(GameRegistry.findBlock((String)"bigtrees", (String)"bt_bigSapling"), 1, 0), (Object[])new Object[]{"#", "X", "X", Character.valueOf('#'), new ItemStack(Blocks.field_150345_g, 1, 0), Character.valueOf('X'), new ItemStack(Blocks.field_150364_r, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(GameRegistry.findBlock((String)"bigtrees", (String)"bt_bigSapling"), 1, 1), (Object[])new Object[]{"#", "X", "X", Character.valueOf('#'), new ItemStack(Blocks.field_150345_g, 1, 2), Character.valueOf('X'), new ItemStack(Blocks.field_150364_r, 1, 2)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(GameRegistry.findBlock((String)"bigtrees", (String)"bt_bigSapling"), 1, 2), (Object[])new Object[]{"#", "X", "X", Character.valueOf('#'), new ItemStack(Blocks.field_150345_g, 1, 1), Character.valueOf('X'), new ItemStack(Blocks.field_150364_r, 1, 1)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(GameRegistry.findBlock((String)"bigtrees", (String)"bt_bigSapling"), 1, 4), (Object[])new Object[]{" # ", " X ", "X X", Character.valueOf('#'), new ItemStack(Blocks.field_150345_g, 1, 1), Character.valueOf('X'), new ItemStack(Blocks.field_150364_r, 1, 1)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(GameRegistry.findBlock((String)"bigtrees", (String)"bt_bigSapling"), 1, 3), (Object[])new Object[]{"###", " X ", " X ", Character.valueOf('#'), Items.field_151055_y, Character.valueOf('X'), new ItemStack(Blocks.field_150364_r, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(GameRegistry.findBlock((String)"bigtrees", (String)"bt_bigSapling"), 1, 5), (Object[])new Object[]{" # ", "#X#", Character.valueOf('#'), new ItemStack(Blocks.field_150345_g, 1, 0), Character.valueOf('X'), new ItemStack(Blocks.field_150364_r, 1, 0)});
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        BiomeDictionary.registerAllBiomesAndGenerateEvents();
        this.config = new File(this.configDir + File.separator + "treeconfigs");
        this.config.mkdir();
        KTreeCfgTrees.init(this.config);
        this.config = new File(this.configDir, "biomegroups.cfg");
        KTreeCfgBiomes.init(this.config);
        this.config = new File(this.configDir, "individualbiomes.cfg");
        KTreeCfgBiomes2.init(this.config);
        this.kWorldGenBigTree = new KWorldGenBigTree(false);
        this.kWorldGenCyprusTree = new KWorldGenCyprusTree(false);
        this.kWorldGenHatTree = new KWorldGenHatTree(false);
        this.kWorldGenTallTree = new KWorldGenTallTree(false);
    }

    @SubscribeEvent
    public boolean decorate(DecorateBiomeEvent.Decorate evt) {
        boolean verity = false;
        if (evt.type == DecorateBiomeEvent.Decorate.EventType.TREE) {
            int posX = evt.chunkX;
            int posY = evt.chunkZ;
            int seed = (int)evt.world.func_72905_C();
            BiomeGenBase biome = evt.world.func_72959_q().func_76935_a(posX + 16, posY + 16);
            int x = posX + evt.rand.nextInt(16) + 8;
            int z = posY + evt.rand.nextInt(16) + 8;
            int y = evt.world.func_72976_f(x, z);
            if (!KTreeCfg.passRealm(evt.world.field_73011_w.field_76574_g)) {
                return true;
            }
            verity = KTreeDecorate.decorate(evt.world, evt.rand, posX, posY, biome);
        }
        return verity;
    }

    public static void registerBlock(Block b, String name) {
        GameRegistry.registerBlock((Block)b, (String)b.func_149739_a());
        LanguageRegistry.addName((Object)b, (String)name);
    }

    public static void registerBlock(Block block, Class<? extends ItemBlock> itemBlockClass) {
        GameRegistry.registerBlock((Block)block, itemBlockClass, (String)block.func_149739_a().replace("tile.", ""));
    }
}

