/*
 * Decompiled with CFR 0.152.
 */
package karob.bigtrees;

import java.util.Random;
import karob.bigtrees.KTreeCfg;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class KWorldGenTallTree
extends WorldGenerator {
    World wo;
    Random rand;
    private int[][][] check;
    private boolean planted;
    private Block tallWoodBlock;
    private Block tallLeafBlock;
    private Block tallBaseBlock1;
    private Block tallBaseBlock2;
    private int woodMeta;
    private int leafMeta;
    private int heightmin;
    private int heightmax;
    private int stuntmin;
    private double branchlessmin;
    private double branchlessmax;
    private double longestbranchp;
    private double branchrot;
    private double taplength;
    private double branchspace;
    private double pitch;
    private double curl;
    private int leafrad;
    private double subbranchdensity;
    private double subbranchinglength;
    private int subbranchingsize;
    private double subbranchangle;
    private double subbranchsize;

    public KWorldGenTallTree(boolean flag) {
        super(flag);
        this.planted = flag;
        this.check = new int[9][9][9];
    }

    void setConfigOptions(Block wood, Block leaf, int woodmeta, int leafmeta, Block Base1, Block Base2, int height1, int height2, int stunt, double branchlessmin1, double branchlessmax1, double longestbranchp1, double branchrot1, double taplength1, double branchspace1, double pitch1, double curl1, int leafrad1, double subbranchdensity1, double subbranchinglength1, int subbranchingsize1, double subbranchangle1, double subbranchsize1) {
        this.tallWoodBlock = wood;
        this.tallLeafBlock = leaf;
        this.tallBaseBlock1 = Base1;
        this.tallBaseBlock2 = Base2;
        this.woodMeta = woodmeta;
        this.leafMeta = leafmeta;
        this.heightmin = height1;
        this.heightmax = height2;
        this.stuntmin = stunt;
        this.branchlessmin = branchlessmin1;
        this.branchlessmax = branchlessmax1;
        this.longestbranchp = longestbranchp1;
        this.branchrot = branchrot1;
        this.taplength = taplength1;
        this.branchspace = branchspace1;
        this.pitch = pitch1;
        this.curl = curl1;
        this.leafrad = leafrad1;
        this.subbranchdensity = subbranchdensity1;
        this.subbranchinglength = subbranchinglength1;
        this.subbranchingsize = subbranchingsize1;
        this.subbranchangle = subbranchangle1;
        this.subbranchsize = subbranchsize1;
    }

    void setBlock(int par1, int par2, int par3, Block par4) {
        try {
            this.wo.func_147465_d(par1, par2, par3, par4, 0, 3);
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    void setBlockAndMetadata(int par1, int par2, int par3, Block par4, int par5) {
        try {
            this.wo.func_147465_d(par1, par2, par3, par4, par5, 3);
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    Block getBlock(int par1, int par2, int par3) {
        try {
            return this.wo.func_147439_a(par1, par2, par3);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        Block zz;
        int ll;
        Block id;
        this.wo = world;
        this.rand = random;
        int l = random.nextInt(this.heightmax - this.heightmin) + this.heightmin;
        if (j < 1) {
            return false;
        }
        if (j + l + 1 > 256 && (l = 256 - j - 2) < this.stuntmin) {
            return false;
        }
        if (!this.planted) {
            if (this.tallBaseBlock1 != Blocks.field_150350_a || this.tallBaseBlock2 != Blocks.field_150350_a) {
                boolean flag = false;
                id = this.getBlock(i, j - 1, k);
                if (this.tallBaseBlock1 != Blocks.field_150350_a && id == this.tallBaseBlock1) {
                    flag = true;
                }
                if (this.tallBaseBlock2 != Blocks.field_150350_a && id == this.tallBaseBlock2) {
                    flag = true;
                }
                if (!flag) {
                    return false;
                }
            }
            if ((id = this.getBlock(i, j, k)) != Blocks.field_150350_a && id != this.tallLeafBlock) {
                return false;
            }
        }
        for (ll = 0; ll <= l && ((zz = this.getBlock(i, j + ll, k)) == Blocks.field_150350_a || zz == this.tallWoodBlock || zz == this.tallLeafBlock); ++ll) {
        }
        if (ll < this.stuntmin) {
            return false;
        }
        int zzz = random.nextInt((int)(100.0 * (this.branchlessmax - this.branchlessmin) + this.branchlessmin));
        int m = l * zzz / 100 + j;
        id = this.getBlock(i, j - 1, k);
        if (!this.planted && this.tallBaseBlock1 != Blocks.field_150350_a && id == this.tallBaseBlock2) {
            this.setBlock(i, j - 1, k, this.tallBaseBlock1);
        }
        this.setBlockAndMetadata(i, j, k, this.tallWoodBlock, this.woodMeta);
        if (KTreeCfg.rootsEnable) {
            int jj = 1;
            while ((double)jj < (double)ll * this.taplength / 100.0 && ((zz = this.getBlock(i, j - jj, k)) == Blocks.field_150350_a || zz == this.tallWoodBlock || zz == this.tallLeafBlock || zz == Blocks.field_150349_c || zz == Blocks.field_150346_d || zz == Blocks.field_150358_i || zz == Blocks.field_150355_j || zz == Blocks.field_150354_m || zz == Blocks.field_150351_n)) {
                this.setBlockAndMetadata(i, j - jj, k, this.tallWoodBlock, this.woodMeta);
                ++jj;
            }
        }
        double bd = (double)random.nextFloat() * 2.0 * Math.PI;
        boolean growflag = true;
        int jj = j;
        for (int j1 = j; j1 <= j + l; ++j1) {
            int branchs;
            if (growflag) {
                id = this.getBlock(i, jj + 1, k);
                if (id == Blocks.field_150350_a || id == this.tallWoodBlock || id == this.tallLeafBlock) {
                    this.setBlockAndMetadata(i, ++jj, k, this.tallWoodBlock, this.woodMeta);
                } else {
                    growflag = false;
                }
            }
            if ((branchs = (int)(100.0 * this.branchspace)) < 0) {
                branchs = 0;
            }
            if (j1 >= m && random.nextInt(branchs) < 100 * (j1 - m) / (j + l - m + 1)) {
                double bl = (double)l * this.longestbranchp;
                bl = bl * (double)(j + l - jj + 1) / (double)(j + l - m + 1);
                this.treeBranch(i, jj, k, bd, bl, this.pitch, this.curl);
            }
            bd += this.branchrot;
            if (j1 != j + l || this.leafrad <= 0) continue;
            this.treeLeaf(i, jj, k, this.leafrad);
        }
        return true;
    }

    void treeBranch(int i, int j, int k, double dir, double len, double up, double crv) {
        double ll;
        if (len < 1.0) {
            return;
        }
        double xx = Math.cos(dir);
        double yy = up;
        double zz = Math.sin(dir);
        double dd = Math.sqrt(xx * xx + yy * yy + zz * zz);
        int xpol = xx > 0.0 ? 1 : -1;
        int ypol = yy > 0.0 ? 1 : -1;
        int zpol = zz > 0.0 ? 1 : -1;
        xx = Math.abs(xx) / dd;
        yy = Math.abs(yy) / dd;
        zz = Math.abs(zz) / dd;
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        int ii = i;
        int jj = j;
        int kk = k;
        for (ll = len; ll > 0.0; ll -= 1.0) {
            boolean chg = false;
            if ((dx += xx) >= 1.0) {
                ii += xpol;
                dx -= 1.0;
                chg = true;
            }
            if ((dy += yy) >= 1.0) {
                jj += ypol;
                dy -= 1.0;
                chg = true;
            }
            if ((dz += zz) >= 1.0) {
                kk += zpol;
                dz -= 1.0;
                chg = true;
            }
            if (chg) {
                Block id = this.getBlock(ii, jj, kk);
                if (id != Blocks.field_150350_a && id != this.tallWoodBlock && id != this.tallLeafBlock) break;
                this.setBlockAndMetadata(ii, jj, kk, this.tallWoodBlock, this.woodMeta);
            }
            if ((double)this.rand.nextInt(100) < this.subbranchdensity && len >= (double)this.subbranchingsize && ll < len * this.subbranchinglength) {
                if (this.rand.nextInt(10) < 5) {
                    this.treeBranch(ii, jj, kk, dir + this.subbranchangle, ll * this.subbranchsize, yy, crv);
                } else {
                    this.treeBranch(ii, jj, kk, dir - this.subbranchangle, ll * this.subbranchsize, yy, crv);
                }
            }
            xx = Math.cos(dir);
            yy = up += crv;
            zz = Math.sin(dir);
            dd = Math.sqrt(xx * xx + yy * yy + zz * zz);
            xpol = xx > 0.0 ? 1 : -1;
            ypol = yy > 0.0 ? 1 : -1;
            zpol = zz > 0.0 ? 1 : -1;
            xx = Math.abs(xx) / dd;
            yy = Math.abs(yy) / dd;
            zz = Math.abs(zz) / dd;
        }
        if (ll <= len / 2.0 && this.leafrad > 0) {
            int klen = (int)(len / 2.0);
            if (klen >= this.leafrad) {
                this.treeLeaf(ii, jj, kk, this.leafrad);
            } else if (klen >= 1) {
                this.treeLeaf(ii, jj, kk, klen);
            } else {
                this.treeLeaf(ii, jj, kk, 1);
            }
        }
    }

    void treeLeaf(int i, int j, int k, int r) {
        if (r <= 0) {
            return;
        }
        if (r <= 3) {
            for (int ii = -r - 1; ii <= r + 1; ++ii) {
                for (int jj = -2; jj <= r + 1; ++jj) {
                    for (int kk = -r - 1; kk <= r + 1; ++kk) {
                        Block zz = this.getBlock(i + ii, j + jj, k + kk);
                        this.check[ii + 4][jj + 4][kk + 4] = zz == Blocks.field_150350_a ? 2 : (zz == this.tallLeafBlock ? 1 : 0);
                    }
                }
            }
            this.leafShell(i, j, k, 1);
            if (r >= 2) {
                this.leafShell(i, j, k, 2);
            }
            if (r == 3) {
                this.leafShell(i, j, k, 3);
            }
        } else {
            int rr = r * r;
            for (int ii = -r; ii <= r; ++ii) {
                for (int jj = -r / 2; jj <= r; ++jj) {
                    for (int kk = -r; kk <= r; ++kk) {
                        if (ii * ii + jj * jj + kk * kk > rr || this.getBlock(i + ii, j + jj, k + kk) != Blocks.field_150350_a || this.rand.nextInt(3) != 0) continue;
                        this.setBlockAndMetadata(i + ii, j + jj, k + kk, this.tallLeafBlock, this.leafMeta);
                    }
                }
            }
        }
    }

    void leafShell(int i, int j, int k, int r) {
        int rr = r * r + 1;
        int rrr = (r - 1) * (r - 1);
        for (int ii = 0; ii <= r; ++ii) {
            for (int jj = 0; jj <= r; ++jj) {
                for (int kk = 0; kk <= r; ++kk) {
                    int zz = ii * ii + jj * jj + kk * kk;
                    if (zz > rr || zz <= rrr) continue;
                    this.plotLeaf(i, j, k, ii, jj, kk, r);
                    this.plotLeaf(i, j, k, ii, jj, -kk, r);
                    this.plotLeaf(i, j, k, -ii, jj, kk, r);
                    this.plotLeaf(i, j, k, -ii, jj, -kk, r);
                    if (jj < 1) {
                        this.plotLeaf(i, j, k, ii, -jj, kk, r);
                        this.plotLeaf(i, j, k, ii, -jj, -kk, r);
                        this.plotLeaf(i, j, k, -ii, -jj, kk, r);
                        this.plotLeaf(i, j, k, -ii, -jj, -kk, r);
                        continue;
                    }
                    if (jj != 1) continue;
                    if (this.rand.nextInt(3) > 0) {
                        this.plotLeaf(i, j, k, ii, -jj, kk, r);
                    }
                    if (this.rand.nextInt(3) > 0) {
                        this.plotLeaf(i, j, k, ii, -jj, -kk, r);
                    }
                    if (this.rand.nextInt(3) > 0) {
                        this.plotLeaf(i, j, k, -ii, -jj, kk, r);
                    }
                    if (this.rand.nextInt(3) <= 0) continue;
                    this.plotLeaf(i, j, k, -ii, -jj, -kk, r);
                }
            }
        }
    }

    void plotLeaf(int i, int j, int k, int ii, int jj, int kk, int r) {
        if (this.check[ii + 4][jj + 4][kk + 4] != 2) {
            return;
        }
        boolean flag = false;
        if (r == 1) {
            flag = true;
        } else {
            if (this.check[ii + 3][jj + 4][kk + 4] == 1) {
                flag = true;
            }
            if (this.check[ii + 5][jj + 4][kk + 4] == 1) {
                flag = true;
            }
            if (this.check[ii + 4][jj + 3][kk + 4] == 1) {
                flag = true;
            }
            if (this.check[ii + 4][jj + 5][kk + 4] == 1) {
                flag = true;
            }
            if (this.check[ii + 4][jj + 4][kk + 3] == 1) {
                flag = true;
            }
            if (this.check[ii + 4][jj + 4][kk + 5] == 1) {
                flag = true;
            }
            if (this.check[ii + 3][jj + 3][kk + 4] == 1) {
                flag = true;
            }
            if (this.check[ii + 3][jj + 5][kk + 4] == 1) {
                flag = true;
            }
            if (this.check[ii + 3][jj + 4][kk + 3] == 1) {
                flag = true;
            }
            if (this.check[ii + 3][jj + 4][kk + 5] == 1) {
                flag = true;
            }
            if (this.check[ii + 5][jj + 3][kk + 4] == 1) {
                flag = true;
            }
            if (this.check[ii + 5][jj + 5][kk + 4] == 1) {
                flag = true;
            }
            if (this.check[ii + 5][jj + 4][kk + 3] == 1) {
                flag = true;
            }
            if (this.check[ii + 5][jj + 4][kk + 5] == 1) {
                flag = true;
            }
            if (this.check[ii + 4][jj + 3][kk + 3] == 1) {
                flag = true;
            }
            if (this.check[ii + 4][jj + 3][kk + 5] == 1) {
                flag = true;
            }
            if (this.check[ii + 4][jj + 5][kk + 3] == 1) {
                flag = true;
            }
            if (this.check[ii + 4][jj + 5][kk + 5] == 1) {
                flag = true;
            }
        }
        if (flag) {
            this.setBlockAndMetadata(i + ii, j + jj, k + kk, this.tallLeafBlock, this.leafMeta);
            this.check[ii + 4][jj + 4][kk + 4] = 1;
        }
    }
}

