/*
 * Decompiled with CFR 0.152.
 */
package karob.bigtrees;

import java.util.Random;
import karob.bigtrees.KTreeCfg;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class KWorldGenBigTree
extends WorldGenerator {
    static final byte[] otherCoordPairs = new byte[]{2, 0, 0, 1, 2, 1};
    Random rand;
    int rootRand = 0;
    int rootAlt = 0;
    int tapRootRand = 0;
    World worldObj;
    int[] basePos = new int[]{0, 0, 0};
    int heightLimit = 0;
    int height;
    double heightAttenuation = 0.318;
    double field_875_h = 1.0;
    double field_874_i = 0.681;
    double field_873_j = 1.0;
    double field_872_k = 1.0;
    int trunkSize = 1;
    int heightLimitLimit = 12;
    int leafDistanceLimit = 4;
    int[][] leafNodes;
    int type = 0;
    Block trunkBlock;
    private int trunkMeta;
    Block leafBlock;
    private int leafMeta;
    private int stuntmin;
    private int heightmin;
    private int heightmax;

    public KWorldGenBigTree(boolean flag) {
        super(flag);
        this.rand = new Random();
    }

    void setConfigOptions(Block wood, Block leaf, int woodmeta, int leafmeta, Block Base1, Block Base2, int height1, int height2, int stunt) {
        this.trunkBlock = wood;
        this.leafBlock = leaf;
        this.trunkMeta = woodmeta;
        this.leafMeta = leafmeta;
        this.heightmin = height1;
        this.heightmax = height2;
        this.stuntmin = stunt;
    }

    void setBlockAndMetadata(int par1, int par2, int par3, Block par4, int par5) {
        try {
            this.worldObj.func_147465_d(par1, par2, par3, par4, par5, 3);
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    Block getBlock(int par1, int par2, int par3) {
        try {
            return this.worldObj.func_147439_a(par1, par2, par3);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private boolean generateLeafNodeList() {
        int i;
        this.height = (int)((double)this.heightLimit * this.heightAttenuation);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        if (this.basePos[1] + this.heightLimit > 252) {
            this.height /= 2;
            this.heightLimit /= 2;
            if (this.height >= this.heightLimit) {
                this.height = this.heightLimit - 1;
            }
            if (this.height < 1) {
                return false;
            }
            if (this.basePos[1] + this.heightLimit > 252) {
                return false;
            }
        }
        if ((i = (int)(1.382 + Math.pow(this.field_872_k * (double)this.heightLimit / 13.0, 2.0))) < 1) {
            i = 1;
        }
        int[][] ai = new int[i * this.heightLimit][4];
        int j = this.basePos[1] + this.heightLimit - this.leafDistanceLimit;
        int k = 1;
        int l = this.basePos[1] + this.height;
        int i1 = j - this.basePos[1];
        ai[0][0] = this.basePos[0];
        ai[0][1] = j--;
        ai[0][2] = this.basePos[2];
        ai[0][3] = l;
        while (i1 >= 0) {
            int j1 = 0;
            float f = this.func_528_a(i1);
            if (k >= i * this.heightLimit) {
                f = -1.0f;
            }
            if (f < 0.0f) {
                --j;
                --i1;
                continue;
            }
            double d = 0.5;
            while (j1 < i) {
                double d1 = this.field_873_j * ((double)f * ((double)this.rand.nextFloat() + 0.328));
                double d2 = (double)this.rand.nextFloat() * 2.0 * 3.14159;
                int k1 = MathHelper.func_76128_c((double)(d1 * Math.sin(d2) + (double)this.basePos[0] + d));
                int l1 = MathHelper.func_76128_c((double)(d1 * Math.cos(d2) + (double)this.basePos[2] + d));
                int[] ai1 = new int[]{k1, j, l1};
                int[] ai2 = new int[]{k1, j + this.leafDistanceLimit, l1};
                if (this.checkBlockLine(ai1, ai2) == -1) {
                    int[] ai3 = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
                    ai3[1] = l;
                    if (this.checkBlockLine(ai3, ai1) == -1) {
                        ai[k][0] = k1;
                        ai[k][1] = j;
                        ai[k][2] = l1;
                        ai[k][3] = ai3[1];
                        ++k;
                    }
                }
                ++j1;
            }
            --j;
            --i1;
        }
        this.leafNodes = new int[k][4];
        System.arraycopy(ai, 0, this.leafNodes, 0, k);
        return true;
    }

    void func_523_a(int i, int j, int k, float f, byte byte0) {
        int i1 = (int)((double)f + 0.618);
        byte byte1 = otherCoordPairs[byte0];
        byte byte2 = otherCoordPairs[byte0 + 3];
        int[] ai = new int[]{i, j, k};
        int[] ai1 = new int[]{0, 0, 0};
        int k1 = -i1;
        ai1[byte0] = ai[byte0];
        for (int j1 = -i1; j1 <= i1; ++j1) {
            ai1[byte1] = ai[byte1] + j1;
            int l1 = -i1;
            while (l1 <= i1) {
                double d = Math.sqrt(Math.pow((double)Math.abs(j1) + 0.5, 2.0) + Math.pow((double)Math.abs(l1) + 0.5, 2.0));
                if (d > (double)f) {
                    ++l1;
                    continue;
                }
                ai1[byte2] = ai[byte2] + l1;
                Block i2 = this.getBlock(ai1[0], ai1[1], ai1[2]);
                if (i2 != Blocks.field_150350_a && i2 != Blocks.field_150362_t) {
                    ++l1;
                    continue;
                }
                this.setBlockAndMetadata(ai1[0], ai1[1], ai1[2], this.leafBlock, this.leafMeta);
                ++l1;
            }
        }
    }

    float func_528_a(int i) {
        if (this.trunkSize == 0) {
            return (float)this.heightLimit - this.rand.nextFloat();
        }
        if (this.trunkSize != 3 && this.trunkSize > 1 && this.rand.nextFloat() > 0.7f) {
            return -1.618f;
        }
        if (this.trunkSize == 3 && (double)i < (double)this.heightLimit * 0.19999999999999998) {
            return -1.618f;
        }
        if (this.trunkSize < 3 && (double)i < (double)this.heightLimit * 0.3) {
            return -1.618f;
        }
        if (this.trunkSize == 4 && (double)i < (double)this.heightLimit * 0.16) {
            return -1.618f;
        }
        float f = (float)this.heightLimit / 2.0f;
        float f1 = (float)this.heightLimit / 2.0f - (float)i;
        float f2 = f1 == 0.0f ? f : (Math.abs(f1) >= f ? 0.0f : (float)Math.sqrt(Math.pow(Math.abs(f), 2.0) - Math.pow(Math.abs(f1), 2.0)));
        return f2 *= 0.5f;
    }

    float func_526_b(int i) {
        if (i < 0 || i >= this.leafDistanceLimit) {
            return -1.0f;
        }
        return i != 0 && i != this.leafDistanceLimit - 1 ? 3.0f : 2.0f;
    }

    void generateLeafNode(int i, int j, int k) {
        int i1 = j + this.leafDistanceLimit;
        for (int l = j; l < i1; ++l) {
            float f = this.func_526_b(l - j);
            this.func_523_a(i, l, k, f, (byte)1);
        }
    }

    void placeBlockLine(int[] ai, int[] ai1) {
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (int k = 0; k != l; k += byte3) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            this.setBlockAndMetadata(ai3[0], ai3[1], ai3[2], this.trunkBlock, this.trunkMeta);
        }
    }

    void generateLeaves() {
        int j = this.leafNodes.length;
        for (int i = 0; i < j; ++i) {
            int k = this.leafNodes[i][0];
            int l = this.leafNodes[i][1];
            int i1 = this.leafNodes[i][2];
            this.generateLeafNode(k, l, i1);
        }
    }

    boolean leafNodeNeedsBase(int i) {
        if (this.trunkSize != 2) {
            return true;
        }
        return (double)i >= (double)this.heightLimit * 0.2;
    }

    void generateTrunk() {
        int i = this.basePos[0];
        int j = this.basePos[1];
        int k = this.basePos[1] + this.height + 2;
        int l = this.basePos[2];
        int[] ai = new int[]{i, j, l};
        int[] ai1 = new int[]{i, k, l};
        if (this.trunkSize == 1) {
            this.placeBlockLine(ai, ai1);
        }
        if (this.trunkSize == 2) {
            this.rootAlt = 0;
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.growRoot(ai[0], ai[1] - 2, ai[2], 0.625, -0.0625);
            this.rootAlt = 1;
            this.growRoot(ai[0], ai[1], ai[2], 0.7125, -0.0625);
            this.placeBlockLine(ai, ai1);
            ai[0] = ai[0] + 1;
            ai1[0] = ai1[0] + 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.growRoot(ai[0], ai[1], ai[2], 0.7875, -0.0625);
            this.growRoot(ai[0], ai[1] - 2, ai[2], 0.875, -0.0625);
            this.rootAlt = 1;
            this.growRoot(ai[0], ai[1], ai[2], 0.9625, -0.0625);
            this.placeBlockLine(ai, ai1);
            ai[2] = ai[2] + 1;
            ai1[2] = ai1[2] + 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.growRoot(ai[0], ai[1], ai[2], 0.0375, -0.0625);
            this.growRoot(ai[0], ai[1] - 2, ai[2], 0.125, -0.0625);
            this.rootAlt = 1;
            this.growRoot(ai[0], ai[1], ai[2], 0.2125, -0.0625);
            this.placeBlockLine(ai, ai1);
            ai[0] = ai[0] - 1;
            ai1[0] = ai1[0] - 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.growRoot(ai[0], ai[1], ai[2], 0.2875, -0.0625);
            this.growRoot(ai[0], ai[1] - 2, ai[2], 0.375, -0.0625);
            this.rootAlt = 1;
            this.growRoot(ai[0], ai[1], ai[2], 0.4625, -0.0625);
            this.placeBlockLine(ai, ai1);
            this.growRoot(ai[0], ai[1], ai[2] - 1, 0.5375, -0.0625);
        }
        if (this.trunkSize == 3) {
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.placeBlockLine(ai, ai1);
            ai[0] = ai[0] + 1;
            ai1[0] = ai1[0] + 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.placeBlockLine(ai, ai1);
            ai[2] = ai[2] + 1;
            ai1[2] = ai1[2] + 1;
            ai[0] = ai[0] - 1;
            ai1[0] = ai1[0] - 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.placeBlockLine(ai, ai1);
            ai[2] = ai[2] - 1;
            ai1[2] = ai1[2] - 1;
            ai[0] = ai[0] - 1;
            ai1[0] = ai1[0] - 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.placeBlockLine(ai, ai1);
            ai[2] = ai[2] - 1;
            ai1[2] = ai1[2] - 1;
            ai[0] = ai[0] + 1;
            ai1[0] = ai1[0] + 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.placeBlockLine(ai, ai1);
        }
        if (this.trunkSize == 4) {
            this.rootAlt = 10;
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.growRoot(ai[0], ai[1] + 1, ai[2], 0.625, -0.0625);
            ai[0] = ai[0] + 1;
            ai1[0] = ai1[0] + 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.growRoot(ai[0], ai[1] + 1, ai[2], 0.875, -0.0625);
            ai[2] = ai[2] + 1;
            ai1[2] = ai1[2] + 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.growRoot(ai[0], ai[1] + 1, ai[2], 0.125, -0.0625);
            ai[0] = ai[0] - 1;
            ai1[0] = ai1[0] - 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 1.0);
            this.growRoot(ai[0], ai[1] + 1, ai[2], 0.375, -0.0625);
            ai[0] = ai[0] - 1;
            ai1[0] = ai1[0] - 1;
            ai[2] = ai[2] - 1;
            ai1[2] = ai1[2] - 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 0.5);
            this.growRoot(ai[0], ai[1] + 1, ai[2], 0.55, -0.0625);
            this.placeBlockLine(ai, ai1);
            ai[0] = ai[0] + 1;
            ai1[0] = ai1[0] + 1;
            ai[2] = ai[2] - 1;
            ai1[2] = ai1[2] - 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 0.5);
            this.growRoot(ai[0], ai[1] + 1, ai[2], 0.7, -0.0625);
            this.placeBlockLine(ai, ai1);
            ai[0] = ai[0] + 1;
            ai1[0] = ai1[0] + 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 0.5);
            this.growRoot(ai[0], ai[1] + 1, ai[2], 0.8, -0.0625);
            this.placeBlockLine(ai, ai1);
            ai[0] = ai[0] + 1;
            ai1[0] = ai1[0] + 1;
            ai[2] = ai[2] + 1;
            ai1[2] = ai1[2] + 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 0.5);
            this.growRoot(ai[0], ai[1] + 1, ai[2], 0.95, -0.0625);
            this.placeBlockLine(ai, ai1);
            ai[2] = ai[2] + 1;
            ai1[2] = ai1[2] + 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 0.5);
            this.growRoot(ai[0], ai[1] + 1, ai[2], 0.05, -0.0625);
            this.placeBlockLine(ai, ai1);
            ai[0] = ai[0] - 1;
            ai1[0] = ai1[0] - 1;
            ai[2] = ai[2] + 1;
            ai1[2] = ai1[2] + 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 0.5);
            this.growRoot(ai[0], ai[1] + 1, ai[2], 0.2, -0.0625);
            this.placeBlockLine(ai, ai1);
            ai[0] = ai[0] - 1;
            ai1[0] = ai1[0] - 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 0.5);
            this.growRoot(ai[0], ai[1] + 1, ai[2], 0.3, -0.0625);
            this.placeBlockLine(ai, ai1);
            ai[0] = ai[0] - 1;
            ai1[0] = ai1[0] - 1;
            ai[2] = ai[2] - 1;
            ai1[2] = ai1[2] - 1;
            this.growTapRoot(ai[0], ai[1], ai[2], 0.5);
            this.growRoot(ai[0], ai[1] + 1, ai[2], 0.45, -0.0625);
            this.placeBlockLine(ai, ai1);
        }
    }

    private int getMedium(int i, int j, int k) {
        int m;
        Block[] canGrowOpen = new Block[]{Blocks.field_150350_a, Blocks.field_150345_g, Blocks.field_150358_i, Blocks.field_150355_j, Blocks.field_150356_k, Blocks.field_150353_l, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150362_t, Blocks.field_150361_u};
        Block[] canGrowSolid = new Block[]{Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150354_m, Blocks.field_150351_n};
        Block qq = this.getBlock(i, j, k);
        int medium = 0;
        for (m = 0; m < canGrowOpen.length; ++m) {
            if (qq != canGrowOpen[m]) continue;
            medium = 1;
            break;
        }
        if (medium == 0) {
            for (m = 0; m < canGrowSolid.length; ++m) {
                if (qq != canGrowSolid[m]) continue;
                medium = 2;
                break;
            }
        }
        return medium;
    }

    void growTapRoot(int i, int j, int k, double flen) {
        int jj;
        if (!KTreeCfg.rootsEnable) {
            return;
        }
        int len = (int)((6.0 + (double)this.rand.nextFloat() * 6.0) * flen);
        if (len == this.tapRootRand || len == this.tapRootRand + 1 || len == this.tapRootRand - 1) {
            len = (int)((6.0 + (double)this.rand.nextFloat() * 6.0) * flen);
        }
        for (jj = 1; jj <= len; ++jj) {
            int med = this.getMedium(i, j - jj, k);
            if (med == 1) {
                --len;
                continue;
            }
            if (med != 0) continue;
            len = Math.min(len, jj - 1);
            break;
        }
        this.tapRootRand = len;
        for (jj = 1; jj <= len; ++jj) {
            this.setBlockAndMetadata(i, j - jj, k, this.trunkBlock, this.trunkMeta);
        }
    }

    void growRoot(int l, int m, int n, double theta, double phi) {
        if (!KTreeCfg.rootsEnable) {
            return;
        }
        if (this.rootAlt == 1) {
            this.rootRand = this.rand.nextInt(2);
            m -= this.rootRand;
            this.rootAlt = 2;
        } else if (this.rootAlt == 2) {
            if (this.rootRand == 0) {
                --m;
            }
            this.rootAlt = 0;
        } else if (this.rootAlt == 10) {
            m -= this.rand.nextInt(2);
        }
        ++m;
        double direction = Math.PI * 2 * (theta += (double)this.rand.nextFloat() * 0.1 - 0.05);
        double curl = this.rand.nextFloat() * 0.4f - 0.2f;
        double pitch = Math.PI * 2 * (phi -= (double)this.rand.nextFloat() * 0.05);
        int length = 2 + 3 * this.trunkSize + this.rand.nextInt(2);
        double x = l > 0 ? (double)l + 0.5 : (double)l - 0.5;
        double y = (double)m + 0.5;
        double z = n > 0 ? (double)n + 0.5 : (double)n - 0.5;
        int i = (int)x;
        int j = (int)y;
        int k = (int)z;
        int med = this.getMedium(i, j, k);
        int cnt = 0;
        while ((double)length > 0.0) {
            --length;
            curl = curl + (double)(this.rand.nextFloat() * 0.06f) - (double)0.03f;
            pitch = med == 1 ? (pitch + 1.5707963267948966) * 0.7 - 1.5707963267948966 : (pitch + 1.5707963267948966) * 0.9 - 1.5707963267948966;
            double hoz = Math.cos(pitch);
            double x2 = x + Math.cos(direction) * hoz;
            double y2 = y + Math.sin(pitch);
            double z2 = z + Math.sin(direction) * hoz;
            int i2 = (int)x2;
            int j2 = (int)y2;
            int k2 = (int)z2;
            if (i2 == i && j2 == j && k2 == k) continue;
            this.setBlockAndMetadata(i, j, k, this.trunkBlock, this.trunkMeta);
            if (++cnt < 4 && (j2 != j - 1 || i2 != i || k2 != k)) {
                this.setBlockAndMetadata(i, j - 1, k, this.trunkBlock, this.trunkMeta);
            }
            if ((med = this.getMedium(i2, j2, k2)) != 0) {
                x = x2;
                y = y2;
                z = z2;
                i = i2;
                j = j2;
                k = k2;
                continue;
            }
            med = this.getMedium(i, j - 1, k);
            if (med != 0) {
                y -= 1.0;
                --j;
                pitch = -1.5707963267948966;
                continue;
            }
            x2 = x + Math.cos(direction);
            i2 = (int)x2;
            med = this.getMedium(i2, j, k2 = (int)(z2 = z + Math.sin(direction)));
            if (med != 0) {
                x = x2;
                z = z2;
                i = i2;
                k = k2;
                pitch = 0.0;
                continue;
            }
            int dir = (int)(direction * 8.0 / Math.PI);
            dir = dir < 0 ? 15 - (15 - dir) % 16 : (dir %= 16);
            int pol = dir % 2;
            int di = i2 - i;
            int dk = k2 - k;
            int[] tdir = new int[]{0, 0, 0, 0};
            if (di == 0 && dk == 0) {
                if (dir < 1) {
                    di = 1;
                    dk = 0;
                } else if (dir < 3) {
                    di = 1;
                    dk = 1;
                } else if (dir < 5) {
                    di = 0;
                    dk = 1;
                } else if (dir < 7) {
                    di = -1;
                    dk = 1;
                } else if (dir < 9) {
                    di = -1;
                    dk = 0;
                } else if (dir < 11) {
                    di = -1;
                    dk = -1;
                } else if (dir < 13) {
                    di = 0;
                    dk = -1;
                } else if (dir < 15) {
                    di = 1;
                    dk = -1;
                } else {
                    di = 1;
                    dk = 0;
                }
            }
            if (dk == 0) {
                if (di > 0) {
                    if (pol == 1) {
                        tdir[0] = 2;
                        tdir[1] = 14;
                        tdir[2] = 4;
                        tdir[3] = 12;
                    } else {
                        tdir[0] = 14;
                        tdir[1] = 2;
                        tdir[2] = 12;
                        tdir[3] = 4;
                    }
                } else if (pol == 1) {
                    tdir[0] = 6;
                    tdir[1] = 10;
                    tdir[2] = 4;
                    tdir[3] = 12;
                } else {
                    tdir[0] = 10;
                    tdir[1] = 6;
                    tdir[2] = 12;
                    tdir[3] = 4;
                }
            } else if (di == 0) {
                if (dk > 0) {
                    if (pol == 1) {
                        tdir[0] = 2;
                        tdir[1] = 6;
                        tdir[2] = 0;
                        tdir[3] = 8;
                    } else {
                        tdir[0] = 6;
                        tdir[1] = 2;
                        tdir[2] = 8;
                        tdir[3] = 0;
                    }
                } else if (pol == 1) {
                    tdir[0] = 10;
                    tdir[1] = 14;
                    tdir[2] = 8;
                    tdir[3] = 0;
                } else {
                    tdir[0] = 14;
                    tdir[1] = 10;
                    tdir[2] = 0;
                    tdir[3] = 8;
                }
            } else if (dk > 0) {
                if (di > 0) {
                    if (pol == 1) {
                        tdir[0] = 0;
                        tdir[1] = 4;
                        tdir[2] = 14;
                        tdir[3] = 6;
                    } else {
                        tdir[0] = 4;
                        tdir[1] = 0;
                        tdir[2] = 6;
                        tdir[3] = 14;
                    }
                } else if (pol == 1) {
                    tdir[0] = 4;
                    tdir[1] = 8;
                    tdir[2] = 2;
                    tdir[3] = 10;
                } else {
                    tdir[0] = 8;
                    tdir[1] = 4;
                    tdir[2] = 10;
                    tdir[3] = 2;
                }
            } else if (di > 0) {
                if (pol == 1) {
                    tdir[0] = 12;
                    tdir[1] = 0;
                    tdir[2] = 10;
                    tdir[3] = 2;
                } else {
                    tdir[0] = 0;
                    tdir[1] = 12;
                    tdir[2] = 2;
                    tdir[3] = 10;
                }
            } else if (pol == 1) {
                tdir[0] = 8;
                tdir[1] = 12;
                tdir[2] = 6;
                tdir[3] = 14;
            } else {
                tdir[0] = 12;
                tdir[1] = 8;
                tdir[2] = 14;
                tdir[3] = 6;
            }
            for (int q = 0; q < 4; ++q) {
                if (tdir[q] == 0) {
                    di = 1;
                    dk = 0;
                } else if (tdir[q] == 2) {
                    di = 1;
                    dk = 1;
                } else if (tdir[q] == 4) {
                    di = 0;
                    dk = 1;
                } else if (tdir[q] == 6) {
                    di = -1;
                    dk = 1;
                } else if (tdir[q] == 8) {
                    di = -1;
                    dk = 0;
                } else if (tdir[q] == 10) {
                    di = -1;
                    dk = -1;
                } else if (tdir[q] == 12) {
                    di = 0;
                    dk = -1;
                } else {
                    di = 1;
                    dk = -1;
                }
                i2 = i + di;
                k2 = k + dk;
                med = this.getMedium(i2, j, k2);
                if (med == 0) continue;
                i = i2;
                k = k2;
                x = (double)i + 0.5;
                z = (double)k + 0.5;
                pitch = 0.0;
                direction = (double)tdir[q] * 2.0 * Math.PI / 16.0;
                break;
            }
            if (med != 0) continue;
            return;
        }
    }

    void generateLeafNodeBases() {
        int j = this.leafNodes.length;
        int[] ai = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        for (int i = 0; i < j; ++i) {
            int[] ai1 = this.leafNodes[i];
            int[] ai2 = new int[]{ai1[0], ai1[1], ai1[2]};
            ai[1] = ai1[3];
            int k = ai[1] - this.basePos[1];
            if (!this.leafNodeNeedsBase(k)) continue;
            this.placeBlockLine(ai, ai2);
        }
    }

    int checkBlockLine(int[] ai, int[] ai1) {
        int j;
        int[] ai2 = new int[]{0, 0, 0};
        int i = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[i])) continue;
            i = byte0;
        }
        if (ai2[i] == 0) {
            return -1;
        }
        byte byte1 = otherCoordPairs[i];
        byte byte2 = otherCoordPairs[i + 3];
        int byte3 = ai2[i] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[i];
        double d1 = (double)ai2[byte2] / (double)ai2[i];
        int[] ai3 = new int[]{0, 0, 0};
        int k = ai2[i] + byte3;
        for (j = 0; j != k; j += byte3) {
            ai3[i] = ai[i] + j;
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)j * d));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)j * d1));
            Block l = this.getBlock(ai3[0], ai3[1], ai3[2]);
            if (l != Blocks.field_150350_a && l != Blocks.field_150362_t && l != Blocks.field_150364_r) break;
        }
        if (j == k) {
            return -1;
        }
        return Math.abs(j);
    }

    boolean validTreeLocation() {
        Block i = this.getBlock(this.basePos[0], this.basePos[1] - 1, this.basePos[2]);
        return i == Blocks.field_150349_c || i == Blocks.field_150346_d || i == Blocks.field_150354_m;
    }

    public void func_517_a(double d, double d1, double d2) {
        this.heightLimitLimit = (int)(d * 12.0);
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        this.type = 0;
        return this.generator(world, random, i, j, k);
    }

    public boolean desertGenerate(World world, Random random, int i, int j, int k) {
        this.type = 1;
        return this.generator(world, random, i, j, k);
    }

    public boolean desertGenerate2(World world, Random random, int i, int j, int k) {
        this.type = 11;
        return this.generator(world, random, i, j, k);
    }

    public boolean swampGenerate(World world, Random random, int i, int j, int k) {
        this.type = 2;
        return this.generator(world, random, i, j, k);
    }

    public boolean greatGenerate(World world, Random random, int i, int j, int k) {
        this.type = 3;
        return this.generator(world, random, i, j, k);
    }

    public boolean pineGenerate(World world, Random random, int i, int j, int k) {
        this.type = 4;
        return this.generator(world, random, i, j, k);
    }

    public boolean blockOakGenerate(World world, Random random, int i, int j, int k) {
        this.type = 5;
        return this.generator(world, random, i, j, k);
    }

    public boolean birchGenerate(World world, Random random, int i, int j, int k) {
        this.type = 6;
        return this.generator(world, random, i, j, k);
    }

    private boolean generator(World world, Random random, int i, int j, int k) {
        this.worldObj = world;
        long l = random.nextLong();
        this.rand.setSeed(l);
        this.basePos[0] = i;
        this.basePos[1] = j;
        this.basePos[2] = k;
        boolean qbirch = false;
        int qq = this.type == 1 ? this.rand.nextInt(8) + 86 : (this.type == 2 ? 0 : (this.type == 3 ? 0 : (this.type == 4 ? 30 : (this.type == 5 || this.type == 6 ? 80 : this.rand.nextInt(94)))));
        if (this.type == 6) {
            qbirch = true;
        }
        if (this.type == 11) {
            this.type = 1;
            qq = 87;
        }
        int[] heightvector = new int[]{this.heightmin, this.heightmax - this.heightmin};
        this.heightLimit = KTreeCfg.vary(this.rand, heightvector);
        if (qq < 8) {
            this.heightAttenuation = 0.1;
            this.field_873_j = 1.4;
            this.trunkSize = 4;
            this.heightLimitLimit = 4;
            this.leafDistanceLimit = 4;
        } else if (qq < 40) {
            this.heightAttenuation = 0.3;
            this.field_873_j = 1.2;
            this.trunkSize = 3;
            this.heightLimitLimit = 3;
            this.leafDistanceLimit = 4;
        } else if (qq < 90) {
            this.heightAttenuation = 0.3;
            this.field_873_j = 1.0;
            this.trunkSize = 2;
            this.heightLimitLimit = 3;
            this.leafDistanceLimit = 4;
            if (qbirch) {
                this.heightLimit = KTreeCfg.vary(this.rand, KTreeCfg.birchHeight);
            }
        } else if (qq < 95) {
            this.heightAttenuation = 0.3;
            this.field_873_j = 1.0;
            this.trunkSize = 2;
            this.heightLimitLimit = 3;
            this.leafDistanceLimit = 0;
        } else {
            this.heightLimit = 5;
            this.heightAttenuation = 0.1;
            this.field_873_j = 2.0;
            this.trunkSize = 0;
            this.heightLimitLimit = 0;
            this.leafDistanceLimit = 0;
            this.trunkBlock = Blocks.field_150360_v;
            this.leafBlock = Blocks.field_150360_v;
        }
        if (this.type == 1) {
            if (this.trunkSize != 1) {
                this.field_873_j *= 1.0;
            }
            this.leafDistanceLimit = 0;
        } else if (this.type == 2) {
            this.heightAttenuation = 0.0;
        }
        if (this.heightLimitLimit > 0) {
            this.heightLimit = this.heightLimit + this.rand.nextInt(this.heightLimitLimit * 2) - this.heightLimitLimit;
        }
        if (!this.validTreeLocation()) {
            return false;
        }
        this.rootRand = this.rand.nextInt(4);
        if (this.generateLeafNodeList()) {
            this.generateLeaves();
            this.generateTrunk();
            this.generateLeafNodeBases();
            return true;
        }
        return false;
    }
}

