/*
 * Decompiled with CFR 0.152.
 */
package karob.bigtrees;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import java.util.Random;
import karob.bigtrees.KWorldGenBigTree;
import karob.bigtrees.KWorldGenCyprusTree;
import karob.bigtrees.KWorldGenHatTree;
import karob.bigtrees.KWorldGenTallTree;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockBTSapling
extends BlockSapling {
    private int treeType;
    private static final String[] treeNames = new String[]{"BigOak", "BigBirch", "BigPine", "DeadTree", "Cyprus", "HatTree"};
    private int[] growTimes = new int[]{3, 3, 3, 3, 3, 3};
    private int x_offset;
    private int z_offset;
    private Block[][] neighborBuffer = new Block[7][7];
    private int[][] neighborBugger = new int[7][7];
    static final IIcon[] textures = new IIcon[treeNames.length];

    public BlockBTSapling() {
        this.func_149711_c(0.0f);
        this.func_149672_a(Block.field_149779_h);
        float var3 = 0.4f;
        this.func_149676_a(0.5f - var3, 0.0f, 0.5f - var3, 0.5f + var3, var3 * 2.0f, 0.5f + var3);
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta < 0 || meta >= treeNames.length) {
            meta = 0;
        }
        return textures[meta];
    }

    public void func_149666_a(Item block, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < treeNames.length; ++i) {
            list.add(new ItemStack(block, 1, i));
        }
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        for (int i = 0; i < treeNames.length; ++i) {
            BlockBTSapling.textures[i] = par1IconRegister.func_94245_a("bigtrees:sapling" + treeNames[i]);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (!world.field_72995_K && world.func_72957_l(x, y + 1, z) >= 9 && random.nextInt(7) == 0) {
            this.func_149878_d(world, x, y, z, random);
        }
    }

    public void func_149879_c(World p_149879_1_, int p_149879_2_, int p_149879_3_, int p_149879_4_, Random p_149879_5_) {
        int l = p_149879_1_.func_72805_g(p_149879_2_, p_149879_3_, p_149879_4_);
        this.func_149878_d(p_149879_1_, p_149879_2_, p_149879_3_, p_149879_4_, p_149879_5_);
    }

    public void func_149878_d(World par1World, int i, int j, int k, Random r) {
        this.resetNeighborBuffer();
        int meta = par1World.func_72805_g(i, j, k) & 0xF;
        Object obj = null;
        if (meta == 0) {
            if (this.checkTreeCoin4x4(par1World, i, j, k, GameRegistry.findBlock((String)"bigtrees", (String)"bt_bigSapling"), meta)) {
                this.clearTreeCoin4x4(par1World, i, j, k);
                KWorldGenBigTree tree = new KWorldGenBigTree(true);
                tree.setConfigOptions(Blocks.field_150364_r, (Block)Blocks.field_150362_t, 0, 0, Blocks.field_150346_d, (Block)Blocks.field_150349_c, 28, 32, 13);
                if (!tree.greatGenerate(par1World, r, this.x_offset, j, this.z_offset)) {
                    this.resetTreeCoin4x4(par1World, i, j, k, GameRegistry.findBlock((String)"bigtrees", (String)"bt_bigSapling"), meta);
                }
            } else if (this.checkTreeRing4x4(par1World, i, j, k, GameRegistry.findBlock((String)"bigtrees", (String)"bt_bigSapling"), meta)) {
                this.clearTreeRing4x4(par1World, i, j, k);
                KWorldGenBigTree tree = new KWorldGenBigTree(true);
                tree.setConfigOptions(Blocks.field_150364_r, (Block)Blocks.field_150362_t, 0, 0, Blocks.field_150346_d, (Block)Blocks.field_150349_c, 28, 32, 13);
                if (!tree.swampGenerate(par1World, r, this.x_offset, j, this.z_offset)) {
                    this.resetTreeRing4x4(par1World, i, j, k, GameRegistry.findBlock((String)"bigtrees", (String)"bt_bigSapling"), meta);
                }
            } else if (this.checkTreeBlock2x2(par1World, i, j, k, GameRegistry.findBlock((String)"bigtrees", (String)"bt_bigSapling"), meta)) {
                this.clearTreeBlock2x2(par1World, i, j, k);
                KWorldGenBigTree tree = new KWorldGenBigTree(true);
                tree.setConfigOptions(Blocks.field_150364_r, (Block)Blocks.field_150362_t, 0, 0, Blocks.field_150346_d, (Block)Blocks.field_150349_c, 12, 18, 8);
                if (!tree.blockOakGenerate(par1World, r, this.x_offset, j, this.z_offset)) {
                    this.resetTreeBlock2x2(par1World, i, j, k, GameRegistry.findBlock((String)"bigtrees", (String)"bt_bigSapling"), meta);
                }
            } else {
                par1World.func_147468_f(i, j, k);
                KWorldGenTallTree tree = new KWorldGenTallTree(true);
                tree.setConfigOptions(Blocks.field_150364_r, (Block)Blocks.field_150362_t, 0, 0, Blocks.field_150346_d, (Block)Blocks.field_150349_c, 28, 32, 13, 0.23, 0.32, 0.6, 0.618034, 0.5, 0.6, 0.0, 0.08, 3, 0.12, 0.6, 4, 30.0, 0.75);
                if (!tree.func_76484_a(par1World, r, i, j, k)) {
                    par1World.func_147449_b(i, j, k, GameRegistry.findBlock((String)"bigtrees", (String)"bt_bigSapling"));
                }
            }
        } else if (meta == 1) {
            if (this.checkTreeBlock2x2(par1World, i, j, k, GameRegistry.findBlock((String)"bigtrees", (String)"bt_bigSapling"), meta)) {
                this.clearTreeBlock2x2(par1World, i, j, k);
                KWorldGenBigTree tree = new KWorldGenBigTree(true);
                tree.setConfigOptions(Blocks.field_150364_r, (Block)Blocks.field_150362_t, 2, 2, Blocks.field_150346_d, (Block)Blocks.field_150349_c, 19, 24, 13);
                if (!tree.birchGenerate(par1World, r, this.x_offset, j, this.z_offset)) {
                    this.resetTreeBlock2x2(par1World, i, j, k, GameRegistry.findBlock((String)"bigtrees", (String)"bt_bigSapling"), meta);
                }
            }
        } else if (meta == 2) {
            if (this.checkTreeCross3x3(par1World, i, j, k, GameRegistry.findBlock((String)"bigtrees", (String)"bt_bigSapling"), meta)) {
                this.clearTreeCross3x3(par1World, i, j, k);
                KWorldGenBigTree tree = new KWorldGenBigTree(true);
                tree.setConfigOptions(Blocks.field_150364_r, (Block)Blocks.field_150362_t, 1, 1, Blocks.field_150346_d, (Block)Blocks.field_150349_c, 18, 22, 13);
                if (!tree.pineGenerate(par1World, r, this.x_offset, j, this.z_offset)) {
                    this.resetTreeCross3x3(par1World, i, j, k, GameRegistry.findBlock((String)"bigtrees", (String)"bt_bigSapling"), meta);
                }
            }
        } else if (meta == 3) {
            if (this.checkTreeBlock2x2(par1World, i, j, k, GameRegistry.findBlock((String)"bigtrees", (String)"bt_bigSapling"), meta)) {
                this.clearTreeBlock2x2(par1World, i, j, k);
                KWorldGenBigTree tree = new KWorldGenBigTree(true);
                tree.setConfigOptions(Blocks.field_150364_r, (Block)Blocks.field_150362_t, 0, 0, Blocks.field_150346_d, (Block)Blocks.field_150349_c, 13, 17, 10);
                if (!tree.desertGenerate(par1World, r, this.x_offset, j, this.z_offset)) {
                    this.resetTreeBlock2x2(par1World, i, j, k, GameRegistry.findBlock((String)"bigtrees", (String)"bt_bigSapling"), meta);
                }
            }
        } else if (meta == 4) {
            if (this.checkTreeBlock2x2(par1World, i, j, k, GameRegistry.findBlock((String)"bigtrees", (String)"bt_bigSapling"), meta)) {
                this.clearTreeBlock2x2(par1World, i, j, k);
                KWorldGenCyprusTree tree = new KWorldGenCyprusTree(true);
                tree.setConfigOptions(Blocks.field_150364_r, (Block)Blocks.field_150362_t, 1, 1, Blocks.field_150346_d, (Block)Blocks.field_150349_c, 28, 32, 13);
                if (!tree.func_76484_a(par1World, r, this.x_offset, j, this.z_offset)) {
                    this.resetTreeBlock2x2(par1World, i, j, k, GameRegistry.findBlock((String)"bigtrees", (String)"bt_bigSapling"), meta);
                }
            }
        } else if (meta == 5 && this.checkTreeRing4x4(par1World, i, j, k, GameRegistry.findBlock((String)"bigtrees", (String)"bt_bigSapling"), meta)) {
            this.clearTreeRing4x4(par1World, i, j, k);
            KWorldGenHatTree tree = new KWorldGenHatTree(true);
            tree.setConfigOptions(Blocks.field_150364_r, (Block)Blocks.field_150362_t, 0, 0, Blocks.field_150346_d, (Block)Blocks.field_150349_c, 28, 32, 13);
            if (!new KWorldGenHatTree(true).func_76484_a(par1World, r, this.x_offset, j, this.z_offset)) {
                this.resetTreeRing4x4(par1World, i, j, k, GameRegistry.findBlock((String)"bigtrees", (String)"bt_bigSapling"), meta);
            }
        }
    }

    public boolean checkTreeBlock2x2(World wo, int x, int y, int z, Block id, int meta) {
        if (wo.func_147439_a(x, y, z - 1) == id && wo.func_72805_g(x, y, z - 1) == meta) {
            if (wo.func_147439_a(x - 1, y, z) == id && wo.func_147439_a(x - 1, y, z - 1) == id && wo.func_72805_g(x - 1, y, z) == meta && wo.func_72805_g(x - 1, y, z - 1) == meta) {
                this.x_offset = x - 1;
                this.z_offset = z - 1;
                return true;
            }
            if (wo.func_147439_a(x + 1, y, z) == id && wo.func_147439_a(x + 1, y, z - 1) == id && wo.func_72805_g(x + 1, y, z) == meta && wo.func_72805_g(x + 1, y, z - 1) == meta) {
                this.x_offset = x;
                this.z_offset = z - 1;
                return true;
            }
        }
        if (wo.func_147439_a(x, y, z + 1) == id && wo.func_72805_g(x, y, z + 1) == meta) {
            if (wo.func_147439_a(x - 1, y, z) == id && wo.func_147439_a(x - 1, y, z + 1) == id && wo.func_72805_g(x - 1, y, z) == meta && wo.func_72805_g(x - 1, y, z + 1) == meta) {
                this.x_offset = x - 1;
                this.z_offset = z;
                return true;
            }
            if (wo.func_147439_a(x + 1, y, z) == id && wo.func_147439_a(x + 1, y, z + 1) == id && wo.func_72805_g(x + 1, y, z) == meta && wo.func_72805_g(x + 1, y, z + 1) == meta) {
                this.x_offset = x;
                this.z_offset = z;
                return true;
            }
        }
        return false;
    }

    public void clearTreeBlock2x2(World wo, int x, int y, int z) {
        wo.func_147468_f(this.x_offset, y, this.z_offset);
        wo.func_147468_f(this.x_offset + 1, y, this.z_offset);
        wo.func_147468_f(this.x_offset + 1, y, this.z_offset + 1);
        wo.func_147468_f(this.x_offset, y, this.z_offset + 1);
    }

    public void resetTreeBlock2x2(World wo, int x, int y, int z, Block id, int meta) {
        wo.func_147465_d(this.x_offset, y, this.z_offset, id, meta, 3);
        wo.func_147465_d(this.x_offset + 1, y, this.z_offset, id, meta, 3);
        wo.func_147465_d(this.x_offset + 1, y, this.z_offset + 1, id, meta, 3);
        wo.func_147465_d(this.x_offset, y, this.z_offset + 1, id, meta, 3);
    }

    public boolean checkTreeCross3x3(World wo, int x, int y, int z, Block id, int meta) {
        int summation = 0;
        if (wo.func_147439_a(x, y, z - 1) == id && wo.func_72805_g(x, y, z - 1) == meta) {
            ++summation;
            if (wo.func_147439_a(x - 1, y, z - 1) == id && wo.func_147439_a(x + 1, y, z - 1) == id && wo.func_147439_a(x, y, z - 2) == id && wo.func_72805_g(x - 1, y, z - 1) == meta && wo.func_72805_g(x + 1, y, z - 1) == meta && wo.func_72805_g(x, y, z - 2) == meta) {
                this.x_offset = x;
                this.z_offset = z - 1;
                return true;
            }
        }
        if (wo.func_147439_a(x, y, z + 1) == id && wo.func_72805_g(x, y, z + 1) == meta) {
            ++summation;
            if (wo.func_147439_a(x - 1, y, z + 1) == id && wo.func_147439_a(x + 1, y, z + 1) == id && wo.func_147439_a(x, y, z + 2) == id && wo.func_72805_g(x - 1, y, z + 1) == meta && wo.func_72805_g(x + 1, y, z + 1) == meta && wo.func_72805_g(x, y, z + 2) == meta) {
                this.x_offset = x;
                this.z_offset = z + 1;
                return true;
            }
        }
        if (wo.func_147439_a(x - 1, y, z) == id && wo.func_72805_g(x - 1, y, z) == meta) {
            ++summation;
            if (wo.func_147439_a(x - 1, y, z - 1) == id && wo.func_147439_a(x - 1, y, z + 1) == id && wo.func_147439_a(x - 2, y, z) == id && wo.func_72805_g(x - 1, y, z - 1) == meta && wo.func_72805_g(x - 1, y, z + 1) == meta && wo.func_72805_g(x - 2, y, z) == meta) {
                this.x_offset = x - 1;
                this.z_offset = z;
                return true;
            }
        }
        if (wo.func_147439_a(x + 1, y, z) == id && wo.func_72805_g(x + 1, y, z) == meta) {
            ++summation;
            if (wo.func_147439_a(x + 1, y, z - 1) == id && wo.func_147439_a(x + 1, y, z + 1) == id && wo.func_147439_a(x + 2, y, z) == id && wo.func_72805_g(x + 1, y, z - 1) == meta && wo.func_72805_g(x + 1, y, z + 1) == meta && wo.func_72805_g(x + 2, y, z) == meta) {
                this.x_offset = x + 1;
                this.z_offset = z;
                return true;
            }
        }
        if (summation == 4) {
            this.x_offset = x;
            this.z_offset = z;
            return true;
        }
        return false;
    }

    public void clearTreeCross3x3(World wo, int x, int y, int z) {
        wo.func_147468_f(this.x_offset, y, this.z_offset);
        wo.func_147468_f(this.x_offset + 1, y, this.z_offset);
        wo.func_147468_f(this.x_offset - 1, y, this.z_offset);
        wo.func_147468_f(this.x_offset, y, this.z_offset + 1);
        wo.func_147468_f(this.x_offset, y, this.z_offset - 1);
    }

    public void resetTreeCross3x3(World wo, int x, int y, int z, Block id, int meta) {
        wo.func_147465_d(this.x_offset, y, this.z_offset, id, meta, 3);
        wo.func_147465_d(this.x_offset + 1, y, this.z_offset, id, meta, 3);
        wo.func_147465_d(this.x_offset - 1, y, this.z_offset, id, meta, 3);
        wo.func_147465_d(this.x_offset, y, this.z_offset + 1, id, meta, 3);
        wo.func_147465_d(this.x_offset, y, this.z_offset - 1, id, meta, 3);
    }

    public boolean checkTreeCoin4x4(World wo, int x, int y, int z, Block id, int meta) {
        if (this.checkTreeCoin4x4_sub(wo, x, y, z, id, meta, 0, 1)) {
            return true;
        }
        if (this.checkTreeCoin4x4_sub(wo, x, y, z, id, meta, -1, 1)) {
            return true;
        }
        if (this.checkTreeCoin4x4_sub(wo, x, y, z, id, meta, 1, 0)) {
            return true;
        }
        if (this.checkTreeCoin4x4_sub(wo, x, y, z, id, meta, 0, 0)) {
            return true;
        }
        if (this.checkTreeCoin4x4_sub(wo, x, y, z, id, meta, -1, 0)) {
            return true;
        }
        if (this.checkTreeCoin4x4_sub(wo, x, y, z, id, meta, -2, 0)) {
            return true;
        }
        if (this.checkTreeCoin4x4_sub(wo, x, y, z, id, meta, 1, -1)) {
            return true;
        }
        if (this.checkTreeCoin4x4_sub(wo, x, y, z, id, meta, 0, -1)) {
            return true;
        }
        if (this.checkTreeCoin4x4_sub(wo, x, y, z, id, meta, -1, -1)) {
            return true;
        }
        if (this.checkTreeCoin4x4_sub(wo, x, y, z, id, meta, -2, -1)) {
            return true;
        }
        if (this.checkTreeCoin4x4_sub(wo, x, y, z, id, meta, 0, -2)) {
            return true;
        }
        return this.checkTreeCoin4x4_sub(wo, x, y, z, id, meta, -1, -2);
    }

    public boolean checkTreeCoin4x4_sub(World wo, int x, int y, int z, Block id, int meta, int ox, int oz) {
        if (this.checkNeighbor(wo, x, y, z, id, meta, ox + 0, oz - 1) && this.checkNeighbor(wo, x, y, z, id, meta, ox + 1, oz - 1) && this.checkNeighbor(wo, x, y, z, id, meta, ox - 1, oz + 0) && this.checkNeighbor(wo, x, y, z, id, meta, ox + 0, oz + 0) && this.checkNeighbor(wo, x, y, z, id, meta, ox + 1, oz + 0) && this.checkNeighbor(wo, x, y, z, id, meta, ox + 2, oz + 0) && this.checkNeighbor(wo, x, y, z, id, meta, ox - 1, oz + 1) && this.checkNeighbor(wo, x, y, z, id, meta, ox + 0, oz + 1) && this.checkNeighbor(wo, x, y, z, id, meta, ox + 1, oz + 1) && this.checkNeighbor(wo, x, y, z, id, meta, ox + 2, oz + 1) && this.checkNeighbor(wo, x, y, z, id, meta, ox + 0, oz + 2) && this.checkNeighbor(wo, x, y, z, id, meta, ox + 1, oz + 2)) {
            this.x_offset = x + ox;
            this.z_offset = z + oz;
            return true;
        }
        return false;
    }

    public void clearTreeCoin4x4(World wo, int x, int y, int z) {
        wo.func_147468_f(this.x_offset, y, this.z_offset);
        wo.func_147468_f(this.x_offset + 1, y, this.z_offset);
        wo.func_147468_f(this.x_offset + 1, y, this.z_offset + 1);
        wo.func_147468_f(this.x_offset, y, this.z_offset + 1);
        wo.func_147468_f(this.x_offset - 1, y, this.z_offset);
        wo.func_147468_f(this.x_offset, y, this.z_offset - 1);
        wo.func_147468_f(this.x_offset + 1, y, this.z_offset - 1);
        wo.func_147468_f(this.x_offset + 2, y, this.z_offset);
        wo.func_147468_f(this.x_offset + 2, y, this.z_offset - 1);
        wo.func_147468_f(this.x_offset + 1, y, this.z_offset - 2);
        wo.func_147468_f(this.x_offset, y, this.z_offset - 2);
        wo.func_147468_f(this.x_offset - 1, y, this.z_offset - 1);
    }

    public void resetTreeCoin4x4(World wo, int x, int y, int z, Block id, int meta) {
        wo.func_147465_d(this.x_offset, y, this.z_offset, id, meta, 3);
        wo.func_147465_d(this.x_offset + 1, y, this.z_offset, id, meta, 3);
        wo.func_147465_d(this.x_offset + 1, y, this.z_offset + 1, id, meta, 3);
        wo.func_147465_d(this.x_offset, y, this.z_offset + 1, id, meta, 3);
        wo.func_147465_d(this.x_offset - 1, y, this.z_offset, id, meta, 3);
        wo.func_147465_d(this.x_offset, y, this.z_offset - 1, id, meta, 3);
        wo.func_147465_d(this.x_offset + 1, y, this.z_offset - 1, id, meta, 3);
        wo.func_147465_d(this.x_offset + 2, y, this.z_offset, id, meta, 3);
        wo.func_147465_d(this.x_offset + 2, y, this.z_offset - 1, id, meta, 3);
        wo.func_147465_d(this.x_offset + 1, y, this.z_offset - 2, id, meta, 3);
        wo.func_147465_d(this.x_offset, y, this.z_offset - 2, id, meta, 3);
        wo.func_147465_d(this.x_offset - 1, y, this.z_offset - 1, id, meta, 3);
    }

    public boolean checkTreeRing4x4(World wo, int x, int y, int z, Block id, int meta) {
        if (this.checkTreeRing4x4_sub(wo, x, y, z, id, meta, 0, 1)) {
            return true;
        }
        if (this.checkTreeRing4x4_sub(wo, x, y, z, id, meta, -1, 1)) {
            return true;
        }
        if (this.checkTreeRing4x4_sub(wo, x, y, z, id, meta, 1, 0)) {
            return true;
        }
        if (this.checkTreeRing4x4_sub(wo, x, y, z, id, meta, -2, 0)) {
            return true;
        }
        if (this.checkTreeRing4x4_sub(wo, x, y, z, id, meta, 1, -1)) {
            return true;
        }
        if (this.checkTreeRing4x4_sub(wo, x, y, z, id, meta, -2, -1)) {
            return true;
        }
        if (this.checkTreeRing4x4_sub(wo, x, y, z, id, meta, 0, -2)) {
            return true;
        }
        return this.checkTreeRing4x4_sub(wo, x, y, z, id, meta, -1, -2);
    }

    public boolean checkTreeRing4x4_sub(World wo, int x, int y, int z, Block id, int meta, int ox, int oz) {
        if (this.checkNeighbor(wo, x, y, z, id, meta, ox + 0, oz - 1) && this.checkNeighbor(wo, x, y, z, id, meta, ox + 1, oz - 1) && this.checkNeighbor(wo, x, y, z, id, meta, ox - 1, oz + 0) && this.checkNeighbor(wo, x, y, z, id, meta, ox + 2, oz + 0) && this.checkNeighbor(wo, x, y, z, id, meta, ox - 1, oz + 1) && this.checkNeighbor(wo, x, y, z, id, meta, ox + 2, oz + 1) && this.checkNeighbor(wo, x, y, z, id, meta, ox + 0, oz + 2) && this.checkNeighbor(wo, x, y, z, id, meta, ox + 1, oz + 2)) {
            this.x_offset = x + ox;
            this.z_offset = z + oz;
            return true;
        }
        return false;
    }

    public void clearTreeRing4x4(World wo, int x, int y, int z) {
        wo.func_147468_f(this.x_offset - 1, y, this.z_offset);
        wo.func_147468_f(this.x_offset, y, this.z_offset - 1);
        wo.func_147468_f(this.x_offset + 1, y, this.z_offset - 1);
        wo.func_147468_f(this.x_offset + 2, y, this.z_offset);
        wo.func_147468_f(this.x_offset + 2, y, this.z_offset - 1);
        wo.func_147468_f(this.x_offset + 1, y, this.z_offset - 2);
        wo.func_147468_f(this.x_offset, y, this.z_offset - 2);
        wo.func_147468_f(this.x_offset - 1, y, this.z_offset - 1);
    }

    public void resetTreeRing4x4(World wo, int x, int y, int z, Block id, int meta) {
        wo.func_147465_d(this.x_offset - 1, y, this.z_offset, id, meta, 3);
        wo.func_147465_d(this.x_offset, y, this.z_offset - 1, id, meta, 3);
        wo.func_147465_d(this.x_offset + 1, y, this.z_offset - 1, id, meta, 3);
        wo.func_147465_d(this.x_offset + 2, y, this.z_offset, id, meta, 3);
        wo.func_147465_d(this.x_offset + 2, y, this.z_offset - 1, id, meta, 3);
        wo.func_147465_d(this.x_offset + 1, y, this.z_offset - 2, id, meta, 3);
        wo.func_147465_d(this.x_offset, y, this.z_offset - 2, id, meta, 3);
        wo.func_147465_d(this.x_offset - 1, y, this.z_offset - 1, id, meta, 3);
    }

    public void resetNeighborBuffer() {
        for (int i = 0; i <= 6; ++i) {
            for (int j = 0; j <= 6; ++j) {
                this.neighborBuffer[i][j] = null;
                this.neighborBugger[i][j] = -1;
            }
        }
    }

    public boolean checkNeighbor(World wo, int x, int y, int z, Block id, int meta, int ox, int oz) {
        Block temp = this.neighborBuffer[ox + 3][oz + 3];
        int temp1 = this.neighborBugger[ox + 3][oz + 3];
        if (temp == null || temp1 == -1) {
            this.neighborBuffer[ox + 3][oz + 3] = temp = wo.func_147439_a(x + ox, y, z + oz);
            this.neighborBugger[ox + 3][oz + 3] = temp1 = wo.func_72805_g(x + ox, y, z + oz);
        }
        return temp == id && temp1 == meta;
    }

    public int func_149692_a(int meta) {
        return meta & 0xF;
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) & 0xF;
    }
}

