/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.utils;

import com.syspatch.zip.ZipEntry;
import com.syspatch.zip.ZipInputStream;
import com.syspatch.zip.ZipOutputStream;
import com.webbuilder.common.Var;
import com.webbuilder.utils.StringUtil;
import com.webbuilder.utils.SysUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class ZipUtil {
    public static void zip(File[] source, OutputStream outputStream) throws Exception {
        ZipOutputStream zipStream = new ZipOutputStream(outputStream);
        zipStream.fileCharset = Var.get("server.fileNameCharset");
        try {
            File[] fileArray = source;
            int n = source.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                ZipUtil.zip(file, zipStream, file.getName());
                ++n2;
            }
        }
        finally {
            zipStream.close();
        }
    }

    public static void zip(File[] source, File zipFile) throws Exception {
        ZipUtil.zip(source, new FileOutputStream(zipFile));
    }

    private static void zip(File source, ZipOutputStream zipStream, String base) throws Exception {
        if (source.isDirectory()) {
            File[] fileList;
            ZipEntry entry = new ZipEntry(String.valueOf(base) + "/");
            entry.setTime(source.lastModified());
            zipStream.putNextEntry(entry);
            if (!StringUtil.isEmpty(base)) {
                base = String.valueOf(base) + "/";
            }
            File[] fileArray = fileList = source.listFiles();
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                ZipUtil.zip(file, zipStream, String.valueOf(base) + file.getName());
                ++n2;
            }
        } else {
            ZipEntry entry = new ZipEntry(base);
            entry.setTime(source.lastModified());
            zipStream.putNextEntry(entry);
            FileInputStream in = new FileInputStream(source);
            try {
                SysUtil.isToOs(in, (OutputStream)zipStream);
            }
            finally {
                in.close();
            }
        }
    }

    public static void unzip(InputStream inputStream, File dest) throws Exception {
        ZipInputStream zipStream = new ZipInputStream(inputStream);
        zipStream.fileCharset = Var.get("server.fileNameCharset");
        try {
            ZipEntry z;
            while ((z = zipStream.getNextEntry()) != null) {
                File f;
                String name = z.getName();
                if (z.isDirectory()) {
                    f = new File(dest, name = name.substring(0, name.length() - 1));
                    if (!f.exists()) {
                        f.mkdir();
                    }
                } else {
                    f = new File(dest, name);
                    if (!f.exists()) {
                        f.createNewFile();
                    }
                    FileOutputStream out = new FileOutputStream(f);
                    try {
                        SysUtil.isToOs((InputStream)zipStream, out);
                    }
                    finally {
                        out.close();
                    }
                }
                f.setLastModified(z.getTime());
            }
        }
        finally {
            zipStream.close();
        }
    }

    public static void unzip(File zipFile, File dest) throws Exception {
        ZipUtil.unzip(new FileInputStream(zipFile), dest);
    }
}

