/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.utils;

import com.webbuilder.common.Parser;
import com.webbuilder.common.Str;
import com.webbuilder.common.Var;
import com.webbuilder.common.XwlBuffer;
import com.webbuilder.tool.PageInfo;
import com.webbuilder.tool.QueueWriter;
import com.webbuilder.utils.FileUtil;
import com.webbuilder.utils.JsonUtil;
import com.webbuilder.utils.StringUtil;
import com.webbuilder.utils.SysUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebUtil {
    public static String request(String url, JSONObject params) throws Exception {
        return new String(WebUtil.requestData(url, params), "utf-8");
    }

    public static byte[] requestData(String url, JSONObject params) throws Exception {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        try {
            byte[] data = WebUtil.getParamsText(params).getBytes("utf-8");
            int timeout = Var.getInt("webbuilder.session.submitTimeout");
            conn.setConnectTimeout(timeout);
            conn.setReadTimeout(timeout);
            conn.setUseCaches(false);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            conn.setRequestProperty("Content-Length", Integer.toString(data.length));
            OutputStream os = conn.getOutputStream();
            try {
                os.write(data);
                os.flush();
            }
            finally {
                os.close();
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            InputStream is = conn.getInputStream();
            try {
                SysUtil.isToOs(is, bos);
            }
            finally {
                is.close();
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            conn.disconnect();
        }
    }

    private static String getParamsText(JSONObject jo) throws Exception {
        if (jo == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator names = jo.keys();
        boolean isFirst = true;
        while (names.hasNext()) {
            String name = (String)names.next();
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("&");
            }
            sb.append(name);
            sb.append("=");
            sb.append(URLEncoder.encode(JsonUtil.optString(jo, name), "utf-8"));
        }
        return sb.toString();
    }

    public static PageInfo getPage(HttpServletRequest request) throws Exception {
        String sv = WebUtil.fetch(request, "start");
        String lv = WebUtil.fetch(request, "limit");
        PageInfo pageInfo = new PageInfo();
        int start = StringUtil.isEmpty(sv) ? 0 : Integer.parseInt(sv);
        int limit = StringUtil.isEmpty(lv) ? Integer.MAX_VALUE - start : Integer.parseInt(lv);
        pageInfo.start = start;
        pageInfo.end = start + limit - 1;
        request.setAttribute("start", (Object)(start + 1));
        request.setAttribute("end", (Object)(pageInfo.end + 1));
        int limitRecords = Var.getInt("webbuilder.control.limitRecords");
        if (limitRecords == -1) {
            limitRecords = Integer.MAX_VALUE;
        }
        pageInfo.limit = limitRecords;
        pageInfo.count = 0;
        return pageInfo;
    }

    public static int checkPage(PageInfo pageInfo) {
        return WebUtil.checkPage(pageInfo, true, true);
    }

    public static int checkPage(PageInfo pageInfo, boolean paged, boolean totalCount) {
        int index = pageInfo.count;
        int result = index >= pageInfo.limit ? 1 : (paged && index < pageInfo.start ? 2 : (paged && index > pageInfo.end ? (totalCount ? 2 : 1) : 0));
        if (result != 1) {
            ++pageInfo.count;
        }
        return result;
    }

    public static void setTotal(StringBuilder buf, PageInfo pageInfo) {
        buf.insert(0, "{total:" + Integer.toString(pageInfo.count));
    }

    public static void setCb(StringBuilder buf, String cb) {
        if (cb != null) {
            buf.insert(0, String.valueOf(cb) + "(");
            buf.append(");");
        }
    }

    public static String[] getSortInfo(HttpServletRequest request) throws Exception {
        String sort = request.getParameter("sort");
        if (StringUtil.isEmpty(sort)) {
            return null;
        }
        JSONObject jo = new JSONArray(sort).getJSONObject(0);
        String[] result = new String[]{jo.getString("property"), jo.optString("direction")};
        return result;
    }

    public static String encodeFilename(HttpServletRequest request, String name) throws Exception {
        String agent = StringUtil.optString(request.getHeader("user-agent")).toLowerCase();
        if (name == null) {
            name = "";
        }
        if (agent.indexOf("msie") != -1) {
            return StringUtil.concat("filename=\"", WebUtil.encodeString(name), "\"");
        }
        if (agent.indexOf("opera") != -1) {
            return StringUtil.concat("filename*=\"utf-8''", WebUtil.encodeString(name), "\"");
        }
        return StringUtil.concat("filename=\"", new String(name.getBytes("utf-8"), "ISO-8859-1"), "\"");
    }

    public static String encodeString(String str) throws Exception {
        return StringUtil.replace(URLEncoder.encode(str, "utf-8"), "+", "%20");
    }

    public static String decode(String str) throws Exception {
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        return new String(str.getBytes("ISO-8859-1"), "utf-8");
    }

    public static void clearUploadFile(HttpServletRequest request, List<?> list) {
        for (Object t : list) {
            FileItem item = (FileItem)t;
            if (!item.isFormField()) {
                SysUtil.closeInputStream((InputStream)request.getAttribute(item.getFieldName()));
            }
            item.delete();
        }
        String uploadId = (String)request.getAttribute("sys.uploadId");
        if (uploadId != null) {
            HttpSession session = request.getSession(true);
            session.removeAttribute("sys.upread." + uploadId);
            session.removeAttribute("sys.uplen." + uploadId);
        }
    }

    public static List<?> setUploadFile(HttpServletRequest request) throws Exception {
        HttpSession session;
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        final String uploadId = request.getParameter("__uploadId");
        factory.setSizeThreshold(Var.getInt("webbuilder.service.upload.bufferSize"));
        request.setAttribute("sys.uploadId", (Object)uploadId);
        if (uploadId != null && uploadId.indexOf(46) == -1 && (session = request.getSession(true)) != null) {
            upload.setProgressListener(new ProgressListener(){

                public void update(long read, long length, int id) {
                    session.setAttribute("sys.upread." + uploadId, (Object)read);
                    session.setAttribute("sys.uplen." + uploadId, (Object)length);
                }
            });
        }
        upload.setSizeMax(Var.getLong("webbuilder.service.upload.maxSize"));
        List list = upload.parseRequest(request);
        if (list == null || list.size() == 0) {
            return null;
        }
        try {
            for (Object obj : list) {
                FileItem item = (FileItem)obj;
                String fieldName = item.getFieldName();
                if (fieldName.indexOf(46) != -1) continue;
                if (item.isFormField()) {
                    request.setAttribute(fieldName, (Object)item.getString("utf-8"));
                    continue;
                }
                request.setAttribute(fieldName, (Object)item.getInputStream());
                request.setAttribute(String.valueOf(fieldName) + "__name", (Object)FileUtil.extractFilename(item.getName()));
                request.setAttribute(String.valueOf(fieldName) + "__size", (Object)item.getSize());
            }
        }
        catch (Throwable e) {
            WebUtil.clearUploadFile(request, list);
            throw new Exception(e);
        }
        return list;
    }

    public static void showException(Throwable exception, HttpServletRequest request, HttpServletResponse response) throws Exception {
        StringWriter writer = new StringWriter();
        PrintWriter pwriter = new PrintWriter((Writer)writer, true);
        exception.printStackTrace(pwriter);
        pwriter.close();
        String stackMsg = writer.toString();
        if (Var.getBool("server.printError")) {
            System.err.println(stackMsg);
        }
        WebUtil.println(request, stackMsg);
        if (!response.isCommitted()) {
            response.reset();
            request.setCharacterEncoding("utf-8");
            response.setContentType("text/html;charset=utf-8");
            String shortError = StringUtil.convertHTML(SysUtil.getShortError(exception));
            if (WebUtil.isFormSubmit(request)) {
                WebUtil.response(response, shortError, false);
            } else {
                request.setAttribute("sys.shortError", (Object)shortError);
                request.setAttribute("sys.longError", (Object)StringUtil.toHTML(stackMsg));
                response.setStatus(500);
                Parser parser = new Parser(request, response, "error");
                parser.simpleParse(false);
            }
        }
    }

    public static void notExist(HttpServletRequest request) throws Exception {
        throw new Exception(Str.format(request, "objectNotExist", new String[0]));
    }

    public static boolean isFormSubmit(HttpServletRequest request) {
        return request.getParameter("_xwlfm") != null;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean checkRight(HttpServletRequest request, String xwlId) throws Exception {
        xwlMap = XwlBuffer.getXwlMap();
        d = xwlMap.get(xwlId);
        if (d == null) {
            return false;
        }
        if (!d.isFolder && !d.content.optBoolean("loginRequired", true)) {
            return true;
        }
        userRoles = (String[])request.getAttribute("sys.userRoles");
        if (StringUtil.indexOf(userRoles, "admin") == -1) ** GOTO lbl18
        return true;
lbl-1000:
        // 1 sources

        {
            setRoles = d.roles;
            if (setRoles != null) {
                for (String r : setRoles) {
                    role = StringUtil.getNamePart(r);
                    if (!role.equals("default") && StringUtil.indexOf(userRoles, role) == -1) continue;
                    return true;
                }
                return false;
            }
            d = xwlMap.get(d.parentId);
lbl18:
            // 2 sources

            ** while (d != null)
        }
lbl19:
        // 1 sources

        return true;
    }

    public static boolean checkLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(false);
        if (session == null || session.getAttribute("sys.logined") == null) {
            if (WebUtil.isFormSubmit(request)) {
                String resp = Var.getBool("webbuilder.session.loginVerify") ? "{success:false,value:\"xwlw__login,xwlw__needLV=true\"}" : "{success:false,value:\"xwlw__login\"}";
                WebUtil.response(response, resp);
            } else {
                response.setStatus(401);
                Parser parser = new Parser(request, response, "login");
                parser.simpleParse(false);
            }
            return false;
        }
        request.setAttribute("sys.user", session.getAttribute("sys.user"));
        request.setAttribute("sys.userName", session.getAttribute("sys.userName"));
        request.setAttribute("sys.dispName", session.getAttribute("sys.dispName"));
        request.setAttribute("sys.userRoles", session.getAttribute("sys.userRoles"));
        String lang = (String)session.getAttribute("sys.lang");
        if (!StringUtil.isEmpty(lang) && !lang.equals("auto")) {
            request.setAttribute("sys.lang", (Object)lang);
        }
        return true;
    }

    public static String getUrl(String url, boolean onlyId) {
        if (url.startsWith("#")) {
            int idx = url.indexOf(40);
            url = idx == -1 ? url.substring(1) : url.substring(1, idx);
            if (onlyId) {
                return url.trim();
            }
            return "main?xwl=" + url.trim();
        }
        return url;
    }

    public static String getLanguage(HttpServletRequest request) throws Exception {
        String setLan = Var.get("webbuilder.language");
        if (setLan.equalsIgnoreCase("auto")) {
            String acceptLang = request.getHeader("Accept-Language");
            if (acceptLang != null) {
                int pos = acceptLang.indexOf(44);
                if (pos != -1) {
                    acceptLang = acceptLang.substring(0, pos);
                }
                if ((pos = acceptLang.indexOf(59)) != -1) {
                    acceptLang = acceptLang.substring(0, pos);
                }
                if ((pos = acceptLang.indexOf(45)) == -1) {
                    return acceptLang.toLowerCase();
                }
                String language = acceptLang.substring(0, pos).toLowerCase();
                String country = acceptLang.substring(pos + 1).toUpperCase();
                return String.valueOf(language) + "_" + country;
            }
            return Var.get("webbuilder.defaultLanguage");
        }
        return setLan;
    }

    public static void checkNull(HttpServletRequest request, String list) throws Exception {
        String[] l;
        if (StringUtil.isEmpty(list)) {
            return;
        }
        String[] stringArray = l = list.split(",");
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            if (StringUtil.isEmpty(request.getParameter(n3))) {
                SysUtil.error(Str.format(request, "nullValue", n3));
            }
            ++n2;
        }
    }

    public static String getIdWithUser(HttpServletRequest request, String id) throws Exception {
        String user = (String)request.getAttribute("sys.user");
        return StringUtil.concat(StringUtil.optString(user), "@", id);
    }

    public static void print(HttpServletRequest request, Object s) {
        WebUtil.innerPrint(request, s, false);
    }

    public static void println(HttpServletRequest request, Object s) {
        WebUtil.innerPrint(request, s, true);
    }

    private static void innerPrint(HttpServletRequest request, Object s, boolean addLn) {
        QueueWriter out;
        HttpSession session = request.getSession(false);
        if (session != null && (out = (QueueWriter)session.getAttribute("sys.out")) != null) {
            if (addLn) {
                out.println(s);
            } else {
                out.print(s);
            }
        }
    }

    public static String fetch(HttpServletRequest request, String name) {
        Object obj = request.getAttribute(name);
        if (obj == null) {
            String val = request.getParameter(name);
            if (val == null) {
                return "";
            }
            return val;
        }
        return obj.toString();
    }

    public static void response(HttpServletResponse response, Object obj) throws Exception {
        if (obj instanceof InputStream) {
            InputStream is = (InputStream)obj;
            try {
                SysUtil.isToOs(is, (OutputStream)response.getOutputStream());
            }
            finally {
                is.close();
            }
        } else {
            byte[] bytes = obj instanceof byte[] ? (byte[])obj : obj.toString().getBytes("utf-8");
            int len = bytes.length;
            if (len >= Var.getInt("server.respGzipMinSize")) {
                response.setHeader("Content-Encoding", "gzip");
                GZIPOutputStream gos = new GZIPOutputStream((OutputStream)response.getOutputStream());
                try {
                    gos.write(bytes);
                }
                finally {
                    gos.close();
                }
            } else {
                response.setContentLength(len);
                response.getOutputStream().write(bytes);
            }
        }
        response.flushBuffer();
    }

    public static void response(HttpServletResponse response, String obj, boolean successful) throws Exception {
        WebUtil.response(response, StringUtil.concat("{success:", Boolean.toString(successful), ",value:", StringUtil.quote(StringUtil.convertHTML(obj)), "}"));
    }
}

