/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.utils;

import com.webbuilder.common.Str;
import com.webbuilder.common.Var;
import com.webbuilder.utils.SysUtil;
import com.webbuilder.utils.WebUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.mail.internet.MimeUtility;
import javax.servlet.http.HttpServletRequest;

public class StringUtil {
    private static final String HexCharSet = "0123456789ABCDEF";

    public static String[] sort(List<String> list) {
        String[] sl = list.toArray(new String[list.size()]);
        return StringUtil.sort(sl);
    }

    public static String[] sort(String[] list) {
        Arrays.sort(list, new Comparator<String>(){
            Collator collator = Collator.getInstance();

            @Override
            public int compare(String s1, String s2) {
                CollationKey key1 = this.collator.getCollationKey(StringUtil.optString(s1).toLowerCase());
                CollationKey key2 = this.collator.getCollationKey(StringUtil.optString(s2).toLowerCase());
                return key1.compareTo(key2);
            }
        });
        return list;
    }

    public static String duplicate(String text, int count) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < count) {
            buf.append(text);
            ++i;
        }
        return buf.toString();
    }

    public static String[] getList(String ... args) {
        String[] r = new String[args.length];
        int i = 0;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            r[i++] = s;
            ++n2;
        }
        return r;
    }

    public static String[] split(String string, String separator) {
        if (StringUtil.isEmpty(string)) {
            String[] result = new String[]{""};
            return result;
        }
        String[] result = new String[StringUtil.stringOccur(string, separator) + 1];
        int oldPos = 0;
        int pos = 0;
        int count = 0;
        int len = separator.length();
        while (pos != -1) {
            pos = string.indexOf(separator, oldPos);
            if (pos == -1) continue;
            result[count++] = string.substring(oldPos, pos);
            oldPos = pos += len;
        }
        result[count] = string.substring(oldPos);
        return result;
    }

    public static boolean isSame(String string1, String string2) {
        String s1 = string1 == null ? "" : string1;
        String s2 = string2 == null ? "" : string2;
        return s1.equalsIgnoreCase(s2);
    }

    public static boolean isEqual(String string1, String string2) {
        String s1 = string1 == null ? "" : string1;
        String s2 = string2 == null ? "" : string2;
        return s1.equals(s2);
    }

    public static String toHTML(String string) {
        return StringUtil.toHTML(string, false, true);
    }

    public static String convertHTML(String string) {
        if (StringUtil.isEmpty(string)) {
            return "";
        }
        int j = string.length();
        StringBuilder out = new StringBuilder();
        int i = 0;
        while (i < j) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    out.append("&amp;");
                    break;
                }
                case '>': {
                    out.append("&gt;");
                    break;
                }
                case '<': {
                    out.append("&lt;");
                    break;
                }
                default: {
                    out.append(c);
                }
            }
            ++i;
        }
        return out.toString();
    }

    public static String toHTML(String string, boolean nbspAsEmpty, boolean brAsEnter) {
        if (StringUtil.isEmpty(string)) {
            if (nbspAsEmpty) {
                return "&nbsp;";
            }
            return "";
        }
        int j = string.length();
        StringBuilder out = new StringBuilder();
        int i = 0;
        while (i < j) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    out.append("&nbsp;");
                    break;
                }
                case '\"': {
                    out.append("&quot;");
                    break;
                }
                case '<': {
                    out.append("&lt;");
                    break;
                }
                case '>': {
                    out.append("&gt;");
                    break;
                }
                case '&': {
                    out.append("&amp;");
                    break;
                }
                case '\n': {
                    if (brAsEnter) {
                        out.append("<br>");
                        break;
                    }
                    out.append("&nbsp;");
                    break;
                }
                case '\r': {
                    break;
                }
                case '\t': {
                    out.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                    break;
                }
                default: {
                    out.append(c);
                }
            }
            ++i;
        }
        return out.toString();
    }

    public static boolean across(String[] list1, String[] list2) {
        if (list1 == null || list2 == null) {
            return false;
        }
        String[] stringArray = list1;
        int n = list1.length;
        int n2 = 0;
        while (n2 < n) {
            String s1 = stringArray[n2];
            String[] stringArray2 = list2;
            int n3 = list2.length;
            int n4 = 0;
            while (n4 < n3) {
                String s2 = stringArray2[n4];
                if (s1.equals(s2)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public static int indexOf(String[] list, String string) {
        if (list == null) {
            return -1;
        }
        int j = list.length;
        int i = 0;
        while (i < j) {
            if (list[i].equals(string)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String concat(String s, String ... more) {
        StringBuilder buf = new StringBuilder(s);
        String[] stringArray = more;
        int n = more.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            buf.append(t);
            ++n2;
        }
        return buf.toString();
    }

    public static boolean getBool(String value) {
        return StringUtil.isEqual(value, "1") || StringUtil.isSame(value, "true");
    }

    public static int stringOccur(String source, String dest) {
        if (StringUtil.isEmpty(source) || StringUtil.isEmpty(dest)) {
            return 0;
        }
        int pos = 0;
        int count = 0;
        while (pos != -1) {
            if ((pos = source.indexOf(dest, pos)) == -1) continue;
            ++pos;
            ++count;
        }
        return count;
    }

    public static boolean isNumeric(String string, boolean decimal) {
        int j;
        String ts = string.trim();
        if (decimal && StringUtil.stringOccur(string, ".") > 1) {
            return false;
        }
        if (ts.length() > 1 && StringUtil.isEqual(ts.substring(0, 1), "-")) {
            ts = ts.substring(1);
        }
        if ((j = ts.length()) == 0) {
            return false;
        }
        int i = 0;
        while (i < j) {
            char ch = ts.charAt(i);
            if (!(ch >= '0' && ch <= '9' || decimal && ch == '.')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String toLine(String string) {
        if (string == null) {
            return "";
        }
        int len = (string = string.trim()).length();
        if (len == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    buffer.append(' ');
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static List<Map.Entry<String, ?>> sortMapValue(Map<String, ?> map) {
        ArrayList list = new ArrayList(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, ?>>(){
            Collator collator = Collator.getInstance();

            @Override
            public int compare(Map.Entry<String, ?> e1, Map.Entry<String, ?> e2) {
                CollationKey key1 = this.collator.getCollationKey(e1.getValue().toString().toLowerCase());
                CollationKey key2 = this.collator.getCollationKey(e2.getValue().toString().toLowerCase());
                return key1.compareTo(key2);
            }
        });
        return list;
    }

    public static List<Map.Entry<String, ?>> sortMapKey(Map<String, ?> map) {
        return StringUtil.sortMapKey(map, false);
    }

    public static List<Map.Entry<String, ?>> sortMapKey(Map<String, ?> map, boolean keyAsNumber) {
        ArrayList list = new ArrayList(map.entrySet());
        final boolean keyAsNum = keyAsNumber;
        Collections.sort(list, new Comparator<Map.Entry<String, ?>>(){
            Collator collator = Collator.getInstance();

            @Override
            public int compare(Map.Entry<String, ?> e1, Map.Entry<String, ?> e2) {
                if (keyAsNum) {
                    return Integer.parseInt(e1.getKey()) - Integer.parseInt(e2.getKey());
                }
                CollationKey key1 = this.collator.getCollationKey(e1.getKey().toLowerCase());
                CollationKey key2 = this.collator.getCollationKey(e2.getKey().toLowerCase());
                return key1.compareTo(key2);
            }
        });
        return list;
    }

    public static String getNamePart(String string) {
        if (string == null) {
            return "";
        }
        int index = string.indexOf(61);
        if (index == -1) {
            return string;
        }
        return string.substring(0, index);
    }

    public static String getValuePart(String string) {
        if (string == null) {
            return "";
        }
        int index = string.indexOf(61);
        if (index == -1) {
            return "";
        }
        return string.substring(index + 1);
    }

    public static String replaceParameters(HttpServletRequest request, String text) throws Exception {
        int start = 0;
        int startPos = text.indexOf("{#", start);
        int endPos = text.indexOf("#}", startPos + 2);
        if (startPos != -1 && endPos != -1) {
            StringBuilder buf = new StringBuilder();
            while (startPos != -1 && endPos != -1) {
                String paramValue;
                String paramName = text.substring(startPos + 2, endPos);
                String prefix = StringUtil.substring(paramName, 0, 4);
                if (prefix.equals("Var.")) {
                    paramValue = Var.get(paramName.substring(4));
                    if (paramValue == null) {
                        paramValue = "";
                    }
                } else {
                    paramValue = prefix.equals("Str.") ? Str.format(request, paramName.substring(4), new String[0]) : WebUtil.fetch(request, paramName);
                }
                buf.append(text.substring(start, startPos));
                buf.append(paramValue);
                start = endPos + 2;
                startPos = text.indexOf("{#", start);
                endPos = text.indexOf("#}", startPos + 2);
            }
            buf.append(text.substring(start));
            return buf.toString();
        }
        return text;
    }

    public static String replace(String string, String oldString, String newString) {
        return StringUtil.innerReplace(string, oldString, newString, true);
    }

    public static String replaceFirst(String string, String oldString, String newString) {
        return StringUtil.innerReplace(string, oldString, newString, false);
    }

    public static String substring(String string, int pos, int len) {
        if (string == null || string.length() < len - pos) {
            return "";
        }
        return string.substring(pos, pos + len);
    }

    public static String joinArray(String[] list, String spliter) {
        StringBuilder buf = new StringBuilder();
        boolean isFirst = true;
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(spliter);
            }
            buf.append(s);
            ++n2;
        }
        return buf.toString();
    }

    public static String joinList(Iterable<String> list, String spliter) {
        StringBuilder buf = new StringBuilder();
        boolean isFirst = true;
        for (String s : list) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(spliter);
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public static String getUtfString(InputStream stream) throws Exception {
        return StringUtil.getString(stream, "utf-8");
    }

    public static String getString(InputStream stream) throws Exception {
        return StringUtil.getString(stream, Var.get("server.charset"));
    }

    public static String getString(InputStream stream, String charset) throws Exception {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            SysUtil.isToOs(stream, os);
            if (StringUtil.isEmpty(charset)) {
                String string = new String(os.toByteArray());
                return string;
            }
            String string = new String(os.toByteArray(), charset);
            return string;
        }
        finally {
            stream.close();
        }
    }

    private static String innerReplace(String string, String oldString, String newString, boolean isAll) {
        if (string == null) {
            return "";
        }
        int index = string.indexOf(oldString);
        if (index == -1) {
            return string;
        }
        int start = 0;
        int len = oldString.length();
        if (len == 0) {
            return string;
        }
        StringBuilder buffer = new StringBuilder(string.length() + len);
        do {
            buffer.append(string.substring(start, index));
            buffer.append(newString);
            start = index + len;
        } while (isAll && (index = string.indexOf(oldString, start)) != -1);
        buffer.append(string.substring(start));
        return buffer.toString();
    }

    public static String quote(String string) {
        if (string == null) {
            return "\"\"";
        }
        int len = string.length();
        if (len == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        int i = 0;
        while (i < len) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    break;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u");
                        sb.append(t.substring(t.length() - 4));
                        break;
                    }
                    sb.append(c);
                }
            }
            ++i;
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String[] merge(String[] list1, String[] list2) {
        int l = list1.length;
        int j = l + list2.length;
        String[] list = new String[j];
        int i = 0;
        while (i < j) {
            list[i] = i < l ? list1[i] : list2[i - l];
            ++i;
        }
        return list;
    }

    public static String optString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String byteToHex(byte[] bs) {
        StringBuilder buf = new StringBuilder(bs.length * 2);
        byte[] byArray = bs;
        int n = bs.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            String s = Integer.toHexString(b & 0xFF);
            if (s.length() == 1) {
                buf.append('0');
            }
            buf.append(s);
            ++n2;
        }
        return buf.toString().toUpperCase();
    }

    public static byte[] hexToByte(String s) {
        int j = s.length() / 2;
        char[] b = s.toCharArray();
        byte[] d = new byte[j];
        int i = 0;
        while (i < j) {
            int k = i * 2;
            d[i] = (byte)(HexCharSet.indexOf(b[k]) << 4 | HexCharSet.indexOf(b[k + 1]));
            ++i;
        }
        return d;
    }

    public static String encodeBase64(InputStream is) throws Exception {
        ByteArrayOutputStream bos2;
        OutputStream eos = null;
        try {
            ByteArrayOutputStream bos1 = new ByteArrayOutputStream();
            bos2 = new ByteArrayOutputStream();
            SysUtil.isToOs(is, bos1);
            eos = MimeUtility.encode((OutputStream)bos2, (String)"base64");
            eos.write(bos1.toByteArray());
        }
        finally {
            is.close();
            if (eos != null) {
                eos.close();
            }
        }
        return new String(bos2.toByteArray());
    }

    public static byte[] decodeBase64(String data) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        InputStream bis = MimeUtility.decode((InputStream)is, (String)"base64");
        try {
            SysUtil.isToOs(bis, os);
        }
        finally {
            bis.close();
        }
        return os.toByteArray();
    }

    public static String encode(Object obj) throws Exception {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof InputStream) {
            return StringUtil.quote(StringUtil.encodeBase64((InputStream)obj));
        }
        if (obj instanceof Number || obj instanceof Boolean) {
            return obj.toString();
        }
        return StringUtil.quote(obj.toString());
    }
}

