/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.utils;

import com.webbuilder.utils.FileUtil;
import com.webbuilder.utils.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonUtil {
    public static HashMap<JSONObject, JSONObject> getRelations(JSONArray jsonArray, ArrayList<JSONObject> children, String key) throws Exception {
        HashMap<JSONObject, JSONObject> map = new HashMap<JSONObject, JSONObject>();
        JsonUtil.markParent(map, null, jsonArray, children, key);
        return map;
    }

    private static void markParent(HashMap<JSONObject, JSONObject> map, JSONObject parent, JSONArray jsonArray, ArrayList<JSONObject> children, String key) throws Exception {
        int j = jsonArray.length();
        int i = 0;
        while (i < j) {
            JSONArray ja;
            JSONObject jo = jsonArray.getJSONObject(i);
            if (parent != null) {
                map.put(jo, parent);
            }
            if ((ja = jo.optJSONArray(key)) == null) {
                children.add(jo);
            } else {
                JsonUtil.markParent(map, jo, ja, children, key);
            }
            ++i;
        }
    }

    public static String insert(JSONArray ja, String text, int index) throws Exception {
        StringBuilder sb = new StringBuilder();
        int j = ja.length();
        sb.append('[');
        int i = 0;
        while (i < index) {
            sb.append(ja.get(i).toString());
            sb.append(',');
            ++i;
        }
        sb.append(text);
        i = index;
        while (i < j) {
            sb.append(',');
            sb.append(ja.get(i).toString());
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }

    public static JSONObject readObject(File file) throws Exception {
        String s = FileUtil.readUtfText(file);
        if (StringUtil.isEmpty(s)) {
            return new JSONObject();
        }
        return new JSONObject(s.substring(s.indexOf(123)));
    }

    public static JSONArray readArray(File file) throws Exception {
        String s = FileUtil.readUtfText(file);
        if (StringUtil.isEmpty(s)) {
            return new JSONArray();
        }
        return new JSONArray(s.substring(s.indexOf(91)));
    }

    public static String optString(JSONObject jo, String key) {
        if (jo.isNull(key)) {
            return "";
        }
        return jo.optString(key);
    }

    public static String optString(JSONArray ja, int index) {
        if (ja.isNull(index)) {
            return "";
        }
        return ja.optString(index);
    }

    public static Object opt(JSONObject jo, String key) {
        if (jo.isNull(key)) {
            return null;
        }
        return jo.opt(key);
    }

    public static Object opt(JSONArray ja, int index) {
        if (ja.isNull(index)) {
            return null;
        }
        return ja.opt(index);
    }

    public static void clear(JSONObject jo) throws Exception {
        Iterator t = jo.keys();
        while (t.hasNext()) {
            jo.put((String)t.next(), (Object)"");
        }
    }

    public static String getText(ArrayList<String> list) {
        StringBuilder buf = new StringBuilder();
        boolean isFirst = true;
        buf.append('[');
        for (String s : list) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(',');
            }
            buf.append(StringUtil.quote(s));
        }
        buf.append(']');
        return buf.toString();
    }

    public static JSONObject findObject(JSONArray ja, String key, String text) throws Exception {
        int j = ja.length();
        int i = 0;
        while (i < j) {
            JSONObject jo = ja.getJSONObject(i);
            if (JsonUtil.optString(jo, key).equals(text)) {
                return jo;
            }
            ++i;
        }
        return null;
    }
}

