/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.utils;

import com.webbuilder.common.Main;
import com.webbuilder.common.Str;
import com.webbuilder.common.Var;
import com.webbuilder.controls.Query;
import com.webbuilder.utils.DateUtil;
import com.webbuilder.utils.FileUtil;
import com.webbuilder.utils.JsonUtil;
import com.webbuilder.utils.StringUtil;
import com.webbuilder.utils.SysUtil;
import com.webbuilder.utils.WebUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.json.JSONArray;
import org.json.JSONObject;

public class DbUtil {
    public static void testJndi(String jndi) throws Exception {
        Connection conn = DbUtil.getConnection(jndi);
        conn.close();
    }

    public static void importData(Connection conn, String tableName, JSONArray ja) throws Exception {
        int y;
        StringBuilder buf;
        PreparedStatement st;
        ResultSet rs;
        block8: {
            rs = null;
            st = null;
            buf = new StringBuilder();
            y = ja.length();
            if (y >= 2) break block8;
            DbUtil.closeResultSet(rs);
            DbUtil.closeStatement(st);
            return;
        }
        try {
            JSONArray rec = ja.getJSONArray(0);
            int j = rec.length();
            int i = 0;
            while (i < j) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(rec.getString(i));
                ++i;
            }
            String fields = buf.toString();
            rs = DbUtil.getResultSet(conn, StringUtil.concat("select ", fields, " from ", tableName, " where 1=0"));
            ResultSetMetaData meta = rs.getMetaData();
            int[] types = new int[j];
            i = 0;
            while (i < j) {
                types[i] = meta.getColumnType(i + 1);
                ++i;
            }
            st = conn.prepareStatement(StringUtil.concat("insert into ", tableName, "(", fields, ") values (", StringUtil.duplicate(",?", j).substring(1), ")"));
            int x = 1;
            while (x < y) {
                rec = ja.getJSONArray(x);
                i = 0;
                while (i < j) {
                    DbUtil.setObject(st, i + 1, types[i], JsonUtil.opt(rec, i));
                    ++i;
                }
                st.addBatch();
                ++x;
            }
            st.executeBatch();
        }
        catch (Throwable throwable) {
            DbUtil.closeResultSet(rs);
            DbUtil.closeStatement(st);
            throw throwable;
        }
        DbUtil.closeResultSet(rs);
        DbUtil.closeStatement(st);
    }

    public static Connection getConnection() throws Exception {
        return DbUtil.getConnection("");
    }

    public static Connection getConnection(HttpServletRequest request) throws Exception {
        return DbUtil.getConnection(request, null);
    }

    public static Connection getConnection(String jndi) throws Exception {
        if (StringUtil.isEmpty(jndi)) {
            jndi = Var.get("server.jndi");
        }
        InitialContext ctx = new InitialContext();
        DataSource ds = (DataSource)ctx.lookup(jndi);
        return ds.getConnection();
    }

    public static Connection getConnection(HttpServletRequest request, String jndi) throws Exception {
        Connection conn;
        String jn = StringUtil.isEmpty(jndi) ? Var.get("server.jndi") : jndi;
        String storeName = "jndi@@" + jn;
        Object obj = request.getAttribute(storeName);
        if (obj == null) {
            conn = DbUtil.getConnection(jn);
            request.setAttribute(storeName, (Object)conn);
        } else {
            conn = (Connection)obj;
        }
        return conn;
    }

    public static void closeConnection(Connection connection) {
        DbUtil.closeConnection(connection, true);
    }

    public static void closeConnection(Connection connection, boolean rollBack) {
        block11: {
            if (connection == null) {
                return;
            }
            try {
                if (connection.isClosed()) {
                    return;
                }
                try {
                    try {
                        if (connection.getAutoCommit()) break block11;
                        if (rollBack) {
                            connection.rollback();
                            break block11;
                        }
                        connection.commit();
                    }
                    catch (Throwable e) {
                        if (!rollBack) {
                            connection.rollback();
                        }
                        connection.close();
                        connection = null;
                    }
                }
                finally {
                    connection.close();
                    connection = null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static ResultSet getResultSet(Connection conn, String sql) throws Exception {
        PreparedStatement st = conn.prepareStatement(sql);
        try {
            return st.executeQuery();
        }
        catch (Throwable e) {
            DbUtil.closeStatement(st);
            throw new Exception(e);
        }
    }

    public static void closeResultSet(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        Statement stm = null;
        try {
            try {
                stm = resultSet.getStatement();
            }
            catch (Throwable throwable) {
                try {
                    resultSet.close();
                    resultSet = null;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                DbUtil.closeStatement(stm);
            }
        }
        finally {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Throwable throwable) {}
            DbUtil.closeStatement(stm);
        }
    }

    public static void closeStatement(Statement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
            statement = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static ArrayList<String> listJndi() throws Exception {
        HashMap<String, String> buffer = Var.getServerVar();
        Set<Map.Entry<String, String>> es = buffer.entrySet();
        ArrayList<String> list = new ArrayList<String>(buffer.size());
        for (Map.Entry<String, String> e : es) {
            String k = e.getKey();
            if (k.toLowerCase().indexOf("jndi") == -1) continue;
            list.add("Var.server." + k);
        }
        return list;
    }

    public static void startTrans(Connection connection, String isolation) throws Exception {
        if (!connection.getAutoCommit()) {
            connection.commit();
        }
        connection.setAutoCommit(false);
        if (!StringUtil.isEmpty(isolation)) {
            if (isolation.equals("readUncommitted")) {
                connection.setTransactionIsolation(1);
            } else if (isolation.equals("readCommitted")) {
                connection.setTransactionIsolation(2);
            } else if (isolation.equals("repeatableRead")) {
                connection.setTransactionIsolation(4);
            } else if (isolation.equals("serializable")) {
                connection.setTransactionIsolation(8);
            }
        }
    }

    public static boolean isBlobField(int type) {
        switch (type) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTextField(int type) {
        switch (type) {
            case -16: 
            case -1: 
            case 2005: 
            case 2011: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLargeField(int type) {
        switch (type) {
            case -16: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 2004: 
            case 2005: 
            case 2011: {
                return true;
            }
        }
        return false;
    }

    public static void loadFirstRow(HttpServletRequest request, String queryName) throws Exception {
        ResultSet resultSet = (ResultSet)request.getAttribute(queryName);
        if (!resultSet.next()) {
            return;
        }
        ResultSetMetaData meta = resultSet.getMetaData();
        int j = meta.getColumnCount();
        int i = 1;
        while (i <= j) {
            int type = meta.getColumnType(i);
            String name = String.valueOf(queryName) + "." + meta.getColumnLabel(i);
            if (DbUtil.isBlobField(type)) {
                request.setAttribute(name, (Object)resultSet.getBinaryStream(i));
            } else {
                request.setAttribute(name, DbUtil.getObject(resultSet, i, type));
            }
            ++i;
        }
    }

    public static String getTypeCategory(int type) {
        switch (type) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return "int";
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return "float";
            }
            case 91: 
            case 92: 
            case 93: {
                return "date";
            }
            case -7: 
            case 16: {
                return "bool";
            }
        }
        return "string";
    }

    public static String getFields(ResultSetMetaData meta, int colCount, boolean dateAsString, JSONObject keyMap) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int i = 0;
        while (i < colCount) {
            String fmt;
            if (i > 0) {
                buf.append(',');
            }
            buf.append("{name:");
            String name = meta.getColumnLabel(i + 1);
            if (StringUtil.isEmpty(name)) {
                name = "FIELD" + Integer.toString(i + 1);
            }
            buf.append(StringUtil.quote(name));
            buf.append(",type:\"");
            int type = keyMap != null && keyMap.has(name) ? 12 : meta.getColumnType(i + 1);
            if (dateAsString && (type == 93 || type == 91 || type == 92)) {
                type = 12;
            }
            String category = DbUtil.getTypeCategory(type);
            buf.append(category);
            switch (type) {
                case 91: 
                case 93: {
                    fmt = "Y-m-d H:i:s.u";
                    break;
                }
                case 92: {
                    fmt = "H:i:s";
                    break;
                }
                default: {
                    fmt = null;
                }
            }
            if (fmt != null) {
                buf.append("\",dateFormat:\"");
                buf.append(fmt);
            }
            buf.append("\"}");
            ++i;
        }
        buf.append(']');
        return buf.toString();
    }

    public static String getColumns(ResultSetMetaData meta, int colCount, String editorType, boolean rowNumber, boolean dateAsString, JSONObject keyMap) throws Exception {
        StringBuilder buf = new StringBuilder();
        int editor = editorType.equals("editable") ? 1 : (editorType.equals("readOnly") ? 2 : 0);
        buf.append('[');
        if (rowNumber) {
            buf.append("{width:45,sortable:false,hideable:false,type:\"rowNumber\",renderer:\"Wb.nr\",align:\"right\"}");
        }
        int i = 0;
        while (i < colCount) {
            String field;
            if (rowNumber || i > 0) {
                buf.append(',');
            }
            if (StringUtil.isEmpty(field = meta.getColumnLabel(i + 1))) {
                field = "FIELD" + Integer.toString(i + 1);
            }
            String name = StringUtil.quote(field);
            buf.append("{dataIndex:");
            buf.append(name);
            buf.append(",header:");
            buf.append(name);
            boolean isMap = keyMap != null && keyMap.has(field);
            int type = isMap ? 12 : meta.getColumnType(i + 1);
            boolean isText = DbUtil.isTextField(type);
            boolean isBlob = DbUtil.isBlobField(type);
            String renderer = "Wb.htmlRender";
            String validator = "";
            int len = isMap ? 20 : (isText ? 25 : (isBlob ? 6 : meta.getColumnDisplaySize(i + 1)));
            switch (type) {
                case 91: 
                case 93: {
                    if (editor == 1) {
                        validator = "Wb.tsValidator";
                    }
                    if (!dateAsString) {
                        renderer = "Wb.dateRender";
                    }
                    len = 18;
                    break;
                }
                case 92: {
                    if (editor == 1) {
                        validator = "Wb.tmValidator";
                    }
                    if (!dateAsString) {
                        renderer = "Wb.timeRender";
                    }
                    len = 10;
                    break;
                }
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    buf.append(",align:\"right\"");
                    if (editor != 1) break;
                    validator = "Wb.numValidator";
                }
            }
            if (editor == 1 && isBlob) {
                buf.append(",renderer:\"Wb.downRender('" + field + "')\"");
            } else {
                buf.append(",renderer:");
                buf.append(StringUtil.quote(renderer));
            }
            buf.append(",sortable:true,width:");
            int k = name.length() - 1;
            if (len < k) {
                len = k;
            }
            if (len < 5) {
                len = 5;
            }
            if (len > 25) {
                len = 25;
            }
            buf.append(len * 9);
            if (editor > 0 && !isBlob) {
                buf.append(",editor:{xtype:\"");
                if (isText) {
                    buf.append("textarea\",height:100");
                } else {
                    buf.append("textfield\"");
                }
                if (meta.isNullable(i + 1) == 0) {
                    buf.append(",allowBlank:false");
                }
                if (isMap || isBlob || editor == 2 || meta.isReadOnly(i + 1)) {
                    buf.append(",readOnly:true,fieldStyle:\"background-image:none;background-color:#C0C0C0\"");
                }
                if (!validator.isEmpty()) {
                    buf.append(",validator:");
                    buf.append(validator);
                }
                buf.append('}');
            }
            buf.append('}');
            ++i;
        }
        buf.append(']');
        return buf.toString();
    }

    public static Object query(HttpServletRequest request, String sql, boolean beginTrans, String jndi, String type, boolean loadData) throws Exception {
        JSONObject jo = new JSONObject();
        jo.put("id", (Object)SysUtil.getId());
        jo.put("sql", (Object)sql);
        jo.put("jndi", (Object)jndi);
        jo.put("type", (Object)type);
        jo.put("loadData", loadData);
        jo.put("transaction", (Object)(beginTrans ? "start" : ""));
        Query query = new Query();
        query.request = request;
        query.xwlObject = jo;
        query.create();
        return query.result;
    }

    public static ResultSet query(HttpServletRequest request, String sql) throws Exception {
        return (ResultSet)DbUtil.query(request, sql, false, null, "query", false);
    }

    public static ResultSet query(HttpServletRequest request, String sql, String jndi) throws Exception {
        return (ResultSet)DbUtil.query(request, sql, false, jndi, "query", false);
    }

    public static ResultSet query(HttpServletRequest request, String sql, String jndi, boolean loadData) throws Exception {
        return (ResultSet)DbUtil.query(request, sql, false, jndi, "query", loadData);
    }

    public static int update(HttpServletRequest request, String sql) throws Exception {
        return (Integer)DbUtil.query(request, sql, false, null, "update", false);
    }

    public static int update(HttpServletRequest request, String sql, String jndi) throws Exception {
        return (Integer)DbUtil.query(request, sql, false, jndi, "update", false);
    }

    public static int update(HttpServletRequest request, String sql, String jndi, boolean beginTrans) throws Exception {
        return (Integer)DbUtil.query(request, sql, beginTrans, jndi, "update", false);
    }

    public static Object execute(HttpServletRequest request, String sql) throws Exception {
        return DbUtil.query(request, sql, false, null, "execute", false);
    }

    public static Object execute(HttpServletRequest request, String sql, String jndi) throws Exception {
        return DbUtil.query(request, sql, false, jndi, "execute", false);
    }

    public static Object execute(HttpServletRequest request, String sql, String jndi, boolean beginTrans) throws Exception {
        return DbUtil.query(request, sql, beginTrans, jndi, "execute", false);
    }

    public static void outputBlob(ResultSet resultSet, HttpServletRequest request, HttpServletResponse response, boolean download) throws Exception {
        InputStream inputStream = null;
        int rowCount = resultSet.getMetaData().getColumnCount();
        String name = "blob.bin";
        String size = null;
        try {
            response.reset();
            if (resultSet.next()) {
                switch (rowCount) {
                    case 1: {
                        inputStream = resultSet.getBinaryStream(1);
                        break;
                    }
                    case 2: {
                        name = resultSet.getString(2);
                        inputStream = resultSet.getBinaryStream(1);
                        break;
                    }
                    case 3: {
                        name = resultSet.getString(2);
                        size = resultSet.getString(3);
                        inputStream = resultSet.getBinaryStream(1);
                    }
                }
            } else {
                throw new Exception(Str.format(request, "objectNotExist", new String[0]));
            }
            ServletOutputStream outputStream = response.getOutputStream();
            if (download) {
                response.setHeader("content-type", "application/force-download");
            } else {
                response.setHeader("content-type", "application/octet-stream");
            }
            response.setHeader("content-disposition", "attachment;" + WebUtil.encodeFilename(request, name));
            if (size != null) {
                response.setHeader("content-length", size);
            }
            if (inputStream != null) {
                SysUtil.isToOs(inputStream, (OutputStream)outputStream);
            }
            response.flushBuffer();
        }
        catch (Throwable throwable) {
            SysUtil.closeInputStream(inputStream);
            throw throwable;
        }
        SysUtil.closeInputStream(inputStream);
    }

    public static void outputImage(ResultSet resultSet, HttpServletRequest request, HttpServletResponse response, String format) throws Exception {
        InputStream inputStream = null;
        int rowCount = resultSet.getMetaData().getColumnCount();
        String name = "file";
        String size = null;
        try {
            response.reset();
            if (StringUtil.isEqual(format, "image")) {
                format = null;
            }
            if (resultSet.next()) {
                switch (rowCount) {
                    case 1: {
                        inputStream = resultSet.getBinaryStream(1);
                        break;
                    }
                    case 2: {
                        name = resultSet.getString(2);
                        if (format == null) {
                            format = FileUtil.extractFileExt(name);
                        }
                        inputStream = resultSet.getBinaryStream(1);
                        break;
                    }
                    case 3: {
                        name = resultSet.getString(2);
                        size = resultSet.getString(3);
                        if (format == null) {
                            format = FileUtil.extractFileExt(name);
                        }
                        inputStream = resultSet.getBinaryStream(1);
                    }
                }
            }
            ServletOutputStream outputStream = response.getOutputStream();
            if (inputStream == null) {
                inputStream = new FileInputStream(new File(Main.path, "webbuilder/images/null.gif"));
                format = "gif";
            }
            if (format != null) {
                response.setContentType("image/" + format);
            }
            response.setHeader("content-disposition", "attachment;" + WebUtil.encodeFilename(request, name));
            if (size != null) {
                response.setHeader("content-length", size);
            }
            if (inputStream != null) {
                SysUtil.isToOs(inputStream, (OutputStream)outputStream);
            }
            response.flushBuffer();
        }
        catch (Throwable throwable) {
            SysUtil.closeInputStream(inputStream);
            throw throwable;
        }
        SysUtil.closeInputStream(inputStream);
    }

    public static void exportData(Writer writer, ResultSet rs) throws Exception {
        ResultSetMetaData meta = rs.getMetaData();
        int j = meta.getColumnCount();
        int ct = 0;
        int[] types = new int[j];
        writer.write("[[");
        int i = 0;
        while (i < j) {
            types[i] = meta.getColumnType(i + 1);
            if (i > 0) {
                writer.write(44);
            }
            writer.write(meta.getColumnName(i + 1));
            ++i;
        }
        writer.write(93);
        while (rs.next()) {
            writer.write(",[");
            i = 0;
            while (i < j) {
                if (i > 0) {
                    writer.write(44);
                }
                writer.write(StringUtil.encode(DbUtil.getObject(rs, i + 1, types[i], false)));
                ++i;
            }
            writer.write(93);
            ++ct;
        }
        writer.write(93);
        writer.flush();
    }

    public static String getArray(ResultSet rs) throws Exception {
        StringBuilder buf = new StringBuilder();
        ResultSetMetaData meta = rs.getMetaData();
        int j = meta.getColumnCount();
        int ct = 0;
        int[] types = new int[j];
        int limit = Var.getInt("webbuilder.control.limitRecords");
        boolean isFirst = true;
        int i = 0;
        while (i < j) {
            types[i] = meta.getColumnType(i + 1);
            ++i;
        }
        buf.append('[');
        while (rs.next()) {
            if (ct > limit) break;
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(',');
            }
            if (j > 1) {
                buf.append('[');
                i = 0;
                while (i < j) {
                    if (i > 0) {
                        buf.append(',');
                    }
                    buf.append(StringUtil.encode(DbUtil.getObject(rs, i + 1, types[i], true)));
                    ++i;
                }
                buf.append(']');
            } else {
                buf.append(StringUtil.encode(DbUtil.getObject(rs, 1, types[0], true)));
            }
            ++ct;
        }
        buf.append(']');
        return buf.toString();
    }

    public static String getCharStream(ResultSet rs, int index) throws Exception {
        return (String)DbUtil.getObject(rs, index, -1);
    }

    public static void setCharStream(PreparedStatement st, int index, String value) throws Exception {
        DbUtil.setObject(st, index, -1, value);
    }

    public static Object getObject(CallableStatement st, int index, int type) throws Exception {
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                return st.getString(index);
            }
            case 4: {
                return st.getInt(index);
            }
            case -6: {
                return st.getByte(index);
            }
            case 5: {
                return st.getShort(index);
            }
            case -5: {
                return st.getLong(index);
            }
            case 6: 
            case 7: {
                return Float.valueOf(st.getFloat(index));
            }
            case 8: {
                return st.getDouble(index);
            }
            case 2: 
            case 3: {
                return st.getBigDecimal(index);
            }
            case 91: 
            case 93: {
                return st.getTimestamp(index);
            }
            case 92: {
                return st.getTime(index);
            }
            case -7: 
            case 16: {
                return st.getBoolean(index);
            }
            case -16: 
            case -1: 
            case 2005: 
            case 2011: {
                Reader rd = st.getCharacterStream(index);
                if (rd == null) {
                    return null;
                }
                return SysUtil.readString(rd);
            }
        }
        return st.getObject(index);
    }

    public static Object getObject(ResultSet rs, int index, int type) throws Exception {
        return DbUtil.getObject(rs, index, type, true);
    }

    public static Object getObject(ResultSet rs, int index, int type, boolean ignoreBlob) throws Exception {
        Object obj;
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                obj = rs.getString(index);
                break;
            }
            case 4: {
                obj = rs.getInt(index);
                break;
            }
            case -6: {
                obj = rs.getByte(index);
                break;
            }
            case 5: {
                obj = rs.getShort(index);
                break;
            }
            case -5: {
                obj = rs.getLong(index);
                break;
            }
            case 6: 
            case 7: {
                obj = Float.valueOf(rs.getFloat(index));
                break;
            }
            case 8: {
                obj = rs.getDouble(index);
                break;
            }
            case 2: 
            case 3: {
                obj = rs.getBigDecimal(index);
                break;
            }
            case 91: 
            case 93: {
                obj = rs.getTimestamp(index);
                break;
            }
            case 92: {
                obj = rs.getTime(index);
                break;
            }
            case -7: 
            case 16: {
                obj = rs.getBoolean(index);
                break;
            }
            case -16: 
            case -1: 
            case 2005: 
            case 2011: {
                Reader rd = rs.getCharacterStream(index);
                if (rd == null) {
                    obj = null;
                    break;
                }
                obj = SysUtil.readString(rd);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                InputStream is = rs.getBinaryStream(index);
                if (ignoreBlob) {
                    if (is == null) {
                        return "(blob)";
                    }
                    is.close();
                    return "(BLOB)";
                }
                return is;
            }
            default: {
                obj = rs.getObject(index);
            }
        }
        if (rs.wasNull()) {
            return null;
        }
        return obj;
    }

    public static void setObject(PreparedStatement st, int index, int type, Object obj) throws Exception {
        if (obj != null && !(obj instanceof String)) {
            if (obj instanceof InputStream) {
                st.setBinaryStream(index, (InputStream)obj, ((InputStream)obj).available());
            } else if (obj instanceof Date) {
                st.setTimestamp(index, new Timestamp(((Date)obj).getTime()));
            } else if (type != 12) {
                st.setObject(index, obj, type);
            } else {
                st.setObject(index, obj);
            }
            return;
        }
        String value = obj == null ? null : (String)obj;
        if (StringUtil.isEmpty(value)) {
            st.setNull(index, type);
        } else {
            switch (type) {
                case -15: 
                case -9: 
                case 1: 
                case 12: {
                    st.setString(index, value);
                    break;
                }
                case 4: {
                    st.setInt(index, Integer.parseInt(value));
                    break;
                }
                case -6: {
                    st.setByte(index, Byte.parseByte(value));
                    break;
                }
                case 5: {
                    st.setShort(index, Short.parseShort(value));
                    break;
                }
                case -5: {
                    st.setLong(index, Long.parseLong(value));
                    break;
                }
                case 6: 
                case 7: {
                    st.setFloat(index, Float.parseFloat(value));
                    break;
                }
                case 8: {
                    st.setDouble(index, Double.parseDouble(value));
                    break;
                }
                case 2: 
                case 3: {
                    st.setBigDecimal(index, new BigDecimal(value));
                    break;
                }
                case 91: 
                case 93: {
                    st.setTimestamp(index, Timestamp.valueOf(DateUtil.fixTimestamp(value)));
                    break;
                }
                case 92: {
                    st.setTime(index, Time.valueOf(DateUtil.fixTime(value)));
                    break;
                }
                case -7: 
                case 16: {
                    st.setBoolean(index, StringUtil.getBool(value));
                    break;
                }
                case -16: 
                case -1: 
                case 2005: 
                case 2011: {
                    st.setCharacterStream(index, (Reader)new StringReader(value), value.length());
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    ByteArrayInputStream is = new ByteArrayInputStream(StringUtil.decodeBase64(value));
                    st.setBinaryStream(index, (InputStream)is, ((InputStream)is).available());
                    break;
                }
                default: {
                    st.setObject(index, (Object)value, type);
                }
            }
        }
    }
}

