/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.utils;

import com.webbuilder.utils.StringUtil;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static String formatDate(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public static String getDateString(Date date) {
        return DateUtil.formatDate(date, "yyyy-MM-dd");
    }

    public static String fixTimestamp(String str) {
        if (str.indexOf(58) == -1) {
            return String.valueOf(DateUtil.qualify(str)) + " 00:00:00";
        }
        int i = str.indexOf(32);
        return String.valueOf(DateUtil.qualify(str.substring(0, i))) + str.substring(i);
    }

    private static String qualify(String dateStr) {
        if (dateStr.length() == 10) {
            return dateStr;
        }
        String[] sec = StringUtil.split(dateStr, "-");
        if (sec.length == 3) {
            StringBuilder buf = new StringBuilder(10);
            buf.append(sec[0]);
            buf.append("-");
            if (sec[1].length() == 1) {
                buf.append("0");
            }
            buf.append(sec[1]);
            buf.append("-");
            if (sec[2].length() == 1) {
                buf.append("0");
            }
            buf.append(sec[2]);
            return buf.toString();
        }
        return dateStr;
    }

    public static String fixTime(String str) {
        if (str.indexOf(58) == -1) {
            return "00:00:00";
        }
        int b = str.indexOf(32);
        int e = str.indexOf(46);
        if (b == -1) {
            b = 0;
        }
        if (e == -1) {
            e = str.length();
        }
        return str.substring(b, e);
    }

    public static String getHours(long milliSecs) {
        long h = milliSecs / 3600000L;
        long hm = milliSecs % 3600000L;
        long m = hm / 60000L;
        long mm = hm % 60000L;
        long s = mm / 1000L;
        long sm = mm % 1000L;
        return StringUtil.concat(Long.toString(h), ":", Long.toString(m), ":", Long.toString(s), ".", Long.toString(sm));
    }

    public static int daysInMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.getActualMaximum(5);
    }

    public static int dayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static int yearOf(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static int dayOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(6);
    }

    public static int dayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7);
    }

    public static String toString(Date date) {
        if (date == null) {
            return "";
        }
        Timestamp t = new Timestamp(date.getTime());
        return t.toString();
    }

    public static Date incYear(Date date, int years) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, years);
        return cal.getTime();
    }

    public static Date incMonth(Date date, int months) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, months);
        return cal.getTime();
    }

    public static int hourOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(11);
    }

    public static Date incDay(Date date, long days) {
        return new Date(date.getTime() + 86400000L * days);
    }

    public static Date incSecond(Date date, long seconds) {
        return new Date(date.getTime() + 1000L * seconds);
    }
}

