/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.tool;

import com.webbuilder.common.Var;
import com.webbuilder.tool.ExcelObject;
import com.webbuilder.utils.DateUtil;
import com.webbuilder.utils.JsonUtil;
import com.webbuilder.utils.StringUtil;
import java.math.RoundingMode;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class PrintObject {
    public static final String printPath = "webbuilder.service.download.print.";

    public static String preview(JSONArray data, JSONArray meta, String title, String dateFormat, String timeFormat, String previewText, String numText, String numWidth, String thousandSeparator, String decimalSeparator) throws Exception {
        JSONObject jo;
        ArrayList<JSONObject> children = new ArrayList<JSONObject>();
        int flexColWidth = Var.getInt("webbuilder.service.download.excel.flexColumnWidth");
        String header = PrintObject.createHeaders(children, meta, numText, numWidth, flexColWidth);
        StringBuilder buf = new StringBuilder();
        int y = children.size();
        int width = 0;
        SimpleDateFormat defaultDateFormat = new SimpleDateFormat(PrintObject.toJavaDateFormat(dateFormat));
        SimpleDateFormat defaultTimeFormat = new SimpleDateFormat(PrintObject.toJavaDateFormat(timeFormat));
        SimpleDateFormat defaultDTFormat = new SimpleDateFormat(PrintObject.toJavaDateFormat(String.valueOf(dateFormat) + " " + timeFormat));
        int[] types = new int[y];
        String[] names = new String[y];
        String[] aligns = new String[y];
        Format[] formats = new Format[y];
        boolean[] isRate = new boolean[y];
        int x = 0;
        while (x < y) {
            jo = children.get(x);
            names[x] = jo.optString("dataIndex");
            types[x] = ExcelObject.getFieldType(jo);
            aligns[x] = JsonUtil.optString(jo, "align");
            String selFormat = JsonUtil.optString(jo, "ptFormat");
            width += jo.isNull("width") ? flexColWidth : jo.optInt("width");
            if (selFormat.isEmpty() && !(selFormat = JsonUtil.optString(jo, "jsFormat")).isEmpty()) {
                if (types[x] == 5) {
                    formats[x] = new SimpleDateFormat(PrintObject.toJavaDateFormat(selFormat));
                } else {
                    formats[x] = new DecimalFormat(PrintObject.toJavaNumFormat(selFormat));
                    DecimalFormat df = (DecimalFormat)formats[x];
                    df.setRoundingMode(RoundingMode.HALF_UP);
                    DecimalFormatSymbols dfs = new DecimalFormatSymbols();
                    dfs.setDecimalSeparator(decimalSeparator.charAt(0));
                    dfs.setGroupingSeparator(thousandSeparator.charAt(0));
                    df.setDecimalFormatSymbols(dfs);
                }
            }
            isRate[x] = selFormat.endsWith("%");
            ++x;
        }
        width = numWidth == null ? (width += 3 * (y - 1)) : (width += Integer.parseInt(numWidth) + 3 * y);
        buf.append("<!DOCTYPE html><html><head><meta http-equiv=\"content-type\" content=\"text/html;charset=utf-8\"><title>");
        if (StringUtil.isEmpty(title)) {
            buf.append(previewText);
        } else {
            buf.append(title);
        }
        buf.append("</title><style type=\"text/css\">table{border:1px solid #000000;table-layout:fixed;border-collapse:collapse");
        String fontName = Var.get("webbuilder.service.download.print.fontFamily");
        if (!StringUtil.isEmpty(fontName)) {
            buf.append(";font-family:");
            buf.append(fontName);
        }
        buf.append("}td{border:1px solid #000000;word-wrap:break-word;word-break:break-all;font-size:");
        buf.append(Var.get("webbuilder.service.download.print.fontSize"));
        buf.append("px}</style></head><body>");
        if (!StringUtil.isEmpty(title)) {
            buf.append("<p style=\"text-align:center;font-size:");
            buf.append(Var.get("webbuilder.service.download.print.titleFontSize"));
            buf.append("px");
            if (Var.getBool("webbuilder.service.download.print.titleFontBold")) {
                buf.append(";font-weight:bold");
            }
            if (!StringUtil.isEmpty(fontName = Var.get("webbuilder.service.download.print.titleFontFamily"))) {
                buf.append(";font-family:");
                buf.append(fontName);
            }
            buf.append(";width:");
            buf.append(width);
            buf.append("px\">");
            buf.append(PrintObject.toHTML(title));
            buf.append("</p>");
        }
        buf.append("<table width=\"");
        buf.append(width);
        buf.append("\"");
        buf.append(" border=\"1px\" cellspacing=\"0px\" cellpadding=\"3px\">");
        buf.append(header);
        int j = data.length();
        int i = 0;
        while (i < j) {
            buf.append("<tr>");
            if (numText != null) {
                buf.append("<td align=\"right\"");
                buf.append(">");
                buf.append(Integer.toString(i + 1));
                buf.append("</td>");
            }
            jo = data.getJSONObject(i);
            x = 0;
            while (x < y) {
                String value = JsonUtil.optString(jo, names[x]);
                if (!value.isEmpty()) {
                    switch (types[x]) {
                        case 2: 
                        case 3: {
                            if (formats[x] != null) {
                                double doubleVal = Double.parseDouble(value);
                                if (isRate[x]) {
                                    doubleVal /= 100.0;
                                }
                                value = formats[x].format(doubleVal);
                                break;
                            }
                            if (!value.endsWith(".0")) break;
                            value = value.substring(0, value.length() - 2);
                            break;
                        }
                        case 5: {
                            boolean isTime = value.indexOf(32) == -1;
                            Date dateValue = isTime ? Time.valueOf(value) : Timestamp.valueOf(value);
                            value = formats[x] != null ? formats[x].format(dateValue) : (isTime ? defaultTimeFormat.format((Object)dateValue) : (value.endsWith("00:00:00.0") ? defaultDateFormat.format((Object)dateValue) : defaultDTFormat.format((Object)dateValue)));
                            if (!value.endsWith("_X")) break;
                            value = String.valueOf(value.substring(0, value.length() - 2)) + (DateUtil.hourOfDay(dateValue) < 12 ? "AM" : "PM");
                        }
                    }
                }
                buf.append("<td align=\"");
                buf.append(aligns[x]);
                buf.append("\">");
                buf.append(PrintObject.toHTML(value));
                buf.append("</td>");
                ++x;
            }
            buf.append("</tr>");
            ++i;
        }
        buf.append("</table></body></html>");
        return buf.toString();
    }

    private static String toJavaNumFormat(String format) {
        int i = format.indexOf(46);
        i = i == -1 ? format.length() - 1 : --i;
        return String.valueOf(StringUtil.replace(format.substring(0, i), "0", "#")) + format.substring(i);
    }

    private static String toJavaDateFormat(String format) {
        String[][] map;
        String[][] stringArrayArray = map = new String[][]{{"y", "yy"}, {"Y", "yyyy"}, {"m", "MM"}, {"n", "M"}, {"d", "dd"}, {"j", "d"}, {"H", "HH"}, {"h", "hh"}, {"G", "H"}, {"g", "h"}, {"i", "mm"}, {"s", "ss"}, {"u", "SSS"}, {"A", "'_X'"}};
        int n = map.length;
        int n2 = 0;
        while (n2 < n) {
            String[] s = stringArrayArray[n2];
            format = StringUtil.replace(format, s[0], s[1]);
            ++n2;
        }
        return format;
    }

    private static String createHeaders(ArrayList<JSONObject> children, JSONArray columns, String numText, String numWidth, int flexColWidth) throws Exception {
        int depth;
        HashMap<JSONObject, JSONObject> relations = JsonUtil.getRelations(columns, children, "columns");
        int maxDepth = 0;
        StringBuilder buf = new StringBuilder();
        for (JSONObject o : children) {
            depth = 1;
            JSONObject parent = o;
            while ((parent = relations.get(parent)) != null) {
                parent.put("colspan", parent.optInt("colspan") + 1);
                ++depth;
            }
            o.put("depth", depth);
            maxDepth = Math.max(maxDepth, depth);
        }
        int x = 0;
        while (x < maxDepth) {
            buf.append("<tr style=\"");
            String bgColor = Var.get("webbuilder.service.download.print.headerFontBgColor");
            if (!StringUtil.isEmpty(bgColor)) {
                buf.append(";background-color:#");
                buf.append(bgColor);
            }
            if (Var.getBool("webbuilder.service.download.print.headerFontBold")) {
                buf.append(";font-weight:bold");
            }
            buf.append("\">");
            if (x == 0 && numText != null) {
                buf.append("<td align=\"right\"");
                if (maxDepth > 1) {
                    buf.append(" rowspan=\"");
                    buf.append(maxDepth);
                    buf.append("\"");
                }
                buf.append(" width=\"");
                buf.append(numWidth);
                buf.append("\">");
                buf.append(PrintObject.toHTML(numText));
                buf.append("</td>");
            }
            for (JSONObject item : children) {
                depth = item.optInt("depth");
                JSONObject jo = PrintObject.getAt(relations, item, x);
                if (jo == null) continue;
                int z = x == depth - 1 ? maxDepth - (depth - 1) : 1;
                buf.append("<td align=\"");
                buf.append(x == depth - 1 ? jo.optString("align") : "center");
                buf.append("\"");
                if (z > 1) {
                    buf.append(" rowspan=\"");
                    buf.append(z);
                    buf.append("\"");
                }
                if ((z = jo.optInt("colspan")) > 1) {
                    buf.append(" colspan=\"");
                    buf.append(z);
                    buf.append("\"");
                }
                if (!jo.has("columns")) {
                    buf.append(" width=\"");
                    buf.append(jo.isNull("width") ? flexColWidth : jo.optInt("width"));
                    buf.append("\"");
                }
                buf.append(">");
                buf.append(PrintObject.toHTML(JsonUtil.optString(jo, "text")));
                buf.append("</td>");
            }
            buf.append("</tr>");
            ++x;
        }
        return buf.toString();
    }

    private static String toHTML(String text) {
        return StringUtil.toHTML(text, true, true);
    }

    private static JSONObject getAt(HashMap<JSONObject, JSONObject> relations, JSONObject jo, int depth) throws Exception {
        int i = 1;
        int z = jo.getInt("depth");
        JSONObject parent = jo;
        while (z - i != depth) {
            ++i;
            if ((parent = relations.get(parent)) != null) continue;
        }
        if (parent != null) {
            if (parent.optBoolean("xwlProcessed")) {
                return null;
            }
            parent.put("xwlProcessed", true);
        }
        return parent;
    }
}

