/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.tool;

import com.webbuilder.common.Var;
import com.webbuilder.utils.JsonUtil;
import com.webbuilder.utils.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.json.JSONArray;
import org.json.JSONObject;

public class ExcelObject {
    public static final String excelPath = "webbuilder.service.download.excel.";

    public static String getColName(int colIndex) {
        String ch = colIndex < 26 ? String.valueOf((char)(colIndex + 65)) : String.valueOf(String.valueOf((char)(colIndex / 26 + 65 - 1))) + String.valueOf((char)(colIndex % 26 + 65));
        return ch;
    }

    public static byte[] getExcelBytes(JSONArray data, JSONArray columnsDefine, String groupName, String title, String sheetName, String dateFormat, String timeFormat, String totalText, String thousandSeparator, String decimalSeparator) throws Exception {
        JSONObject jo;
        HSSFCell cell;
        HSSFRow row;
        int startRow;
        String value;
        HSSFWorkbook book = new HSSFWorkbook();
        HSSFSheet sheet = book.createSheet("Sheet1");
        HashMap<String, HSSFCellStyle> cachedStyle = new HashMap<String, HSSFCellStyle>();
        int j = data.length();
        int k = 0;
        short rowHeight = (short)Var.getInt("webbuilder.service.download.excel.rowHeight");
        ArrayList<JSONObject> children = new ArrayList<JSONObject>();
        if (!StringUtil.isEmpty(sheetName)) {
            book.setSheetName(0, sheetName);
        }
        Short bgColor = StringUtil.isEmpty(value = Var.get("webbuilder.service.download.excel.headerFontBgColor")) ? null : Short.valueOf(Short.parseShort(value));
        dateFormat = ExcelObject.toExcelDateFormat(dateFormat);
        timeFormat = ExcelObject.toExcelDateFormat(timeFormat);
        if (StringUtil.isEmpty(title) || !Var.getBool("webbuilder.service.download.excel.showTitle")) {
            startRow = 0;
            row = null;
        } else {
            startRow = 1;
            row = sheet.createRow(0);
            row.setHeight((short)Var.getInt("webbuilder.service.download.excel.titleHeight"));
        }
        startRow = ExcelObject.createHeaders(children, sheet, book, bgColor, columnsDefine, startRow);
        int y = children.size();
        if (Var.getBool("webbuilder.service.download.excel.freezeHeader")) {
            sheet.createFreezePane(0, startRow);
        }
        if (row != null) {
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, y - 1));
            cell = row.createCell(0);
            cell.setCellStyle(ExcelObject.createTitleStyle(book));
            cell.setCellValue(title);
        }
        HSSFCellStyle[] styles = new HSSFCellStyle[y];
        HSSFCellStyle[] summaryStyles = new HSSFCellStyle[y];
        String[] names = new String[y];
        int[] types = new int[y];
        boolean[] isRate = new boolean[y];
        String[] aligns = new String[y];
        int[] dateTypes = new int[y];
        int x = 0;
        while (x < y) {
            jo = children.get(x);
            styles[x] = ExcelObject.createRowStyle(book, jo, null);
            summaryStyles[x] = ExcelObject.createRowStyle(book, jo, bgColor);
            names[x] = jo.optString("dataIndex");
            types[x] = ExcelObject.getFieldType(jo);
            String selFormat = JsonUtil.optString(jo, "format");
            if (selFormat.isEmpty()) {
                selFormat = JsonUtil.optString(jo, "jsFormat");
            }
            isRate[x] = selFormat.endsWith("%");
            aligns[x] = JsonUtil.optString(jo, "align");
            dateTypes[x] = 0;
            ++x;
        }
        HSSFCellStyle blankStyle = ExcelObject.getCellStyle(cachedStyle, book, "", "", null);
        j = data.length();
        int i = 0;
        while (i < j) {
            jo = data.getJSONObject(i);
            int curRow = i + startRow + k;
            row = sheet.createRow(curRow);
            row.setHeight(rowHeight);
            x = 0;
            while (x < y) {
                boolean nullStyle;
                cell = row.createCell(x);
                boolean bl = nullStyle = styles[x] == null;
                if (!nullStyle) {
                    cell.setCellStyle(styles[x]);
                }
                if ((value = JsonUtil.optString(jo, names[x])).isEmpty()) {
                    if (nullStyle) {
                        cell.setCellStyle(blankStyle);
                    }
                } else {
                    switch (types[x]) {
                        case 2: 
                        case 3: {
                            double doubleVal = Double.parseDouble(value);
                            if (isRate[x]) {
                                doubleVal /= 100.0;
                            }
                            cell.setCellValue(doubleVal);
                            break;
                        }
                        case 4: {
                            cell.setCellValue(StringUtil.getBool(value));
                            break;
                        }
                        case 5: {
                            HSSFCellStyle style;
                            if (value.indexOf(32) != -1) {
                                if (nullStyle) {
                                    if (value.endsWith("00:00:00.0")) {
                                        style = ExcelObject.getCellStyle(cachedStyle, book, dateFormat, aligns[x], null);
                                        cell.setCellStyle(style);
                                        if (dateTypes[x] == 0) {
                                            dateTypes[x] = 2;
                                        } else if (dateTypes[x] == 1) {
                                            dateTypes[x] = 3;
                                        }
                                    } else {
                                        style = ExcelObject.getCellStyle(cachedStyle, book, String.valueOf(dateFormat) + " " + timeFormat, aligns[x], null);
                                        cell.setCellStyle(style);
                                        if (dateTypes[x] < 3) {
                                            dateTypes[x] = 3;
                                        }
                                    }
                                }
                                cell.setCellValue((java.util.Date)Timestamp.valueOf(value));
                                break;
                            }
                            if (value.indexOf(45) != -1) {
                                if (nullStyle) {
                                    style = ExcelObject.getCellStyle(cachedStyle, book, dateFormat, aligns[x], null);
                                    cell.setCellStyle(style);
                                    if (dateTypes[x] == 0) {
                                        dateTypes[x] = 2;
                                    } else if (dateTypes[x] == 1) {
                                        dateTypes[x] = 3;
                                    }
                                }
                                cell.setCellValue((java.util.Date)Date.valueOf(value));
                                break;
                            }
                            if (nullStyle) {
                                style = ExcelObject.getCellStyle(cachedStyle, book, timeFormat, aligns[x], null);
                                cell.setCellStyle(style);
                                if (dateTypes[x] == 0) {
                                    dateTypes[x] = 1;
                                }
                            }
                            cell.setCellValue((java.util.Date)Time.valueOf(value));
                            break;
                        }
                        default: {
                            cell.setCellValue(value);
                        }
                    }
                }
                ++x;
            }
            ++i;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        book.write((OutputStream)os);
        return os.toByteArray();
    }

    private static HSSFCellStyle getCellStyle(HashMap<String, HSSFCellStyle> cache, HSSFWorkbook book, String format, String align, Short bgColor) throws Exception {
        String key = StringUtil.concat(format, ".", align, ".", bgColor == null ? "x" : Short.toString(bgColor));
        HSSFCellStyle style = cache.get(key);
        if (style == null) {
            style = ExcelObject.createRowStyle(book, new JSONObject(StringUtil.concat("{format:", StringUtil.quote(format), ",align:\"", align, "\"}")), bgColor);
            cache.put(key, style);
        }
        return style;
    }

    public static int getFieldType(JSONObject jo) {
        String[] types = new String[]{"auto", "string", "int", "float", "boolean", "date"};
        return StringUtil.indexOf(types, JsonUtil.optString(jo, "type"));
    }

    private static int createHeaders(ArrayList<JSONObject> children, HSSFSheet sheet, HSSFWorkbook book, Short bgColor, JSONArray columns, int startRow) throws Exception {
        HSSFCell cell;
        int x;
        JSONObject parent;
        int depth;
        HashMap<JSONObject, JSONObject> relations = JsonUtil.getRelations(columns, children, "columns");
        int maxDepth = 1;
        HashMap<String, HSSFCell> map = new HashMap<String, HSSFCell>();
        for (JSONObject jo : children) {
            depth = 1;
            parent = jo;
            while ((parent = relations.get(parent)) != null) {
                parent.put("size", parent.optInt("size") + 1);
                ++depth;
            }
            jo.put("depth", depth);
            maxDepth = Math.max(maxDepth, depth);
        }
        int y = children.size();
        int height = Var.getInt("webbuilder.service.download.excel.headerHeight");
        int flexColWidth = Var.getInt("webbuilder.service.download.excel.flexColumnWidth");
        int i = 0;
        while (i < maxDepth) {
            HSSFRow row = sheet.createRow(i + startRow);
            row.setHeight((short)height);
            x = 0;
            while (x < y) {
                JSONObject jco;
                cell = row.createCell(x);
                depth = (jco = children.get(x)).getInt("depth");
                cell.setCellStyle(ExcelObject.createHeaderStyle(book, bgColor, jco, i < depth - 1));
                map.put(String.valueOf(Integer.toString(x)) + "," + Integer.toString(i), cell);
                ++x;
            }
            ++i;
        }
        x = 0;
        for (JSONObject jo : children) {
            y = maxDepth - 1;
            depth = jo.getInt("depth");
            int offset = maxDepth - depth;
            if (offset > 0) {
                sheet.addMergedRegion(new CellRangeAddress(y - offset + startRow, y + startRow, x, x));
            }
            cell = (HSSFCell)map.get(String.valueOf(Integer.toString(x)) + "," + Integer.toString(y - offset));
            cell.setCellValue(JsonUtil.optString(jo, "text"));
            int w = jo.isNull("width") ? flexColWidth : jo.getInt("width");
            sheet.setColumnWidth(x, (int)((double)w * 36.55));
            if (jo.optBoolean("hidden")) {
                sheet.setColumnHidden(x, true);
            }
            parent = jo;
            int index = 0;
            int z = maxDepth - offset - 1;
            while ((parent = relations.get(parent)) != null) {
                if (parent.optBoolean("xwlProcessed")) continue;
                sheet.addMergedRegion(new CellRangeAddress(z - ++index + startRow, z - index + startRow, x, x + parent.getInt("size") - 1));
                cell = (HSSFCell)map.get(String.valueOf(Integer.toString(x)) + "," + Integer.toString(z - index));
                cell.setCellValue(JsonUtil.optString(parent, "text"));
                parent.put("xwlProcessed", true);
            }
            ++x;
        }
        return maxDepth + startRow;
    }

    private static HSSFCellStyle createTitleStyle(HSSFWorkbook book) throws Exception {
        HSSFCellStyle style = book.createCellStyle();
        HSSFFont font = book.createFont();
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        style.setWrapText(true);
        String fn = Var.get("webbuilder.service.download.excel.titleFontName");
        if (!StringUtil.isEmpty(fn)) {
            font.setFontName(fn);
        }
        font.setBoldweight((short)Var.getInt("webbuilder.service.download.excel.titleFontBold"));
        font.setFontHeight((short)Var.getInt("webbuilder.service.download.excel.titleFontHeight"));
        style.setFont(font);
        return style;
    }

    private static HSSFCellStyle createHeaderStyle(HSSFWorkbook book, Short bgColor, JSONObject jo, boolean center) throws Exception {
        String align;
        HSSFCellStyle style = book.createCellStyle();
        HSSFFont font = book.createFont();
        if (center) {
            align = "center";
        } else {
            align = JsonUtil.optString(jo, "headerAlign");
            if (align.isEmpty()) {
                align = JsonUtil.optString(jo, "align");
            }
        }
        style.setAlignment(ExcelObject.getAlign(align));
        style.setVerticalAlignment((short)1);
        if (bgColor != null) {
            style.setFillForegroundColor(bgColor.shortValue());
            style.setFillPattern((short)1);
        }
        style.setWrapText(true);
        style.setBorderTop((short)1);
        style.setBorderBottom((short)1);
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        String v = Var.get("webbuilder.service.download.excel.headerFontName");
        if (!StringUtil.isEmpty(v)) {
            font.setFontName(v);
        }
        font.setBoldweight((short)Var.getInt("webbuilder.service.download.excel.headerFontBold"));
        font.setFontHeight((short)Var.getInt("webbuilder.service.download.excel.headerFontHeight"));
        v = Var.get("webbuilder.service.download.excel.headerFontColor");
        if (!StringUtil.isEmpty(v)) {
            font.setColor(Short.parseShort(v));
        }
        style.setFont(font);
        return style;
    }

    private static HSSFCellStyle createRowStyle(HSSFWorkbook book, JSONObject jo, Short bgColor) throws Exception {
        String v;
        String format = JsonUtil.optString(jo, "format");
        String type = JsonUtil.optString(jo, "type");
        String jsFormat = JsonUtil.optString(jo, "jsFormat");
        if (format.isEmpty() && !jsFormat.isEmpty()) {
            format = type.equals("date") ? ExcelObject.toExcelDateFormat(jsFormat) : ExcelObject.toExcelNumFormat(jsFormat);
        }
        if (format.isEmpty()) {
            if (type.equals("string")) {
                format = "@";
            } else if (type.equals("date")) {
                return null;
            }
        }
        HSSFCellStyle style = book.createCellStyle();
        HSSFFont font = book.createFont();
        style.setAlignment(ExcelObject.getAlign(jo.optString("align")));
        style.setVerticalAlignment((short)1);
        if (jo.optBoolean("autoWrap")) {
            style.setWrapText(true);
        }
        if (!StringUtil.isEmpty(v = Var.get("webbuilder.service.download.excel.rowFontName"))) {
            font.setFontName(v);
        }
        font.setBoldweight((short)Var.getInt("webbuilder.service.download.excel.rowFontBold"));
        font.setFontHeight((short)Var.getInt("webbuilder.service.download.excel.rowFontHeight"));
        if (!format.isEmpty()) {
            style.setDataFormat(book.createDataFormat().getFormat(format));
        }
        style.setBorderTop((short)1);
        style.setBorderBottom((short)1);
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        if (bgColor != null) {
            style.setFillForegroundColor(bgColor.shortValue());
            style.setFillPattern((short)1);
        }
        style.setFont(font);
        return style;
    }

    private static String toExcelNumFormat(String format) {
        int i = format.indexOf(46);
        i = i == -1 ? format.length() - 1 : --i;
        return String.valueOf(StringUtil.replace(format.substring(0, i), "0", "#")) + format.substring(i);
    }

    private static String toExcelDateFormat(String format) {
        String[][] map;
        if (StringUtil.isEmpty(format)) {
            return "";
        }
        String[][] stringArrayArray = map = new String[][]{{"y", "yy"}, {"Y", "yyyy"}, {"m", "mm"}, {"n", "m"}, {"d", "dd"}, {"j", "d"}, {"H", "hh"}, {"h", "hh"}, {"G", "h"}, {"g", "h"}, {"i", "mm"}, {"s", "ss"}, {"u", "000"}, {"/", "\"/\""}, {"A", "AM/PM"}};
        int n = map.length;
        int n2 = 0;
        while (n2 < n) {
            String[] s = stringArrayArray[n2];
            format = StringUtil.replace(format, s[0], s[1]);
            ++n2;
        }
        return format;
    }

    private static short getAlign(String align) {
        if (align.equals("right")) {
            return 3;
        }
        if (align.equals("center")) {
            return 2;
        }
        return 1;
    }

    public static Object getCellValue(HSSFCell cell) {
        switch (cell.getCellType()) {
            case 0: 
            case 2: {
                return cell.getNumericCellValue();
            }
            case 1: {
                return cell.getStringCellValue();
            }
            case 4: {
                return cell.getBooleanCellValue();
            }
        }
        return null;
    }
}

