/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.interact;

import com.webbuilder.common.TaskService;
import com.webbuilder.common.Var;
import com.webbuilder.tool.PageInfo;
import com.webbuilder.utils.DateUtil;
import com.webbuilder.utils.DbUtil;
import com.webbuilder.utils.StringUtil;
import com.webbuilder.utils.WebUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;

public class TaskMng {
    public static void getTaskList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("findTask", (Object)StringUtil.replaceParameters(request, "%{#findTask#}%"));
        Scheduler sched = TaskService.getScheduler();
        ResultSet rs = DbUtil.query(request, "select * from WB_TASK where TASK_NAME like {?findTask?}");
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        PageInfo pageInfo = WebUtil.getPage(request);
        buf.append(",rows:[");
        while (rs.next()) {
            boolean hasTrigger;
            int cp = WebUtil.checkPage(pageInfo);
            if (cp == 1) break;
            if (cp == 2) continue;
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            String jobId = rs.getString("TASK_ID");
            buf.append("{taskId:");
            buf.append(StringUtil.quote(jobId));
            buf.append(",taskName:");
            buf.append(StringUtil.quote(rs.getString("TASK_NAME")));
            buf.append(",intervalType:");
            buf.append(rs.getInt("INTERVAL_TYPE"));
            buf.append(",express:");
            buf.append(StringUtil.quote(rs.getString("INTERVAL_EXPRESS")));
            buf.append(",clsName:");
            buf.append(StringUtil.quote(rs.getString("CLASS_NAME")));
            buf.append(",beginDate:\"");
            Timestamp date = rs.getTimestamp("BEGIN_DATE");
            if (date == null) {
                buf.append("");
            } else {
                buf.append(DateUtil.toString(date));
            }
            buf.append("\",endDate:\"");
            date = rs.getTimestamp("END_DATE");
            if (date == null) {
                buf.append("");
            } else {
                buf.append(DateUtil.toString(date));
            }
            buf.append("\",taskStatus:");
            buf.append(rs.getInt("STATUS"));
            Trigger[] triggers = sched.getTriggersOfJob(jobId, "DEFAULT");
            buf.append(",previous:\"");
            boolean bl = hasTrigger = triggers != null && triggers.length > 0;
            if (hasTrigger) {
                buf.append(DateUtil.toString(triggers[0].getPreviousFireTime()));
            } else {
                buf.append("");
            }
            buf.append("\",next:\"");
            if (hasTrigger) {
                buf.append(DateUtil.toString(triggers[0].getNextFireTime()));
            } else {
                buf.append("");
            }
            buf.append("\",remark:");
            buf.append(StringUtil.quote(rs.getString("REMARK")));
            buf.append('}');
        }
        buf.append("]}");
        WebUtil.setTotal(buf, pageInfo);
        WebUtil.response(response, buf);
    }

    public static void startTasks(HttpServletRequest request, HttpServletResponse response) throws Exception {
        TaskService.shutdown();
        TaskMng.loadTasks(null, request);
        Var.set("server.startTask", true);
    }

    public static void shutdownTasks(HttpServletRequest request, HttpServletResponse response) throws Exception {
        TaskService.shutdown();
        Var.set("server.startTask", false);
    }

    public static void pauseResumeTasks(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Scheduler scheduler = TaskService.getScheduler();
        JSONArray rows = new JSONArray(request.getParameter("grid1"));
        int j = rows.length();
        boolean isFirst = true;
        boolean isPause = !StringUtil.getBool(request.getParameter("status"));
        StringBuilder buf = new StringBuilder();
        Trigger trigger = null;
        ArrayList<String> ids = isPause ? null : new ArrayList<String>();
        int i = 0;
        while (i < j) {
            String id = rows.getJSONObject(i).getString("taskId");
            if (isPause) {
                scheduler.deleteJob(id, "DEFAULT");
            } else {
                ids.add(id);
            }
            ++i;
        }
        if (isPause) {
            WebUtil.response(response, "[]");
        } else {
            TaskMng.loadTasks(ids.toArray(new String[ids.size()]), request);
            Thread.sleep(20L);
            buf.append('[');
            for (String s : ids) {
                Trigger[] triggers = scheduler.getTriggersOfJob(s, "DEFAULT");
                trigger = triggers == null || triggers.length == 0 ? null : triggers[0];
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append(',');
                }
                buf.append("{p:\"");
                if (trigger != null) {
                    buf.append(DateUtil.toString(trigger.getPreviousFireTime()));
                }
                buf.append("\",n:\"");
                if (trigger != null) {
                    buf.append(DateUtil.toString(trigger.getNextFireTime()));
                }
                buf.append("\"}");
            }
            buf.append(']');
            WebUtil.response(response, buf);
        }
    }

    public static void removeTasks(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Scheduler scheduler = TaskService.getScheduler();
        JSONArray rows = new JSONArray(request.getParameter("grid1"));
        int j = rows.length();
        int i = 0;
        while (i < j) {
            scheduler.deleteJob(rows.getJSONObject(i).getString("taskId"), "DEFAULT");
            ++i;
        }
    }

    private static void runTask(HttpServletRequest request, HttpServletResponse response, String id, boolean dateOnly) throws Exception {
        TaskMng.loadTasks(StringUtil.getList(id), request);
        Thread.sleep(20L);
        Trigger[] tgs = TaskService.getScheduler().getTriggersOfJob(id, "DEFAULT");
        JSONObject jo = new JSONObject();
        if (!dateOnly) {
            jo.put("taskId", (Object)id);
            jo.put("taskStatus", 1);
        }
        if (tgs != null && tgs.length > 0) {
            jo.put("previous", (Object)DateUtil.toString(tgs[0].getPreviousFireTime()));
            jo.put("next", (Object)DateUtil.toString(tgs[0].getNextFireTime()));
        } else {
            jo.put("previous", null);
            jo.put("next", null);
        }
        WebUtil.response(response, jo);
    }

    public static void startTask(HttpServletRequest request, HttpServletResponse response) throws Exception {
        TaskMng.runTask(request, response, (String)request.getAttribute("sys.id"), false);
    }

    public static void restartTask(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String id = request.getParameter("taskId");
        TaskService.getScheduler().deleteJob(id, "DEFAULT");
        TaskMng.runTask(request, response, id, true);
    }

    public static void startup() throws Exception {
        TaskMng.loadTasks(null, null);
    }

    private static void loadTasks(String[] ids, HttpServletRequest request) throws Exception {
        Connection conn = null;
        ResultSet rs = null;
        Scheduler sched = TaskService.getScheduler();
        Trigger trigger = null;
        String e = "Invalid interval expression.";
        try {
            if (request == null) {
                conn = DbUtil.getConnection();
                rs = DbUtil.getResultSet(conn, "select * from WB_TASK");
            } else {
                rs = DbUtil.query(request, "select * from WB_TASK");
            }
            while (rs.next()) {
                String id = rs.getString("TASK_ID");
                if (ids != null && StringUtil.indexOf(ids, id) == -1 || rs.getInt("STATUS") != 1 || sched.getJobDetail(id, "DEFAULT") != null) continue;
                JobDetail job = new JobDetail(id, "DEFAULT", Class.forName(rs.getString("CLASS_NAME")));
                job.setDescription(rs.getString("TASK_NAME"));
                String[] express = StringUtil.split(rs.getString("INTERVAL_EXPRESS"), ":");
                switch (rs.getInt("INTERVAL_TYPE")) {
                    case 0: {
                        trigger = TriggerUtils.makeSecondlyTrigger((int)Integer.parseInt(express[0]));
                        break;
                    }
                    case 1: {
                        trigger = TriggerUtils.makeMinutelyTrigger((int)Integer.parseInt(express[0]));
                        break;
                    }
                    case 2: {
                        trigger = TriggerUtils.makeHourlyTrigger((int)Integer.parseInt(express[0]));
                        break;
                    }
                    case 3: {
                        if (express.length != 2) {
                            throw new Exception(e);
                        }
                        trigger = TriggerUtils.makeDailyTrigger((int)Integer.parseInt(express[0]), (int)Integer.parseInt(express[1]));
                        break;
                    }
                    case 4: {
                        if (express.length != 3) {
                            throw new Exception(e);
                        }
                        trigger = TriggerUtils.makeWeeklyTrigger((int)Integer.parseInt(express[0]), (int)Integer.parseInt(express[1]), (int)Integer.parseInt(express[2]));
                        break;
                    }
                    case 5: {
                        if (express.length != 3) {
                            throw new Exception(e);
                        }
                        trigger = TriggerUtils.makeMonthlyTrigger((int)Integer.parseInt(express[0]), (int)Integer.parseInt(express[1]), (int)Integer.parseInt(express[2]));
                    }
                }
                trigger.setName(id);
                Timestamp date = rs.getTimestamp("BEGIN_DATE");
                if (date != null) {
                    trigger.setStartTime((Date)date);
                }
                if ((date = rs.getTimestamp("END_DATE")) != null) {
                    trigger.setEndTime((Date)date);
                }
                sched.scheduleJob(job, trigger);
            }
            sched.start();
        }
        finally {
            if (request == null) {
                DbUtil.closeResultSet(rs);
                DbUtil.closeConnection(conn);
            }
        }
    }
}

