/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.interact;

import com.webbuilder.common.Main;
import com.webbuilder.common.Str;
import com.webbuilder.common.Var;
import com.webbuilder.interact.MngTool;
import com.webbuilder.tool.Encrypter;
import com.webbuilder.utils.DbUtil;
import com.webbuilder.utils.FileUtil;
import com.webbuilder.utils.JsonUtil;
import com.webbuilder.utils.StringUtil;
import com.webbuilder.utils.SysUtil;
import com.webbuilder.utils.WebUtil;
import com.webbuilder.utils.ZipUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;

public class Install {
    private static boolean isRespUpdate = false;

    public static void respUpdate(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResultSet rs = (ResultSet)request.getAttribute("query2");
        WebUtil.response(response, rs.next() ? "ok" : "failed");
    }

    public static void checkUpdate(String contextPath) {
        final String ctx = contextPath;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject params = new JSONObject();
                    params.put("xwlTitle", (Object)Var.get("webbuilder.title"));
                    params.put("xwlRegCode", (Object)Var.get("server.serialNumber"));
                    params.put("xwlContext", (Object)ctx);
                    String r = WebUtil.request("http://www.putdb.com/main?xwl=checkUpdate", params);
                    isRespUpdate = StringUtil.isSame(r, "failed");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        thread.start();
    }

    public static boolean checkInstall() {
        try {
            HashMap<String, String> map = Var.getServerVar();
            String jndi = map.get("jndi");
            if (StringUtil.isEmpty(jndi)) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public static void setup(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String xwl = request.getParameter("xwl");
        if (StringUtil.isEqual(xwl, "xwlfist")) {
            try {
                String jndi = request.getParameter("jndi");
                String dbType = request.getParameter("dbType");
                DbUtil.testJndi(jndi);
                Install.doInstall(jndi, dbType);
            }
            catch (Throwable e) {
                response.setStatus(500);
                WebUtil.response(response, StringUtil.toHTML(SysUtil.getShortError(e)));
            }
        } else {
            WebUtil.response(response, FileUtil.readUtfText(new File(Main.path, "webbuilder/data/setup.txt")));
        }
    }

    public static void exportTables(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] tables = new String[]{"WB_CUST", "WB_DUAL", "WB_KEY", "WB_META", "WB_MODULE", "WB_MODULE_ROLE", "WB_ROLE", "WB_TASK", "WB_USER", "WB_USER_ROLE", "WB_VAR"};
        File[] fs = new File(Main.path, "webbuilder/data/table").listFiles();
        BufferedWriter writer = null;
        File[] fileArray = fs;
        int n = fs.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            f.delete();
            ++n2;
        }
        Connection conn = DbUtil.getConnection(request);
        String[] stringArray = tables;
        int n3 = tables.length;
        int n4 = 0;
        while (n4 < n3) {
            String t = stringArray[n4];
            ResultSet rs = DbUtil.getResultSet(conn, "select * from " + t);
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(Main.path, StringUtil.concat("webbuilder/data/table/", t, ".txt"))), "utf-8"));
                DbUtil.exportData(writer, rs);
            }
            finally {
                DbUtil.closeResultSet(rs);
                if (writer != null) {
                    writer.close();
                }
            }
            ++n4;
        }
    }

    public static void exportPackage(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.reset();
        response.setHeader("content-type", "application/force-download");
        response.setHeader("content-disposition", "attachment;" + WebUtil.encodeFilename(request, "webbuilder.zip"));
        ZipUtil.zip(Main.path.listFiles(), (OutputStream)response.getOutputStream());
        response.flushBuffer();
    }

    public static void doInstall(String jndi, String dbType) throws Exception {
        File file = new File(Main.path, StringUtil.concat("webbuilder/data/sql/", dbType, ".txt"));
        Connection conn = null;
        Statement st = null;
        try {
            String[] sqls = FileUtil.readUtfText(file).split(";");
            conn = DbUtil.getConnection(jndi);
            st = conn.createStatement();
            String[] stringArray = sqls;
            int n = sqls.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                int index = t.indexOf("CREATE TABLE");
                if (index == -1) {
                    st.executeUpdate(t.trim());
                } else {
                    String table = t.substring(index + 13, t.indexOf(40)).trim();
                    try {
                        st.executeUpdate("DROP TABLE " + table);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    st.executeUpdate(t.trim());
                    file = new File(Main.path, StringUtil.concat("webbuilder/data/table/", table, ".txt"));
                    if (file.exists()) {
                        DbUtil.importData(conn, table, JsonUtil.readArray(file));
                    }
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            DbUtil.closeConnection(conn);
            DbUtil.closeStatement(st);
            throw throwable;
        }
        DbUtil.closeConnection(conn);
        DbUtil.closeStatement(st);
        Main.installed = true;
        Var.set("server.jndi", jndi);
        Var.set("server.dbType", dbType);
        MngTool.loadSystem(true);
    }

    public static void register(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Var.set("server.serialNumber", request.getParameter("serialNumber"));
        if (!Install.isRegistered()) {
            throw new Exception(Str.format(request, "invalidSN", new String[0]));
        }
    }

    public static int getUserCount() throws Exception {
        String s = Var.get("server.serialNumber");
        int[] users = new int[]{10, 100, 1000, 10000, 100000, -1};
        if (Install.isRegistered() && !isRespUpdate) {
            return users[Integer.parseInt(s.substring(5, 6)) - 1];
        }
        return 3;
    }

    public static boolean isRegistered() throws Exception {
        String s = Var.get("server.serialNumber");
        if (s == null || s.length() != 19) {
            return false;
        }
        String v = s.substring(15);
        s = String.valueOf(s.substring(5, 9)) + s.substring(10, 14) + s.substring(0, 4);
        int j = 0;
        int i = 0;
        while (i < 12) {
            j += s.charAt(i);
            j = (j = j * (i + 2) * 2 + i) % 2 == 0 ? ++j : (j += 2);
            ++i;
        }
        return v.equals(Encrypter.getMD5(String.valueOf(s) + Integer.toString(j)).substring(0, 4));
    }
}

