/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.interact;

import com.webbuilder.common.Main;
import com.webbuilder.utils.FileUtil;
import com.webbuilder.utils.StringUtil;
import com.webbuilder.utils.SysUtil;
import com.webbuilder.utils.WebUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileSystem {
    public static void getFileTree(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String dir = request.getParameter("dir");
        boolean check = StringUtil.getBool(request.getParameter("check"));
        File[] files = StringUtil.isEmpty(dir) ? File.listRoots() : (dir.equals("@") ? Main.path.listFiles() : new File(dir).listFiles());
        FileUtil.sortFiles(files);
        WebUtil.response(response, FileSystem.getFilesInfo(files, check));
    }

    private static String getFilesInfo(File[] files, boolean check) {
        StringBuilder buf = new StringBuilder();
        boolean isFirst = true;
        buf.append('[');
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(',');
            }
            String name = file.getName();
            String dir = FileUtil.getPath(file);
            if (StringUtil.isEmpty(name)) {
                name = FileUtil.extractDir(dir);
            }
            buf.append("{text:\"");
            buf.append(name);
            buf.append("\",dir:\"");
            buf.append(dir);
            buf.append("\"");
            boolean isDir = file.isDirectory();
            buf.append(",isDir:");
            buf.append(isDir);
            if (!FileUtil.hasSubFile(file, false)) {
                if (isDir) {
                    buf.append(",children:[]");
                } else {
                    if (check) {
                        buf.append(",checked:false");
                    }
                    buf.append(",leaf:true,iconCls:\"default_icon\",icon:\"main?xwl=13MY44A9AOKN&file=\"+encodeURIComponent(\"" + dir + "\")");
                }
            }
            buf.append('}');
            ++n2;
        }
        buf.append(']');
        return buf.toString();
    }

    public static void getIcon(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String fileName = WebUtil.decode(request.getParameter("file"));
        String fileExt = FileUtil.extractFileExt(fileName).toLowerCase();
        String[] imgTypes = new String[]{"gif", "jpg", "png", "bmp"};
        String[] zipTypes = new String[]{"zip", "rar", "gzip", "gz", "tar", "cab"};
        File file = null;
        response.reset();
        if (StringUtil.indexOf(imgTypes, fileExt) != -1) {
            file = new File(fileName);
            long fileLen = file.length();
            if (fileLen > 10240L || fileLen == 0L) {
                fileName = "image";
                file = null;
            }
        } else {
            fileName = StringUtil.indexOf(zipTypes, fileExt) != -1 ? "zip" : (fileExt.equals("txt") ? "text" : (fileExt.equals("doc") ? "word" : (fileExt.equals("xls") ? "excel" : (fileExt.equals("ppt") ? "ppt" : (fileExt.equals("htm") || fileExt.equals("html") ? "web" : "file")))));
        }
        if (file == null) {
            file = new File(Main.path, StringUtil.concat("webbuilder/images/", String.valueOf(fileName) + ".gif"));
            response.setContentType("image/gif");
        } else {
            response.setContentType("image/" + fileExt);
        }
        FileInputStream is = new FileInputStream(file);
        try {
            SysUtil.isToOs(is, (OutputStream)response.getOutputStream());
        }
        finally {
            is.close();
        }
        response.flushBuffer();
    }
}

