/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.interact;

import com.webbuilder.common.Main;
import com.webbuilder.common.Str;
import com.webbuilder.utils.FileUtil;
import com.webbuilder.utils.StringUtil;
import com.webbuilder.utils.WebUtil;
import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;

public class Example {
    public static void setLanContent(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Enumeration enums = request.getParameterNames();
        ConcurrentHashMap<String, ConcurrentHashMap<String, String>> map = Str.getLangMap();
        while (enums.hasMoreElements()) {
            JSONObject jo;
            String p = enums.nextElement().toString();
            if (!StringUtil.isEqual(StringUtil.substring(p, 0, 5), "lang_")) continue;
            String lan = p.substring(5);
            String content = request.getParameter(p);
            File f = new File(Main.path, "webbuilder/script/locale/wb-lang-" + lan + ".js");
            try {
                jo = new JSONObject(StringUtil.concat("{", content, "}"));
            }
            catch (Throwable e) {
                throw new Exception(String.valueOf(lan) + ": " + Str.format(request, "invalidFormat", new String[0]));
            }
            FileUtil.writeUtfText(f, StringUtil.concat("var Str={\n", content, "\n}"));
            ConcurrentHashMap<String, String> lm = new ConcurrentHashMap<String, String>();
            Iterator it = jo.keys();
            while (it.hasNext()) {
                String k = (String)it.next();
                lm.put(k, jo.getString(k));
            }
            map.put(lan, lm);
        }
    }

    public static void langEditorInit(HttpServletRequest request, HttpServletResponse response) throws Exception {
        StringBuilder tabs = new StringBuilder();
        StringBuilder tree = new StringBuilder();
        ConcurrentHashMap<String, ConcurrentHashMap<String, String>> lans = Str.getLangMap();
        List<Map.Entry<String, ?>> ls = StringUtil.sortMapKey(lans);
        boolean isFirst = true;
        for (Map.Entry<String, ?> e : ls) {
            String key = e.getKey();
            ConcurrentHashMap<String, String> v = lans.get(key);
            if (v.size() == 0) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                tabs.append(',');
                tree.append(',');
            }
            tabs.append("{title:");
            tabs.append(StringUtil.quote(key));
            tabs.append(StringUtil.concat(",id:\"tab_", key, "\",layout:\"fit\",items:[{xtype:\"textarea\",id:\"area_", key, "\"}]"));
            tabs.append('}');
            tree.append("{text:");
            tree.append(StringUtil.quote(key));
            tree.append(",iconCls:\"item_icon\",leaf:true");
            tree.append('}');
        }
        request.setAttribute("langTabs", (Object)tabs.toString());
        request.setAttribute("treeContent", (Object)tree.toString());
    }

    public static void getLanContent(HttpServletRequest request, HttpServletResponse response) throws Exception {
        File f = new File(Main.path, "webbuilder/script/locale/wb-lang-" + request.getParameter("lang") + ".js");
        String s = FileUtil.readUtfText(f);
        if (StringUtil.isEmpty(s)) {
            WebUtil.response(response, "");
        } else {
            JSONObject jo = new JSONObject(s.substring(s.indexOf(123)));
            StringBuilder buf = new StringBuilder();
            Iterator it = jo.sortedKeys();
            boolean isFirst = true;
            while (it.hasNext()) {
                String n = (String)it.next();
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append(",\n");
                }
                buf.append(n);
                buf.append(" : ");
                buf.append(StringUtil.quote(jo.getString(n)));
            }
            WebUtil.response(response, buf);
        }
    }
}

