/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.interact;

import com.webbuilder.common.Main;
import com.webbuilder.utils.FileUtil;
import com.webbuilder.utils.JsonUtil;
import com.webbuilder.utils.StringUtil;
import com.webbuilder.utils.WebUtil;
import java.io.File;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public class Docs {
    public static void searchKey(HttpServletRequest request, HttpServletResponse response) throws Exception {
        StringBuilder buf = new StringBuilder();
        int times = 0;
        buf.append("[");
        String key = request.getParameter("query");
        if (!StringUtil.isEmpty(key)) {
            Docs.recurseSearch(buf, new File(Main.path, "webbuilder/docs/index.txt"), key, times);
        }
        buf.append("]");
        WebUtil.response(response, buf);
    }

    private static int recurseSearch(StringBuilder buf, File idxFile, String key, int times) throws Exception {
        JSONArray ja = JsonUtil.readArray(idxFile);
        int j = ja.length();
        int l = key.length();
        int i = 0;
        while (i < j) {
            File file;
            JSONObject jo = ja.getJSONObject(i);
            String text = JsonUtil.optString(jo, "text");
            String fileName = JsonUtil.optString(jo, "file");
            String iconCls = JsonUtil.optString(jo, "icon");
            if (iconCls.isEmpty()) {
                iconCls = "ht_icon";
            }
            if (fileName.isEmpty()) {
                fileName = text;
            }
            if ((file = new File(idxFile.getParentFile(), fileName)).exists()) {
                if (file.isDirectory()) {
                    if ((file = new File(file, "index.txt")).exists()) {
                        times = Docs.recurseSearch(buf, file, key, times);
                    }
                } else {
                    String content = FileUtil.readUtfText(file);
                    int contentLen = content.length();
                    int k = content.toLowerCase().indexOf(key.toLowerCase());
                    if (k != -1) {
                        char c;
                        int y;
                        if (times > 0) {
                            buf.append(",");
                        }
                        buf.append("{file:");
                        buf.append(StringUtil.quote(FileUtil.getPath(file)));
                        buf.append(",iconCls:");
                        buf.append(StringUtil.quote(iconCls));
                        buf.append(",title:");
                        buf.append(StringUtil.quote(text));
                        buf.append(",text:\"<b>");
                        buf.append(StringUtil.toHTML(text));
                        buf.append("</b><br>");
                        int bx = k;
                        int x = 1;
                        while (x < 50) {
                            y = k - x;
                            if (y < 0 || (c = content.charAt(y)) == '<' || c == '>' || x > 20 && (c == ' ' || c == ',' || c == '.')) break;
                            bx = y;
                            ++x;
                        }
                        int ex = k + l;
                        x = 0;
                        while (x < 50) {
                            y = k + l + x;
                            if (y >= contentLen) break;
                            ex = y;
                            c = content.charAt(y);
                            if (c == '<' || c == '>' || x > 20 && (c == ' ' || c == ',' || c == '.')) break;
                            ++x;
                        }
                        String str = (String.valueOf(content.substring(bx, k)) + "*").trim();
                        buf.append(StringUtil.toHTML(str.substring(0, str.length() - 1)));
                        buf.append("<span style='background-color:#FF0'>");
                        buf.append(StringUtil.toHTML(content.substring(k, k + l)));
                        buf.append("</span>");
                        y = k + l;
                        if (ex < contentLen && y < contentLen) {
                            buf.append(StringUtil.toHTML(content.substring(y, ex)));
                        }
                        buf.append("\"}");
                        if (times > 29) break;
                        ++times;
                    }
                }
            }
            ++i;
        }
        return times;
    }

    public static void getFileContent(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String dir = request.getParameter("dir");
        if (dir.startsWith("@")) {
            WebUtil.response(response, FileUtil.readUtfText(new File(Main.path, "webbuilder/docs/" + dir.substring(1))));
        } else {
            WebUtil.response(response, FileUtil.readUtfText(new File(dir)));
        }
    }

    public static void getTopicTree(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String dir = request.getParameter("dir");
        StringBuilder buf = new StringBuilder();
        boolean isFirst = true;
        File base = StringUtil.isEmpty(dir) ? new File(Main.path, "webbuilder/docs") : new File(dir);
        File file = new File(base, "index.txt");
        JSONArray ja = JsonUtil.readArray(file);
        buf.append("[");
        int j = ja.length();
        int i = 0;
        while (i < j) {
            boolean isLink;
            JSONObject jo = ja.getJSONObject(i);
            String text = jo.optString("text");
            String fileName = JsonUtil.optString(jo, "file");
            String link = JsonUtil.optString(jo, "link");
            boolean bl = isLink = !link.isEmpty();
            if (fileName.isEmpty()) {
                fileName = text;
            }
            if ((file = new File(base, fileName)).exists() || isLink) {
                String iconCls;
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append(",");
                }
                buf.append("{text:");
                buf.append(StringUtil.quote(text));
                buf.append(",dir:");
                buf.append(StringUtil.quote(FileUtil.getPath(file)));
                if (isLink) {
                    buf.append(",link:");
                    buf.append(StringUtil.quote(link));
                }
                if (!(iconCls = JsonUtil.optString(jo, "icon")).isEmpty()) {
                    buf.append(",iconCls:");
                    buf.append(StringUtil.quote(iconCls));
                } else if (!file.isDirectory()) {
                    buf.append(",iconCls:\"ht_icon\"");
                }
                if (file.isFile() || isLink) {
                    buf.append(",leaf:true");
                } else if (!FileUtil.hasSubFile(file, false)) {
                    buf.append(",children:[]");
                }
                buf.append("}");
            }
            ++i;
        }
        buf.append("]");
        WebUtil.response(response, buf);
    }
}

