/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.interact;

import com.webbuilder.common.Main;
import com.webbuilder.common.ScriptBuffer;
import com.webbuilder.common.Str;
import com.webbuilder.common.Value;
import com.webbuilder.common.Var;
import com.webbuilder.common.XwlBuffer;
import com.webbuilder.common.XwlData;
import com.webbuilder.tool.PageInfo;
import com.webbuilder.tool.QueueWriter;
import com.webbuilder.utils.DateUtil;
import com.webbuilder.utils.DbUtil;
import com.webbuilder.utils.FileUtil;
import com.webbuilder.utils.JsonUtil;
import com.webbuilder.utils.StringUtil;
import com.webbuilder.utils.SysUtil;
import com.webbuilder.utils.WebUtil;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class Designer {
    public static void exportPack(HttpServletRequest request, HttpServletResponse response) throws Exception {
        XwlData data;
        ConcurrentHashMap<String, XwlData> map = XwlBuffer.getXwlMap();
        Set<Map.Entry<String, XwlData>> es = map.entrySet();
        StringBuilder buf = new StringBuilder();
        String root = request.getParameter("root");
        String title = Var.get("webbuilder.title");
        boolean expAll = root.equals("-1");
        buf.append("[");
        if (root.equals("-1")) {
            buf.append("{id:\"-1\"}");
        } else {
            data = map.get(root);
            title = StringUtil.replaceParameters(request, data.title);
            if (data.parentId.equals("-1")) {
                buf.append("{id:\"-1\"}");
            } else {
                buf.append("{id:\"");
                buf.append(data.parentId);
                buf.append("\",date:\"");
                data = map.get(data.parentId);
                buf.append(StringUtil.substring(DateUtil.toString(data.createDate), 0, 19));
                buf.append("\"}");
            }
        }
        for (Map.Entry<String, XwlData> e : es) {
            String id = e.getKey();
            data = e.getValue();
            boolean found = false;
            if (expAll || root.equals(id)) {
                found = true;
            } else {
                XwlData current = data;
                do {
                    if (!root.equals(current.parentId)) continue;
                    found = true;
                    break;
                } while ((current = map.get(current.parentId)) != null);
            }
            if (!found) continue;
            buf.append(",{MODULE_ID:");
            buf.append(StringUtil.quote(id));
            buf.append(",PARENT_ID:");
            buf.append(StringUtil.quote(data.parentId));
            buf.append(",MODULE_CONTENT:");
            if (data.content == null) {
                buf.append("null");
            } else {
                buf.append(StringUtil.quote(data.content.toString()));
            }
            buf.append(",DISPLAY_NAME:");
            buf.append(StringUtil.quote(data.title));
            buf.append(",DISPLAY_ICON:");
            buf.append(StringUtil.quote(data.icon));
            buf.append(",IS_HIDDEN:");
            buf.append(data.isHidden ? 1 : 0);
            buf.append(",NEW_WIN:");
            buf.append(data.newWin ? 1 : 0);
            buf.append(",CREATE_DATE:\"");
            buf.append(DateUtil.toString(data.createDate));
            buf.append("\",LAST_MODIFY_DATE:\"");
            buf.append(DateUtil.toString(data.lastModifyDate));
            buf.append("\",ORDER_INDEX:");
            buf.append(data.orderIndex);
            buf.append("}");
        }
        buf.append("]");
        response.reset();
        response.setHeader("content-type", "application/force-download");
        response.setHeader("content-disposition", "attachment;" + WebUtil.encodeFilename(request, String.valueOf(title) + ".gz"));
        GZIPOutputStream os = new GZIPOutputStream((OutputStream)response.getOutputStream());
        try {
            ((OutputStream)os).write(buf.toString().getBytes("utf-8"));
        }
        finally {
            ((OutputStream)os).close();
        }
        response.flushBuffer();
    }

    public static void initPack(HttpServletRequest request, HttpServletResponse response) throws Exception {
        StringBuilder buf = new StringBuilder();
        JSONArray ja = Designer.preparePack(request, buf);
        JSONArray updateJa = new JSONArray();
        JSONArray insertJa = new JSONArray();
        int j = ja.length();
        int i = 0;
        while (i < j) {
            JSONObject jo = ja.getJSONObject(i);
            if (jo.optInt("isCancel") != 1) {
                if (jo.optInt("isUpdate") == 1) {
                    updateJa.put((Object)jo);
                } else {
                    insertJa.put((Object)jo);
                }
            }
            ++i;
        }
        request.setAttribute("updateArray", (Object)updateJa);
        request.setAttribute("insertArray", (Object)insertJa);
        request.setAttribute("replaceIds", (Object)buf.toString());
    }

    private static JSONArray preparePack(HttpServletRequest request, StringBuilder replacedIds) throws Exception {
        String content;
        GZIPInputStream is = new GZIPInputStream((InputStream)request.getAttribute("uploadFile"));
        try {
            content = StringUtil.getUtfString(is);
        }
        finally {
            ((InputStream)is).close();
        }
        JSONArray ja = new JSONArray(content);
        String oldParentId = null;
        int j = ja.length();
        boolean isFirst = true;
        boolean renewParentId = false;
        ArrayList<String> list = new ArrayList<String>();
        ConcurrentHashMap<String, XwlData> map = XwlBuffer.getXwlMap();
        JSONObject jo = ja.getJSONObject(0);
        String moduleId = jo.optString("id");
        XwlData data = map.get(moduleId);
        if (!(moduleId.equals("-1") || data != null && StringUtil.substring(DateUtil.toString(data.createDate), 0, 19).equals(jo.opt("date")))) {
            oldParentId = moduleId;
            renewParentId = true;
        }
        int i = 1;
        while (i < j) {
            jo = ja.getJSONObject(i);
            moduleId = jo.getString("MODULE_ID");
            if (renewParentId && StringUtil.isEqual(oldParentId, jo.getString("PARENT_ID"))) {
                jo.put("PARENT_ID", (Object)"-1");
            }
            if ((data = map.get(moduleId)) != null) {
                String orgDate = StringUtil.substring(DateUtil.toString(data.createDate), 0, 19);
                String modifyDate = StringUtil.substring(DateUtil.toString(data.lastModifyDate), 0, 19);
                String newOrgDate = StringUtil.substring(JsonUtil.optString(jo, "CREATE_DATE"), 0, 19);
                String newModifyDate = StringUtil.substring(JsonUtil.optString(jo, "LAST_MODIFY_DATE"), 0, 19);
                if (orgDate.equals(newOrgDate) || moduleId.length() < 12) {
                    if (modifyDate.equals(newModifyDate)) {
                        jo.put("isCancel", 1);
                    } else {
                        jo.put("isUpdate", 1);
                    }
                } else {
                    String id = SysUtil.getId();
                    list.add(String.valueOf(id) + "=" + moduleId);
                    jo.put("MODULE_ID", (Object)id);
                }
            }
            ++i;
        }
        ja.remove(0);
        content = ja.toString();
        for (String s : list) {
            String src = StringUtil.getValuePart(s);
            String dst = StringUtil.getNamePart(s);
            content = StringUtil.replace(content, src, dst);
            if (isFirst) {
                isFirst = false;
            } else {
                replacedIds.append(", ");
            }
            replacedIds.append(src);
            replacedIds.append("-&gt;");
            replacedIds.append(dst);
        }
        return new JSONArray(content);
    }

    public static void impModule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String content = StringUtil.getUtfString((InputStream)request.getAttribute("uploadFile"));
        JSONObject jo = new JSONObject(content);
        request.setAttribute("content", (Object)content);
        DbUtil.update(request, "update WB_MODULE set MODULE_CONTENT={?text.content?},LAST_MODIFY_USER={?sys.user?},LAST_MODIFY_DATE={?sys.date?} where MODULE_ID={?moduleId?}");
        ConcurrentHashMap<String, XwlData> map = XwlBuffer.getXwlMap();
        String id = (String)request.getAttribute("moduleId");
        ScriptBuffer.remove(id);
        XwlData data = map.get(id);
        data.content = jo;
        data.lastModifyUser = (String)request.getAttribute("sys.user");
        data.lastModifyDate = (Date)request.getAttribute("sys.date");
    }

    public static void expModule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.reset();
        response.setHeader("content-type", "application/force-download");
        response.setHeader("content-disposition", "attachment;" + WebUtil.encodeFilename(request, String.valueOf(request.getParameter("title")) + ".xwl"));
        ConcurrentHashMap<String, XwlData> map = XwlBuffer.getXwlMap();
        String id = request.getParameter("moduleId");
        XwlData data = map.get(id);
        WebUtil.response(response, data.content.toString());
    }

    public static void search(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Pattern pattern;
        boolean useRegExp = StringUtil.getBool(request.getParameter("regCheck"));
        boolean caseSens = StringUtil.getBool(request.getParameter("caseCheck"));
        boolean searchAll = StringUtil.getBool(request.getParameter("allCheck"));
        boolean onlyKey = StringUtil.getBool(request.getParameter("keyCheck"));
        ConcurrentHashMap<String, XwlData> map = XwlBuffer.getXwlMap();
        Set<Map.Entry<String, XwlData>> es = map.entrySet();
        StringBuilder buf = new StringBuilder();
        String searchText = request.getParameter("searchText");
        PageInfo pageInfo = WebUtil.getPage(request);
        String moduleId = request.getParameter("module");
        if (StringUtil.isEmpty(moduleId)) {
            searchAll = true;
        }
        if (useRegExp) {
            pattern = Pattern.compile(searchText);
        } else {
            pattern = null;
            if (!caseSens) {
                searchText = searchText.toLowerCase();
            }
        }
        buf.append(",rows:[");
        for (Map.Entry<String, XwlData> e : es) {
            String iconCls;
            String title;
            String key = e.getKey();
            if (!searchAll && !key.equals(moduleId)) continue;
            XwlData data = e.getValue();
            if (!data.isFolder && !Designer.searchJson(data.content, buf, searchText, pattern, onlyKey, caseSens, title = StringUtil.replaceParameters(request, data.title), key, pageInfo, iconCls = data.icon)) break;
        }
        buf.append("]}");
        WebUtil.setTotal(buf, pageInfo);
        WebUtil.response(response, buf);
    }

    private static boolean searchJson(JSONObject jo, StringBuilder buf, String searchText, Pattern pattern, boolean onlyKey, boolean caseSens, String module, String moduleId, PageInfo pageInfo, String iconCls) throws Exception {
        int k = 0;
        Matcher matcher = null;
        Iterator it = jo.keys();
        while (it.hasNext()) {
            int ct;
            String name = (String)it.next();
            if (name.equals("xwlMeta")) continue;
            if (name.equals("children")) {
                JSONArray ja = jo.getJSONArray("children");
                int j = ja.length();
                int i = 0;
                while (i < j) {
                    Designer.searchJson(ja.getJSONObject(i), buf, searchText, pattern, onlyKey, caseSens, module, moduleId, pageInfo, iconCls);
                    ++i;
                }
                continue;
            }
            String value = jo.optString(name);
            String text = onlyKey ? name : value;
            if (pattern == null && !caseSens) {
                text = text.toLowerCase();
            }
            if ((pattern != null || (k = text.indexOf(searchText)) == -1) && (pattern == null || !(matcher = pattern.matcher(text)).find())) continue;
            int cp = WebUtil.checkPage(pageInfo);
            if (cp == 1) {
                return false;
            }
            if (cp == 2) continue;
            if (pageInfo.count > pageInfo.start + 1) {
                buf.append(",");
            }
            String objId = jo.optString("id");
            buf.append("{value:");
            if (!onlyKey) {
                int l;
                if (pattern == null) {
                    l = k + searchText.length();
                } else {
                    k = matcher.start();
                    l = matcher.end();
                }
                value = StringUtil.concat(StringUtil.toHTML(value.substring(Math.max(0, k - 30), k), false, false), "<b>", StringUtil.toHTML(value.substring(k, l), false, false), "</b>", StringUtil.toHTML(value.substring(l), false, false));
            }
            if (pattern == null) {
                ct = StringUtil.stringOccur(text, searchText);
            } else {
                ct = 1;
                while (matcher.find()) {
                    ++ct;
                }
            }
            buf.append(StringUtil.quote(StringUtil.concat("(", Integer.toString(ct), ") ", value)));
            buf.append(",name:");
            buf.append(StringUtil.quote(StringUtil.concat(objId, ".", name)));
            buf.append(",module:");
            buf.append(StringUtil.quote(module));
            buf.append(",moduleId:");
            buf.append(StringUtil.quote(moduleId));
            buf.append(",iconCls:");
            buf.append(StringUtil.quote(iconCls));
            buf.append(",objId:");
            buf.append(StringUtil.quote(objId));
            buf.append("}");
        }
        return true;
    }

    public static void getOutputs(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String s = "";
        HttpSession session = request.getSession(true);
        QueueWriter out = (QueueWriter)session.getAttribute("sys.out");
        if (out == null) {
            out = new QueueWriter(Var.getInt("webbuilder.app.ide.consoleSize"));
            session.setAttribute("sys.out", (Object)out);
        } else {
            s = out.toString();
            out.clear();
        }
        WebUtil.response(response, s);
    }

    public static void saveModuleTree(HttpServletRequest request, HttpServletResponse response) throws Exception {
        XwlData data;
        ConcurrentHashMap<String, XwlData> map = XwlBuffer.getXwlMap();
        Set<Map.Entry<String, XwlData>> es = map.entrySet();
        String parentId = request.getParameter("parentId");
        String srcId = request.getParameter("srcId");
        int orderIndex = Integer.parseInt(request.getParameter("orderIndex"));
        for (Map.Entry<String, XwlData> e : es) {
            data = e.getValue();
            if (!StringUtil.isEqual(data.parentId, parentId) || data.orderIndex < orderIndex) continue;
            ++data.orderIndex;
        }
        data = map.get(srcId);
        if (data == null) {
            WebUtil.notExist(request);
        } else {
            data.parentId = parentId;
            data.orderIndex = orderIndex;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void pasteModule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        block5: {
            isCut = StringUtil.getBool(request.getParameter("isCut"));
            id = request.getParameter("id");
            parentId = request.getParameter("parentId");
            orderIndex = Integer.parseInt(request.getParameter("orderIndex"));
            map = XwlBuffer.getXwlMap();
            es = map.entrySet();
            conn = null;
            stm = null;
            stmDel = null;
            copiedList = new ArrayList<String>();
            try {
                block6: {
                    try {
                        user = (String)request.getAttribute("sys.user");
                        date = new Date();
                        conn = DbUtil.getConnection();
                        conn.setAutoCommit(false);
                        stm = conn.prepareStatement("insert into WB_MODULE (MODULE_ID,PARENT_ID,MODULE_CONTENT,DISPLAY_NAME,DISPLAY_ICON,IS_HIDDEN,NEW_WIN,CREATE_USER,CREATE_DATE,LAST_MODIFY_USER,LAST_MODIFY_DATE,ORDER_INDEX) values(?,?,?,?,?,?,?,?,?,?,?,?)");
                        stmDel = conn.prepareStatement("delete from WB_MODULE where MODULE_ID=?");
                        newId = Designer.copyModule(stm, stmDel, map, es, id, copiedList, isCut, parentId, orderIndex, user, date);
                        stmDel.executeBatch();
                        stm.executeBatch();
                        WebUtil.response(response, StringUtil.concat("{id:\"", new String[]{newId, "\",user:\"", user, "\",date:\"", String.valueOf(DateUtil.toString(date)) + "\"}"}));
                        conn.commit();
                        break block5;
                    }
                    catch (Throwable e) {
                        if (isCut) break block6;
                        ** for (s : copiedList)
                    }
lbl-1000:
                    // 1 sources

                    {
                        map.remove(s);
                        continue;
                    }
                }
                throw new Exception(e);
            }
            catch (Throwable var16_18) {
                DbUtil.closeStatement(stm);
                DbUtil.closeStatement(stmDel);
                DbUtil.closeConnection(conn);
                throw var16_18;
            }
        }
        DbUtil.closeStatement(stm);
        DbUtil.closeStatement(stmDel);
        DbUtil.closeConnection(conn);
    }

    private static String copyModule(PreparedStatement stm, PreparedStatement stmDel, ConcurrentHashMap<String, XwlData> map, Set<Map.Entry<String, XwlData>> es, String id, ArrayList<String> newList, boolean isCut, String parentId, int orderIndex, String user, Date date) throws Exception {
        XwlData data = map.get(id);
        XwlData newData = new XwlData();
        String newId = isCut ? id : SysUtil.getId();
        if (data == null) {
            throw new Exception(Str.format("objectNotExist", new String[0]));
        }
        if (!data.isFolder) {
            newData.content = new JSONObject(data.content.toString());
        }
        if (isCut) {
            newData.createDate = data.createDate;
            newData.lastModifyDate = data.lastModifyDate;
            newData.createUser = data.createUser;
            newData.lastModifyUser = data.lastModifyUser;
        } else {
            newData.createDate = date;
            newData.lastModifyDate = date;
            newData.createUser = user;
            newData.lastModifyUser = user;
        }
        Timestamp tsCreate = new Timestamp(newData.createDate.getTime());
        newData.icon = data.icon;
        newData.isFolder = data.isFolder;
        newData.isHidden = data.isHidden;
        newData.newWin = data.newWin;
        Timestamp tsModified = new Timestamp(newData.lastModifyDate.getTime());
        newData.orderIndex = orderIndex == -1 ? data.orderIndex : orderIndex;
        newData.parentId = parentId;
        newData.title = data.title;
        map.put(newId, newData);
        if (!isCut) {
            newList.add(newId);
        }
        stm.setString(1, newId);
        stm.setString(2, parentId);
        if (data.isFolder) {
            stm.setNull(3, -1);
        } else {
            DbUtil.setCharStream(stm, 3, newData.content.toString());
        }
        stm.setString(4, newData.title);
        stm.setString(5, newData.icon);
        stm.setInt(6, newData.isHidden ? 1 : 0);
        stm.setInt(7, newData.newWin ? 1 : 0);
        stm.setString(8, user);
        stm.setTimestamp(9, tsCreate);
        stm.setString(10, user);
        stm.setTimestamp(11, tsModified);
        stm.setInt(12, newData.orderIndex);
        stm.addBatch();
        for (Map.Entry<String, XwlData> e : es) {
            if (!StringUtil.isEqual(e.getValue().parentId, id)) continue;
            Designer.copyModule(stm, stmDel, map, es, e.getKey(), newList, isCut, newId, -1, user, date);
        }
        if (isCut) {
            stmDel.setString(1, id);
            stmDel.addBatch();
        }
        return newId;
    }

    public static void updateModule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ConcurrentHashMap<String, XwlData> map = XwlBuffer.getXwlMap();
        String user = (String)request.getAttribute("sys.user");
        Date date = (Date)request.getAttribute("sys.date");
        XwlData data = map.get(request.getParameter("id").toString());
        if (data == null) {
            WebUtil.notExist(request);
        }
        data.title = request.getParameter("title");
        data.icon = request.getParameter("icon");
        data.isHidden = StringUtil.getBool(request.getParameter("hidden"));
        data.newWin = StringUtil.getBool(request.getParameter("newWin"));
        data.lastModifyUser = user;
        data.lastModifyDate = date;
        JSONObject jo = new JSONObject();
        jo.put("user", (Object)((String)request.getAttribute("sys.user")));
        jo.put("date", (Object)((String)request.getAttribute("sys.now")));
        jo.put("title", (Object)StringUtil.replaceParameters(request, data.title));
        WebUtil.response(response, jo);
    }

    public static void newModule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        XwlData data;
        ConcurrentHashMap<String, XwlData> map = XwlBuffer.getXwlMap();
        Set<Map.Entry<String, XwlData>> es = map.entrySet();
        String user = (String)request.getAttribute("sys.user");
        String content = request.getParameter("content");
        Date date = (Date)request.getAttribute("sys.date");
        String id = request.getAttribute("sys.id").toString();
        String parentId = request.getParameter("parentId");
        int orderIndex = Integer.parseInt(request.getParameter("orderIndex"));
        for (Map.Entry<String, XwlData> e : es) {
            data = e.getValue();
            if (!StringUtil.isEqual(data.parentId, parentId) || data.orderIndex < orderIndex) continue;
            ++data.orderIndex;
        }
        data = new XwlData();
        data.parentId = parentId;
        data.isFolder = StringUtil.isEmpty(content);
        if (!data.isFolder) {
            data.content = new JSONObject(content);
        }
        data.title = request.getParameter("title");
        data.icon = request.getParameter("icon");
        data.isHidden = StringUtil.getBool(request.getParameter("hidden"));
        data.newWin = StringUtil.getBool(request.getParameter("newWin"));
        data.createUser = user;
        data.lastModifyUser = user;
        data.createDate = date;
        data.lastModifyDate = date;
        data.orderIndex = orderIndex;
        map.put(id, data);
        String info = StringUtil.replaceParameters(request, "{id:\"{#sys.id#}\",user:\"{#sys.user#}\",date:\"{#sys.now#}\",title:");
        info = String.valueOf(info) + StringUtil.quote(StringUtil.replaceParameters(request, data.title)) + "}";
        WebUtil.response(response, StringUtil.concat("{info:", info, "}"));
    }

    public static void checkParentId(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String id = request.getParameter("parentId");
        if (!XwlBuffer.exists(id)) {
            WebUtil.notExist(request);
        }
    }

    public static void deleteModule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String id = request.getParameter("id");
        ConcurrentHashMap<String, XwlData> map = XwlBuffer.getXwlMap();
        Set<Map.Entry<String, XwlData>> es = map.entrySet();
        ArrayList<String> delList = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement st1 = null;
        PreparedStatement st2 = null;
        boolean isAll = StringUtil.getBool(request.getParameter("isAll"));
        try {
            conn = DbUtil.getConnection();
            conn.setAutoCommit(false);
            st1 = conn.prepareStatement("delete from WB_MODULE where MODULE_ID=?");
            st2 = conn.prepareStatement("delete from WB_MODULE_ROLE where MODULE_ID=?");
            Designer.addDelModule(st1, st2, map, es, id, delList, isAll);
            st1.executeBatch();
            st2.executeBatch();
            for (String s : delList) {
                ScriptBuffer.remove(s);
                map.remove(s);
            }
            WebUtil.response(response, StringUtil.joinList(delList, ","));
            conn.commit();
        }
        catch (Throwable throwable) {
            DbUtil.closeStatement(st1);
            DbUtil.closeStatement(st2);
            DbUtil.closeConnection(conn);
            throw throwable;
        }
        DbUtil.closeStatement(st1);
        DbUtil.closeStatement(st2);
        DbUtil.closeConnection(conn);
    }

    public static void deleteControl(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String name = request.getParameter("META_NAME");
        DbUtil.update(request, "delete from WB_META where META_NAME={?META_NAME?}");
        XwlBuffer.getMetaMap().remove(name);
    }

    public static void initialize(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Designer.getIconList(request);
        Designer.getJndiList(request);
        Designer.setVars(request);
        HttpSession session = request.getSession(true);
        QueueWriter out = (QueueWriter)session.getAttribute("sys.out");
        if (out == null) {
            out = new QueueWriter(Var.getInt("webbuilder.app.ide.consoleSize"));
            session.setAttribute("sys.out", (Object)out);
        } else {
            out.clear();
        }
    }

    private static void setVars(HttpServletRequest request) throws Exception {
        if (Var.getBool("webbuilder.app.ide.saveLastPath")) {
            request.setAttribute("idepath", (Object)StringUtil.quote(Value.get(request, "wb.ide.path")));
        } else {
            request.setAttribute("idepath", (Object)"\"-\"");
        }
    }

    private static void getIconList(HttpServletRequest request) throws Exception {
        File iconPath = new File(Main.path, "webbuilder/images");
        File[] list = iconPath.listFiles();
        FileUtil.sortFiles(list);
        StringBuilder buf = new StringBuilder();
        boolean isFirst = true;
        buf.append("Ds.iconList=[");
        File[] fileArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!f.isDirectory()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append(',');
                }
                String name = FileUtil.extractFilenameNoExt(f.getName());
                buf.append('\"');
                buf.append(name);
                buf.append('\"');
            }
            ++n2;
        }
        buf.append("];");
        request.setAttribute("dsIconScript", (Object)buf);
    }

    private static void getJndiList(HttpServletRequest request) throws Exception {
        ArrayList<String> list = DbUtil.listJndi();
        StringBuilder buf = new StringBuilder();
        boolean isFirst = true;
        buf.append("Ds.jndiList=[");
        for (String s : list) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(',');
            }
            buf.append(StringUtil.quote(s));
        }
        buf.append("];");
        request.setAttribute("dsJndiScript", (Object)buf);
    }

    public static void getControlTree(HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean runMode = request.getParameter("r") != null;
        String sql = runMode ? " where META_NAME<>'module'" : "";
        ResultSet rs = DbUtil.query(request, "select META_NAME,META_TYPE from WB_META" + sql + " order by ORDER_INDEX");
        StringBuilder buf = new StringBuilder();
        String oldType = null;
        boolean isFirst = true;
        boolean firstSec = true;
        buf.append("{children:[");
        while (rs.next()) {
            String name = rs.getString(1);
            String type = rs.getString(2);
            if (!StringUtil.isEqual(type, oldType)) {
                oldType = type;
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append("]},");
                }
                buf.append("{text:");
                buf.append(StringUtil.quote(type));
                buf.append(",children:[");
                firstSec = true;
            }
            if (firstSec) {
                firstSec = false;
            } else {
                buf.append(',');
            }
            JSONObject jo = new JSONObject("{xwlMeta:\"" + name + "\",id:\"" + name + "\"}");
            Designer.setControl(jo, runMode, runMode, false);
            buf.append(jo.toString());
        }
        buf.append("]}]}");
        WebUtil.response(response, buf);
    }

    private static void saveTree(HttpServletRequest request, Connection conn) throws Exception {
        JSONArray array = new JSONArray(request.getParameter("metaTree"));
        PreparedStatement stm = conn.prepareStatement("update WB_META set META_TYPE=?,ORDER_INDEX=? where META_NAME=?");
        int j = array.length();
        int i = 0;
        while (i < j) {
            JSONObject jo = array.getJSONObject(i);
            stm.setString(1, jo.getString("META_TYPE"));
            stm.setInt(2, jo.getInt("ORDER_INDEX"));
            stm.setString(3, jo.getString("META_NAME"));
            stm.addBatch();
            ++i;
        }
        stm.executeBatch();
    }

    public static void saveMetaTree(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Connection conn = DbUtil.getConnection(request);
        conn.setAutoCommit(false);
        Designer.saveTree(request, conn);
    }

    public static void getModuleTree(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String parentId = request.getParameter("parentId");
        boolean check = StringUtil.getBool(WebUtil.fetch(request, "check"));
        boolean role = StringUtil.getBool(WebUtil.fetch(request, "role"));
        int type = check ? 1 : (role ? 2 : 0);
        WebUtil.response(response, Designer.getModuleTree(request, parentId, false, type));
    }

    public static void listModules(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String parentId = request.getParameter("parentId");
        WebUtil.response(response, Designer.getModuleTree(request, parentId, true, 0));
    }

    public static void getModule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String path;
        String id = WebUtil.fetch(request, "id");
        XwlData data = XwlBuffer.getXwl(id);
        if (data == null) {
            throw new Exception(Str.format(request, "notFound", id));
        }
        JSONObject obj = data.content;
        if (Var.getBool("webbuilder.app.ide.saveLastPath") && !StringUtil.isEmpty(path = request.getParameter("path"))) {
            Value.set(request, "wb.ide.path", path);
        }
        JSONObject objCopy = new JSONObject(obj.toString());
        Designer.setControl(objCopy, false, true, true);
        WebUtil.response(response, StringUtil.concat("{children:[", objCopy.toString(), "]}"));
    }

    public static void getControl(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String id = WebUtil.fetch(request, "id");
        JSONObject obj = XwlBuffer.getMeta(id);
        if (obj == null) {
            throw new Exception(Str.format(request, "notFound", id));
        }
        JSONObject objCopy = new JSONObject(obj.toString());
        Designer.setMeta(objCopy);
        WebUtil.response(response, objCopy);
    }

    public static void saveModule(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String id;
        Connection conn = DbUtil.getConnection(request);
        ConcurrentHashMap<String, XwlData> map = XwlBuffer.getXwlMap();
        PreparedStatement stm = conn.prepareStatement("update WB_MODULE set MODULE_CONTENT=?,LAST_MODIFY_DATE=?,LAST_MODIFY_USER=? where MODULE_ID=?");
        Enumeration enums = request.getParameterNames();
        String user = (String)request.getAttribute("sys.user");
        HashMap<String, String> buffer = new HashMap<String, String>();
        Date date = new Date();
        Timestamp time = new Timestamp(date.getTime());
        conn.setAutoCommit(false);
        while (enums.hasMoreElements()) {
            String p = enums.nextElement().toString();
            if (!StringUtil.isEqual(StringUtil.substring(p, 0, 4), "xwl_")) continue;
            id = p.substring(4);
            String data = request.getParameter(p);
            DbUtil.setCharStream(stm, 1, data);
            stm.setTimestamp(2, time);
            stm.setString(3, user);
            stm.setString(4, id);
            stm.addBatch();
            buffer.put(id, data);
        }
        stm.executeBatch();
        Set es = buffer.entrySet();
        for (Map.Entry e : es) {
            id = (String)e.getKey();
            XwlData xd = map.get(id);
            if (xd == null) {
                WebUtil.notExist(request);
                continue;
            }
            String xwl = (String)e.getValue();
            ScriptBuffer.remove(id);
            xd.content = new JSONObject(xwl);
            xd.lastModifyDate = date;
            xd.lastModifyUser = user;
        }
    }

    public static void saveControl(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Connection conn = DbUtil.getConnection(request);
        PreparedStatement stm = conn.prepareStatement("update WB_META set META_CONTENT=? where META_NAME=?");
        Enumeration enums = request.getParameterNames();
        HashMap<String, String> buffer = new HashMap<String, String>();
        conn.setAutoCommit(false);
        while (enums.hasMoreElements()) {
            String p = enums.nextElement().toString();
            if (!StringUtil.isEqual(StringUtil.substring(p, 0, 4), "xwl_")) continue;
            String v = request.getParameter(p);
            String id = p.substring(4);
            String content = Designer.optimizeControl(v);
            DbUtil.setCharStream(stm, 1, content);
            stm.setString(2, id);
            stm.addBatch();
            buffer.put(id, content);
        }
        stm.executeBatch();
        stm.close();
        ConcurrentHashMap<String, JSONObject> map = XwlBuffer.getMetaMap();
        Set es = buffer.entrySet();
        for (Map.Entry e : es) {
            map.put((String)e.getKey(), new JSONObject((String)e.getValue()));
        }
    }

    public static void newControl(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Connection conn = DbUtil.getConnection(request);
        String name = request.getParameter("META_NAME");
        String type = request.getParameter("META_TYPE");
        String meta = "{xwlMeta:{xwlText:" + StringUtil.quote(name) + ",id:\"string\",xwlIconCls:\"item_icon\"},properties:{id:\"\"}}";
        conn.setAutoCommit(false);
        PreparedStatement stm = conn.prepareStatement("insert into WB_META values(?,?,?,?)");
        stm.setString(1, name);
        stm.setString(2, type);
        DbUtil.setCharStream(stm, 3, meta);
        stm.setInt(4, 1);
        stm.executeUpdate();
        Designer.saveTree(request, conn);
        XwlBuffer.getMetaMap().put(name, new JSONObject(meta));
        request.setAttribute("id", (Object)name);
        Designer.getControl(request, response);
    }

    private static String optimizeControl(String v) throws Exception {
        String para;
        JSONObject json;
        String s;
        String n;
        int n2;
        int n3;
        String[] stringArray;
        String[] names;
        JSONObject jo = new JSONObject(v);
        JSONObject m = jo.getJSONObject("xwlMeta");
        JSONObject p = jo.optJSONObject("properties");
        JSONObject e = jo.optJSONObject("events");
        if (p == null) {
            if (jo.has("properties")) {
                jo.remove("properties");
            }
        } else {
            names = JSONObject.getNames((JSONObject)p);
            if (names == null) {
                jo.remove("properties");
            } else {
                stringArray = names;
                n3 = names.length;
                n2 = 0;
                while (n2 < n3) {
                    n = stringArray[n2];
                    s = p.getString(n);
                    if (!StringUtil.isEmpty(s)) {
                        json = new JSONObject(s);
                        para = json.optString("parameters");
                        if (!StringUtil.isEmpty(para)) {
                            para = "=" + para;
                        }
                        m.put(n, (Object)(String.valueOf(json.getString("type")) + para));
                        p.put(n, (Object)json.optString("defaultValue"));
                    }
                    ++n2;
                }
            }
        }
        if (e == null) {
            if (jo.has("events")) {
                jo.remove("events");
            }
        } else {
            names = JSONObject.getNames((JSONObject)e);
            if (names == null) {
                jo.remove("events");
            } else {
                stringArray = names;
                n3 = names.length;
                n2 = 0;
                while (n2 < n3) {
                    n = stringArray[n2];
                    s = e.getString(n);
                    if (!StringUtil.isEmpty(s)) {
                        json = new JSONObject(s);
                        para = json.optString("parameters");
                        if (!StringUtil.isEmpty(para)) {
                            para = "=" + para;
                        }
                        m.put(n, (Object)(String.valueOf(json.getString("type")) + para));
                        e.put(n, (Object)json.optString("defaultValue"));
                    }
                    ++n2;
                }
            }
        }
        return jo.toString();
    }

    private static void setMeta(JSONObject obj) throws Exception {
        String n;
        JSONObject events;
        JSONObject meta = obj.getJSONObject("xwlMeta");
        JSONObject properties = obj.optJSONObject("properties");
        if (properties == null) {
            properties = new JSONObject();
            obj.put("properties", (Object)properties);
        }
        if ((events = obj.optJSONObject("events")) == null) {
            events = new JSONObject();
            obj.put("events", (Object)events);
        }
        JSONObject e1 = new JSONObject();
        JSONObject e2 = new JSONObject();
        JSONObject e3 = new JSONObject();
        String[] names = JSONObject.getNames((JSONObject)meta);
        String edit = "new Ext.form.field.Trigger({enableKeyEvents:true,hideTrigger:true,listeners:{keydown:Cm.monitorKey,change:Cm.monitorChange,focus:Cm.monitorFocus}})";
        String trigger = Designer.getTrigger("Cm.editProperty");
        String[] stringArray = names;
        int n2 = names.length;
        int n3 = 0;
        while (n3 < n2) {
            n = stringArray[n3];
            String content = meta.getString(n);
            if (StringUtil.substring(n, 0, 3).equals("xwl")) {
                e1.put(n, (Object)edit);
            } else {
                String dftValue;
                String value;
                String name;
                if (content.indexOf(61) == -1) {
                    name = content;
                    value = "";
                } else {
                    name = StringUtil.getNamePart(content);
                    value = StringUtil.getValuePart(content);
                }
                content = "{type:\"" + name + "\"";
                if (!StringUtil.isEmpty(value)) {
                    content = String.valueOf(content) + ",parameters:" + StringUtil.quote(value);
                }
                if (properties.has(n)) {
                    dftValue = properties.getString(n);
                    if (!StringUtil.isEmpty(dftValue)) {
                        content = String.valueOf(content) + ",defaultValue:" + StringUtil.quote(dftValue);
                    }
                    properties.put(n, (Object)(String.valueOf(content) + "}"));
                } else if (events.has(n)) {
                    dftValue = events.getString(n);
                    if (!StringUtil.isEmpty(dftValue)) {
                        content = String.valueOf(content) + ",defaultValue:" + StringUtil.quote(dftValue);
                    }
                    events.put(n, (Object)(String.valueOf(content) + "}"));
                }
                meta.remove(n);
            }
            ++n3;
        }
        names = JSONObject.getNames((JSONObject)properties);
        if (names != null) {
            stringArray = names;
            n2 = names.length;
            n3 = 0;
            while (n3 < n2) {
                n = stringArray[n3];
                e2.put(n, (Object)trigger);
                ++n3;
            }
        }
        if ((names = JSONObject.getNames((JSONObject)events)) != null) {
            stringArray = names;
            n2 = names.length;
            n3 = 0;
            while (n3 < n2) {
                n = stringArray[n3];
                e3.put(n, (Object)trigger);
                ++n3;
            }
        }
        obj.put("custGEditors", (Object)e1);
        obj.put("custPEditors", (Object)e2);
        obj.put("custEEditors", (Object)e3);
    }

    private static void setControl(JSONObject obj, boolean textAsId, boolean childAppend, boolean clearDefault) throws Exception {
        String[] stringArray;
        String[] nl;
        JSONObject events;
        JSONObject properties;
        String meta = obj.getString("xwlMeta");
        JSONObject metaObj = XwlBuffer.getMeta(meta);
        JSONObject propertyMeta = metaObj.optJSONObject("properties");
        if (propertyMeta == null) {
            properties = new JSONObject();
        } else {
            properties = new JSONObject(propertyMeta.toString());
            if (clearDefault) {
                JsonUtil.clear(properties);
            }
        }
        JSONObject eventMeta = metaObj.optJSONObject("events");
        if (eventMeta == null) {
            events = new JSONObject();
        } else {
            events = new JSONObject(eventMeta.toString());
            if (clearDefault) {
                JsonUtil.clear(events);
            }
        }
        JSONObject metaConf = metaObj.getJSONObject("xwlMeta");
        JSONObject pEditors = new JSONObject();
        JSONObject empObj = new JSONObject();
        JSONObject eEditors = new JSONObject();
        JSONObject eParaMeta = new JSONObject();
        JSONArray empArray = new JSONArray();
        String[] names = JSONObject.getNames((JSONObject)obj);
        String id = obj.getString("id");
        String text = metaConf.getString("xwlText");
        String iconCls = metaConf.getString("xwlIconCls");
        boolean isLeaf = true;
        String[] stringArray2 = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray2[n2];
            if (n3.equals("children")) {
                JSONArray children = obj.getJSONArray(n3);
                int j = children.length();
                int i = 0;
                while (i < j) {
                    Designer.setControl(children.getJSONObject(i), textAsId, childAppend, clearDefault);
                    ++i;
                }
                isLeaf = false;
            } else if (properties != null && properties.has(n3)) {
                properties.put(n3, obj.get(n3));
                obj.remove(n3);
            } else if (events != null && events.has(n3)) {
                events.put(n3, obj.get(n3));
                obj.remove(n3);
            }
            ++n2;
        }
        if (textAsId) {
            obj.put("text", (Object)text);
        } else {
            obj.put("text", (Object)id);
        }
        obj.put("iconCls", (Object)iconCls);
        Designer.setXwlMeta(metaConf, obj);
        if (properties == null) {
            obj.put("properties", (Object)empObj);
        } else {
            obj.put("properties", (Object)properties);
            nl = JSONObject.getNames((JSONObject)properties);
            if (nl != null) {
                stringArray = nl;
                int n4 = nl.length;
                n = 0;
                while (n < n4) {
                    String n5 = stringArray[n];
                    Designer.setEditors(pEditors, metaConf, n5);
                    Designer.setParaMeta(eParaMeta, metaConf, n5);
                    ++n;
                }
            }
        }
        if (events == null) {
            obj.put("events", (Object)empObj);
        } else {
            obj.put("events", (Object)events);
            nl = JSONObject.getNames((JSONObject)events);
            if (nl != null) {
                stringArray = nl;
                int n6 = nl.length;
                n = 0;
                while (n < n6) {
                    String n7 = stringArray[n];
                    Designer.setEditors(eEditors, metaConf, n7);
                    Designer.setParaMeta(eParaMeta, metaConf, n7);
                    ++n;
                }
            }
        }
        obj.put("custPEditors", (Object)pEditors);
        obj.put("custEEditors", (Object)eEditors);
        obj.put("custEPara", (Object)eParaMeta);
        if (isLeaf) {
            if (!childAppend || StringUtil.isEmpty(metaConf.optString("xwlChildren"))) {
                obj.put("leaf", true);
            } else {
                obj.put("children", (Object)empArray);
            }
        }
    }

    private static void setXwlMeta(JSONObject meta, JSONObject obj) throws Exception {
        String[] ns = JSONObject.getNames((JSONObject)meta);
        JSONObject jo = new JSONObject();
        String[] stringArray = ns;
        int n = ns.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            String val = meta.getString(n3);
            if (StringUtil.substring(n3, 0, 3).equals("xwl")) {
                obj.put(n3, (Object)val);
            } else {
                jo.put(n3, (Object)val);
            }
            ++n2;
        }
        obj.put("xwlPT", (Object)jo);
    }

    private static String getTrigger(String func) {
        return "new Ext.form.field.Trigger({enableKeyEvents:true,onTriggerClick:" + func + ",listeners:{keydown:Cm.monitorKey,render:Cm.populateDblClick},editable:false,blockPost:true,triggerCls:'ellipsis_icon'})";
    }

    private static void setEditors(JSONObject editors, JSONObject meta, String name) throws Exception {
        String value = meta.optString(name);
        String type = StringUtil.getNamePart(value);
        String para = StringUtil.getValuePart(value);
        if (StringUtil.isEqual(para, value)) {
            para = "";
        }
        if (type.equals("js") || type.equals("ss") || type.equals("object") || type.equals("text") || type.equals("sql")) {
            editors.put(name, (Object)("Ds.edtTrigger('" + type + "')"));
        } else if (type.equals("boolean")) {
            editors.put(name, (Object)"Ds.edtBool()");
        } else if (type.equals("date")) {
            editors.put(name, (Object)"Ds.edtDate()");
        } else if (type.equals("color")) {
            editors.put(name, (Object)"Ds.edtColor()");
        } else if (type.equals("iconClass")) {
            editors.put(name, (Object)"Ds.edtIcon()");
        } else if (type.equals("jndi")) {
            editors.put(name, (Object)"Ds.edtJndi()");
        } else if (type.equals("bind") || type.equals("bindText")) {
            editors.put(name, (Object)("Ds.edtBind('" + para + "')"));
        } else if (type.equals("bindMulti")) {
            editors.put(name, (Object)("Ds.edtBind('" + para + "',true)"));
        } else if (type.equals("enum")) {
            editors.put(name, (Object)("Ds.edtEnum('" + para + "')"));
        } else if (type.equals("enumMulti")) {
            editors.put(name, (Object)("Ds.edtEnum('" + para + "',true)"));
        } else if (type.equals("url")) {
            editors.put(name, (Object)"Ds.edtUrl(false)");
        } else if (type.equals("urlList")) {
            editors.put(name, (Object)"Ds.edtUrl(true)");
        } else if (StringUtil.isEqual(name, "id")) {
            editors.put(name, (Object)"Ds.edtText('id')");
        } else {
            editors.put(name, (Object)("Ds.edtText('" + type + "')"));
        }
    }

    private static void setParaMeta(JSONObject paraMeta, JSONObject meta, String name) throws Exception {
        String value = meta.optString(name);
        String type = StringUtil.getNamePart(value);
        String para = StringUtil.getValuePart(value);
        if (type.equals("js") || type.equals("ss")) {
            paraMeta.put(name, (Object)para);
        }
    }

    private static String getModuleTree(HttpServletRequest request, String parentId, boolean runMode, int type) throws Exception {
        ConcurrentHashMap<String, XwlData> map = XwlBuffer.getXwlMap();
        Set<Map.Entry<String, XwlData>> es = map.entrySet();
        StringBuilder buf = new StringBuilder();
        boolean isFirst = true;
        String pid = StringUtil.isEmpty(parentId) ? "-1" : parentId;
        buf.append("{children:[");
        for (Map.Entry<String, XwlData> e : es) {
            boolean hasRole;
            String id = e.getKey();
            XwlData d = e.getValue();
            if (!StringUtil.isEqual(pid, d.parentId) || runMode && (d.isHidden || !d.isFolder && !WebUtil.checkRight(request, id) || d.isFolder && !Designer.canDisplay(request, map, es, id))) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(',');
            }
            buf.append("{text:");
            String text = StringUtil.replaceParameters(request, d.title);
            boolean bl = hasRole = type == 2 && d.roles != null;
            if (hasRole) {
                buf.append(StringUtil.quote(StringUtil.concat("<b>", text, "</b>")));
            } else {
                buf.append(StringUtil.quote(text));
            }
            buf.append(",orgTitle:");
            buf.append(StringUtil.quote(text));
            buf.append(",iconCls:\"");
            buf.append(d.icon);
            buf.append("\",leaf:");
            buf.append(!d.isFolder);
            buf.append(",MODULE_ID:\"");
            buf.append(id);
            buf.append("\",PARENT_ID:\"");
            buf.append(d.parentId);
            if (d.isHidden) {
                buf.append("\",cls:\"wb_blue");
            }
            buf.append("\",ORDER_INDEX:");
            buf.append(d.orderIndex);
            buf.append(",IS_FOLDER:");
            buf.append(d.isFolder);
            if (hasRole) {
                buf.append(",roles:");
                buf.append(JsonUtil.getText(d.roles));
            }
            buf.append(",NEW_WIN:");
            buf.append(d.newWin);
            if (d.isFolder) {
                if (!Designer.folderHasChildren(es, id)) {
                    buf.append(",children:[]");
                }
            } else if (type == 1) {
                buf.append(",checked:false");
            }
            if (!runMode) {
                buf.append(",orgText:");
                buf.append(StringUtil.quote(d.title));
                buf.append(",CREATE_USER:\"");
                buf.append(d.createUser);
                buf.append("\",CREATE_DATE:\"");
                buf.append(DateUtil.toString(d.createDate));
                buf.append("\",LAST_MODIFY_USER:\"");
                buf.append(d.createUser);
                buf.append("\",LAST_MODIFY_DATE:\"");
                buf.append(DateUtil.toString(d.lastModifyDate));
                buf.append("\",IS_HIDDEN:");
                buf.append(d.isHidden);
            }
            buf.append('}');
        }
        buf.append("]}");
        return buf.toString();
    }

    private static boolean canDisplay(HttpServletRequest request, ConcurrentHashMap<String, XwlData> xwlMap, Set<Map.Entry<String, XwlData>> es, String xwlId) {
        boolean notHasDescendant = true;
        String[] userRoles = (String[])request.getAttribute("sys.userRoles");
        for (Map.Entry<String, XwlData> e : es) {
            String id;
            XwlData curData;
            XwlData d = curData = e.getValue();
            if (d.isFolder) continue;
            boolean isDescendant = false;
            boolean isHidden = false;
            while ((d = xwlMap.get(id = d.parentId)) != null) {
                if (d.isHidden) {
                    isHidden = true;
                }
                if (!id.equals(xwlId)) continue;
                if (isHidden) break;
                isDescendant = true;
                break;
            }
            if (!isDescendant || curData.isHidden) continue;
            if (!curData.content.optBoolean("loginRequired", true)) {
                return true;
            }
            if (notHasDescendant) {
                notHasDescendant = false;
            }
            boolean hasPerm = true;
            d = curData;
            do {
                ArrayList<String> setRoles;
                if ((setRoles = d.roles) == null) continue;
                for (String r : setRoles) {
                    String role = StringUtil.getNamePart(r);
                    if (!role.equals("default") && StringUtil.indexOf(userRoles, role) == -1) continue;
                    return true;
                }
                hasPerm = false;
                break;
            } while ((d = xwlMap.get(id = d.parentId)) != null);
            if (!hasPerm) continue;
            return true;
        }
        if (notHasDescendant) {
            return false;
        }
        return StringUtil.indexOf(userRoles, "admin") != -1;
    }

    private static boolean folderHasChildren(Set<Map.Entry<String, XwlData>> es, String id) {
        for (Map.Entry<String, XwlData> e : es) {
            if (!StringUtil.isEqual(e.getValue().parentId, id)) continue;
            return true;
        }
        return false;
    }

    private static void addDelModule(PreparedStatement st1, PreparedStatement st2, ConcurrentHashMap<String, XwlData> map, Set<Map.Entry<String, XwlData>> es, String id, ArrayList<String> delList, boolean isAll) throws Exception {
        if (isAll) {
            delList.add(id);
            st1.setString(1, id);
            st1.addBatch();
            st2.setString(1, id);
            st2.addBatch();
        }
        for (Map.Entry<String, XwlData> e : es) {
            if (!StringUtil.isEqual(e.getValue().parentId, id)) continue;
            Designer.addDelModule(st1, st2, map, es, e.getKey(), delList, true);
        }
    }
}

