/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.interact;

import com.webbuilder.common.Resource;
import com.webbuilder.common.Str;
import com.webbuilder.common.Var;
import com.webbuilder.tool.ExcelObject;
import com.webbuilder.utils.DbUtil;
import com.webbuilder.utils.FileUtil;
import com.webbuilder.utils.JsonUtil;
import com.webbuilder.utils.StringUtil;
import com.webbuilder.utils.WebUtil;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.json.JSONArray;
import org.json.JSONObject;

public class DbExplorer {
    public static void getProperty(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResultSet rs = (ResultSet)request.getAttribute("query1");
        ResultSetMetaData meta = rs.getMetaData();
        StringBuilder buf = new StringBuilder();
        int j = meta.getColumnCount();
        buf.append("{rows:[");
        int i = 0;
        while (i < j) {
            if (i > 0) {
                buf.append(",");
            }
            int k = i + 1;
            buf.append("{name:");
            buf.append(StringUtil.quote(meta.getColumnLabel(k)));
            buf.append(",type:");
            buf.append(StringUtil.quote(meta.getColumnTypeName(k)));
            buf.append(",required:");
            buf.append(meta.isNullable(k) == 0 ? 1 : 0);
            buf.append(",size:\"");
            buf.append(meta.getPrecision(k));
            int scale = meta.getScale(k);
            if (scale != 0) {
                buf.append(",");
                buf.append(scale);
            }
            buf.append("\"}");
            ++i;
        }
        buf.append("]}");
        WebUtil.response(response, buf);
    }

    public static void getBlob(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String table = request.getParameter("___table");
        String keyField = request.getParameter("___field");
        Connection conn = null;
        PreparedStatement st2 = null;
        PreparedStatement st3 = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        ResultSet rs3 = null;
        StringBuilder sql = new StringBuilder();
        boolean isFirst = true;
        ArrayList<String> params = new ArrayList<String>();
        try {
            conn = DbUtil.getConnection(request.getParameter("___jndi"));
            rs1 = DbUtil.getResultSet(conn, StringUtil.concat("select * from ", table, " where 1=0"));
            ResultSetMetaData meta = rs1.getMetaData();
            sql.append(" from " + table + " where ");
            int j = meta.getColumnCount();
            int i = 0;
            while (i < j) {
                int type = meta.getColumnType(i + 1);
                if (DbExplorer.fieldAsKey(type)) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sql.append(" and ");
                    }
                    String field = meta.getColumnLabel(i + 1);
                    String value = request.getParameter(field);
                    if (StringUtil.isEmpty(value)) {
                        switch (type) {
                            case -15: 
                            case -9: 
                            case 1: 
                            case 12: {
                                sql.append("(");
                                sql.append(field);
                                sql.append(" is null or ");
                                sql.append(field);
                                sql.append("='')");
                                break;
                            }
                            default: {
                                sql.append(field);
                                sql.append(" is null");
                                break;
                            }
                        }
                    } else {
                        sql.append(field);
                        sql.append("=?");
                        params.add(String.valueOf(type) + "=" + value);
                    }
                }
                ++i;
            }
            st2 = conn.prepareStatement("select count(*) as \"CT\"" + sql.toString());
            i = 1;
            for (String t : params) {
                DbUtil.setObject(st2, i++, Integer.parseInt(StringUtil.getNamePart(t)), StringUtil.getValuePart(t));
            }
            rs2 = st2.executeQuery();
            if (rs2.next() && rs2.getInt(1) > 1) {
                throw new Exception(Str.format(request, "recordNotUnique", new String[0]));
            }
            st3 = conn.prepareStatement("select " + keyField + sql.toString());
            i = 1;
            for (String t : params) {
                DbUtil.setObject(st3, i++, Integer.parseInt(StringUtil.getNamePart(t)), StringUtil.getValuePart(t));
            }
            rs3 = st3.executeQuery();
            DbUtil.outputBlob(rs3, request, response, true);
        }
        catch (Throwable throwable) {
            DbUtil.closeResultSet(rs1);
            DbUtil.closeResultSet(rs2);
            DbUtil.closeResultSet(rs3);
            DbUtil.closeStatement(st2);
            DbUtil.closeStatement(st3);
            DbUtil.closeConnection(conn);
            throw throwable;
        }
        DbUtil.closeResultSet(rs1);
        DbUtil.closeResultSet(rs2);
        DbUtil.closeResultSet(rs3);
        DbUtil.closeStatement(st2);
        DbUtil.closeStatement(st3);
        DbUtil.closeConnection(conn);
    }

    public static void exportData(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.reset();
        response.setHeader("content-type", "application/force-download");
        response.setHeader("content-disposition", "attachment;" + WebUtil.encodeFilename(request, String.valueOf(request.getParameter("title")) + ".txt"));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "utf-8"));
        try {
            DbUtil.exportData(writer, (ResultSet)request.getAttribute("query1"));
        }
        finally {
            ((Writer)writer).close();
        }
        response.flushBuffer();
    }

    public static void importData(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String filename = (String)request.getAttribute("uploadFile__name");
        if (FileUtil.extractFileExt(filename).equalsIgnoreCase("xls")) {
            DbExplorer.importExcel(request, response);
        } else {
            DbExplorer.importTxt(request, response);
        }
    }

    private static void importTxt(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONArray ja = new JSONArray(StringUtil.getUtfString((InputStream)request.getAttribute("uploadFile")));
        Connection conn = DbUtil.getConnection(request, (String)request.getAttribute("jndi"));
        conn.setAutoCommit(false);
        String table = (String)request.getAttribute("table");
        DbUtil.importData(conn, table, ja);
    }

    private static void importExcel(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResultSet rs = null;
        Statement st = null;
        Connection conn = null;
        boolean firstRow = true;
        boolean[] isDate = null;
        int[] types = null;
        StringBuilder fields = new StringBuilder();
        try {
            HSSFWorkbook wb = new HSSFWorkbook((InputStream)request.getAttribute("uploadFile"));
            HSSFSheet sheet = wb.getSheetAt(0);
            Iterator rows = sheet.rowIterator();
            conn = DbUtil.getConnection((String)request.getAttribute("jndi"));
            conn.setAutoCommit(false);
            String table = (String)request.getAttribute("table");
            while (rows.hasNext()) {
                HSSFRow row = (HSSFRow)rows.next();
                Iterator cells = row.cellIterator();
                int i = 0;
                while (cells.hasNext()) {
                    HSSFCell cell = (HSSFCell)cells.next();
                    if (firstRow) {
                        String val = cell.getStringCellValue();
                        if (i > 0) {
                            fields.append(",");
                        }
                        fields.append(val);
                    } else {
                        Object obj = ExcelObject.getCellValue(cell);
                        if (isDate[i] && obj instanceof Double) {
                            obj = HSSFDateUtil.getJavaDate((double)((Double)obj));
                        }
                        DbUtil.setObject((PreparedStatement)st, i + 1, types[i], obj);
                    }
                    ++i;
                }
                if (firstRow) {
                    firstRow = false;
                    rs = DbUtil.getResultSet(conn, StringUtil.concat("select ", fields.toString(), " from ", table, " where 1=0"));
                    ResultSetMetaData meta = rs.getMetaData();
                    int j = meta.getColumnCount();
                    types = new int[j];
                    isDate = new boolean[j];
                    st = conn.prepareStatement(StringUtil.concat("insert into ", table, " (", fields.toString(), ") values (", StringUtil.duplicate(",?", j).substring(1), ")"));
                    i = 0;
                    while (i < j) {
                        types[i] = meta.getColumnType(i + 1);
                        isDate[i] = DbUtil.getTypeCategory(types[i]).equals("date");
                        ++i;
                    }
                    continue;
                }
                st.addBatch();
            }
            st.executeBatch();
            conn.commit();
        }
        catch (Throwable throwable) {
            DbUtil.closeResultSet(rs);
            DbUtil.closeStatement(st);
            DbUtil.closeConnection(conn);
            throw throwable;
        }
        DbUtil.closeResultSet(rs);
        DbUtil.closeStatement(st);
        DbUtil.closeConnection(conn);
    }

    private static boolean fieldAsKey(int type) throws Exception {
        boolean f = Var.getBool("webbuilder.app.dbe.floatFieldAsKey");
        boolean b = Var.getBool("webbuilder.app.dbe.bigFieldAsKey");
        switch (type) {
            case 6: 
            case 7: 
            case 8: {
                return f;
            }
            case -16: 
            case -1: 
            case 2005: 
            case 2011: {
                return b;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return false;
            }
        }
        return true;
    }

    public static void deleteData(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONArray ja = new JSONArray(request.getParameter("data"));
        int j = ja.length();
        if (j == 0) {
            return;
        }
        String table = request.getParameter("table");
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement delete = null;
        StringBuilder buf = new StringBuilder();
        try {
            conn = DbUtil.getConnection(request.getParameter("jndi"));
            conn.setAutoCommit(false);
            rs = DbUtil.getResultSet(conn, StringUtil.concat("select * from ", table, " where 1=0"));
            ResultSetMetaData meta = rs.getMetaData();
            int y = meta.getColumnCount();
            boolean isFirst = true;
            String[] params = new String[y];
            int[] types = new int[y];
            String deleteSql = "delete from " + table + " where ";
            int x = 0;
            while (x < y) {
                int type;
                types[x] = type = meta.getColumnType(x + 1);
                if (DbExplorer.fieldAsKey(type)) {
                    params[x] = meta.getColumnName(x + 1);
                }
                ++x;
            }
            int i = 0;
            while (i < j) {
                JSONObject jo = ja.getJSONObject(i);
                isFirst = true;
                buf.delete(0, buf.length());
                x = 0;
                while (x < y) {
                    if (DbExplorer.fieldAsKey(types[x])) {
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            buf.append(" and ");
                        }
                        if (JsonUtil.optString(jo, params[x]).isEmpty()) {
                            switch (types[x]) {
                                case -15: 
                                case -9: 
                                case 1: 
                                case 12: {
                                    buf.append("(");
                                    buf.append(params[x]);
                                    buf.append(" is null or ");
                                    buf.append(params[x]);
                                    buf.append("='')");
                                    break;
                                }
                                default: {
                                    buf.append(params[x]);
                                    buf.append(" is null");
                                    break;
                                }
                            }
                        } else {
                            buf.append(params[x]);
                            buf.append("=?");
                        }
                    }
                    ++x;
                }
                delete = conn.prepareStatement(StringUtil.concat(deleteSql, buf.toString()));
                int k = 1;
                x = 0;
                while (x < y) {
                    String val = JsonUtil.optString(jo, params[x]);
                    if (!val.isEmpty()) {
                        DbUtil.setObject(delete, k++, types[x], val);
                    }
                    ++x;
                }
                k = delete.executeUpdate();
                if (k > 1) {
                    throw new Exception(Str.format(request, "recordNotUnique", new String[0]));
                }
                if (k == 0) {
                    throw new Exception("Record cannot be deleted.");
                }
                delete.close();
                ++i;
            }
            conn.commit();
        }
        catch (Throwable throwable) {
            DbUtil.closeResultSet(rs);
            DbUtil.closeStatement(delete);
            DbUtil.closeConnection(conn);
            throw throwable;
        }
        DbUtil.closeResultSet(rs);
        DbUtil.closeStatement(delete);
        DbUtil.closeConnection(conn);
    }

    public static void saveData(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONArray ja = new JSONArray(request.getParameter("data"));
        int j = ja.length();
        if (j == 0) {
            return;
        }
        String table = request.getParameter("table");
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement insert = null;
        PreparedStatement update = null;
        StringBuilder buf = new StringBuilder();
        StringBuilder fields = new StringBuilder();
        try {
            conn = DbUtil.getConnection(request.getParameter("jndi"));
            conn.setAutoCommit(false);
            rs = DbUtil.getResultSet(conn, StringUtil.concat("select * from ", table, " where 1=0"));
            ResultSetMetaData meta = rs.getMetaData();
            int y = meta.getColumnCount();
            boolean isFirst = true;
            int z = 0;
            String[] params = new String[y];
            int[] types = new int[y];
            buf.append("update ");
            buf.append(table);
            buf.append(" set ");
            int x = 0;
            while (x < y) {
                int type = meta.getColumnType(x + 1);
                if (!DbUtil.isBlobField(type) && !meta.isReadOnly(x + 1)) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        fields.append(",");
                        buf.append(",");
                    }
                    String name = meta.getColumnName(x + 1);
                    fields.append(name);
                    buf.append(name);
                    buf.append("=?");
                    types[z] = type;
                    params[z] = name;
                    ++z;
                }
                ++x;
            }
            insert = conn.prepareStatement(StringUtil.concat("insert into ", table, "(", fields.toString(), ") values (", StringUtil.duplicate(",?", z).substring(1), ")"));
            buf.append(" where ");
            String updateSql = buf.toString();
            int i = 0;
            while (i < j) {
                JSONObject jo = ja.getJSONObject(i);
                if (jo.has("__isNew")) {
                    x = 0;
                    while (x < z) {
                        DbUtil.setObject(insert, x + 1, types[x], JsonUtil.opt(jo, params[x]));
                        ++x;
                    }
                    insert.executeUpdate();
                } else {
                    isFirst = true;
                    JSONObject origin = jo.getJSONObject("__origin");
                    buf.delete(0, buf.length());
                    x = 0;
                    while (x < z) {
                        if (DbExplorer.fieldAsKey(types[x])) {
                            if (isFirst) {
                                isFirst = false;
                            } else {
                                buf.append(" and ");
                            }
                            if (JsonUtil.optString(origin, params[x]).isEmpty()) {
                                switch (types[x]) {
                                    case -15: 
                                    case -9: 
                                    case 1: 
                                    case 12: {
                                        buf.append("(");
                                        buf.append(params[x]);
                                        buf.append(" is null or ");
                                        buf.append(params[x]);
                                        buf.append("='')");
                                        break;
                                    }
                                    default: {
                                        buf.append(params[x]);
                                        buf.append(" is null");
                                        break;
                                    }
                                }
                            } else {
                                buf.append(params[x]);
                                buf.append("=?");
                            }
                        }
                        ++x;
                    }
                    update = conn.prepareStatement(StringUtil.concat(updateSql, buf.toString()));
                    x = 0;
                    while (x < z) {
                        DbUtil.setObject(update, x + 1, types[x], JsonUtil.opt(jo, params[x]));
                        ++x;
                    }
                    int k = 0;
                    x = 0;
                    while (x < z) {
                        String val = JsonUtil.optString(origin, params[x]);
                        if (DbExplorer.fieldAsKey(types[x]) && !val.isEmpty()) {
                            DbUtil.setObject(update, z + 1 + k++, types[x], val);
                        }
                        ++x;
                    }
                    k = update.executeUpdate();
                    if (k != 1) {
                        throw new Exception(Str.format(request, "recordNotUnique", new String[0]));
                    }
                    update.close();
                }
                ++i;
            }
            conn.commit();
        }
        catch (Throwable throwable) {
            DbUtil.closeResultSet(rs);
            DbUtil.closeStatement(insert);
            DbUtil.closeStatement(update);
            DbUtil.closeConnection(conn);
            throw throwable;
        }
        DbUtil.closeResultSet(rs);
        DbUtil.closeStatement(insert);
        DbUtil.closeStatement(update);
        DbUtil.closeConnection(conn);
    }

    public static void removeJndi(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String tree = Resource.get("wb.dbe.tree");
        if (!StringUtil.isEmpty(tree)) {
            String id = request.getParameter("id");
            JSONArray ja = new JSONArray(tree);
            boolean deleted = false;
            int j = ja.length();
            int i = 0;
            while (i < j) {
                JSONObject jo = ja.getJSONObject(i);
                if (jo.optString("id").equals(id)) {
                    ja.remove(i);
                    deleted = true;
                    break;
                }
                ++i;
            }
            if (deleted) {
                Resource.set("wb.dbe.tree", ja.toString());
            }
        }
    }

    public static void newJndi(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String result;
        JSONArray ja;
        String jndi = request.getParameter("jndiEdit");
        String text = request.getParameter("dispEdit");
        DbUtil.testJndi(jndi);
        String tree = Resource.get("wb.dbe.tree");
        if (StringUtil.isEmpty(tree)) {
            ja = new JSONArray();
        } else {
            ja = new JSONArray(tree);
            if (JsonUtil.findObject(ja, "text", text) != null) {
                throw new Exception(Str.format(request, "alreadyExists", text));
            }
        }
        JSONObject jo = new JSONObject();
        String index = request.getParameter("index");
        jo.put("text", (Object)text);
        jo.put("jndi", (Object)jndi);
        jo.put("id", (Object)((String)request.getAttribute("sys.id")));
        if (StringUtil.isEmpty(index)) {
            ja.put((Object)jo);
            result = ja.toString();
        } else {
            int ix = Integer.parseInt(index) - 1;
            if (ix == -1) {
                ix = 0;
            }
            result = JsonUtil.insert(ja, jo.toString(), ix);
        }
        Resource.set("wb.dbe.tree", result);
        WebUtil.response(response, jo);
    }

    public static void getList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String jndi = request.getParameter("jndi");
        if (StringUtil.isEmpty(jndi)) {
            WebUtil.response(response, DbExplorer.getDbList(request));
        } else {
            WebUtil.response(response, DbExplorer.getTableList(jndi));
        }
    }

    private static String getTableList(String jndi) throws Exception {
        String string;
        Connection conn = null;
        ResultSet rs = null;
        StringBuilder buf = new StringBuilder();
        boolean isFirst = true;
        String[] types = new String[]{"TABLE"};
        ArrayList<String> tableList = new ArrayList<String>();
        try {
            conn = DbUtil.getConnection(jndi);
            rs = conn.getMetaData().getTables(null, null, null, types);
            while (rs.next()) {
                tableList.add(rs.getString("TABLE_NAME"));
            }
            String[] tables = StringUtil.sort(tableList);
            buf.append('[');
            String[] stringArray = tables;
            int n = tables.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append(',');
                }
                buf.append("{text:\"");
                buf.append(t);
                buf.append("\",leaf:true,iconCls:\"table_icon\"}");
                ++n2;
            }
            buf.append(']');
            string = buf.toString();
        }
        catch (Throwable throwable) {
            DbUtil.closeResultSet(rs);
            DbUtil.closeConnection(conn);
            throw throwable;
        }
        DbUtil.closeResultSet(rs);
        DbUtil.closeConnection(conn);
        return string;
    }

    private static String getDbList(HttpServletRequest request) throws Exception {
        int i;
        int j;
        JSONArray ja = new JSONArray("[{text:\"{#Str.defaultStr#}\",jndi:\"{#Var.server.jndi#}\",id:\"default\"}]");
        String tree = Resource.get("wb.dbe.tree");
        if (tree != null) {
            JSONArray treeJa = new JSONArray(tree);
            j = treeJa.length();
            i = 0;
            while (i < j) {
                ja.put(treeJa.get(i));
                ++i;
            }
        }
        StringBuilder buf = new StringBuilder();
        boolean isFirst = true;
        j = ja.length();
        buf.append('[');
        i = 0;
        while (i < j) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(',');
            }
            JSONObject jo = ja.getJSONObject(i);
            jo.put("iconCls", (Object)"db_icon");
            buf.append(StringUtil.replaceParameters(request, jo.toString()));
            ++i;
        }
        buf.append(']');
        return buf.toString();
    }
}

