/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.controls;

import com.webbuilder.controls.ExtControl;
import com.webbuilder.utils.StringUtil;
import com.webbuilder.utils.WebUtil;

public class Store
extends ExtControl {
    private String[] key = new String[]{"id", "url", "fields", "beforeload", "load", "exception", "proxyType", "timeout", "mask", "showMask", "message", "showResult", "pageSize", "params"};
    private boolean isTree;

    @Override
    public void create() throws Exception {
        String type = this.getMeta("xwlType");
        this.isTree = type.indexOf("TreeStore") != -1;
        this.headerScript(StringUtil.concat("Wd.", this.gs("id"), "=new ", type, "({"));
        this.footerScript("});");
        this.headerScript(this.getJson(null));
    }

    @Override
    protected String getTagProperties() throws Exception {
        String fields = this.gs("fields");
        String pageSize = this.gs("pageSize");
        String params = this.gs("params");
        String timeout = this.gs("timeout");
        String proxy = this.gs("proxy");
        if (proxy.isEmpty()) {
            String proxyType = this.gs("proxyType");
            if (proxyType.isEmpty()) {
                proxyType = "ajax";
            }
            this.addText("type", proxyType);
            this.addText("url", WebUtil.getUrl(this.gs("url"), false));
            if (timeout.equals("-1")) {
                timeout = "Wb.maxInt";
            }
            this.addExpress("timeout", timeout);
            if (!this.isTree) {
                this.addExpress("reader", "{type:\"json\",root:\"rows\",totalProperty:\"total\"}");
            }
            String except = this.gs("exception");
            if (this.gb("showResult", true)) {
                except = except.isEmpty() ? "Wb.except(response.responseText);" : String.valueOf(except) + "\nWb.except(response.responseText);";
            }
            if (!except.isEmpty()) {
                this.addExpress("listeners", StringUtil.concat("{exception:function(proxy,response,operation,options){\n", except, "\n}}"));
            }
            proxy = this.getPBuffer();
            this.resetPBuffer();
            this.addExpress("proxy", "{" + proxy + "}");
        } else {
            this.addExpress("proxy", proxy);
        }
        if (!this.isTree && fields.isEmpty()) {
            fields = "[]";
        }
        this.addExpress("fields", fields);
        if (pageSize.equals("-1")) {
            pageSize = "Wb.maxInt";
        }
        this.addExpress("pageSize", pageSize);
        if (params.isEmpty()) {
            params = "{}";
        }
        this.addExpress("params", params);
        return this.getPBuffer();
    }

    @Override
    protected String getTagEvents() throws Exception {
        String beforeload = this.gs("beforeload");
        String msk = this.ge("mask");
        String msg = this.ge("msg");
        String load = this.gs("load");
        boolean showMask = this.gb("showMask", !this.isTree);
        boolean buffered = this.gb("buffered", false);
        if (!load.isEmpty()) {
            load = StringUtil.concat("if(successful){\n", load, "\n}");
        }
        String loadFuncPara = this.isTree ? "store,node,records,successful,options" : "store,records,successful,operation,options";
        if (!this.gs("grid").isEmpty()) {
            String f = StringUtil.concat("if(successful)Wb.setGrid(", this.ge("grid"), ",this);");
            load = load.isEmpty() ? f : StringUtil.concat(f, "\n", load);
        }
        beforeload = beforeload.isEmpty() ? "Wb.setStore(store);" : StringUtil.concat("Wb.setStore(store);\n", beforeload);
        if (showMask) {
            load = load.isEmpty() ? StringUtil.concat("Wb.unmask(", msk, ");") : StringUtil.concat("Wb.unmask(", msk, ");\n", load);
            msk = StringUtil.concat("Wb.mask(", msk, ",", msg, ");");
            beforeload = StringUtil.concat(beforeload, "\n", msk);
        }
        if (!StringUtil.isEmpty(beforeload)) {
            this.addEvent(buffered ? "beforeprefetch" : "beforeload", StringUtil.concat("function(store,operation,options){\n", beforeload, "\n}"));
        }
        if (!StringUtil.isEmpty(load)) {
            this.addEvent(buffered ? "prefetch" : "load", StringUtil.concat("function(", loadFuncPara, "){\n", load, "\n}"));
        }
        return this.getEBuffer();
    }

    @Override
    protected String[] getReservedKeys() throws Exception {
        return this.key;
    }
}

