/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.controls;

import com.webbuilder.common.Str;
import com.webbuilder.common.Var;
import com.webbuilder.controls.BackControl;
import com.webbuilder.utils.DbUtil;
import com.webbuilder.utils.JsonUtil;
import com.webbuilder.utils.StringUtil;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class Query
extends BackControl {
    public Object result;
    private Object[][] typeMap;
    private String id;
    private String jndi;
    private String sql;
    private String an;
    private String type;
    private String transaction;
    private String isolation;
    private boolean loadData;
    private boolean uniqueUpdate;
    private ArrayList<String> paramList = new ArrayList();
    private ArrayList<String> outParamList = new ArrayList();
    private int paramSize;
    private int batchBufferSize;
    private Connection connection;
    private PreparedStatement statement;
    private static String[] sqlTypes = new String[]{"VARCHAR=12", "INTEGER=4", "TIMESTAMP=93", "DOUBLE=8", "TEXT=-1", "BLOB=2004", "LONGVARCHAR=-1", "NUMERIC=2", "DECIMAL=3", "SMALLINT=5", "BIGINT=-5", "TINYINT=-6", "FLOAT=6", "REAL=7", "DOUBLE=8", "CHAR=1", "BIT=-7", "DATE=91", "TIME=92", "BINARY=-2", "VARBINARY=-3", "LONGVARBINARY=-4", "NULL=0", "OTHER=1111", "JAVA_OBJECT=2000", "DISTINCT=2001", "STRUCT=2002", "ARRAY=2003", "CLOB=2005", "REF=2006", "DATALINK=70", "BOOLEAN=16", "ROWID=-8", "NCHAR=-15", "NVARCHAR=-9", "LONGNVARCHAR=-16", "NCLOB=2011", "SQLXML=2009"};

    @Override
    public void create() throws Exception {
        this.getProperties();
        if (StringUtil.isEmpty(this.sql) || this.gb("disabled", false)) {
            return;
        }
        boolean hasRs = false;
        if (this.jndi.startsWith("Var.")) {
            this.jndi = Var.get(this.jndi.substring(4));
        }
        this.connection = DbUtil.getConnection(this.request, this.jndi);
        if (this.uniqueUpdate && this.transaction.isEmpty() && this.connection.getAutoCommit()) {
            this.transaction = "start";
        }
        if (StringUtil.isEqual(this.transaction, "start")) {
            DbUtil.startTrans(this.connection, this.isolation);
        }
        try {
            this.replaceSqlParameters();
            boolean isCall = this.sql.substring(0, 1).equals("{");
            if (isCall) {
                this.statement = this.connection.prepareCall(this.sql);
                this.type = null;
            } else {
                this.statement = this.connection.prepareStatement(this.sql);
            }
            if (this.paramSize > 0) {
                this.regParameters();
            }
            if (!StringUtil.isEmpty(this.an)) {
                this.executeBatch(this.an);
            } else if (StringUtil.isEqual(this.type, "query")) {
                this.result = this.statement.executeQuery();
                this.request.setAttribute(this.id, this.result);
                hasRs = true;
                if (this.loadData) {
                    DbUtil.loadFirstRow(this.request, this.id);
                }
            } else if (StringUtil.isEqual(this.type, "update")) {
                this.result = this.statement.executeUpdate();
                if (this.uniqueUpdate && (Integer)this.result != 1) {
                    throw new Exception(Str.format(this.request, "recordNotUnique", new String[0]));
                }
                this.request.setAttribute(this.id, this.result);
            } else {
                if (this.statement.execute()) {
                    this.result = this.statement.getResultSet();
                    this.request.setAttribute(this.id, this.result);
                    hasRs = true;
                    if (this.loadData) {
                        DbUtil.loadFirstRow(this.request, this.id);
                    }
                } else {
                    this.result = this.statement.getUpdateCount();
                    if (this.uniqueUpdate && (Integer)this.result != 1) {
                        throw new Exception(Str.format(this.request, "recordNotUnique", new String[0]));
                    }
                    this.request.setAttribute(this.id, this.result);
                }
                if (isCall && this.paramSize > 0) {
                    this.getOutParameter();
                }
            }
            if (this.transaction.equals("commit")) {
                this.connection.commit();
                this.connection.setAutoCommit(true);
            }
        }
        finally {
            if (!hasRs) {
                DbUtil.closeStatement(this.statement);
            }
        }
    }

    private void executeBatch(String an) throws Exception {
        JSONArray ja;
        Object obj = this.ga(an);
        boolean commitAll = false;
        if (obj instanceof JSONArray) {
            ja = (JSONArray)obj;
        } else {
            if (obj == null) {
                return;
            }
            String val = obj.toString();
            if (val.isEmpty()) {
                return;
            }
            ja = new JSONArray(val);
        }
        int j = ja.length();
        if (j == 0) {
            return;
        }
        int l = this.typeMap.length;
        int i = 0;
        while (i < j) {
            JSONObject jo = ja.getJSONObject(i);
            int k = 0;
            while (k < l) {
                Object[] types = this.typeMap[k];
                if (jo.has((String)types[1])) {
                    DbUtil.setObject(this.statement, k + 1, (Integer)types[0], JsonUtil.opt(jo, (String)types[1]));
                }
                ++k;
            }
            this.statement.addBatch();
            if ((i + 1) % this.batchBufferSize == 0) {
                this.statement.executeBatch();
                if (i == j - 1) {
                    commitAll = true;
                }
            }
            ++i;
        }
        if (!commitAll) {
            this.statement.executeBatch();
        }
    }

    private void getProperties() throws Exception {
        this.id = this.gs("id");
        this.jndi = this.gs("jndi");
        this.sql = this.gs("sql");
        String switcher = this.gs("sqlSwitcher");
        if (this.sql.isEmpty() && !switcher.isEmpty()) {
            this.sql = this.gp(switcher);
        }
        this.sql = this.sql.trim();
        this.type = this.gs("type");
        this.an = this.gs("arrayName");
        this.transaction = this.gs("transaction");
        this.uniqueUpdate = this.gb("uniqueUpdate", false);
        this.isolation = this.gs("isolation");
        this.loadData = this.gb("loadData", false);
        this.batchBufferSize = this.gi("batchBufferSize", Integer.MAX_VALUE);
    }

    private int getSqlType(String type) {
        int j = sqlTypes.length;
        int i = 0;
        while (i < j) {
            if (StringUtil.isSame(StringUtil.getNamePart(sqlTypes[i]), type)) {
                return Integer.parseInt(StringUtil.getValuePart(sqlTypes[i]));
            }
            ++i;
        }
        if (StringUtil.isNumeric(type, false)) {
            return Integer.parseInt(type);
        }
        return 12;
    }

    private boolean isSqlType(String type) {
        int j = sqlTypes.length;
        if (StringUtil.isNumeric(type, false)) {
            return true;
        }
        int i = 0;
        while (i < j) {
            if (StringUtil.isSame(StringUtil.getNamePart(sqlTypes[i]), type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void regParameters() throws Exception {
        CallableStatement callStatement = this.statement instanceof CallableStatement ? (CallableStatement)this.statement : null;
        this.typeMap = new Object[this.paramSize][2];
        int i = 0;
        while (i < this.paramSize) {
            String param = this.paramList.get(i);
            if (callStatement != null && StringUtil.substring(param, 0, 1).equals("@")) {
                int type;
                boolean hasSub;
                String paraName;
                String typeText;
                int dotPos = (param = param.substring(1)).indexOf(46);
                if (dotPos == -1) {
                    typeText = "varchar";
                    paraName = param;
                } else {
                    typeText = param.substring(0, dotPos);
                    paraName = param.substring(dotPos + 1);
                }
                boolean bl = hasSub = typeText.indexOf(61) != -1;
                if (hasSub) {
                    type = this.getSqlType(StringUtil.getNamePart(typeText));
                    int subType = Integer.parseInt(StringUtil.getValuePart(typeText));
                    callStatement.registerOutParameter(i + 1, type, subType);
                } else {
                    type = this.getSqlType(typeText);
                    callStatement.registerOutParameter(i + 1, type);
                }
                this.outParamList.add(StringUtil.concat(Integer.toString(type), "=", paraName));
            } else {
                Object[] params = this.parseParam(param);
                this.typeMap[i] = params;
                DbUtil.setObject(this.statement, i + 1, (Integer)params[0], this.ga((String)params[1]));
                this.outParamList.add("");
            }
            ++i;
        }
    }

    private Object[] parseParam(String param) {
        String name;
        String type;
        Object[] result = new Object[2];
        int dotPos = param.indexOf(46);
        if (dotPos == -1) {
            type = "VARCHAR";
            name = param;
        } else {
            type = param.substring(0, dotPos);
            if (this.isSqlType(type)) {
                name = param.substring(dotPos + 1);
            } else {
                type = "VARCHAR";
                name = param;
            }
        }
        result[0] = this.getSqlType(type);
        result[1] = name;
        return result;
    }

    private void getOutParameter() throws Exception {
        CallableStatement st = (CallableStatement)this.statement;
        int i = 0;
        while (i < this.paramSize) {
            String para = this.outParamList.get(i);
            if (!StringUtil.isEmpty(para)) {
                this.request.setAttribute(StringUtil.getValuePart(para), DbUtil.getObject(st, i + 1, Integer.parseInt(StringUtil.getNamePart(para))));
            }
            ++i;
        }
    }

    private void replaceSqlParameters() {
        int endPos;
        int startPos;
        while ((startPos = this.sql.indexOf("{?")) > -1 && (endPos = this.sql.indexOf("?}")) > -1) {
            String param = this.sql.substring(startPos + 2, endPos);
            this.sql = StringUtil.replaceFirst(this.sql, "{?" + param + "?}", "?");
            this.paramList.add(param);
        }
        this.paramSize = this.paramList.size();
    }
}

